/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.ad;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.BooleanConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.user.User;
import com.beyondcron.core.user.UserService;
import com.hazelcast.core.HazelcastInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.logging.log4j.Logger;

public class ADUserService
extends UserService {
    static final Logger logger = LogUtils.getLogger(ADUserService.class);
    public static final String SERVICE_NAME = "AD";
    @PeriodConfig.Annotation(defaultValue="15 minutes")
    public static final String AD_CACHE_PERIOD = "ad.refresh.period";
    @StringConfig.Annotation(defaultValue="bc_")
    public static final String AD_GROUP_PREFIX = "ad.group.prefix";
    @BooleanConfig.Annotation
    public static final String AD_GROUP_REQUIRED = "ad.group.required";
    @StringConfig.Annotation(defaultValue="beyondcron")
    public static final String AD_QUERY_USER_NAME = "ad.query.user.dn";
    @StringConfig.Annotation(defaultValue="beyondcron", secret=true)
    public static final String AD_QUERY_USER_PASSWORD = "ad.query.user.password";
    @StringConfig.Annotation
    public static final String AD_URL = "ad.url";
    @StringConfig.Annotation
    public static final String AD_NODE_USERS = "ad.users.dn";
    @StringConfig.Annotation
    public static final String AD_NODE_GROUPS = "ad.groups.dn";
    public static final String AD_ATTRIBUTE_ACCOUNT_NAME = "sAMAccountName";
    public static final String AD_ATTRIBUTE_ACCOUNT_TYPE = "sAMAccountType";
    public static final String SAM_GROUP_OBJECT = Integer.toString(0x10000000);
    public static final String SAM_NORMAL_USER_ACCOUNT = Integer.toString(0x30000000);
    public static final String AD_ATTRIBUTE_DISTINGUISHED_NAME = "distinguishedName";
    public static final String AD_ATTRIBUTE_DESCRIPTION = "description";
    public static final String AD_ATTRIBUTE_MEMBER_OF = "memberOf";
    public static final String AD_ATTRIBUTE_NAME = "name";
    private HazelcastInstance hazelcast;
    private String adURL;
    private String adNodeUsers;
    private String adNodeUsersFilter = String.format("(%s=%s)", "sAMAccountType", SAM_NORMAL_USER_ACCOUNT);
    private String adNodeUserFilter = String.format("(&(%s=%s)(%s=%%s))", "sAMAccountType", SAM_NORMAL_USER_ACCOUNT, "sAMAccountName");
    private String adNodeGroups;
    private String adNodeGroupsFilter;
    private String adQueryUserName;
    private String adQueryUserPassword;
    private DirContext queryConnection;
    private boolean groupRequired;
    private String groupPrefix;
    private int groupPrefixLength;
    private long cachePeriod;
    private UserCache users;
    private RoleCache roles;

    public ADUserService() {
        this(null);
    }

    public ADUserService(HazelcastInstance hazelcast) {
        super(SERVICE_NAME);
        this.hazelcast = hazelcast;
        this.users = new UserCache(hazelcast);
        this.roles = new RoleCache(hazelcast);
    }

    public boolean disconnect() {
        if (!super.disconnect()) {
            return false;
        }
        if (this.queryConnection != null) {
            try {
                this.queryConnection.close();
            }
            catch (NamingException e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception closing connection - %1$s", (Object[])new Object[]{e.getMessage()});
                return false;
            }
        }
        return true;
    }

    protected void init() throws ServiceException {
        super.init();
        this.adURL = (String)Configs.get((String)AD_URL);
        if (StringUtils.isNullOrEmpty((String)this.adURL)) {
            throw new ServiceException(Localise.format((String)"Undefined AD server url property - %s", (Object[])new Object[]{AD_URL}));
        }
        this.adQueryUserName = (String)Configs.get((String)AD_QUERY_USER_NAME);
        this.adQueryUserPassword = (String)Configs.get((String)AD_QUERY_USER_PASSWORD);
        try {
            this.queryConnection = this.getADConnection(this.adQueryUserName, this.adQueryUserPassword);
        }
        catch (AuthenticationException e) {
            throw new ServiceException(Localise.format((String)"Authentication error connecting to %s - %s", (Object[])new Object[]{this.adURL, e.getMessage()}));
        }
        catch (NamingException e) {
            throw new ServiceException(Localise.format((String)"Could not connect to AD server %s - %s", (Object[])new Object[]{this.adURL, e.getMessage()}));
        }
        this.groupRequired = (Boolean)Configs.get((String)AD_GROUP_REQUIRED);
        this.groupPrefix = (String)Configs.get((String)AD_GROUP_PREFIX);
        this.groupPrefixLength = this.groupPrefix.length();
        this.adNodeGroupsFilter = this.groupPrefixLength > 0 ? String.format("(&(%s=%s)(%s=%s*))", AD_ATTRIBUTE_ACCOUNT_TYPE, SAM_GROUP_OBJECT, AD_ATTRIBUTE_NAME, this.groupPrefix) : String.format("(%s=%s)", AD_ATTRIBUTE_ACCOUNT_TYPE, SAM_GROUP_OBJECT);
        this.adNodeUsers = (String)Configs.get((String)AD_NODE_USERS);
        if (StringUtils.isNullOrEmpty((String)this.adNodeUsers)) {
            throw new ServiceException(Localise.format((String)"Undefined user node parent property - %s", (Object[])new Object[]{AD_NODE_USERS}));
        }
        this.adNodeGroups = (String)Configs.get((String)AD_NODE_GROUPS);
        if (StringUtils.isNullOrEmpty((String)this.adNodeGroups)) {
            this.adNodeGroups = this.adNodeUsers;
        }
        this.cachePeriod = ((Period)Configs.get((String)AD_CACHE_PERIOD)).getMilliseconds();
    }

    public User authenticateUser(String name, String password) {
        if (!this.isConnected()) {
            return null;
        }
        User user = this.users.updateCache(name, true);
        if (user == null) {
            return null;
        }
        try {
            this.getADConnection(this.users.getUserDN(name), password).close();
        }
        catch (AuthenticationException e) {
            user = null;
        }
        catch (NamingException e) {
            Localise.logDebug((Logger)logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
            user = null;
        }
        return user;
    }

    public User getUser(String name, boolean refresh) {
        return this.users.getUser(name, refresh);
    }

    public Set<User> getUsers(Filter filter) {
        TreeSet<User> userSet = new TreeSet<User>();
        for (User user : this.users.getUsers()) {
            if (filter != null && !filter.matches(user.getName())) continue;
            userSet.add(user);
        }
        return userSet;
    }

    public boolean isUser(String name) {
        return this.users.isUser(name);
    }

    public Role getRole(String name) {
        return this.roles.getRole(name);
    }

    public Set<Role> getRoles(Filter filter) {
        TreeSet<Role> roleSet = new TreeSet<Role>();
        for (Role role : this.roles.getRoles()) {
            if (filter != null && !filter.matches(role.getName())) continue;
            roleSet.add(role);
        }
        return roleSet;
    }

    public boolean isRole(String name) {
        return this.roles.isRole(name);
    }

    public void refresh() {
        Localise.logInfo((Logger)logger, (String)"Refreshing AD service", (Object[])new Object[0]);
        this.roles.updateCache(true);
        this.users.updateCache(true);
    }

    private DirContext getADConnection(String name, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.adURL);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", name);
        env.put("java.naming.security.credentials", password);
        return new InitialDirContext(env);
    }

    private String getValue(Attribute attribute) throws NamingException {
        return this.getValue(attribute, 0);
    }

    private String getValue(Attribute attribute, int index) throws NamingException {
        return index < attribute.size() ? attribute.get(index).toString() : null;
    }

    private class RoleCache {
        Map<String, Role> roles;
        private long cacheExpiry = 0L;
        private Lock lock;

        public RoleCache(HazelcastInstance hazelcast) {
            if (hazelcast != null) {
                this.roles = hazelcast.getMap("service.user.ad.roles");
                this.lock = hazelcast.getLock("service.user.ad.roles.lock");
            } else {
                this.roles = new HashMap<String, Role>();
                this.lock = new ReentrantLock();
            }
        }

        public Role getRole(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                Role role = this.roles.get(name);
                return role;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isRole(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                boolean bl = this.roles.containsKey(name);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Collection<Role> getRoles() {
            this.lock.lock();
            try {
                this.updateCache(false);
                Collection<Role> collection = this.roles.values();
                return collection;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(boolean force) {
            block7: {
                if (!ADUserService.this.isConnected()) {
                    return;
                }
                this.lock.lock();
                try {
                    if (!force && System.currentTimeMillis() <= this.cacheExpiry) break block7;
                    this.roles.clear();
                    SearchControls controls = new SearchControls();
                    controls.setReturningAttributes(new String[]{ADUserService.AD_ATTRIBUTE_ACCOUNT_NAME, ADUserService.AD_ATTRIBUTE_DESCRIPTION});
                    try {
                        NamingEnumeration<SearchResult> results = ADUserService.this.queryConnection.search(ADUserService.this.adNodeGroups, ADUserService.this.adNodeGroupsFilter, controls);
                        while (results.hasMore()) {
                            Attributes attributes = results.next().getAttributes();
                            Role role = new Role(ADUserService.this.getValue(attributes.get(ADUserService.AD_ATTRIBUTE_ACCOUNT_NAME)), ADUserService.this.getValue(attributes.get(ADUserService.AD_ATTRIBUTE_DESCRIPTION)));
                            this.roles.put(role.getName(), role);
                        }
                    }
                    catch (NamingException e) {
                        Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    }
                    this.cacheExpiry = System.currentTimeMillis() + ADUserService.this.cachePeriod;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    private class UserCache {
        private Map<String, User> users;
        private Map<String, String> userDNs;
        private long cacheExpiry = 0L;
        private Lock lock;

        public UserCache(HazelcastInstance hazelcast) {
            if (hazelcast != null) {
                this.users = hazelcast.getMap("service.user.ad.users");
                this.userDNs = hazelcast.getMap("service.user.ad.users.dn");
                this.lock = hazelcast.getLock("service.user.ad.users.lock");
            } else {
                this.users = new HashMap<String, User>();
                this.userDNs = new HashMap<String, String>();
                this.lock = new ReentrantLock();
            }
        }

        public boolean isUser(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                boolean bl = this.users.containsKey(name);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String getUserDN(String name) {
            return this.userDNs.get(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public User getUser(String name, boolean ignoreCache) {
            this.lock.lock();
            try {
                this.updateCache(ignoreCache);
                User user = this.users.get(name);
                return user;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Collection<User> getUsers() {
            this.lock.lock();
            try {
                this.updateCache(false);
                Collection<User> collection = this.users.values();
                return collection;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(boolean force) {
            block7: {
                if (!ADUserService.this.isConnected()) {
                    return;
                }
                this.lock.lock();
                try {
                    if (!force && System.currentTimeMillis() <= this.cacheExpiry) break block7;
                    ADUserService.this.roles.updateCache(force);
                    this.users.clear();
                    this.userDNs.clear();
                    SearchControls controls = new SearchControls();
                    controls.setReturningAttributes(new String[]{ADUserService.AD_ATTRIBUTE_DISTINGUISHED_NAME, ADUserService.AD_ATTRIBUTE_ACCOUNT_NAME, ADUserService.AD_ATTRIBUTE_NAME, ADUserService.AD_ATTRIBUTE_MEMBER_OF});
                    try {
                        NamingEnumeration<SearchResult> results = ADUserService.this.queryConnection.search(ADUserService.this.adNodeUsers, ADUserService.this.adNodeUsersFilter, controls);
                        while (results.hasMore()) {
                            Attributes attributes = results.next().getAttributes();
                            ADUser user = this.getUser(attributes);
                            if (user == null) continue;
                            String name = user.getName();
                            this.users.put(name, user);
                            this.userDNs.put(name, user.getUserDN());
                        }
                    }
                    catch (NamingException e) {
                        Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    }
                    this.cacheExpiry = System.currentTimeMillis() + ADUserService.this.cachePeriod;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private User updateCache(String name, boolean ignoreCache) {
            if (!ignoreCache || !ADUserService.this.isConnected()) {
                return this.getUser(name, ignoreCache);
            }
            ADUser user = null;
            SearchControls controls = new SearchControls();
            controls.setReturningAttributes(new String[]{ADUserService.AD_ATTRIBUTE_DISTINGUISHED_NAME, ADUserService.AD_ATTRIBUTE_ACCOUNT_NAME, ADUserService.AD_ATTRIBUTE_NAME, ADUserService.AD_ATTRIBUTE_MEMBER_OF});
            try {
                Attributes attributes;
                NamingEnumeration<SearchResult> results = ADUserService.this.queryConnection.search(ADUserService.this.adNodeUsers, String.format(ADUserService.this.adNodeUserFilter, name), controls);
                if (results.hasMore() && (user = this.getUser(attributes = results.next().getAttributes())) != null) {
                    this.users.put(name, user);
                    this.userDNs.put(name, user.getUserDN());
                }
            }
            catch (NamingException e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
            }
            return user;
        }

        private ADUser getUser(Attributes attributes) throws NamingException {
            ADUser user = new ADUser(ADUserService.this.getValue(attributes.get(ADUserService.AD_ATTRIBUTE_ACCOUNT_NAME)), ADUserService.this.getValue(attributes.get(ADUserService.AD_ATTRIBUTE_NAME)), ADUserService.this.getValue(attributes.get(ADUserService.AD_ATTRIBUTE_DISTINGUISHED_NAME)));
            Attribute attribute = attributes.get(ADUserService.AD_ATTRIBUTE_MEMBER_OF);
            if (attribute != null) {
                for (int i = 0; i < attribute.size(); ++i) {
                    Role role = this.getRole(ADUserService.this.getValue(attribute, i));
                    if (role == null) continue;
                    user.addRole(role);
                }
            }
            return !ADUserService.this.groupRequired || !user.getRoles().isEmpty() ? user : null;
        }

        private Role getRole(String cnName) {
            int i = cnName.indexOf("=");
            int j = cnName.indexOf(",");
            if (i++ < 0 || j < 0 || i >= j) {
                return null;
            }
            return ADUserService.this.roles.getRole(cnName.substring(i, j));
        }
    }

    public static class ADUser
    extends User {
        private String userDN;

        public ADUser(String name, String description, String userDN) {
            super(name, description);
            this.userDN = userDN;
        }

        public String getUserDN() {
            return this.userDN;
        }
    }
}

