/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.jdbc;

import com.beyondcron.core.Configs;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.service.jdbc.JDBCException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class JDBCClient {
    static final Logger logger = LogUtils.getLogger(JDBCClient.class);
    public static final String JDBC_PREFIX = "jdbc.";
    public static final String JDBC_PREFIX_STARTUP = "JDBC_";
    public static final String JDBC_TABLE_PREFIX = "jdbc.table.";
    public static final String URL = "url";
    @StringConfig.Annotation
    public static final String JDBC_URL = "jdbc.url";
    @StringConfig.Annotation
    public static final String JDBC_USER = "jdbc.user";
    @StringConfig.Annotation(secret=true)
    public static final String JDBC_PASSWORD = "jdbc.password";
    @StringConfig.Annotation(startup=true)
    public static final String JDBC_URL_STARTUP = "JDBC_URL";
    @StringConfig.Annotation(startup=true)
    public static final String JDBC_USER_STARTUP = "JDBC_USER";
    @StringConfig.Annotation(startup=true, secret=true)
    public static final String JDBC_PASSWORD_STARTUP = "JDBC_PASSWORD";
    private String product = null;
    private String connectionURL;
    private Connection connection;

    public JDBCClient(boolean startup, String ... configNames) throws ServiceException {
        List<String> missing = JDBCClient.validateConfigs(startup, configNames);
        if (!missing.isEmpty()) {
            if (startup) {
                throw new ServiceException(Localise.format((String)"Startup variable/s undefined - %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", missing)}));
            }
            throw new ServiceException(Localise.format((String)"Configuration variable/s undefined - %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", missing)}));
        }
        String dirName = (String)Configs.get((String)"BEYONDCRON_CONFIG_DIR");
        if (!StringUtils.isNullOrEmpty((String)dirName)) {
            File dir = new File(dirName);
            IOUtils.addResourceDirectory((File)(dir.isAbsolute() ? dir : dir.getAbsoluteFile()));
        }
        this.init(startup);
    }

    public static List<String> getConfigNames(boolean startup) {
        ArrayList<String> names = new ArrayList<String>();
        if (startup) {
            Collections.addAll(names, JDBC_URL_STARTUP, JDBC_USER_STARTUP, JDBC_PASSWORD_STARTUP);
        } else {
            Collections.addAll(names, JDBC_URL, JDBC_USER, JDBC_PASSWORD);
        }
        return names;
    }

    public static List<String> validateConfigs(boolean startup, String ... configNames) {
        List<String> names = JDBCClient.getConfigNames(startup);
        Collections.addAll(names, configNames);
        ArrayList<String> missing = new ArrayList<String>();
        for (String name : names) {
            if (!StringUtils.isNullOrEmpty((String)((String)Configs.get((String)name)))) continue;
            missing.add(name);
        }
        return missing;
    }

    private void init(boolean startup) throws ServiceException {
        Properties properties = new Properties();
        String prefix = startup ? JDBC_PREFIX_STARTUP : JDBC_PREFIX;
        for (Config config : Configs.getConfigs((String)prefix, (boolean)startup)) {
            String value;
            String name = config.getName();
            if (name.equals(JDBC_PASSWORD_STARTUP)) {
                try {
                    value = Configs.getPassword((String)name);
                }
                catch (IOException e) {
                    throw new ServiceException(Localise.format((String)"Could not read password - %1$s", (Object[])new Object[]{e.getMessage()}));
                }
            } else {
                value = config.getValue().toString();
            }
            if ((name = name.toLowerCase(Locale.ROOT).replace("_", ".")).startsWith(JDBC_TABLE_PREFIX)) continue;
            properties.setProperty(StringUtils.stripPrefix((String)name, (String)JDBC_PREFIX), value);
        }
        try {
            this.init(properties);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private void init(Properties properties) throws JDBCException {
        this.connectionURL = properties.getProperty(URL);
        try {
            this.connection = DriverManager.getConnection(this.connectionURL, properties);
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        try {
            this.product = this.connection.getMetaData().getDatabaseProductName().toLowerCase();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    public String getDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isNullOrEmpty((String)this.product)) {
            list.add(this.product);
        }
        if (!StringUtils.isNullOrEmpty((String)this.connectionURL)) {
            list.add(this.connectionURL);
        }
        return StringUtils.join((String)" ", list);
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public String getProduct() {
        return this.product;
    }

    public boolean disconnect() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
            return true;
        }
        catch (SQLException e) {
            Localise.logError((Logger)logger, (String)"Unexpected exception closing connection - %1$s", (Object[])new Object[]{e.getMessage()});
            return false;
        }
    }

    public boolean isConnected() {
        boolean connected;
        try {
            connected = this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException e) {
            Localise.logError((Logger)logger, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
            connected = false;
        }
        return connected;
    }

    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    public PreparedStatement prepareStatement(String resourceName, String ... args) throws SQLException {
        return this.connection.prepareStatement(this.getSQL(resourceName, args));
    }

    public boolean validateTable(String tableName, String ... columnNames) throws JDBCException {
        Set<String> columns = this.getColumnNames(tableName);
        if (columns.size() == 0) {
            return false;
        }
        for (String columnName : columnNames) {
            if (columns.contains(columnName)) continue;
            throw new JDBCException(Localise.format((String)"table %s is missing column %s", (Object[])new Object[]{tableName, columnName}));
        }
        return true;
    }

    public Set<String> getColumnNames(String tableName) {
        DatabaseMetaData meta;
        HashSet<String> names = new HashSet<String>();
        try {
            meta = this.connection.getMetaData();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        try {
            ResultSet result = meta.getColumns(null, null, tableName, "%");
            while (result.next()) {
                names.add(result.getString("COLUMN_NAME"));
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        return names;
    }

    public String getSQL(String resourceName, String ... args) {
        String sqlTemplate;
        try {
            sqlTemplate = IOUtils.readResource((String)String.format("%s.%s.sql", resourceName, this.product));
        }
        catch (IOException e) {
            try {
                sqlTemplate = IOUtils.readResource((String)String.format("%s.sql", resourceName));
            }
            catch (IOException e1) {
                throw new JDBCException(Localise.format((String)"could not find %s[.%s].sql", (Object[])new Object[]{resourceName, this.product}));
            }
        }
        String sql = Localise.format((String)sqlTemplate, (Object[])args);
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"getSQL: %1$s %2$s", (Object[])new Object[]{resourceName, StringUtils.join((String)" ", (String[])args)});
            Localise.logDebug((Logger)logger, (String)"   sql: %1$s", (Object[])new Object[]{sql});
        }
        return sql;
    }

    static {
        Configs.addConfigs(JDBCClient.class);
    }
}

