/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.Configs;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.message.Change;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class GitNative
implements Persist.Git {
    static final Logger logger = LogUtils.getLogger(GitNative.class);
    private static final int EXECUTE_ARG_MAX = (Integer)Configs.get((String)"beyondcron.execute.arg.max");
    public static final String GIT = "git";
    public static final String GIT_INIT = "init";
    public static final String GIT_ABBREV = "--abbrev=%d";
    public static final String GIT_ABBREV_COMMIT = "--abbrev-commit";
    public static final String GIT_ADD = "add";
    public static final String GIT_ARGS_END = "--";
    public static final String GIT_CLONE = "clone";
    public static final String GIT_CLONE_QUIET = "--quiet";
    public static final String GIT_COMMIT = "commit";
    public static final String GIT_COMMIT_AUTHOR = "--author='%s <%s>'";
    public static final String GIT_COMMIT_DATE = "--date=%d";
    public static final String GIT_COMMIT_MESSAGE_FILE = "--file=%s";
    public static final String GIT_CONFIG = "config";
    public static final String GIT_CONFIG_USER_EMAIL = "user.email";
    public static final String GIT_CONFIG_USER_NAME = "user.name";
    public static final String GIT_FETCH = "fetch";
    public static final String GIT_FORMAT_ABBREV_COMMIT = "--format=%h";
    public static final String GIT_HEAD = "HEAD";
    public static final String GIT_LOG = "log";
    public static final String GIT_LOG_DATE_RAW = "--date=raw";
    public static final String GIT_LOG_DATES_ONLY = "--pretty=format:%at";
    public static final String GIT_LOG_NO_DECTORATE = "--no-decorate";
    public static final String GIT_LOG_SINCE = "--since=%d";
    public static final String GIT_LOG_UNTIL = "--until=%d";
    public static final String GIT_MAX_COUNT = "--max-count=%d";
    public static final String GIT_MAX_PARENTS = "--max-parents=%d";
    public static final String GIT_NO_PAGER = "--no-pager";
    public static final String GIT_NO_PATCH = "--no-patch";
    public static final String GIT_ONELINE = "--oneline";
    public static final String GIT_REMOVE = "rm";
    public static final String GIT_REMOTE = "remote";
    public static final String GIT_REMOTE_ADD = "add";
    public static final String GIT_RESET = "reset";
    public static final String GIT_RESET_HARD = "--hard";
    public static final String GIT_RESET_TREE = "%s/master";
    public static final String GIT_REV_LIST = "rev-list";
    public static final String GIT_SHOW = "show";
    public static final String GIT_SHOW_OBJECT = "%s:%s";
    private static final Pattern PATTERN_COMMIT_ID = Pattern.compile("^commit\\s+(\\S+)$");
    private static final Pattern PATTER_COMMIT_AUTHOR = Pattern.compile("^Author:\\s+(\\S.+\\S)$");
    private static final Pattern PATTERN_COMMIT_DATE = Pattern.compile("^Date:\\s+(\\d+) [-+]\\d{4}$");
    private static final Pattern PATTERN_REMOTE_NAME = Pattern.compile("^(ssh|git|http|https|ftp|ftps)://(.+?)/.*");
    private File repositoryRoot;
    private String repositoryURL;
    private Date creationDate = null;
    private String firstCommitId = null;
    private Command addCommand = new Command("add", "git", "add");
    private Command removeCommand = new Command("remove", "git", "rm");

    @Override
    public Persist.Git init(File repositoryRoot, InetAddress address, String masterURL) throws Persist.PersistException {
        this.repositoryRoot = repositoryRoot;
        this.repositoryURL = String.format((String)Configs.get((String)"beyondcron.git.repository.url"), address.getCanonicalHostName(), repositoryRoot.toString());
        File gitDir = new File(repositoryRoot, ".git");
        if (StringUtils.isNullOrEmpty((String)masterURL)) {
            if (!gitDir.exists()) {
                Localise.logDebug((Logger)logger, (String)"Creating local repository", (Object[])new Object[0]);
                try {
                    this.execute(GIT, GIT_INIT, repositoryRoot.toString());
                }
                catch (Exception e) {
                    throw new Persist.PersistException(Localise.format((String)"Could not init %1$s - %2$s", (Object[])new Object[]{repositoryRoot.toString(), e.getMessage()}));
                }
            }
            this.initConfig();
            return this;
        }
        if (!gitDir.exists()) {
            Localise.logDebug((Logger)logger, (String)"Cloning %1$s", (Object[])new Object[]{masterURL});
            try {
                this.execute(GIT, GIT_CLONE, GIT_CLONE_QUIET, masterURL, repositoryRoot.toString());
            }
            catch (Exception e) {
                throw new Persist.PersistException(Localise.format((String)"Could not clone %1$s - %2$s", (Object[])new Object[]{masterURL, e.getMessage()}));
            }
            this.initConfig();
        } else {
            Localise.logDebug((Logger)logger, (String)"Pulling from %1$s", (Object[])new Object[]{masterURL});
            String masterHost = GitNative.getRemoteName(masterURL);
            boolean knownMaster = false;
            try {
                for (String s : this.execute(GIT, GIT_REMOTE)) {
                    if (!s.equals(masterHost)) continue;
                    knownMaster = true;
                    break;
                }
            }
            catch (Exception e) {
                throw new Persist.PersistException(Localise.format((String)"Could not list remotes - %1$s", (Object[])new Object[]{e.getMessage()}));
            }
            if (!knownMaster) {
                try {
                    this.execute(GIT, GIT_REMOTE, "add", masterHost, masterURL);
                }
                catch (Exception e) {
                    throw new Persist.PersistException(Localise.format((String)"Could not add remote %1$s as %2$s - %3$s", (Object[])new Object[]{masterURL, masterHost, e.getMessage()}));
                }
            }
            this.initConfig();
            try {
                this.execute(GIT, GIT_FETCH, masterHost);
            }
            catch (Exception e) {
                throw new Persist.PersistException(Localise.format((String)"Could not fetch from %1$s - %2$s", (Object[])new Object[]{masterURL, e.getMessage()}));
            }
            try {
                this.execute(GIT, GIT_RESET, GIT_RESET_HARD, String.format(GIT_RESET_TREE, masterHost));
            }
            catch (Exception e) {
                throw new Persist.PersistException(Localise.format((String)"Could not reset tree - %1$s", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return this;
    }

    private void initConfig() throws Persist.PersistException {
        try {
            this.execute(GIT, GIT_CONFIG, GIT_CONFIG_USER_EMAIL, "<>");
            this.execute(GIT, GIT_CONFIG, GIT_CONFIG_USER_NAME, Program.getUserName());
        }
        catch (Exception e) {
            throw new Persist.PersistException(Localise.format((String)"Could not update git config - %1$s", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public static String getRemoteName(String master) throws Persist.PersistException {
        Matcher m = PATTERN_REMOTE_NAME.matcher(master);
        if (!m.matches()) {
            throw new Persist.PersistException(Localise.format((String)"Unsupported master repository - %1$s", (Object[])new Object[]{master}));
        }
        return m.group(2).replace(':', '_');
    }

    @Override
    public Date getCreationDate() {
        if (this.creationDate == null) {
            TreeSet<Long> commitTimes = new TreeSet<Long>();
            try {
                for (String timestamp : this.execute(GIT, GIT_NO_PAGER, GIT_LOG, GIT_LOG_DATES_ONLY)) {
                    commitTimes.add(Long.parseLong(timestamp));
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Could not read repository log - %1$s", (Object[])new Object[]{e.getMessage()});
            }
            long hour = Period.Unit.HOUR.getSeconds(1L);
            long firstTime = 0L;
            long time = 0L;
            Iterator iterator = commitTimes.iterator();
            while (iterator.hasNext()) {
                long t;
                time = t = ((Long)iterator.next()).longValue();
                if (firstTime > 0L) {
                    if (time - firstTime <= hour) continue;
                    break;
                }
                firstTime = time;
            }
            this.creationDate = time - firstTime > hour ? new Date(time * 1000L) : new Date();
        }
        return this.creationDate;
    }

    @Override
    public String getFirstCommitId() {
        if (this.firstCommitId == null) {
            try {
                Iterator<String> iterator = this.execute(GIT, GIT_NO_PAGER, GIT_REV_LIST, GIT_ABBREV_COMMIT, String.format(GIT_MAX_PARENTS, 0), GIT_HEAD).iterator();
                if (iterator.hasNext()) {
                    String commitId;
                    this.firstCommitId = commitId = iterator.next();
                }
                if (this.firstCommitId == null) {
                    return "";
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Could not read repository log - %1$s", (Object[])new Object[]{e.getMessage()});
                return e.getMessage();
            }
        }
        return this.firstCommitId;
    }

    @Override
    public String getLastCommitId() {
        return this.getLastCommitId(0);
    }

    @Override
    public String getLastCommitId(int length) {
        try {
            if (length > 0) {
                Iterator<String> iterator = this.execute(GIT, GIT_SHOW, GIT_FORMAT_ABBREV_COMMIT, String.format(GIT_ABBREV, length), GIT_NO_PATCH).iterator();
                if (iterator.hasNext()) {
                    String commitId = iterator.next();
                    return commitId;
                }
            } else {
                Iterator<String> iterator = this.execute(GIT, GIT_SHOW, GIT_FORMAT_ABBREV_COMMIT, GIT_NO_PATCH).iterator();
                if (iterator.hasNext()) {
                    String commitId = iterator.next();
                    return commitId;
                }
            }
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (String)"Could not read repository log - %1$s", (Object[])new Object[]{e.getMessage()});
        }
        return null;
    }

    @Override
    public boolean isCommit(String commitId) {
        try {
            return this.execute(GIT, GIT_SHOW, GIT_FORMAT_ABBREV_COMMIT, GIT_NO_PATCH, commitId, GIT_ARGS_END).size() == 1;
        }
        catch (Exception e) {
            if (!e.getMessage().contains("bad object") && !e.getMessage().contains("bad revision")) {
                Localise.logError((Logger)logger, (String)"Could not read repository log - %1$s", (Object[])new Object[]{e.getMessage()});
            }
            return false;
        }
    }

    @Override
    public void add(File ... files) throws Persist.PersistException {
        for (File file : files) {
            String fileName = file.toString();
            if (this.addCommand.add(fileName) <= EXECUTE_ARG_MAX) continue;
            this.addCommand.pop();
            this.addCommand.execute();
            this.addCommand.add(fileName);
        }
    }

    @Override
    public void remove(File ... files) throws Persist.PersistException {
        for (File file : files) {
            String fileName = file.toString();
            if (this.removeCommand.add(fileName) <= EXECUTE_ARG_MAX) continue;
            this.removeCommand.pop();
            this.removeCommand.execute();
            this.removeCommand.add(fileName);
        }
    }

    @Override
    public void commit(String authorName, String authorEmail, long authorDate, String message) throws Persist.PersistException {
        File messageFile;
        if (!this.addCommand.isEmpty()) {
            this.addCommand.execute();
        }
        if (!this.removeCommand.isEmpty()) {
            this.removeCommand.execute();
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(GIT);
        command.add(GIT_COMMIT);
        command.add(String.format(GIT_COMMIT_AUTHOR, authorName, authorEmail));
        command.add(String.format(GIT_COMMIT_DATE, authorDate));
        try {
            messageFile = File.createTempFile("beyondcron", null);
        }
        catch (IOException e) {
            throw new Persist.PersistException(Localise.format((String)"Could not create temporary GIT message file - %1$s", (Object[])new Object[]{e.getMessage()}));
        }
        messageFile.deleteOnExit();
        try {
            PrintStream messageOut = new PrintStream(messageFile);
            messageOut.println(message);
            messageOut.close();
        }
        catch (FileNotFoundException e) {
            throw new Persist.PersistException(Localise.format((String)"Could not write to GIT message file %1$s - %2$s", (Object[])new Object[]{messageFile.toString(), e.getMessage()}));
        }
        command.add(String.format(GIT_COMMIT_MESSAGE_FILE, messageFile.toString()));
        try {
            this.execute(command);
        }
        catch (Exception e) {
            throw new Persist.PersistException(Localise.format((String)"Could not commit changes - %s", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            messageFile.delete();
        }
    }

    @Override
    public <T extends Message<?>> List<T> get(Name name, String messageTag, String commitId, boolean directory) throws Persist.PersistException {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory) {
            paths.add(Persist.getPath(name, messageTag));
        } else {
            String pathDir = Persist.getDirectoryPath(name, messageTag);
            try {
                List<String> files = this.execute(Arrays.asList(GIT, GIT_NO_PAGER, GIT_SHOW, String.format(GIT_SHOW_OBJECT, commitId, Persist.getDirectoryPath(name, messageTag))));
                for (String file : files) {
                    if (file.length() <= 0 || file.endsWith("/")) continue;
                    paths.add(pathDir + file);
                }
            }
            catch (Exception e) {
                throw new Persist.PersistException(Localise.format((String)"Could not read commit files in %1$s - %2$s", (Object[])new Object[]{pathDir, e.getMessage()}));
            }
        }
        for (String path : paths) {
            try {
                byte[] data = this.executeBinary(Arrays.asList(GIT, GIT_NO_PAGER, GIT_SHOW, String.format(GIT_SHOW_OBJECT, commitId, path)));
                Message message = new MessageSerializer().read(data);
                if (message == null) continue;
                messages.add(message);
            }
            catch (Exception e) {
                String msg = e.getMessage().toLowerCase();
                if (msg.contains("invalid object name")) {
                    throw new Persist.PersistException(Localise.format((String)"Illegal commit id - %1$s", (Object[])new Object[]{commitId}));
                }
                throw new Persist.PersistException(Localise.format((String)"Could not read file %1$s - %2$s", (Object[])new Object[]{path, e.getMessage()}));
            }
        }
        return messages;
    }

    @Override
    public List<Change> getCommit(String commitId) throws Persist.PersistException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(GIT);
        command.add(GIT_NO_PAGER);
        command.add(GIT_LOG);
        command.add(GIT_ABBREV_COMMIT);
        command.add(GIT_LOG_DATE_RAW);
        command.add(GIT_LOG_NO_DECTORATE);
        command.add(String.format(GIT_MAX_COUNT, 1));
        command.add(commitId);
        command.add(GIT_ARGS_END);
        try {
            return this.parseGitLogOutput(Name.ROOT, command);
        }
        catch (Exception e) {
            throw new Persist.PersistException(Localise.format((String)"Could not get information for commit %1$s - %2$s", (Object[])new Object[]{commitId, e.getMessage()}));
        }
    }

    @Override
    public List<Change> getCommits(long startTimestamp, long endTimestamp) throws Persist.PersistException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(GIT);
        command.add(GIT_NO_PAGER);
        command.add(GIT_LOG);
        command.add(GIT_ABBREV_COMMIT);
        command.add(GIT_LOG_DATE_RAW);
        command.add(GIT_LOG_NO_DECTORATE);
        if (startTimestamp >= 0L) {
            command.add(String.format(GIT_LOG_SINCE, startTimestamp));
        }
        if (endTimestamp >= 0L) {
            command.add(String.format(GIT_LOG_UNTIL, endTimestamp));
        }
        command.add(GIT_ARGS_END);
        try {
            return this.parseGitLogOutput(Name.ROOT, command);
        }
        catch (Exception e) {
            throw new Persist.PersistException(Localise.format((String)"Could not get information for commits since %1$d - %2$s", (Object[])new Object[]{startTimestamp, e.getMessage()}));
        }
    }

    @Override
    public List<Change> getHistory(Name name, String messageTag) throws Persist.PersistException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(GIT);
        command.add(GIT_NO_PAGER);
        command.add(GIT_LOG);
        command.add(GIT_ABBREV_COMMIT);
        command.add(GIT_LOG_DATE_RAW);
        command.add(GIT_LOG_NO_DECTORATE);
        command.add(GIT_ARGS_END);
        command.add(Persist.getPath(name, messageTag));
        try {
            return this.parseGitLogOutput(name, command);
        }
        catch (Exception e) {
            throw new Persist.PersistException(Localise.format((String)"Could not get history for file %1$s - %2$s", (Object[])new Object[]{Persist.getFile(this.repositoryRoot, name, messageTag), e.getMessage()}));
        }
    }

    private List<Change> parseGitLogOutput(Name name, List<String> command) throws Exception {
        ArrayList<Change> changes = new ArrayList<Change>();
        String commitId = null;
        String author = "";
        long timestamp = 0L;
        ArrayList<String> message = new ArrayList<String>();
        for (String s : this.execute(command)) {
            Matcher m = PATTERN_COMMIT_ID.matcher(s);
            if (m.matches()) {
                if (commitId != null) {
                    changes.add(new Change(name, commitId, timestamp, author, StringUtils.join((String)"\n", message)));
                    message.clear();
                }
                commitId = m.group(1);
                continue;
            }
            m = PATTER_COMMIT_AUTHOR.matcher(s);
            if (m.matches()) {
                author = m.group(1);
                continue;
            }
            m = PATTERN_COMMIT_DATE.matcher(s);
            if (m.matches()) {
                timestamp = Long.parseLong(m.group(1)) * 1000L;
                continue;
            }
            if ((s = s.trim()).length() <= 0) continue;
            message.add(s);
        }
        if (commitId != null) {
            changes.add(new Change(name, commitId, timestamp, author, StringUtils.join((String)"\n", message)));
        }
        return changes;
    }

    private List<String> execute(String ... command) throws Exception {
        return this.execute(Arrays.asList(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> execute(List<String> command) throws Exception {
        ArrayList<String> output = new ArrayList<String>();
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        builder.directory(this.repositoryRoot);
        Process process = builder.start();
        try (BufferedReader processOut = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            process.getOutputStream().close();
            while ((line = processOut.readLine()) != null) {
                output.add(line);
            }
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                int i = output.size();
                if (i > 5) {
                    i = 5;
                }
                throw new Exception(StringUtils.join((String)"\n", output.subList(0, i)));
            }
        }
        catch (Throwable throwable) {
            if (logger.isDebugEnabled()) {
                Localise.logDebug((Logger)logger, (String)"Executing: %1$s", (Object[])new Object[]{StringUtils.join((String)" ", command)});
                Localise.logDebug((Logger)logger, (String)"Returned: %1$s", (Object[])new Object[]{StringUtils.join((String)"\n  ", output)});
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"Executing: %1$s", (Object[])new Object[]{StringUtils.join((String)" ", command)});
            Localise.logDebug((Logger)logger, (String)"Returned: %1$s", (Object[])new Object[]{StringUtils.join((String)"\n  ", output)});
        }
        return output;
    }

    private byte[] executeBinary(List<String> command) throws Exception {
        byte[] bytes;
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"Executing: %1$s", (Object[])new Object[]{StringUtils.join((String)" ", command)});
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        builder.directory(this.repositoryRoot);
        Process process = builder.start();
        try (InputStream processOut = process.getInputStream();){
            process.getOutputStream().close();
            bytes = IOUtils.readBytes((InputStream)processOut);
            if (logger.isDebugEnabled()) {
                Localise.logDebug((Logger)logger, (String)"Read %1$d bytes", (Object[])new Object[]{bytes.length});
            }
            int exitValue = process.waitFor();
            if (logger.isDebugEnabled()) {
                Localise.logDebug((Logger)logger, (String)"Exit value: %1$d", (Object[])new Object[]{exitValue});
            }
            if (exitValue != 0) {
                throw new Exception(new String(bytes).trim());
            }
        }
        return bytes;
    }

    protected class Command {
        String action;
        String[] defaultArgs;
        List<String> args = new ArrayList<String>();
        int argsLength = -1;

        public Command(String action, String ... args) {
            this.action = action;
            this.defaultArgs = args;
            this.add(args);
        }

        public int add(String ... args) {
            for (String arg : args) {
                this.args.add(arg);
                this.argsLength += arg.length() + 1;
            }
            return this.argsLength;
        }

        public String pop() {
            String arg = this.args.remove(this.args.size() - 1);
            if (arg != null) {
                this.argsLength -= arg.length() + 1;
            }
            return arg;
        }

        public void reset() {
            this.args.clear();
            this.argsLength = -1;
            this.add(this.defaultArgs);
        }

        public boolean isEmpty() {
            return this.args.size() == this.defaultArgs.length;
        }

        public int length() {
            return this.argsLength;
        }

        public int size() {
            return this.args.size();
        }

        public void execute() throws Persist.PersistException {
            try {
                GitNative.this.execute(this.args);
            }
            catch (Exception e) {
                if (this.args.size() - this.defaultArgs.length == 1) {
                    throw new Persist.PersistException(Localise.format((String)"Could not %1$s file %2$s - %3$s", (Object[])new Object[]{this.action, this.pop(), e.getMessage()}));
                }
                throw new Persist.PersistException(Localise.format((String)"Could not %1$s %2$d files - %3$s", (Object[])new Object[]{this.action, this.args.size() - this.defaultArgs.length, e.getMessage()}));
            }
            finally {
                this.reset();
            }
        }
    }
}

