/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.messaging;

import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Metrics;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.messaging.GitNative;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.message.Change;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.PersistCommand;
import com.beyondcron.messaging.message.PersistUpdate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class Persist {
    static final Logger logger = LogUtils.getLogger(Persist.class);
    private File root;
    private Git git;
    private Date creationDate = null;
    private String firstCommitId = null;
    private Map<Integer, LinkedList<PersistUpdate>> changeLists = new HashMap<Integer, LinkedList<PersistUpdate>>();
    private boolean loading = false;

    public Persist(File root, InetAddress address, String master) throws PersistException {
        this.root = root;
        if (!root.exists()) {
            if (!root.mkdirs()) {
                throw new PersistException(Localise.format((String)"Could not create root directory %s", (Object[])new Object[]{root.toString()}));
            }
        } else {
            if (!root.isDirectory()) {
                throw new PersistException(Localise.format((String)"%s is not a directory", (Object[])new Object[]{root.toString()}));
            }
            if (!root.canWrite()) {
                throw new PersistException(Localise.format((String)"Cannot write to %s", (Object[])new Object[]{root.toString()}));
            }
        }
        Localise.logDebug((Logger)logger, (String)"Initing git repository %s", (Object[])new Object[]{root});
        this.git = new GitNative().init(root, address, master);
    }

    public File getRoot() {
        return this.root;
    }

    public String getRepositoryName() {
        return this.git.getRepositoryURL();
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            this.creationDate = this.git.getCreationDate();
        }
        return this.creationDate;
    }

    public String getFirstCommitId() {
        if (this.firstCommitId == null) {
            this.firstCommitId = this.git.getFirstCommitId();
        }
        return this.firstCommitId;
    }

    public String getLastCommitId() {
        return this.git.getLastCommitId();
    }

    public String getLastCommitId(int length) {
        return this.git.getLastCommitId(length);
    }

    public boolean isCommitId(String commitId) {
        return this.git.isCommit(commitId);
    }

    public Set<String> getMessageTags() {
        HashSet<String> tags = new HashSet<String>();
        File[] fa = this.root.listFiles();
        if (fa != null) {
            for (File f : fa) {
                if (!f.isDirectory() || f.getName().startsWith(".")) continue;
                tags.add(f.getName());
            }
        }
        return tags;
    }

    public int load(Listener listener) throws PersistException {
        Localise.logDebug((Logger)logger, (String)"Loading git repository %s", (Object[])new Object[]{this.root});
        int loaded = 0;
        for (String tag : this.getMessageTags()) {
            loaded += this.load(listener, tag);
        }
        return loaded;
    }

    public int load(Listener listener, String tag) throws PersistException {
        File tagRoot = new File(this.root, tag);
        return this.load(listener, tagRoot, tagRoot);
    }

    private int load(Listener listener, File tagRoot, File file) throws PersistException {
        int loaded = 0;
        if (!file.exists() || file.getName().startsWith(".")) {
            return 0;
        }
        if (file.isDirectory()) {
            File[] fa = file.listFiles();
            if (fa != null) {
                for (File f : fa) {
                    if (file.isDirectory()) {
                        if (file.getName().startsWith(".")) continue;
                        loaded += this.load(listener, tagRoot, f);
                        continue;
                    }
                    Name name = Name.parse((File)FileUtils.stripRoot((File)f, (File)tagRoot));
                    this.loading = true;
                    listener.messageLoaded(name, this.load(f));
                    this.loading = false;
                    ++loaded;
                }
            }
        } else {
            Name name = Name.parse((File)FileUtils.stripRoot((File)file, (File)tagRoot));
            this.loading = true;
            listener.messageLoaded(name, this.load(file));
            this.loading = false;
            ++loaded;
        }
        return loaded;
    }

    public Message<?> load(Name name, Class<? extends Message<?>> clazz) throws PersistException {
        return this.load(Persist.getFile(this.root, name, clazz));
    }

    private Message<?> load(File file) throws PersistException {
        int type;
        if (!file.exists()) {
            throw new PersistException(Localise.format((String)"%s does not exist", (Object[])new Object[]{file.toString()}));
        }
        if (!file.isFile()) {
            throw new PersistException(Localise.format((String)"%s is not a file", (Object[])new Object[]{file.toString()}));
        }
        if (!file.canRead()) {
            throw new PersistException(Localise.format((String)"Cannot read %s", (Object[])new Object[]{file.toString()}));
        }
        byte[] data = new byte[(int)file.length() - 4];
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            type = in.readInt();
            if (in.read(data) != data.length) {
                throw new PersistException(Localise.format((String)"Incomplete read of message file %s", (Object[])new Object[]{file.toString()}));
            }
            in.close();
        }
        catch (IOException e) {
            throw new PersistException(Localise.format((String)"Could not read message file %1$s - %2$s", (Object[])new Object[]{file.toString(), e.getMessage()}));
        }
        Class clazz = MessageSerializer.getMessageClass((Integer)type);
        if (clazz == null) {
            throw new PersistException(Localise.format((String)"%1$s unknown message type %2$s", (Object[])new Object[]{file, type}));
        }
        try {
            return ((Message)clazz.newInstance()).fromProto(data);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new PersistException(Localise.format((String)"Could not instantiate %1$s - %2$s", (Object[])new Object[]{clazz.getName(), e.getMessage()}));
        }
        catch (Exception e) {
            throw new PersistException(Localise.format((String)"Parsing message %1$s - %2$s", (Object[])new Object[]{clazz.getName(), e.getMessage()}));
        }
    }

    public boolean exists(Name name, Message<?> message) {
        return Persist.getFile(this.root, name, message.getMessageTag()).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PersistUpdate update) throws PersistException {
        if (this.loading) {
            return;
        }
        int changeId = update.getChangeGroup();
        PersistUpdate.Type updateType = update.getType();
        LinkedList changeList = changeId == 0 ? new LinkedList() : this.changeLists.computeIfAbsent(changeId, k -> new LinkedList());
        if (updateType == PersistUpdate.Type.COMMIT) {
            changeList.addFirst(update);
        } else {
            changeList.add(update);
        }
        if (changeId == 0 || updateType == PersistUpdate.Type.COMMIT) {
            try {
                if (changeList.isEmpty()) {
                    throw new PersistException(Localise.format((String)"Nothing to commit in change %1$d", (Object[])new Object[]{changeId}));
                }
                this.commit(changeList);
            }
            finally {
                if (changeId != 0) {
                    this.changeLists.remove(changeId);
                }
            }
        }
    }

    private void commit(LinkedList<PersistUpdate> updates) throws PersistException {
        Message message;
        ArrayList<String> messages = new ArrayList<String>();
        PersistUpdate commitUpdate = updates.peekFirst();
        PersistUpdate.Type updateType = commitUpdate.getType();
        Connection connection = commitUpdate.getConnection();
        String reference = null;
        if (updateType == PersistUpdate.Type.COMMIT) {
            message = commitUpdate.getMessage();
            updates.removeFirst();
            if (message instanceof PersistCommand) {
                reference = ((PersistCommand)message).getReference();
            }
        }
        messages.add(Change.getChangeHeader((Connection)connection, reference));
        for (PersistUpdate update : updates) {
            message = update.getMessage();
            switch (update.getType()) {
                case SAVE: {
                    messages.add(this.save(update.getName(), message));
                    break;
                }
                case REMOVE: {
                    messages.add(this.remove(update.getName(), message));
                    break;
                }
            }
        }
        this.commitFinal(connection, commitUpdate.getTime(), messages);
    }

    private void commitFinal(Connection connection, long time, List<String> messages) throws PersistException {
        String authorEmail;
        String authorName;
        if (connection != null) {
            String hostName = connection.getClientHostName();
            authorName = connection.getOsUserName();
            authorEmail = String.format("%s@%s", authorName, hostName);
        } else {
            String hostName = NetUtils.getHostName();
            authorName = Program.getUserName();
            authorEmail = String.format("%s@%s", authorName, hostName);
        }
        long gitStart = System.currentTimeMillis();
        try {
            this.git.commit(authorName, authorEmail, time, StringUtils.join((String)"\n", messages));
        }
        catch (Exception e) {
            throw new PersistException(Localise.format((String)"Could not commit %1$d files - %2$s", (Object[])new Object[]{messages.size() - 1, e.getMessage()}));
        }
        if (Metrics.logger.isInfoEnabled()) {
            long gitEnd = System.currentTimeMillis();
            int i = messages.size() - 1;
            if (i > 1) {
                Localise.logInfo((Logger)Metrics.logger, (String)"%1$s to commit %2$d files", (Object[])new Object[]{TimeUtils.formatDuration((long)(gitEnd - gitStart), (boolean)true), messages.size() - 1});
            } else {
                Localise.logInfo((Logger)Metrics.logger, (String)"%1$s to commit %2$d file", (Object[])new Object[]{TimeUtils.formatDuration((long)(gitEnd - gitStart), (boolean)true), messages.size() - 1});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String save(Name name, Message<?> message) throws PersistException {
        Change.Action action;
        boolean newFile;
        File file;
        String tag;
        block16: {
            tag = message.getMessageTag();
            file = Persist.getFile(this.root, name, tag);
            File dir = file.getParentFile();
            boolean bl = newFile = !file.exists();
            if (newFile) {
                Localise.logDebug((Logger)logger, (String)"Saving %s to repository", (Object[])new Object[]{file});
            } else {
                Localise.logDebug((Logger)logger, (String)"Updating %s in repository", (Object[])new Object[]{file});
            }
            FilterOutputStream out = null;
            if (newFile && !dir.exists() && !dir.mkdirs()) {
                throw new PersistException(Localise.format((String)"Could not create directory %s", (Object[])new Object[]{dir.toString()}));
            }
            try {
                out = new DataOutputStream(new FileOutputStream(file));
                ((DataOutputStream)out).writeInt(MessageSerializer.getMessageType(message.getClass()));
                message.toProto().build().writeTo((OutputStream)out);
                if (out == null) break block16;
            }
            catch (Exception e) {
                try {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    out = null;
                    file.delete();
                    throw new PersistException(Localise.format((String)"Could not create/open message file %1$s - %2$s", (Object[])new Object[]{file.toString(), e.getMessage()}));
                }
                catch (Throwable throwable) {
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new PersistException(Localise.format((String)"Could not close message file %1$s - %2$s", (Object[])new Object[]{file.toString(), e2.getMessage()}));
                    }
                }
            }
            try {
                out.close();
            }
            catch (IOException e) {
                throw new PersistException(Localise.format((String)"Could not close message file %1$s - %2$s", (Object[])new Object[]{file.toString(), e.getMessage()}));
            }
        }
        try {
            this.git.add(Persist.getFile(name, tag));
        }
        catch (Exception e) {
            throw new PersistException(Localise.format((String)"Could not add file %1$s - %2$s", (Object[])new Object[]{file.toString(), e.getMessage()}));
        }
        if (newFile) {
            action = Change.Action.CREATED;
            return Change.getChangeEntry((Name)name, (String)tag, (Change.Action)action);
        }
        action = Change.Action.UPDATED;
        return Change.getChangeEntry((Name)name, (String)tag, (Change.Action)action);
    }

    public void save(File file) throws PersistException {
        Localise.logDebug((Logger)logger, (String)"Saving %s to repository", (Object[])new Object[]{file});
        File fileRelative = FileUtils.stripRoot((File)file, (File)this.root, (boolean)true);
        try {
            this.git.add(fileRelative);
        }
        catch (Exception e) {
            throw new PersistException(Localise.format((String)"Could not add file %1$s - %2$s", (Object[])new Object[]{file.toString(), e.getMessage()}));
        }
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(Change.getChangeHeader(null, null));
        messages.add(Change.getChangeEntry((Name)Name.parse((File)fileRelative), (String)"file", (Change.Action)Change.Action.UPDATED));
        this.commitFinal(null, System.currentTimeMillis(), messages);
    }

    private String remove(Name name, Message<?> message) throws PersistException {
        String tag = message.getMessageTag();
        File file = Persist.getFile(this.root, name, tag);
        if (!file.exists()) {
            throw new PersistFileNotFoundException(file);
        }
        Localise.logDebug((Logger)logger, (String)"Deleting %s from repository", (Object[])new Object[]{file});
        try {
            this.git.remove(Persist.getFile(name, tag));
        }
        catch (Exception e) {
            throw new PersistException(Localise.format((String)"Could not remove file %1$s - %2$s", (Object[])new Object[]{file.toString(), e.getMessage()}));
        }
        return Change.getChangeEntry((Name)name, (String)tag, (Change.Action)Change.Action.REMOVED);
    }

    public static Name getMessageName(String message) {
        int j;
        int i = message.indexOf(58) + 1;
        return i < (j = message.indexOf(32)) ? Name.parse((String)message.substring(i, j)) : null;
    }

    public <T extends Message<?>> List<T> get(Name name, String messageTag, String commitId, boolean directory) throws PersistException {
        return this.git.get(name, messageTag, commitId, directory);
    }

    public List<Change> getCommit(String commitId) throws PersistException {
        return this.git.getCommit(commitId);
    }

    public List<Change> getCommits(long startTimestamp, long endTimestamp) throws PersistException {
        return this.git.getCommits(startTimestamp, endTimestamp);
    }

    public List<Change> getHistory(Name name, String messageTag) throws PersistException {
        return this.git.getHistory(name, messageTag);
    }

    public static File getFile(File root, Name name, Class<?> clazz) {
        return Persist.getFile(root, name, MessageSerializer.getMessageTag(clazz));
    }

    public static File getFile(File root, Name name, String tag) {
        String path = name.getPath();
        if (path.equals("/")) {
            path = "/_";
        }
        return new File(String.format("%1$s/%3$s%2$s.%3$s", root.toString(), path, tag));
    }

    public static File getFile(Name name, String tag) {
        String path = name.getPath();
        if (path.equals("/")) {
            path = "/_";
        }
        return new File(String.format("%2$s%1$s.%2$s", path, tag));
    }

    public static String getPath(Name name, Class<?> clazz) {
        return Persist.getPath(name, MessageSerializer.getMessageTag(clazz));
    }

    public static String getPath(Name name, String tag) {
        String path = name.getPath();
        if (path.equals("/")) {
            path = "/_";
        }
        return String.format("%2$s%1$s.%2$s", path, tag);
    }

    public static String getDirectoryPath(Name name, String tag) {
        String path = String.format("%2$s%1$s", name.getPath(), tag);
        return path.endsWith("/") ? path : path + "/";
    }

    public static interface Git {
        public Git init(File var1, InetAddress var2, String var3) throws Exception;

        public String getRepositoryURL();

        public Date getCreationDate();

        public String getFirstCommitId();

        public String getLastCommitId();

        public String getLastCommitId(int var1);

        public boolean isCommit(String var1);

        public void add(File ... var1) throws Exception;

        public void remove(File ... var1) throws Exception;

        public void commit(String var1, String var2, long var3, String var5) throws Exception;

        public <T extends Message<?>> List<T> get(Name var1, String var2, String var3, boolean var4) throws PersistException;

        public List<Change> getCommit(String var1) throws PersistException;

        public List<Change> getCommits(long var1, long var3) throws PersistException;

        public List<Change> getHistory(Name var1, String var2) throws PersistException;
    }

    public static class PersistUnknownCommitException
    extends PersistException {
        private String commitId;

        public PersistUnknownCommitException(String commitId) {
            super(Localise.format((String)"Unknown commit %s", (Object[])new Object[]{commitId}));
            this.commitId = commitId;
        }

        public String getCommitId() {
            return this.commitId;
        }
    }

    public static class PersistFileNotFoundException
    extends PersistException {
        private File file;

        public PersistFileNotFoundException(File file) {
            super(Localise.format((String)"%s does not exist", (Object[])new Object[]{file.toString()}));
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }

    public static class PersistException
    extends Exception {
        public PersistException(String message) {
            super(message);
        }
    }

    public static interface Listener {
        public void messageLoaded(Name var1, Message<?> var2) throws PersistException;
    }
}

