/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobModeValidator;
import com.beyondcron.server.DataManager;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.util.HashMap;
import java.util.Map;

public class JobModeManager
extends JobModeValidator {
    private static Map<String, JobModeManager> managers = new HashMap<String, JobModeManager>();
    private DataManager data;
    private JobListener jobListener;
    private String jobListenerId = null;
    private PropertiesListener propertiesListener;
    String propertiesListenerId = null;

    public static synchronized JobModeManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        JobModeManager manager = managers.get(name);
        if (manager == null) {
            manager = new JobModeManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private JobModeManager(HazelcastInstance hazelcast) {
        super(hazelcast);
        this.data = DataManager.getInstance(hazelcast);
        this.jobListener = new JobListener();
        this.propertiesListener = new PropertiesListener();
        this.setActive(true);
    }

    public JobModeManager setActive(boolean active) {
        if (active) {
            if (this.jobListenerId == null) {
                this.jobListenerId = this.data.getJobs().addLocalEntryListener((MapListener)this.jobListener);
            }
            if (this.propertiesListenerId == null) {
                this.propertiesListenerId = this.data.getProperties().addLocalEntryListener((EntryListener)this.propertiesListener);
            }
        } else {
            if (this.jobListenerId != null) {
                this.data.getJobs().removeEntryListener(this.jobListenerId);
                this.jobListenerId = null;
            }
            if (this.propertiesListenerId != null) {
                this.data.getProperties().removeEntryListener(this.propertiesListenerId);
                this.propertiesListenerId = null;
            }
        }
        return this;
    }

    private class PropertiesListener
    implements EntryListener<Name, Property> {
        private PropertiesListener() {
        }

        public void entryAdded(EntryEvent<Name, Property> event) {
            JobModeManager.this.flushGroup((Name)event.getKey());
        }

        public void entryEvicted(EntryEvent<Name, Property> event) {
        }

        public void entryRemoved(EntryEvent<Name, Property> event) {
            JobModeManager.this.flushGroup((Name)event.getKey());
        }

        public void entryUpdated(EntryEvent<Name, Property> event) {
            JobModeManager.this.flushGroup((Name)event.getKey());
        }

        public void mapCleared(MapEvent event) {
        }

        public void mapEvicted(MapEvent event) {
        }
    }

    private class JobListener
    implements EntryAddedListener<Name, Job>,
    EntryUpdatedListener<Name, Job>,
    EntryRemovedListener<Name, Job> {
        private JobListener() {
        }

        public void entryAdded(EntryEvent<Name, Job> event) {
            JobModeManager.this.flushJob((Name)event.getKey());
        }

        public void entryRemoved(EntryEvent<Name, Job> event) {
            JobModeManager.this.flushJob((Name)event.getKey());
        }

        public void entryUpdated(EntryEvent<Name, Job> event) {
            JobModeManager.this.flushJob((Name)event.getKey());
        }
    }
}

