/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.BooleanUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.JSONUtils;
import com.beyondcron.core.License;
import com.beyondcron.core.Limit;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Program;
import com.beyondcron.core.Role;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.server.App;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.PersistManager;
import com.beyondcron.server.ServerLimit;
import com.beyondcron.server.UserManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LicenseManager {
    static final Logger logger = LogUtils.getLogger(LicenseManager.class);
    private static Map<String, LicenseManager> managers = new HashMap<String, LicenseManager>();
    private static final String SERVER_USER_NAME = " g3XVegCaMDqvssm88k32";
    private HazelcastInstance hazelcast;
    private IMap<Name, String> owners;
    private IMap<Name, String> homes;
    private IMap<String, License> licenses;
    private boolean evaluationLicense = false;
    private License serverLicense = null;
    private Date serverLicenseExpiry = null;
    private Limit serverLimit = null;
    private IAtomicLong serverJobs;
    private IMap<String, Limit> userLimits;
    private boolean hasUserLimits;
    private boolean adminRoleRequiresLicense = (Boolean)Configs.get((String)"beyondcron.admin.role.license.required");

    public static synchronized LicenseManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        LicenseManager manager = managers.get(name);
        if (manager == null) {
            manager = new LicenseManager(hazelcast);
            managers.put(name, manager);
            if (manager.getServerLicense() == null) {
                try {
                    manager.setServerLicense(new License(), false);
                }
                catch (LicenseException e) {
                    Localise.logFatal((Logger)logger, (Exception)e, (String)"Unexpected exception", (Object[])new Object[0]);
                    Program.exit((int)1);
                }
            }
        }
        return manager;
    }

    private LicenseManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.licenses = Hazelcast.getLicences((HazelcastInstance)hazelcast);
        this.licenses.addEntryListener((MapListener)((EntryAddedListener)event -> this.updateServerLicense((License)event.getValue())), (Object)SERVER_USER_NAME, true);
        this.licenses.addEntryListener((MapListener)((EntryUpdatedListener)event -> this.updateServerLicense((License)event.getValue())), (Object)SERVER_USER_NAME, true);
        this.owners = Hazelcast.getLicenseOwners((HazelcastInstance)hazelcast);
        this.homes = Hazelcast.getUserHomes((HazelcastInstance)hazelcast);
        this.userLimits = Hazelcast.getLicenseLimits((HazelcastInstance)hazelcast);
        this.userLimits.addEntryListener((MapListener)((EntryAddedListener)event -> {
            this.hasUserLimits = !this.userLimits.isEmpty();
        }), false);
        this.userLimits.addEntryListener((MapListener)((EntryRemovedListener)event -> {
            this.hasUserLimits = !this.userLimits.isEmpty();
        }), false);
        this.serverJobs = Hazelcast.getServerJobs((HazelcastInstance)hazelcast);
        this.init();
    }

    private void init() {
        if (this.licenses.isEmpty()) {
            for (User user : UserManager.getInstance(this.hazelcast).getUsers(null)) {
                this.addUser(user);
            }
        }
    }

    public void addUser(User user) {
        if (!this.userRequiresLicense(user)) {
            return;
        }
        String userName = user.getName();
        if (this.licenses.containsKey((Object)userName) || this.userLimits.containsKey((Object)userName)) {
            this.refreshUser(user);
            return;
        }
        License license = user.getLicense();
        if (license == null) {
            return;
        }
        this.licenses.put((Object)userName, (Object)license);
        Name home = user.getHome();
        if (home != null) {
            this.userLimits.put((Object)userName, (Object)this.addHome(userName, home, new Limit(license)));
        }
    }

    public void removeUser(User user) {
        String userName = user.getName();
        this.licenses.remove((Object)userName);
        this.userLimits.remove((Object)userName);
        Name home = user.getHome();
        if (home != null) {
            this.removeHome(userName, home);
        }
    }

    public void refreshUser(User user) {
        String userName = user.getName();
        License license = user.getLicense();
        if (license == null || !this.userRequiresLicense(user)) {
            this.removeUser(user);
            return;
        }
        this.licenses.put((Object)userName, (Object)license);
        Name home = user.getHome();
        if (home == null) {
            this.removeHome(userName);
            return;
        }
        if (this.homes.containsKey((Object)home)) {
            if (!((String)this.homes.get((Object)home)).equals(userName)) {
                this.removeHome(userName);
            }
            this.userLimits.put((Object)userName, (Object)this.addHome(userName, home, new Limit(license)));
        } else {
            this.userLimits.put((Object)userName, (Object)this.addHome(userName, home, new Limit(license)));
        }
    }

    private Limit addHome(String userName, Name home, Limit limit) {
        this.homes.put((Object)home, (Object)userName);
        DataManager data = DataManager.getInstance(this.hazelcast);
        long calendars = 0L;
        for (Name name : data.getCalendars(home)) {
            this.owners.put((Object)name, (Object)userName);
            ++calendars;
        }
        limit.setCalendars(calendars);
        long jobs = 0L;
        for (Name name : data.getJobs(home)) {
            this.owners.put((Object)name, (Object)userName);
            ++jobs;
        }
        limit.setJobs(jobs);
        return limit;
    }

    private void removeHome(String userName) {
        for (Name home : this.homes.keySet()) {
            if (!((String)this.homes.get((Object)home)).equals(userName)) continue;
            this.removeHome(userName, home);
        }
    }

    private void removeHome(String userName, Name home) {
        String removed = (String)this.homes.remove((Object)home);
        if (removed != null) {
            ArrayList<Name> remove = new ArrayList<Name>();
            for (Name name : this.owners.keySet()) {
                if (!((String)this.owners.get((Object)name)).equals(userName)) continue;
                remove.add(name);
            }
            for (Name name : remove) {
                this.owners.remove((Object)name);
            }
        }
    }

    private String getUserName(Name name) {
        for (Name home : this.homes.keySet()) {
            if (!home.contains(name)) continue;
            return (String)this.homes.get((Object)home);
        }
        return null;
    }

    public void resetExecutionCounter(String userName) {
        Limit limit = (Limit)this.userLimits.get((Object)userName);
        if (limit != null && limit.getExecutions() > 0L) {
            limit.resetExecutionCounter();
            this.userLimits.put((Object)userName, (Object)limit);
        }
    }

    public License getServerLicense() {
        return (License)this.licenses.get((Object)SERVER_USER_NAME);
    }

    public void loadServerLicense(License defaultLicense) throws LicenseException {
        License license;
        block14: {
            String licenseFileName;
            File licenseFile;
            String licenseText;
            Exception persistLicenseException;
            block13: {
                Localise.logDebug((Logger)logger, (String)"Initing license", (Object[])new Object[0]);
                if (!this.getServerLicense().isDefaultLicense()) {
                    Localise.logDebug((Logger)logger, (String)"Non default license already loaded", (Object[])new Object[0]);
                    return;
                }
                license = null;
                persistLicenseException = null;
                licenseText = (String)Configs.getConfig((String)"beyondcron.license").getValue();
                if (!StringUtils.isNullOrEmpty((String)licenseText)) {
                    try {
                        license = new License(StringUtils.asStream((String)JSONUtils.fromYAML((String)licenseText).toString()), false);
                        this.validateServerLicense(license);
                        Localise.logDebug((Logger)logger, (String)"Loading persisted license", (Object[])new Object[0]);
                        this.logLicence(license, logger, Level.DEBUG);
                    }
                    catch (Exception e) {
                        persistLicenseException = e;
                        Localise.logError((Logger)logger, (String)"Persisted license is invalid - %1$s", (Object[])new Object[]{e.getMessage()});
                        if (license == null) break block13;
                        this.logLicence(license, logger, Level.ERROR);
                        license = null;
                    }
                }
            }
            if (license == null && (licenseFile = new File(licenseFileName = "/tmp/license.yaml")).exists() && licenseFile.canRead()) {
                try {
                    licenseText = FileUtils.read((File)licenseFile);
                }
                catch (IOException e) {
                    Localise.logError((Logger)logger, (String)"Unexpected error reading %1$s - %2$s", (Object[])new Object[]{licenseFileName, e.getMessage()});
                }
                if (!StringUtils.isNullOrEmpty((String)licenseText)) {
                    try {
                        license = new License(StringUtils.asStream((String)licenseText));
                        this.validateServerLicense(license);
                        Localise.logWarn((Logger)logger, (String)"Loading temporary license %1$s", (Object[])new Object[]{licenseFileName});
                        Localise.logWarn((Logger)logger, (String)"  within bc-cli execute \"server license load %1$s\" to persist this license", (Object[])new Object[]{licenseFileName});
                        this.logLicence(license, logger, Level.DEBUG);
                    }
                    catch (Exception e) {
                        Localise.logError((Logger)logger, (String)"Temporary license file %1$s is invalid - %2$s", (Object[])new Object[]{licenseFileName, e.getMessage()});
                        if (license != null) {
                            this.logLicence(license, logger, Level.ERROR);
                            license = null;
                        }
                        if (persistLicenseException instanceof LicenseException) {
                            throw (LicenseException)persistLicenseException;
                        }
                        if (!(e instanceof LicenseException)) break block14;
                        throw (LicenseException)e;
                    }
                }
            }
        }
        if (license == null) {
            license = defaultLicense;
            this.validateServerLicense(license);
            Localise.logWarn((Logger)logger, (String)"Loading default license", (Object[])new Object[0]);
        }
        this.setServerLicense(license);
    }

    public void setServerLicense(License license) throws LicenseException {
        this.setServerLicense(license, true);
    }

    private void setServerLicense(License license, boolean validate) throws LicenseException {
        if (license == null) {
            throw new IllegalArgumentException("license cannot be null");
        }
        if (validate) {
            this.validateServerLicense(license);
        }
        this.licenses.put((Object)SERVER_USER_NAME, (Object)license);
    }

    private void updateServerLicense(License license) {
        if (license.getExpiry().getTime() > 0L) {
            ArrayList<String> lines = new ArrayList<String>();
            if (this.serverLicense == null) {
                lines.add("License details:");
            } else {
                lines.add("License updated:");
            }
            this.serverLicense = license;
            this.evaluationLicense = this.serverLicense.getType() == License.Type.EVALUATION;
            lines.addAll(Arrays.asList(license.toTable().setColumnSeparator(" ").setIndent("  ").toString().split("\\n")));
            for (String line : lines) {
                LogUtils.consolePrint((Logger)App.logger, (String)line);
            }
        }
        this.serverLicenseExpiry = !license.isTestLicense() ? (license.getType().hasHardExpiry() ? license.getExpiry() : null) : TimeUtils.getDate((LocalDateTime)TimeUtils.getLocalDateTime((Date)license.getIssued()).plusDays(1L));
        if (this.serverLimit != null) {
            this.serverLimit.setLicense(license);
        } else {
            this.serverLimit = new ServerLimit(this.hazelcast, license);
        }
        this.refreshServerLimits();
    }

    public void refreshServerLimits() {
        DataManager data = DataManager.getInstance(this.hazelcast);
        this.serverLimit.setCalendars((long)data.getCalendars().size());
        this.serverLimit.setJobs((long)data.getJobs().size() - this.serverJobs.get());
    }

    private void refreshServerLicense() {
        if (this.evaluationLicense && !((ServerLimit)this.serverLimit).isExpired() && this.serverLicense.isExpired()) {
            this.serverLimit.setLicense(this.serverLicense.reset());
            try {
                this.setServerLicense(this.serverLicense, false);
            }
            catch (LicenseException e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception refreshing license", (Object[])new Object[0]);
            }
        }
    }

    public License getLicense(User user) {
        License license = (License)this.licenses.get((Object)user.getName());
        return license != null ? license : this.getServerLicense();
    }

    public Limit getServerLimit() {
        return new Limit(this.serverLimit);
    }

    public License getUserLicense(String userName) {
        return (License)this.licenses.get((Object)userName);
    }

    public Limit getUserLimit(Name name) {
        String owner = (String)this.owners.get((Object)name);
        return owner != null ? (Limit)this.userLimits.get((Object)owner) : null;
    }

    public Limit getUserLimit(String userName) {
        return (Limit)this.userLimits.get((Object)userName);
    }

    public String getProperty(User user, String name) {
        String value;
        License license = (License)this.licenses.get((Object)user.getName());
        if (license != null && (value = license.getProperty(name)) != null) {
            return value;
        }
        return ((License)this.licenses.get((Object)SERVER_USER_NAME)).getProperty(name);
    }

    public String getProperty(User user, String name, String defaultValue) {
        String value = this.getProperty(user, name);
        return value != null ? value : defaultValue;
    }

    public boolean getBooleanProperty(User user, String name) {
        String value = this.getProperty(user, name);
        return value != null ? BooleanUtils.isTrueYes((String)value) : false;
    }

    public int getIntProperty(User user, String name) {
        int defaultValue = 0;
        String value = this.getProperty(user, name);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException e) {
            Localise.logWarn((Logger)logger, (String)"Property %1$s value %2$s is not an integer, returning default %3$d", (Object[])new Object[]{name, value, defaultValue});
        }
        return defaultValue;
    }

    public long getLongProperty(User user, String name) {
        long defaultValue = 0L;
        String value = this.getProperty(user, name);
        try {
            if (value != null) {
                return Long.parseLong(value);
            }
        }
        catch (NumberFormatException e) {
            Localise.logWarn((Logger)logger, (String)"Property %1$s value %2$s is not an integer, returning default %3$d", (Object[])new Object[]{name, value, defaultValue});
        }
        return defaultValue;
    }

    public void addCalendar(Name name) throws LimitException {
        String userName = null;
        Limit userLimit = null;
        if (this.hasUserLimits) {
            userName = this.getUserName(name);
            Limit limit = userLimit = userName != null ? (Limit)this.userLimits.get((Object)userName) : null;
            if (userLimit != null && !userLimit.addCalendar()) {
                throw new LimitException(userName, AbstractException.Type.USER, LimitException.LimitType.CALENDAR, userLimit);
            }
        }
        this.refreshServerLicense();
        if (!this.serverLimit.addCalendar()) {
            throw new LimitException(AbstractException.Type.SERVER, LimitException.LimitType.CALENDAR, this.serverLimit);
        }
        if (userLimit != null) {
            this.userLimits.put((Object)userName, (Object)userLimit);
            this.owners.put((Object)name, (Object)userName);
        }
    }

    public void removeCalendar(Name name) {
        Limit userLimit;
        String userName;
        if (this.hasUserLimits && (userName = (String)this.owners.remove((Object)name)) != null && (userLimit = (Limit)this.userLimits.get((Object)userName)) != null && userLimit.removeCalendar()) {
            this.userLimits.put((Object)userName, (Object)userLimit);
        }
        this.serverLimit.removeCalendar();
    }

    public long addServerJob() {
        long i = this.serverJobs.incrementAndGet();
        this.refreshServerLimits();
        return i;
    }

    public void addJob(Name name) throws LimitException {
        String userName = null;
        Limit userLimit = null;
        if (this.hasUserLimits) {
            userName = this.getUserName(name);
            Limit limit = userLimit = userName != null ? (Limit)this.userLimits.get((Object)userName) : null;
            if (userLimit != null && !userLimit.addJob()) {
                throw new LimitException(userName, AbstractException.Type.USER, LimitException.LimitType.JOB, userLimit);
            }
        }
        this.refreshServerLicense();
        if (!this.serverLimit.addJob()) {
            throw new LimitException(AbstractException.Type.SERVER, LimitException.LimitType.JOB, this.serverLimit);
        }
        if (userLimit != null) {
            this.userLimits.put((Object)userName, (Object)userLimit);
            this.owners.put((Object)name, (Object)userName);
        }
    }

    public void removeJob(Name name) {
        Limit userLimit;
        String userName;
        if (this.hasUserLimits && (userName = (String)this.owners.remove((Object)name)) != null && (userLimit = (Limit)this.userLimits.get((Object)userName)) != null && userLimit.removeJob()) {
            this.userLimits.put((Object)userName, (Object)userLimit);
        }
        this.serverLimit.removeJob();
    }

    public void execute(Name name) throws LicenseException, LimitException {
        Limit userLimit;
        String userName = this.hasUserLimits ? (String)this.owners.get((Object)name) : null;
        this.validateLicense(userName);
        Limit limit = userLimit = userName != null ? (Limit)this.userLimits.get((Object)userName) : null;
        if (userLimit != null && !userLimit.execute(userName)) {
            throw new LimitException(userName, AbstractException.Type.USER, LimitException.LimitType.EXECUTION, userLimit);
        }
        this.refreshServerLicense();
        if (!this.serverLimit.execute("server")) {
            throw new LimitException(AbstractException.Type.SERVER, LimitException.LimitType.EXECUTION, this.serverLimit);
        }
        if (userLimit != null) {
            this.userLimits.put((Object)userName, (Object)userLimit);
        }
    }

    private boolean userRequiresLicense(User user) {
        return this.adminRoleRequiresLicense || !user.hasRole(Role.ADMIN);
    }

    public void validateLicense(User user) throws LicenseException {
        this.validateLicense(user.getName());
    }

    public void validateLicense(String userName) throws LicenseException {
        License userLicense;
        if (userName != null && (userLicense = (License)this.licenses.get((Object)userName)) != null && userLicense.isExpired()) {
            throw new LicenseException(userName, AbstractException.Type.USER, userLicense.getExpiry());
        }
        if (this.serverLicenseExpiry != null && new Date().after(this.serverLicenseExpiry)) {
            throw new LicenseException(AbstractException.Type.SERVER, this.serverLicenseExpiry);
        }
    }

    public void validateServerLicense(License license) throws LicenseException {
        if (!license.isValid()) {
            throw new LicenseException(license.getReason());
        }
        String licenseInstance = license.getInstance();
        if (!StringUtils.isNullOrEmpty((String)licenseInstance) && !PersistManager.getInstance(this.hazelcast).isCommitId(licenseInstance)) {
            throw new LicenseException(Localise.format((String)"License is not valid on this server"));
        }
        if (license.isExpired()) {
            if (!license.getType().hasHardExpiry()) {
                if (Program.getVersion().getBuildDate().after(license.getExpiry()) && logger != null) {
                    throw new LicenseException(Localise.format((String)"License is not valid for this release, please downgrade to an earlier release, or contact %1$s to renew your license.", (Object[])new Object[]{Program.getVendor()}));
                }
            } else if (logger != null) {
                throw new LicenseException(Localise.format((String)"License has expired, please contact %2$s to renew your license.", (Object[])new Object[]{Program.getVendor()}));
            }
        }
    }

    private void logLicence(License license, Logger logger, Level level) {
        Iterator lines = license.toTable().iterator();
        while (lines.hasNext()) {
            logger.log(level, (String)lines.next());
        }
    }

    public static class LimitException
    extends AbstractException {
        private LimitType limitType;
        long value;
        long maxValue;

        public LimitException(AbstractException.Type type, LimitType limitType, Limit limit) {
            this(type.getLabel(), type, limitType, limit);
        }

        public LimitException(String userName, AbstractException.Type type, LimitType limitType, Limit limit) {
            super(userName, type);
            this.limitType = limitType;
            switch (limitType) {
                case CALENDAR: {
                    this.value = limit.getCalendars();
                    this.maxValue = limit.getMaxCalendars();
                    break;
                }
                case JOB: {
                    this.value = limit.getJobs();
                    this.maxValue = limit.getMaxJobs();
                    break;
                }
                case EXECUTION: {
                    this.value = limit.getExecutions();
                    this.maxValue = limit.getMaxExecutions();
                }
            }
        }

        public LimitType getLimitType() {
            return this.limitType;
        }

        public long getValue() {
            return this.value;
        }

        public long getMaxValue() {
            return this.maxValue;
        }

        @Override
        public String getMessage() {
            if (this.limitType == LimitType.EXECUTION) {
                return Localise.format((String)"%s %s limit (%s/day) exceeded", (Object[])new Object[]{this.userName, this.limitType.getLabel(), this.maxValue});
            }
            return Localise.format((String)"%s %s limit of (%s) exceeded", (Object[])new Object[]{this.userName, this.limitType.getLabel(), this.maxValue});
        }

        public static enum LimitType {
            CALENDAR("calendar"),
            JOB("job"),
            EXECUTION("job execution");

            private String label;

            private LimitType(String label) {
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }
        }
    }

    public static class LicenseException
    extends AbstractException {
        private Date expiry;
        private String message = null;

        public LicenseException(AbstractException.Type type, Date expiry) {
            this(type.getLabel(), type, expiry);
        }

        public LicenseException(String userName, AbstractException.Type type, Date expiry) {
            super(userName, type);
            this.expiry = expiry;
        }

        public LicenseException(String message) {
            this(AbstractException.Type.SERVER, message);
        }

        public LicenseException(AbstractException.Type type, String message) {
            super(type.getLabel(), type);
            this.message = message;
            this.expiry = null;
        }

        public boolean isExpired() {
            return this.expiry != null;
        }

        public Date getExpiry() {
            return this.expiry;
        }

        @Override
        public String getMessage() {
            return this.message != null ? this.message : Localise.format((String)"%s license expired on %s", (Object[])new Object[]{this.userName, this.expiry});
        }
    }

    protected static class AbstractException
    extends Exception {
        protected String userName;
        protected Type type;

        protected AbstractException(String userName, Type type) {
            this.userName = userName;
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public String getUserName() {
            return this.userName;
        }

        public static enum Type {
            SERVER("server"),
            USER("user");

            private String label;

            private Type(String label) {
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }
        }
    }
}

