/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.aws;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.StatusService;
import com.beyondcron.service.aws.AWSClient;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class AWSStatusService
extends StatusService {
    static final Logger logger = LogUtils.getLogger(AWSStatusService.class);
    public static final String SERVICE_NAME = "AWS";
    @StringConfig.Annotation
    public static final String AWS_TABLE_CURRENT = "aws.table.current";
    @StringConfig.Annotation
    public static final String AWS_TABLE_HISTORY = "aws.table.history";
    @StringConfig.Annotation
    public static final String AWS_S3_BUCKET = "aws.s3.bucket";
    @StringConfig.Annotation(defaultValue="beyondcron/status/output")
    public static final String AWS_S3_OBJECT_PREFIX = "aws.s3.object.prefix";
    public static final String AWS_S3_OBJECT_PREFIX_FORMAT = "beyondcron/%s/status/output";
    private AWSClient awsClient;
    private AmazonDynamoDBClient dbClient;
    private DynamoDB db;
    private AmazonS3Client s3Client;
    private Table currentTable;
    private Table historyTable;
    private String outputBucket;
    private String keyPrefix;

    public static void main(String[] args) throws IOException, ServiceException {
        AWSStatusService service = new AWSStatusService();
        System.out.println("endpoint prefix: " + service.dbClient.getEndpointPrefix());
        Status status = new Status(Name.parse((String)"/hello/world"));
        status.setOutput(new Output(new File("/Users/adr/cal-test.ics")));
        service.saveStatus(status);
        System.out.println(service.getStatus(status.getName(), 1479780550254L, true).toJSON().toString(2));
        System.out.println("getStatuses - current");
        for (Status s : service.getStatuses()) {
            System.out.println("- " + s.getName());
        }
        System.out.println("getStatuses - history");
        for (Status s : service.getStatuses(status.getName(), 1479781747062L, 1479787634272L)) {
            System.out.println("- " + s.toJSON());
        }
    }

    public AWSStatusService() {
        super(SERVICE_NAME);
    }

    public boolean disconnect() {
        if (!super.disconnect()) {
            return false;
        }
        if (this.dbClient != null) {
            this.dbClient.shutdown();
        }
        if (this.s3Client != null) {
            this.s3Client.shutdown();
        }
        return true;
    }

    protected void init() throws ServiceException {
        boolean startupConfig = false;
        if (AWSClient.validateConfigs(false, new String[0]).size() == AWSClient.validateConfigs(false, new String[0]).size()) {
            startupConfig = AWSClient.validateConfigs(true, AWS_TABLE_CURRENT, AWS_TABLE_HISTORY, AWS_S3_BUCKET).isEmpty();
        }
        this.awsClient = new AWSClient(startupConfig, AWS_TABLE_CURRENT, AWS_TABLE_HISTORY, AWS_S3_BUCKET);
        this.initDb();
        this.initS3();
    }

    private void initDb() throws ServiceException {
        this.dbClient = this.awsClient.getDBClient();
        this.db = new DynamoDB((AmazonDynamoDB)this.dbClient);
        this.currentTable = this.getStatusTable((String)Configs.get((String)AWS_TABLE_CURRENT), false);
        this.historyTable = this.getStatusTable((String)Configs.get((String)AWS_TABLE_HISTORY), true);
    }

    private void initS3() throws ServiceException {
        this.s3Client = this.awsClient.getS3Client();
        this.outputBucket = (String)Configs.get((String)AWS_S3_BUCKET);
        try {
            this.s3Client.headBucket(new HeadBucketRequest(this.outputBucket));
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() != 404) {
                throw new ServiceException((Throwable)e);
            }
            logger.info("creating bucket {}", (Object)this.outputBucket);
            try {
                this.s3Client.createBucket(this.outputBucket);
            }
            catch (AmazonServiceException e2) {
                throw new ServiceException((Throwable)e2);
            }
        }
        this.keyPrefix = this.awsClient.hasProfile() && Configs.isDefault((String)AWS_S3_OBJECT_PREFIX) ? String.format(AWS_S3_OBJECT_PREFIX_FORMAT, this.awsClient.hasProfile()) : (String)Configs.get((String)AWS_S3_OBJECT_PREFIX);
    }

    private Table getStatusTable(String name, boolean rangeTable) throws ServiceException {
        Table table = this.db.getTable(name);
        boolean createTable = false;
        try {
            table.describe();
        }
        catch (ResourceNotFoundException e) {
            createTable = true;
        }
        if (createTable) {
            logger.info("creating table {}", (Object)name);
            List<KeySchemaElement> keySchema = rangeTable ? Arrays.asList(new KeySchemaElement("name", KeyType.HASH), new KeySchemaElement("timestamp", KeyType.RANGE)) : Arrays.asList(new KeySchemaElement("name", KeyType.HASH));
            List<AttributeDefinition> attributeDefinitions = rangeTable ? Arrays.asList(new AttributeDefinition("name", ScalarAttributeType.S), new AttributeDefinition("timestamp", ScalarAttributeType.N)) : Arrays.asList(new AttributeDefinition("name", ScalarAttributeType.S));
            CreateTableRequest tableRequest = new CreateTableRequest().withTableName(name).withKeySchema(keySchema).withAttributeDefinitions(attributeDefinitions).withBillingMode(BillingMode.PAY_PER_REQUEST);
            try {
                table = this.db.createTable(tableRequest);
                table.waitForActive();
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return table;
    }

    public Status getStatus(Name name, long timestamp, boolean includeOutput) {
        if (!this.isConnected()) {
            return null;
        }
        Status status = null;
        GetItemSpec spec = new GetItemSpec().withPrimaryKey("name", (Object)name.toString(), "timestamp", (Object)timestamp);
        try {
            Item item = this.historyTable.getItem(spec);
            if (item != null && (status = new Status().fromJSON(new JSONObject(item.toJSON()))).hasOutput() && includeOutput) {
                status.setOutput(this.getOutput(this.getS3Key(status)));
            }
        }
        catch (Exception e) {
            logger.error("unexpected exception - getStatus({}, {}, {})", (Object)name.toString(), (Object)Long.valueOf(timestamp).toString(), (Object)Boolean.valueOf(includeOutput).toString(), (Object)e);
        }
        return status;
    }

    private Output getOutput(String key) throws ServiceException {
        logger.info("getOutput - {}", (Object)key);
        try {
            return new Output().fromJSON(new JSONObject(this.s3Client.getObjectAsString(this.outputBucket, key)));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public List<Status> getStatuses(Name name, long startTimestamp, long endTimestamp) {
        if (name.isWildcard()) {
            throw new RuntimeException(Localise.format((String)"%1$s status service does not support wildcard queries", (Object[])new Object[]{SERVICE_NAME}));
        }
        if (!this.isConnected()) {
            return new ArrayList<Status>();
        }
        QuerySpec spec = new QuerySpec().withHashKey("name", (Object)name.toString());
        RangeKeyCondition range = new RangeKeyCondition("timestamp");
        if (endTimestamp < startTimestamp) {
            range.between((Object)startTimestamp, (Object)System.currentTimeMillis());
        } else {
            range.between((Object)startTimestamp, (Object)endTimestamp);
        }
        spec.withRangeKeyCondition(range);
        try {
            return this.getStatuses((Iterator<Item>)this.historyTable.query(spec).iterator());
        }
        catch (Exception e) {
            logger.error("unexpected exception - getStatuses({}, {}, {})", (Object)name.toString(), (Object)Long.valueOf(startTimestamp).toString(), (Object)Long.valueOf(endTimestamp).toString(), (Object)e);
            return new ArrayList<Status>();
        }
    }

    public List<Status> getStatuses() {
        if (!this.isConnected()) {
            return new ArrayList<Status>();
        }
        try {
            return this.getStatuses((Iterator<Item>)this.currentTable.scan(new ScanSpec()).iterator());
        }
        catch (Exception e) {
            logger.error("unexpected exception - getStatuses()", (Throwable)e);
            return new ArrayList<Status>();
        }
    }

    private List<Status> getStatuses(Iterator<Item> items) {
        ArrayList<Status> statuses = new ArrayList<Status>();
        while (items.hasNext()) {
            statuses.add(new Status().fromJSON(new JSONObject(items.next().toJSON())));
        }
        return statuses;
    }

    public void saveStatus(Status status) {
        if (!this.isConnected()) {
            return;
        }
        Item item = Item.fromJSON((String)status.toJSON(false).toString());
        item.withPrimaryKey("name", (Object)status.getName().toString());
        try {
            this.currentTable.putItem(item);
        }
        catch (Exception e) {
            logger.error("unexpected exception - saveStatus({}) - current", (Object)status.toString(), (Object)e);
            return;
        }
        item.withPrimaryKey("timestamp", (Object)status.getTimestamp());
        try {
            this.historyTable.putItem(item);
        }
        catch (Exception e) {
            logger.error("unexpected exception - saveStatus({}) - history", (Object)status.toString(), (Object)e);
            return;
        }
        if (status.hasOutput()) {
            try {
                this.s3Client.putObject(this.outputBucket, this.getS3Key(status), status.getOutput().toJSON().toString());
            }
            catch (Exception e) {
                logger.error("unexpected exception - saveStatus({}) - output", (Object)status.toString(), (Object)e);
            }
        }
    }

    public int removeStatuses(long timestamp) {
        if (!this.isConnected()) {
            return 0;
        }
        logger.warn("method not yet implemented");
        return 0;
    }

    public int removeStatuses(Name name, long timestamp) {
        if (!this.isConnected()) {
            return 0;
        }
        logger.warn("method not yet implemented");
        return 0;
    }

    private String getS3Key(Status status) {
        return this.keyPrefix + status.getName().toString() + "." + status.getTimestamp();
    }

    static {
        Configs.addConfigs(AWSStatusService.class);
    }
}

