/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent;

import com.beyondcron.agent.ProcessManager;
import com.beyondcron.agent.service.CommandService;
import com.beyondcron.agent.service.ProcessList;
import com.beyondcron.agent.service.Shell;
import com.beyondcron.core.Configs;
import com.beyondcron.core.InetSocketAddress;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.AgentConnection;
import com.beyondcron.messaging.Connection;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.service.kubernetes.KubernetesAgentService;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import jnr.constants.platform.Signal;
import org.apache.logging.log4j.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

public class App
implements Program.SignalHandler {
    static final Logger logger = LogUtils.getLogger(App.class);
    public static final String programName = Program.getName();
    @Option(name="--host", aliases={"-h"}, usage="Set the host name of the agent.")
    private String argHostName = null;
    @Option(name="--local", aliases={"-l"}, usage="Start as a local agent only.")
    private boolean argLocal = false;
    @Option(name="--cluster", aliases={"-c"}, usage="Name of cluster to connect to. Default = beyondcron.")
    private String argCluster = null;
    @Option(name="--help", aliases={"-?"}, usage="Print this message.")
    private boolean argHelp = false;
    @Option(name="--version", aliases={"-v"}, usage="Print program version.")
    private boolean argVersion = false;
    @Argument(metaVar="[<server>][:<port>] ...", usage="Server/s name and/or port number")
    private List<InetSocketAddress> servers;
    private int exitCode = 1;
    private Signal stopSignal;
    private AgentConnection connection = null;

    public static void main(String[] args) {
        Localise.addBundle((String)"bc-agent");
        NetUtils.setDefaultHostName((String)Hazelcast.DEFAULT_HOST);
        NetUtils.setDefaultPort((int)Hazelcast.DEFAULT_PORT);
        try {
            boolean error;
            int exitCode = new App(args).run();
            boolean bl = error = exitCode != 0;
            if (!error) {
                LogUtils.consolePrint((Logger)logger, (String)(Program.getName() + " stopped " + new Date()));
            }
            Program.exit((int)exitCode, (boolean)error, (boolean)false);
        }
        catch (Exception e) {
            Localise.logFatal((Logger)logger, (Exception)e, (String)"Unexpected exception", (Object[])new Object[0]);
            Localise.logFatal((Logger)logger, (String)"  OS: %s %s %s", (Object[])new Object[]{Program.getOsName(), Program.getOsArch(), Program.getOsVersion()});
            Localise.logFatal((Logger)logger, (String)"Java: %s %s", (Object[])new Object[]{Program.getJavaVersion(), Program.getJavaVendor()});
            Program.exit((int)1);
        }
    }

    public App(String[] args) {
        Program program = new Program((Object)this);
        try {
            program.parseArgs(args);
        }
        catch (CmdLineException e) {
            System.err.println(programName + ": " + e.getMessage());
            program.printUsage((OutputStream)System.err);
            Program.exit((int)1);
        }
        if (this.argVersion) {
            Program.printVersion();
            System.exit(0);
        } else if (this.argHelp) {
            program.printUsage((OutputStream)System.out, true);
            Program.exit((int)0);
        } else if (program.isRootUser()) {
            System.err.println(Localise.format((String)"%1$s: run as a non-root user", (Object[])new Object[]{Program.getName()}));
            System.exit(1);
        }
        this.init();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int run() {
        ProcessManager processManager = new ProcessManager((Connection)this.connection, !this.argLocal);
        LogUtils.consolePrint((Logger)logger, (String)Localise.format((String)"Job execution: %s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", processManager.getServiceNames())}));
        LogUtils.consolePrint((Logger)logger, (String)Localise.format((String)"%s started %s", (Object[])new Object[]{Program.getName(), new Date()}));
        processManager.run();
        this.close();
        return this.exitCode;
    }

    private synchronized void close() {
        if (!Program.setShuttingDown((boolean)true)) {
            Localise.logWarn((Logger)logger, (String)"Shutting down due to an external event", (Object[])new Object[0]);
        }
        if (this.connection == null || this.connection.isClosing()) {
            return;
        }
        this.connection.close();
        this.connection = null;
    }

    private void init() {
        LogUtils.consolePrint((Logger)logger, (String)(Program.getName() + " " + Program.getVersion()));
        LogUtils.consolePrint((Logger)logger, (String)Program.getCopyright());
        LogUtils.consolePrint((Logger)logger, (String)("Process ID: " + Program.posix.getpid()));
        LogUtils.consolePrint((Logger)logger, (String)("Java: " + Program.getJavaVersion() + " " + Program.getJavaVendor()));
        LogUtils.consolePrintConfigURL((Logger)logger);
        if (!StringUtils.isNullOrEmpty((String)this.argCluster)) {
            Configs.set((String)"BEYONDCRON_CLUSTER_NAME", (Object)this.argCluster);
        }
        if (!StringUtils.isNullOrEmpty((String)this.argHostName)) {
            Configs.set((String)"BEYONDCRON_HOST_NAME", (Object)this.argHostName);
        }
        if (StringUtils.isNullOrEmpty((Object)this.argLocal)) {
            this.argLocal = (Boolean)Configs.get((String)"BEYONDCRON_AGENT_LOCAL");
        }
        this.initConfig();
        this.initShutdownHandlers();
        this.initHazelcast();
    }

    private void initConfig() {
        if (Configs.hasService()) {
            LogUtils.consolePrint((Logger)logger, (String)("Configuration service: " + Configs.getService().getServiceDescription()));
        }
        Configs.addConfigs(CommandService.class);
        Configs.addConfigs(ProcessList.class);
        Configs.addConfigs(Shell.class);
        if (((Boolean)Configs.get((String)"BEYONDCRON_EARLY_ACCESS")).booleanValue()) {
            Configs.addConfigs(KubernetesAgentService.class);
        }
    }

    private void initHazelcast() {
        Localise.logInfo((Logger)logger, (String)"Connecting to BeyondCron", (Object[])new Object[0]);
        try {
            this.connection = new AgentConnection(this.servers, !this.argLocal);
        }
        catch (Exception e) {
            Localise.logFatal((Logger)logger, (String)"Could not connect to BeyondCron server/s - %s", (Object[])new Object[]{e.getMessage()});
            Program.exit((int)1);
        }
        Localise.logInfo((Logger)logger, (String)"Connected:", (Object[])new Object[0]);
        Localise.logInfo((Logger)logger, (String)"  cluster: %s", (Object[])new Object[]{this.connection.getClusterName()});
    }

    private void initShutdownHandlers() {
        this.stopSignal = Program.registerHandler((Program.SignalHandler)this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Localise.logDebug((Logger)logger, (String)"Shutdown hook called", (Object[])new Object[0]);
            this.close();
        }));
    }

    public void signal(int value) {
        Signal signal = Signal.valueOf((long)value);
        Localise.logDebug((Logger)logger, (String)"Received %s (%d)", (Object[])new Object[]{signal.description(), signal.intValue()});
        int n = this.exitCode = signal == this.stopSignal ? 0 : 2;
        if (this.exitCode == 0) {
            Program.setShuttingDown((boolean)true);
        }
        if (this.connection != null) {
            this.close();
        } else {
            Program.exit((int)this.exitCode);
        }
    }
}

