/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent.service;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.Output;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class ProcessList {
    static Logger logger = LogUtils.getLogger(ProcessList.class);
    @StringConfig.Annotation(defaultValue="ps -eo user,pid,ppid,pgid,command")
    public static final String COMMAND_PROCESS_LIST = "beyondcron.processes.command.process.list";
    @StringConfig.Annotation(defaultValue="^\\s*(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(.+)\\s*$")
    public static final String COMMAND_PROCESS_LIST_REGEX = "beyondcron.processes.command.process.list.regex";
    private Program.OS os;
    private Pattern processPattern;
    private Map<Integer, Process> processes = new HashMap<Integer, Process>();

    public ProcessList(Program.OS os) {
        this.os = os;
        this.processPattern = Configs.getPattern((String)COMMAND_PROCESS_LIST_REGEX, (Program.OS)os);
    }

    public boolean isEmpty() {
        return this.processes.isEmpty();
    }

    public void addProcessList(Output output) {
        this.processes.clear();
        ListIterator lines = output.getLines().listIterator(1);
        while (lines.hasNext()) {
            String line = (String)lines.next();
            Matcher matcher = this.processPattern.matcher(line);
            if (matcher.matches()) {
                Process process = new Process(matcher.group(1), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), matcher.group(5));
                this.processes.put(process.getPid(), process);
                continue;
            }
            Localise.logError((Logger)logger, (String)"No match - %1$s", (Object[])new Object[]{line});
            break;
        }
        for (Process child : this.processes.values()) {
            Process parent = this.processes.get(child.ppid);
            if (parent == null) continue;
            parent.childPids.add(child.pid);
        }
    }

    public String getProcessListCommand() {
        return (String)Configs.get((String)COMMAND_PROCESS_LIST, (Program.OS)this.os);
    }

    public Process getProcess(int pid) {
        return this.processes.get(pid);
    }

    static {
        Configs.addConfigs(ProcessList.class);
    }

    public static class Process {
        private String user;
        private int pid;
        private int ppid;
        private int pgrp;
        private Set<Integer> childPids = new HashSet<Integer>();
        private String command;

        private Process(String user, int pid, int ppid, int pgrp, String command) {
            this.user = user;
            this.pid = pid;
            this.ppid = ppid;
            this.pgrp = pgrp;
            this.command = command;
        }

        public String getUser() {
            return this.user;
        }

        public int getPid() {
            return this.pid;
        }

        public int getPpid() {
            return this.ppid;
        }

        public int getPgrp() {
            return this.pgrp;
        }

        public Set<Integer> getChildPids() {
            return Collections.unmodifiableSet(this.childPids);
        }

        public String getCommand() {
            return this.command;
        }

        public String toString() {
            return String.format("%12s %5d %5d %5d %s", this.user, this.pid, this.ppid, this.pgrp, this.command);
        }
    }
}

