/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.BlissUtils;
import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.Filter;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.calendar.CalendarInstance;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.core.calendar.ICalendarInstance;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.PersistManager;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MultiMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import net.fortuna.ical4j.model.CalendarException;
import org.apache.logging.log4j.Logger;

public class CalendarManager
implements Persist.Listener {
    private static final Logger logger = LogUtils.getLogger(CalendarManager.class);
    private static Map<String, CalendarManager> managers = new HashMap<String, CalendarManager>();
    private HazelcastInstance hazelcast;
    private DataManager data;
    private PersistManager persistManager;
    private MultiMap<Name, CalendarInstance> calendarInstances;
    private MultiMap<Name, Name> calendarJobs;
    private IMap<URI, ICalendarData> icalendars;
    private MultiMap<URI, ICalendarInstance> icalendarInstances;
    private MultiMap<URI, Name> icalendarCalendars;

    private CalendarManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.data = DataManager.getInstance(hazelcast);
        this.persistManager = PersistManager.getInstance(hazelcast);
        this.calendarInstances = Hazelcast.getCalendarInstanceMap((HazelcastInstance)hazelcast);
        this.calendarJobs = Hazelcast.getCalendarJobMap((HazelcastInstance)hazelcast);
        this.icalendars = Hazelcast.getICalendarMap((HazelcastInstance)hazelcast);
        this.icalendarInstances = Hazelcast.getICalendarInstanceMap((HazelcastInstance)hazelcast);
        this.icalendars.addLocalEntryListener((EntryListener)new ICalendarUpdateListener(logger));
        this.icalendarCalendars = Hazelcast.getICalendarCalendarMap((HazelcastInstance)hazelcast);
        this.initInternalCalendars();
    }

    public static synchronized CalendarManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        CalendarManager manager = managers.get(name);
        if (manager == null) {
            manager = new CalendarManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private void initInternalCalendars() {
        for (ICalendarData icalendar : new ICalendarData[]{ICalendarData.DAILY, ICalendarData.WEEKDAY, ICalendarData.WEEKEND}) {
            this.initInternalCalendar(icalendar, null);
        }
        for (ICalendarData icalendar : new ICalendarData[]{ICalendarData.JANUARY, ICalendarData.FEBRUARY, ICalendarData.MARCH, ICalendarData.APRIL, ICalendarData.MAY, ICalendarData.JUNE, ICalendarData.JULY, ICalendarData.AUGUST, ICalendarData.SEPTEMBER, ICalendarData.OCTOBER, ICalendarData.NOVEMBER, ICalendarData.DECEMBER}) {
            this.initInternalCalendar(icalendar, Localise.format((String)"month"));
        }
    }

    private void initInternalCalendar(ICalendarData icalendar, String group) {
        this.icalendars.putIfAbsent((Object)icalendar.getURI(), (Object)icalendar);
        Name name = Name.parse((Name)BlissUtils.CALENDAR_DIR, (String[])new String[]{StringUtils.isNullOrEmpty((String)group) ? icalendar.getName() : String.format("%s/%s", group, Localise.format((String)icalendar.getName()))});
        Calendar calendar = new Calendar(name, icalendar.getDescription());
        calendar.addInclusiveCalendar(icalendar.getURI());
        calendar.setLastUpdated(icalendar.getLastModified());
        this.data.addCalendar(calendar);
    }

    public void setCalendar(Calendar calendar) throws CalendarException, NoSuchICalendarException {
        Name name = calendar.getName();
        Calendar currentCalendar = this.data.getCalendar(name);
        long lastUpdated = 0L;
        Set uris = calendar.getCalendars();
        for (URI uri : uris) {
            ICalendarData icalendar = this.getICalendar(uri, true);
            if (icalendar == null) {
                Localise.logError((Logger)logger, (String)"Unexpected exception getting iCalendar %1$s whilst setting calendar %2$s", (Object[])new Object[]{uri.toString(), name.toString()});
                throw new NoSuchICalendarException(uri);
            }
            this.icalendarCalendars.put((Object)uri, (Object)name);
            if (icalendar.getLastModified() <= lastUpdated) continue;
            lastUpdated = icalendar.getLastModified();
        }
        calendar.setLastUpdated(lastUpdated);
        if (currentCalendar != null) {
            for (URI uri : currentCalendar.getCalendars()) {
                if (uris.contains(uri)) continue;
                this.icalendarCalendars.remove((Object)uri, (Object)name);
            }
        }
        this.data.addCalendar(calendar);
    }

    public Calendar deleteCalendar(Name name) throws CalendarInUseException {
        Calendar calendar = this.data.getCalendar(name);
        if (calendar == null) {
            return null;
        }
        if (this.calendarJobs.containsKey((Object)name)) {
            throw new CalendarInUseException(name);
        }
        for (URI uri : CollectionUtils.join((Collection[])new Collection[]{calendar.getInclusiveCalendars(), calendar.getExclusiveCalendars()})) {
            this.icalendarCalendars.remove((Object)uri, (Object)name);
            if (this.icalendarCalendars.containsKey((Object)uri)) continue;
            this.icalendarInstances.remove((Object)uri);
        }
        this.calendarInstances.remove((Object)name);
        this.data.removeCalendar(name);
        return calendar;
    }

    public Collection<Calendar> getCalendars() {
        return Collections.unmodifiableCollection(this.data.getCalendars().values());
    }

    public Set<Calendar> getCalendars(Name group) {
        TreeSet<Calendar> set = new TreeSet<Calendar>();
        for (Name name : this.data.getCalendarGroups().get((Object)group)) {
            set.add(this.data.getCalendar(name));
        }
        return set;
    }

    public Set<Calendar> getCalendars(Filter filter) {
        TreeSet<Calendar> set = new TreeSet<Calendar>();
        IMap<Name, Calendar> calendars = this.data.getCalendars();
        for (Name name : calendars.keySet()) {
            if (filter != null && !filter.matches((Object)name)) continue;
            set.add((Calendar)calendars.get(name));
        }
        return set;
    }

    public int getCalendarCount() {
        return this.data.getCalendars().size();
    }

    public Collection<Name> getChildren(Name group) {
        return Collections.unmodifiableCollection(this.data.getCalendarGroups().get((Object)group));
    }

    public CalendarInstance getCalendarInstance(Job job) {
        Name calendarName = job.getCalendar();
        if (calendarName == null) {
            Localise.logError((Logger)logger, (String)"Job %1$s does not have a calendar", (Object[])new Object[]{job.getName().toString()});
            return null;
        }
        Calendar calendar = this.data.getCalendar(job.getCalendar());
        if (calendar == null) {
            Localise.logError((Logger)logger, (String)"Calendar %1$s does not exist", (Object[])new Object[]{calendarName.toString()});
            return null;
        }
        TimeZone timeZone = job.getTimeZone();
        if (timeZone == null) {
            Localise.logError((Logger)logger, (String)"Job %1$s does not have a timezone", (Object[])new Object[]{job.getName().toString()});
            return null;
        }
        String calendarInstanceName = CalendarInstance.getInstanceName((Job)job);
        CalendarInstance calendarInstance = null;
        for (CalendarInstance c : this.calendarInstances.get((Object)calendarName)) {
            if (!c.getName().equals(calendarInstanceName)) continue;
            calendarInstance = c;
            break;
        }
        if (calendarInstance == null) {
            calendarInstance = new CalendarInstance(calendarInstanceName);
            for (URI uri : calendar.getInclusiveCalendars()) {
                calendarInstance.addInclusiveCalendar(this.getICalendarInstance(uri, timeZone));
            }
            for (URI uri : calendar.getExclusiveCalendars()) {
                calendarInstance.addExclusiveCalendar(this.getICalendarInstance(uri, timeZone));
            }
            this.calendarInstances.put((Object)calendarName, (Object)calendarInstance);
        }
        return calendarInstance;
    }

    private ICalendarInstance getICalendarInstance(URI uri, TimeZone timeZone) {
        ICalendarInstance icalendarInstance = null;
        for (ICalendarInstance c : this.icalendarInstances.get((Object)uri)) {
            if (!c.getTimeZone().equals(timeZone)) continue;
            icalendarInstance = c;
            break;
        }
        if (icalendarInstance == null) {
            icalendarInstance = new ICalendarInstance((ICalendarData)this.icalendars.get((Object)uri), timeZone);
            this.icalendarInstances.put((Object)uri, (Object)icalendarInstance);
        }
        return icalendarInstance;
    }

    public Calendar getCalendar(Name name) {
        return this.data.getCalendar(name);
    }

    public boolean isCalendar(Name name) {
        return this.data.getCalendars().containsKey((Object)name);
    }

    public void updateCalendar(Name name) {
        Calendar calendar = this.data.getCalendar(name);
        if (calendar == null) {
            return;
        }
        this.updateICalendars(CollectionUtils.join((Collection[])new Collection[]{calendar.getInclusiveCalendars(), calendar.getExclusiveCalendars()}));
    }

    public void addCalendarJob(Job job) {
        this.calendarJobs.put((Object)job.getCalendar(), (Object)job.getName());
    }

    public void deleteCalendarJob(Job job) {
        this.calendarJobs.remove((Object)job.getCalendar(), (Object)job.getName());
    }

    public Collection<Name> getCalendarJobs(Name name) {
        return this.calendarJobs.get((Object)name);
    }

    public boolean hasCalendarJobs(Name name) {
        return this.calendarJobs.containsKey((Object)name);
    }

    public ICalendarData deleteICalendar(URI uri) throws NoSuchICalendarException, ICalendarInUseException {
        ICalendarData icalendar = (ICalendarData)this.icalendars.get((Object)uri);
        if (icalendar == null) {
            throw new NoSuchICalendarException(uri);
        }
        if (this.icalendarCalendars.containsKey((Object)uri)) {
            throw new ICalendarInUseException(uri);
        }
        this.icalendarInstances.remove((Object)uri);
        this.icalendars.remove((Object)uri);
        this.persistManager.remove(icalendar.getPersistName(), (Message)icalendar, null, 0);
        return icalendar;
    }

    public ICalendarData getICalendar(URI uri) throws CalendarException {
        return this.getICalendar(uri, false);
    }

    public ICalendarData getICalendar(URI uri, boolean create) throws CalendarException {
        ICalendarData icalendar = (ICalendarData)this.icalendars.get((Object)uri);
        if (icalendar == null && create) {
            icalendar = new ICalendarData(uri);
            try {
                this.icalendars.put((Object)uri, (Object)icalendar);
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                return null;
            }
            this.persistManager.save(icalendar.getPersistName(), (Message)icalendar, null, 0);
        }
        return icalendar;
    }

    public Collection<ICalendarData> getICalendars() {
        return this.icalendars.values();
    }

    public boolean isICalendar(URI uri) {
        return this.icalendars.containsKey((Object)uri);
    }

    public Collection<Name> getICalendarCalendars(URI uri) {
        return this.icalendarCalendars.get((Object)uri);
    }

    public boolean hasICalendarCalendars(URI uri) {
        return this.icalendarCalendars.containsKey((Object)uri);
    }

    public void updateICalendar(URI uri) {
        IExecutorService executor = this.hazelcast.getExecutorService("UpdateICalendar");
        executor.executeOnKeyOwner((Runnable)new ICalendarUpdater(uri), (Object)uri);
    }

    public void updateICalendars(Set<URI> uris) {
        IExecutorService executor = this.hazelcast.getExecutorService("UpdateICalendars");
        for (URI uri : uris) {
            executor.executeOnKeyOwner((Runnable)new ICalendarUpdater(uri), (Object)uri);
        }
    }

    public void updateICalendars(boolean checkPersist) {
        IExecutorService executor = this.hazelcast.getExecutorService("UpdateAllICalendars");
        executor.executeOnAllMembers((Runnable)new ICalendarsUpdater(checkPersist));
    }

    @Override
    public void messageLoaded(Name name, Message<?> message) throws Persist.PersistException {
        if (message instanceof Calendar) {
            try {
                this.setCalendar((Calendar)message);
            }
            catch (NoSuchICalendarException e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception loading %1$s - no such calendar", (Object[])new Object[]{((Calendar)message).getName()});
                throw new Persist.PersistException(e.getMessage());
            }
            catch (CalendarException e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception loading %1$s - %2$s", (Object[])new Object[]{((Calendar)message).getName(), e.getMessage()});
                throw new Persist.PersistException(e.getMessage());
            }
        } else if (message instanceof ICalendarData) {
            ICalendarData ical = (ICalendarData)message;
            this.icalendars.put((Object)ical.getURI(), (Object)ical);
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message type - %1$s", (Object[])new Object[]{message.getClass().getName()});
        }
    }

    public static class NoSuchICalendarException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoSuchICalendarException(URI uri) {
            super(Localise.format((String)"No such icalendar: %s", (Object[])new Object[]{uri}));
        }
    }

    public static class ICalendarInUseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ICalendarInUseException(URI uri) {
            super(Localise.format((String)"Icalendar %s is in use", (Object[])new Object[]{uri}));
        }
    }

    public static class CalendarInUseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CalendarInUseException(Name name) {
            super(Localise.format((String)"Calendar %s is in use", (Object[])new Object[]{name}));
        }
    }

    private static class ICalendarsUpdater
    implements Runnable,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;
        private boolean checkPersist;

        public ICalendarsUpdater(boolean checkPersist) {
            this.checkPersist = checkPersist;
        }

        @Override
        public void run() {
            CalendarManager manager = CalendarManager.getInstance(this.hazelcast);
            PersistManager persistManager = PersistManager.getInstance(this.hazelcast);
            HashSet uris = new HashSet(manager.icalendars.localKeySet());
            for (URI uri : uris) {
                ICalendarData icalendar = (ICalendarData)manager.icalendars.get((Object)uri);
                if (icalendar == null) continue;
                Name name = icalendar.getPersistName();
                try {
                    if (icalendar.update()) {
                        persistManager.save(name, (Message)icalendar, null, 0);
                    } else if (this.checkPersist && !icalendar.getURI().getScheme().equals("beyondcron") && !persistManager.exists(name, (Message)icalendar)) {
                        persistManager.save(name, (Message)icalendar, null, 0);
                    }
                    manager.icalendars.put((Object)uri, (Object)icalendar);
                }
                catch (CalendarException e) {
                    Localise.logError((Logger)logger, (String)"Could not update %1$s - %2$s", (Object[])new Object[]{uri, e.getMessage()});
                }
            }
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    private static class ICalendarUpdater
    implements Runnable,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;
        private URI uri;

        public ICalendarUpdater(URI uri) {
            this.uri = uri;
        }

        @Override
        public void run() {
            CalendarManager manager = CalendarManager.getInstance(this.hazelcast);
            ICalendarData icalendar = (ICalendarData)manager.icalendars.get((Object)this.uri);
            if (icalendar != null) {
                try {
                    if (icalendar.update()) {
                        PersistManager.getInstance(this.hazelcast).save(icalendar.getPersistName(), (Message)icalendar, null, 0);
                    }
                    manager.icalendars.put((Object)this.uri, (Object)icalendar);
                }
                catch (CalendarException e) {
                    Localise.logWarn((Logger)logger, (String)"Could not update %1$s - %2$s", (Object[])new Object[]{this.uri, e.getMessage()});
                }
            }
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    private class ICalendarUpdateListener
    extends Hazelcast.AbstractEntryListener<URI, ICalendarData> {
        public ICalendarUpdateListener(Logger logger) {
            super(logger);
        }

        public void entryUpdated(EntryEvent<URI, ICalendarData> event) {
            URI uri = (URI)event.getKey();
            ICalendarData icalendarData = (ICalendarData)event.getValue();
            long lastModified = icalendarData.getLastModified();
            if (lastModified != ((ICalendarData)event.getOldValue()).getLastModified()) {
                for (ICalendarInstance c : CalendarManager.this.icalendarInstances.get((Object)uri)) {
                    CalendarManager.this.icalendarInstances.put((Object)uri, (Object)c.update(icalendarData));
                }
                for (Name name : CalendarManager.this.icalendarCalendars.get((Object)uri)) {
                    Calendar calendar = CalendarManager.this.data.getCalendar(name);
                    if (calendar == null) continue;
                    CalendarManager.this.data.addCalendar(calendar.setLastUpdated(lastModified));
                }
            }
        }
    }
}

