/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.ConfigProperty;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.Persist;
import org.apache.logging.log4j.Logger;

public class ConfigManager
implements Persist.Listener {
    static final Logger logger = LogUtils.getLogger(ConfigManager.class);

    @Override
    public void messageLoaded(Name name, Message<?> message) {
        if (message instanceof ConfigProperty) {
            ConfigProperty property = (ConfigProperty)message;
            Config config = Configs.getConfig((String)property.getName());
            if (config != null) {
                try {
                    config.set(property.getValue());
                }
                catch (IllegalArgumentException e) {
                    Localise.logError((Logger)logger, (String)"Ignoring configuration property %1$s (%2$s) - %3$s", (Object[])new Object[]{property.getName(), property.getValue(), e.getMessage()});
                }
            } else {
                config = new StringConfig(property.getName(), property.getValue());
            }
            Configs.setConfig((Config)config);
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message type %1$s", (Object[])new Object[]{message.getClass().getName()});
        }
    }
}

