/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.BooleanUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Result;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.user.User;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ConnectionAuthenticate;
import com.beyondcron.messaging.message.ConnectionRegister;
import com.beyondcron.messaging.message.Link;
import com.beyondcron.server.JobStatusManager;
import com.beyondcron.server.LicenseManager;
import com.beyondcron.server.QueueManager;
import com.beyondcron.server.UserManager;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class ConnectionManager
implements ClientListener,
MembershipListener {
    static final Logger logger = LogUtils.getLogger(ConnectionManager.class);
    private static Map<String, ConnectionManager> managers = new HashMap<String, ConnectionManager>();
    private HazelcastInstance hazelcast;
    private IMap<String, Connection> connections;
    private IMap<String, Connection> agents;
    private ISet<String> sshAgents;
    private IMap<String, Connection> servers;
    private String clusterPassword;
    private Thread registrationHandler = null;
    private QueueManager queueManager;
    private UserManager userManager;

    public static Connection getConnection(HazelcastInstance hazelcast) {
        return ConnectionManager.getInstance(hazelcast).get(hazelcast.getLocalEndpoint().getUuid());
    }

    public static synchronized ConnectionManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        ConnectionManager manager = managers.get(name);
        if (manager == null) {
            manager = new ConnectionManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private ConnectionManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.connections = Hazelcast.getConnectionMap((HazelcastInstance)hazelcast);
        this.agents = Hazelcast.getAgentMap((HazelcastInstance)hazelcast);
        this.sshAgents = Hazelcast.getAgentSshSet((HazelcastInstance)hazelcast);
        this.servers = Hazelcast.getServerMap((HazelcastInstance)hazelcast);
        hazelcast.getClientService().addClientListener((ClientListener)this);
        hazelcast.getCluster().addMembershipListener((MembershipListener)this);
        this.queueManager = QueueManager.getInstance(hazelcast);
        this.userManager = UserManager.getInstance(hazelcast);
        try {
            this.clusterPassword = Configs.getPassword((String)"BEYONDCRON_CLUSTER_PASSWORD") + Configs.get((String)"BEYONDCRON_CLUSTER_NAME");
        }
        catch (IOException e) {
            Localise.logFatal((Logger)logger, (String)"Could not read cluster password file %1$s - %2$s", (Object[])new Object[]{Configs.get((String)"BEYONDCRON_CLUSTER_PASSWORD"), e.getMessage()});
            Program.exit((int)1);
        }
    }

    public void start() {
        if (this.registrationHandler != null) {
            throw new IllegalThreadStateException("Connection manager already started");
        }
        this.registrationHandler = ThreadUtils.getThread((Runnable)new RegistrationHandler());
        this.registrationHandler.start();
    }

    public ConnectionRegister.Response register(ConnectionRegister command) {
        String[] names;
        Connection agent;
        Connection connection = command.getConnection();
        ConnectionRegister.Response response = new ConnectionRegister.Response();
        Connection.Type type = connection.getClientType();
        if (!(type != Connection.Type.AGENT && type != Connection.Type.AGENT_SSH && type != Connection.Type.SERVER || connection.getOsUserName().equals(Program.getUserName()))) {
            Localise.logWarn((Logger)logger, (String)"Rejecting %1$s connection from %2$s, user %3$s does not match server user %4$s", (Object[])new Object[]{connection.getClientHostName(), StringUtils.capitalise((Object)connection.getClientType()), connection.getOsUserName(), Program.getUserName()});
            response.setResult(new Result(false, 1, Localise.format((String)"Connection user %1$s does not match server user %2$s", (Object[])new Object[]{connection.getOsUserName(), Program.getUserName()}), new Link[0]));
            return response;
        }
        if (!this.clusterPassword.equals(command.getClusterPassword())) {
            Localise.logWarn((Logger)logger, (String)"Rejecting %1$s connection from %2$s, user %3$s does not match server user %4$s", (Object[])new Object[]{connection.getClientHostName(), StringUtils.capitalise((Object)connection.getClientType()), connection.getOsUserName(), Program.getUserName()});
            response.setResult(new Result(false, 1, Localise.format((String)"Connection user %1$s does not match server user %2$s", (Object[])new Object[]{connection.getOsUserName(), Program.getUserName()}), new Link[0]));
        }
        if ((type == Connection.Type.AGENT || type == Connection.Type.AGENT_SSH) && (agent = (Connection)this.agents.get((Object)connection.getClientHostName())) != null && agent.isConnected() && !agent.getId().equals(connection.getId())) {
            boolean staleConnection = true;
            for (Client client : this.hazelcast.getClientService().getConnectedClients()) {
                if (!client.getUuid().equals(agent.getId())) continue;
                staleConnection = false;
            }
            if (!staleConnection) {
                response.setResult(new Result(false, 1, Localise.format((String)"%s agent is already connected", (Object[])new Object[]{connection.getClientHostName()}), new Link[0]));
                return response;
            }
        }
        if (command.isAuthenticate()) {
            Result result = this.authenticate(connection.getClientUserName(), command.getPassword());
            if (!result.wasSuccess()) {
                response.setResult(result);
                return response;
            }
            response.setAuthenticated(true);
            connection.setAuthenticated(true);
        } else {
            connection.setAuthenticated(false);
        }
        this.connections.put((Object)connection.getId(), (Object)connection);
        switch (connection.getClientType()) {
            case AGENT: 
            case AGENT_SSH: {
                this.agents.put((Object)connection.getClientHostName(), (Object)connection);
                if (type == Connection.Type.AGENT_SSH) {
                    this.sshAgents.add((Object)connection.getClientHostName());
                }
                names = new String[]{"mail.smtp.host", "mail.smtp.port"};
                break;
            }
            case COMMAND: 
            case WEB: {
                names = new String[]{};
                response.addProperty("beyondcron.status.service", BooleanUtils.toString((JobStatusManager.getInstance(this.hazelcast).getStatusService() != null ? 1 : 0) != 0));
                response.addProperty("beyondcron.user.service", BooleanUtils.toString((this.userManager.getUserService() != null ? 1 : 0) != 0));
                break;
            }
            case SERVER: {
                this.servers.put((Object)connection.getClientAddress(), (Object)connection);
                names = new String[]{};
                break;
            }
            default: {
                names = new String[]{};
            }
        }
        for (String name : names) {
            String value = (String)Configs.get((String)name);
            if (value == null) continue;
            response.addProperty(name, value);
        }
        return response;
    }

    public ConnectionAuthenticate.Response authenticate(Connection connection, String password) {
        Result result = this.authenticate(connection.getClientUserName(), password);
        connection.setAuthenticated(result.wasSuccess());
        this.connections.put((Object)connection.getId(), (Object)connection);
        return new ConnectionAuthenticate.Response(result);
    }

    private Result authenticate(String userName, String password) {
        User user = this.userManager.authenticateUser(userName, password);
        if (user == null) {
            return new Result(false, this.userManager.isUser(userName) ? 1 : 2, Localise.format((String)"Incorrect user name or password"), new Link[0]);
        }
        if (user.hasLicense() && user.getHome() != null) {
            LicenseManager.getInstance(this.hazelcast).addUser(user);
        }
        return new Result();
    }

    public Connection get(String id) {
        return (Connection)this.connections.get((Object)id);
    }

    public Collection<Connection> getActiveConnections() {
        return this.connections.values();
    }

    public Collection<Connection> getAgents() {
        return this.agents.values();
    }

    public Connection getAgent(String hostName) {
        return (Connection)this.agents.get((Object)hostName);
    }

    public Collection<Connection> getServers() {
        return this.servers.values();
    }

    public void clientConnected(Client client) {
    }

    public void clientDisconnected(Client client) {
        String uuid = client.getUuid();
        if (!this.connections.localKeySet().contains(uuid)) {
            return;
        }
        Connection connection = (Connection)this.connections.remove((Object)uuid);
        Connection.Type type = connection.getClientType();
        switch (type) {
            case AGENT: 
            case AGENT_SSH: {
                this.agents.put((Object)connection.getClientHostName(), (Object)connection.setConnected(false));
                if (type == Connection.Type.AGENT_SSH) {
                    this.sshAgents.remove((Object)connection.getClientHostName());
                }
                this.queueManager.destroyQueue(Hazelcast.getAgentCommandQueueName((String)connection.getClientHostName()));
                break;
            }
            case COMMAND: 
            case WEB: {
                this.queueManager.destroyQueue(Hazelcast.getCommandReceiveQueueName((String)connection.getId()));
                break;
            }
        }
    }

    public void memberAdded(MembershipEvent membershipEvent) {
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        String uuid = membershipEvent.getMember().getUuid();
        if (!this.connections.localKeySet().contains(uuid)) {
            return;
        }
        Connection connection = (Connection)this.connections.remove((Object)uuid);
        if (connection.getClientType() == Connection.Type.SERVER) {
            this.servers.put((Object)connection.getClientAddress(), (Object)connection.setConnected(false));
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    private class RegistrationHandler
    implements Runnable {
        private RegistrationHandler() {
        }

        @Override
        public void run() {
            IQueue registrationQueue = Hazelcast.getConnectionSendQueue((HazelcastInstance)ConnectionManager.this.hazelcast);
            while (true) {
                try {
                    while (true) {
                        ConnectionRegister message;
                        if ((message = (ConnectionRegister)registrationQueue.take()) == null) {
                            continue;
                        }
                        Hazelcast.getConnectionReceiveQueue((HazelcastInstance)ConnectionManager.this.hazelcast, (String)message.getConnection().getId()).add((Object)ConnectionManager.this.register(message));
                    }
                }
                catch (InterruptedException e) {
                    Localise.logWarn((Logger)logger, (String)"Unexpectedly interrupted - %1$s", (Object[])new Object[]{e.getMessage()});
                    continue;
                }
                catch (HazelcastInstanceNotActiveException e) {
                    if (Program.isShuttingDown()) break;
                    throw e;
                }
                catch (Exception e) {
                    Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    continue;
                }
                break;
            }
        }
    }
}

