/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Name;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.Job;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JobListenerManager {
    private static Map<String, JobListenerManager> managers = new HashMap<String, JobListenerManager>();
    private MultiMap<Name, Name> jobListeners;
    private MultiMap<Name, Name> jobListenerWildcards;
    private Map<Name, Set<Name>> jobListenerCache;

    public static synchronized JobListenerManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        JobListenerManager manager = managers.get(name);
        if (manager == null) {
            manager = new JobListenerManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private JobListenerManager(HazelcastInstance hazelcast) {
        this.jobListeners = Hazelcast.getJobListenerMap((HazelcastInstance)hazelcast);
        this.jobListenerWildcards = Hazelcast.getJobListenerWildcardMap((HazelcastInstance)hazelcast);
        this.jobListenerCache = new HashMap<Name, Set<Name>>();
    }

    public void add(Job job) {
        boolean containsWildcard = false;
        Name name = job.getName();
        for (Condition condition : job.getConditions()) {
            Name trigger = condition.getJob();
            if (trigger.isWildcard()) {
                this.jobListenerWildcards.put((Object)trigger, (Object)name);
                containsWildcard = true;
                continue;
            }
            this.jobListeners.put((Object)trigger, (Object)name);
            Set<Name> cache = this.jobListenerCache.get(trigger);
            if (cache == null) continue;
            cache.add(name);
        }
        if (containsWildcard) {
            this.jobListenerCache.clear();
        }
    }

    public void remove(Job job) {
        boolean containsWildcard = false;
        Name name = job.getName();
        for (Condition condition : job.getConditions()) {
            Name trigger = condition.getJob();
            if (trigger.isWildcard()) {
                this.jobListenerWildcards.remove((Object)trigger, (Object)name);
                containsWildcard = true;
                continue;
            }
            this.jobListeners.remove((Object)trigger, (Object)name);
            Set<Name> cache = this.jobListenerCache.get(trigger);
            if (cache == null) continue;
            cache.remove(name);
        }
        if (containsWildcard) {
            this.jobListenerCache.clear();
        }
    }

    public Set<Name> getListeners(Name name) {
        Set<Name> listeners = this.jobListenerCache.get(name);
        if (listeners == null) {
            listeners = new HashSet<Name>(this.jobListeners.get((Object)name));
            for (Name n : this.jobListenerWildcards.keySet()) {
                if (!name.matches(n)) continue;
                listeners.addAll(this.jobListenerWildcards.get((Object)n));
            }
            this.jobListenerCache.put(name, listeners);
        }
        return listeners;
    }
}

