/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Program;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.job.AgentJob;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.QueuedJob;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.StatusService;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.server.JobListenerManager;
import com.beyondcron.server.JobManager;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryExpiredListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class JobStatusManager {
    Logger logger = LogUtils.getLogger(JobStatusManager.class);
    private static Map<String, JobStatusManager> managers = new HashMap<String, JobStatusManager>();
    private HazelcastInstance hazelcast;
    private JobManager jobManager = null;
    private JobListenerManager jobListenerManager;
    private IMap<Name, Long> activeJobs;
    private MultiMap<Name, QueuedJob> queuedJobs;
    private StateListener jobStateListener;
    private IMap<Name, Status> jobStatuses;
    private StatusListener jobStatusListener;
    private String jobStatuslistenerId = null;
    private long jobStatusListenerActivated = Long.MAX_VALUE;
    private IQueue<Status> statusUpdates;
    private StatusService statusService = null;
    private boolean statusServiceLogAll = (Boolean)Configs.get((String)"beyondcron.status.service.log.all");
    private ISet<String> sshAgents;

    public static synchronized JobStatusManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        JobStatusManager manager = managers.get(name);
        if (manager == null) {
            manager = new JobStatusManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    public static JobStatusManager getInstance(HazelcastInstance hazelcast, JobManager jobManager) {
        return JobStatusManager.getInstance(hazelcast).setJobManager(jobManager);
    }

    private JobStatusManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.jobListenerManager = JobListenerManager.getInstance(hazelcast);
        this.jobStatuses = Hazelcast.getJobStatusMap((HazelcastInstance)hazelcast);
        this.jobStatusListener = new StatusListener();
        this.statusUpdates = Hazelcast.getJobStatusQueue((HazelcastInstance)hazelcast);
        this.activeJobs = Hazelcast.getJobActiveMap((HazelcastInstance)hazelcast);
        this.jobStateListener = new StateListener();
        this.activeJobs.addLocalEntryListener((MapListener)this.jobStateListener);
        this.queuedJobs = Hazelcast.getJobQueuedMap((HazelcastInstance)hazelcast);
        this.sshAgents = Hazelcast.getAgentSshSet((HazelcastInstance)hazelcast);
        this.setActive(true);
    }

    public JobStatusManager setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
        this.initUpdatesListener();
        return this;
    }

    public StatusService getStatusService() {
        return this.statusService;
    }

    public boolean hasStatusService() {
        return this.statusService != null;
    }

    public void reloadService() throws ServiceException {
        Cloneable failures;
        IExecutorService executor = this.hazelcast.getExecutorService("ReloadStatusService");
        if (this.statusService != null) {
            try {
                failures = new TreeSet();
                Map results = executor.submitToAllMembers((Callable)new ServiceStop());
                for (Member member : results.keySet()) {
                    if (((Boolean)((Future)results.get(member)).get()).booleanValue()) continue;
                    failures.add(member.getAddress().getHost());
                }
                if (!failures.isEmpty()) {
                    throw new ServiceException(Localise.format((String)"Could not stop service on %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", (Collection)((Object)failures))}));
                }
            }
            catch (Exception e) {
                String message = Localise.format((String)"Unexpected exception stopping service - %1$s", (Object[])new Object[]{e.getMessage()});
                Localise.logError((Logger)this.logger, (Exception)e, (String)message, (Object[])new Object[0]);
                throw new ServiceException(message);
            }
        }
        try {
            failures = new TreeMap();
            HashSet<String> failureMessages = new HashSet<String>();
            Map results = executor.submitToAllMembers((Callable)new ServiceStart());
            for (Member member : results.keySet()) {
                String message = (String)((Future)results.get(member)).get();
                if (StringUtils.isNullOrEmpty((String)message)) continue;
                failures.put(member.getAddress().getHost(), message);
                failureMessages.add(message);
            }
            if (!failures.isEmpty()) {
                String message = failureMessages.size() == 1 ? Localise.format((String)"Could not start service on %1$s - %2$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", failures.keySet()), failureMessages.iterator().next()}) : Localise.format((String)"Could not start service on %1$s - multiple reasons", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", failures.keySet())});
                throw new ServiceException(message);
            }
        }
        catch (Exception e) {
            String message = Localise.format((String)"Unexpected exception starting service - %1$s", (Object[])new Object[]{e.getMessage()});
            Localise.logError((Logger)this.logger, (Exception)e, (String)message, (Object[])new Object[0]);
            throw new ServiceException(message);
        }
        if (this.statusService != null) {
            if (this.statusService.isConnected()) {
                this.load();
            } else {
                this.statusService.setConnectListener(() -> {
                    this.load();
                    this.statusService.setConnectListener(null);
                });
            }
        }
    }

    public void load() {
        if (this.statusService != null) {
            if (!this.statusService.isConnected()) {
                Localise.logError((Logger)this.logger, (String)"Could not load statuses - service not connected", (Object[])new Object[0]);
                return;
            }
            Localise.logDebug((Logger)this.logger, (String)"Loading job status from status service: %s", (Object[])new Object[]{this.getStatusServiceName()});
            try {
                for (Status status : this.statusService.getStatuses()) {
                    Name name;
                    Status currentStatus;
                    if (status.hasOutput()) {
                        status.setOutput(null, true);
                    }
                    if ((currentStatus = (Status)this.jobStatuses.get((Object)(name = status.getName()))) != null && currentStatus.getTimestamp() >= this.jobStatusListenerActivated) continue;
                    this.jobStatuses.put((Object)name, (Object)status);
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)this.logger, (String)"Could not load statuses - %s", (Object[])new Object[]{e.getMessage()});
            }
        }
    }

    private void initUpdatesListener() {
        new Thread(() -> {
            boolean running;
            while (true) {
                try {
                    while (true) {
                        Status status;
                        Status currentStatus;
                        if ((currentStatus = (Status)this.jobStatuses.get((Object)(status = (Status)this.statusUpdates.take()).getName())) != null) {
                            status.setStartTimestamp(currentStatus.getStartTimestamp());
                        }
                        this.setStatus(status);
                    }
                }
                catch (InterruptedException e) {
                    Localise.logError((Logger)this.logger, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
                    continue;
                }
                catch (HazelcastInstanceNotActiveException e) {
                    if (Program.isShuttingDown()) {
                        running = false;
                        break;
                    }
                    throw e;
                }
                catch (Exception e) {
                    Localise.logError((Logger)this.logger, (Exception)e, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    continue;
                }
                break;
            }
            if (running) {
                Localise.logError((Logger)this.logger, (String)"Update listener unexpectedly stopped", (Object[])new Object[0]);
            }
        }, ThreadUtils.getName((Object)this, (String[])new String[]{"UpdateListener"})).start();
    }

    public JobStatusManager setActive(boolean active) {
        if (active) {
            if (this.jobStatuslistenerId == null) {
                this.jobStatuslistenerId = this.jobStatuses.addLocalEntryListener((MapListener)this.jobStatusListener);
                this.jobStatusListenerActivated = System.currentTimeMillis();
            }
        } else if (this.jobStatuslistenerId != null) {
            this.jobStatuses.removeEntryListener(this.jobStatuslistenerId);
            this.jobStatuslistenerId = null;
        }
        return this;
    }

    public String getStatusServiceName() {
        return this.statusService != null ? this.statusService.getServiceName() : null;
    }

    public Status getStatus(Name name) {
        return (Status)this.jobStatuses.get((Object)name);
    }

    public Status getStatus(Job job) {
        Name name = job.getName();
        Status status = (Status)this.jobStatuses.get((Object)name);
        if (status == null) {
            status = new Status(name, job.getMode());
            this.setStatus(status);
        }
        return status;
    }

    public Set<Status> getStatuses(Filter filter) {
        TreeSet<Status> list = new TreeSet<Status>();
        for (Name name : this.jobStatuses.keySet()) {
            if (filter != null && !filter.matches((Object)name)) continue;
            list.add((Status)this.jobStatuses.get((Object)name));
        }
        return list;
    }

    public void setStatus(Status status) {
        this.setStatus(status, false);
    }

    public void setStatus(Status status, boolean dedupe) {
        boolean persistStatus;
        if (this.jobManager == null) {
            Localise.logError((Logger)this.logger, (String)"jobManager is not defined", (Object[])new Object[0]);
            return;
        }
        Name name = status.getName();
        Job job = this.jobManager.getJob(name);
        if (job == null) {
            this.jobStatuses.remove((Object)name);
            this.queuedJobs.remove((Object)name);
            return;
        }
        switch (status.getState()) {
            case STARTING: {
                this.activeJobs.set((Object)name, (Object)status.getStartTimestamp(), job.getStartLimit().getSeconds(), TimeUnit.SECONDS);
                break;
            }
            case RUNNING: {
                this.activeJobs.set((Object)name, (Object)status.getStartTimestamp(), job.getRunLimit().getSeconds(), TimeUnit.SECONDS);
                break;
            }
            case STOPPED: {
                this.activeJobs.remove((Object)name);
            }
        }
        boolean bl = persistStatus = this.statusService != null;
        if (persistStatus) {
            Status.State state = status.getState();
            if (!this.statusServiceLogAll && state == Status.State.RUNNING) {
                persistStatus = false;
            } else if (dedupe) {
                try {
                    Status persistedStatus = this.statusService.getStatus(name, status.getTimestamp(), false);
                    if (status.equals((Object)persistedStatus)) {
                        status = persistedStatus;
                        persistStatus = false;
                    }
                }
                catch (Exception e) {
                    if (!this.statusService.isConnected()) {
                        try {
                            this.reloadService();
                        }
                        catch (ServiceException ex) {
                            Localise.logError((Logger)this.logger, (String)"Unexpected exception reloading service - %1$s", (Object[])new Object[]{e.getMessage()});
                        }
                    }
                    Localise.logError((Logger)this.logger, (Exception)e, (String)"Could not get status of %s", (Object[])new Object[]{name.toString()});
                    persistStatus = false;
                }
            }
        }
        if (job.getMode() == Job.Mode.ENABLED) {
            if (job.hasSchedule()) {
                status.setNextExecution(this.jobManager.getNextExecution(name));
            }
            if (status.isInactive()) {
                if (job.hasSchedule() && status.getNextExecution() > 0L) {
                    status.setState(Status.State.SCHEDULED);
                } else if (job.hasCondition()) {
                    status.setState(Status.State.WAITING);
                } else if (status.getState() != Status.State.STOPPED) {
                    status.set(Status.State.STOPPED, status.getResult(), status.getExitValue(), status.getMessage());
                }
            }
        }
        if (persistStatus) {
            this.persistStatus(status);
        }
        if (status.hasOutput()) {
            status.setOutput(null, persistStatus);
        }
        this.jobStatuses.put((Object)name, (Object)status);
    }

    public void persistStatus(Status status) {
        if (status == null || this.statusService == null) {
            return;
        }
        try {
            this.statusService.saveStatus(status);
        }
        catch (Exception e) {
            if (!this.statusService.isConnected()) {
                try {
                    this.reloadService();
                }
                catch (ServiceException ex) {
                    Localise.logError((Logger)this.logger, (String)"Unexpected exception reloading service - %1$s", (Object[])new Object[]{e.getMessage()});
                }
            }
            Localise.logError((Logger)this.logger, (String)"Status: %s", (Object[])new Object[]{status.toJSON().toString()});
            Localise.logError((Logger)this.logger, (Exception)e, (String)"Could not log status of %s", (Object[])new Object[]{status.getName().toString()});
        }
    }

    public boolean remove(Name name) {
        return this.jobStatuses.remove((Object)name) != null;
    }

    public void setResult(Name name, Status.Result result) {
        block5: {
            try {
                this.setStatus(this.getStatus(name).setResult(result).updateTimestamp());
            }
            catch (NullPointerException e) {
                Localise.logError((Logger)this.logger, (String)"Non-existent job %s", (Object[])new Object[]{name.toString()});
            }
            catch (Exception e) {
                if (this.statusService.isConnected()) break block5;
                try {
                    this.reloadService();
                }
                catch (ServiceException ex) {
                    Localise.logError((Logger)this.logger, (String)"Unexpected exception reloading service - %1$s", (Object[])new Object[]{e.getMessage()});
                }
            }
        }
    }

    public void setState(Name name, Status.State state, Trigger trigger) {
        block5: {
            try {
                Status status = this.getStatus(name).setState(state).setTrigger(trigger).updateTimestamp(state == Status.State.STARTING);
                this.setStatus(status);
            }
            catch (NullPointerException e) {
                Localise.logError((Logger)this.logger, (String)"Non-existent job %s", (Object[])new Object[]{name.toString()});
            }
            catch (Exception e) {
                if (this.statusService.isConnected()) break block5;
                try {
                    this.reloadService();
                }
                catch (ServiceException ex) {
                    Localise.logError((Logger)this.logger, (String)"Unexpected exception reloading service - %1$s", (Object[])new Object[]{e.getMessage()});
                }
            }
        }
    }

    public void setMissed(Name name, String message, Trigger trigger, boolean clearStarting) {
        Status status = this.getStatus(name);
        if (status == null) {
            Localise.logError((Logger)this.logger, (String)"Non-existent job %s", (Object[])new Object[]{name.toString()});
            return;
        }
        status.setTrigger(trigger).updateTimestamp(true);
        if (clearStarting && status.getState() == Status.State.STARTING) {
            status.set(Status.State.STOPPED, Status.Result.MISSED, -1, message);
        } else {
            status.set(status.getState(), Status.Result.MISSED, status.getExitValue(), message);
        }
        this.setStatus(status);
    }

    public void updateNextExecutionTime(Name name) {
        if (this.jobManager == null) {
            Localise.logError((Logger)this.logger, (String)"jobManager is not defined", (Object[])new Object[0]);
            return;
        }
        Job job = this.jobManager.getJob(name);
        Status status = (Status)this.jobStatuses.get((Object)name);
        if (job == null || status == null) {
            return;
        }
        status.setNextExecution(this.jobManager.getNextExecution(name));
        this.jobStatuses.put((Object)name, (Object)status);
    }

    static class ServiceStart
    implements Callable<String>,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        ServiceStart() {
        }

        @Override
        public String call() {
            JobStatusManager manager = JobStatusManager.getInstance(this.hazelcast);
            if (manager.statusService != null) {
                return Localise.format((String)"%1$s status service is already running", (Object[])new Object[]{manager.statusService.getServiceName()});
            }
            try {
                manager.statusService = StatusService.getService((HazelcastInstance)this.hazelcast);
                return null;
            }
            catch (ServiceException e) {
                return e.getMessage();
            }
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    static class ServiceStop
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        ServiceStop() {
        }

        @Override
        public Boolean call() {
            JobStatusManager manager = JobStatusManager.getInstance(this.hazelcast);
            if (manager.statusService != null && manager.statusService.disconnect()) {
                manager.statusService = null;
            }
            return manager.statusService == null;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    private class StateListener
    implements EntryExpiredListener<Name, Status.State> {
        private StateListener() {
        }

        public void entryExpired(EntryEvent<Name, Status.State> event) {
            Name name = (Name)event.getKey();
            Status status = (Status)JobStatusManager.this.jobStatuses.get((Object)name);
            if (status == null) {
                return;
            }
            Job job = JobStatusManager.this.jobManager.getJob(name);
            Status.State state = status.getState();
            if (state == Status.State.STARTING) {
                if (job instanceof AgentJob) {
                    if (JobStatusManager.this.sshAgents.isEmpty()) {
                        JobStatusManager.this.setStatus(new Status((Name)event.getKey(), Status.Result.MISSED).setMessage(Localise.format((String)"No active agents")));
                    } else {
                        JobStatusManager.this.setStatus(new Status((Name)event.getKey(), Status.Result.MISSED).setMessage(Localise.format((String)"Could not start - check queue depth")));
                    }
                } else {
                    JobStatusManager.this.setStatus(new Status((Name)event.getKey(), Status.Result.MISSED).setMessage(Localise.format((String)"Timed out trying to start")));
                }
            } else if (state == Status.State.RUNNING) {
                Localise.logError((Logger)JobStatusManager.this.logger, (String)"Job run time limit is not yet implemented", (Object[])new Object[0]);
                JobStatusManager.this.activeJobs.put((Object)name, (Object)status.getStartTimestamp());
            }
        }
    }

    private class StatusListener
    implements EntryAddedListener<Name, Status>,
    EntryUpdatedListener<Name, Status> {
        private StatusListener() {
        }

        public void entryAdded(EntryEvent<Name, Status> event) {
            this.entryUpdated(event);
        }

        public void entryUpdated(EntryEvent<Name, Status> event) {
            Name triggerName = (Name)event.getKey();
            Job job = JobStatusManager.this.jobManager.getJob(triggerName);
            Status currentStatus = (Status)event.getOldValue();
            Status newStatus = (Status)event.getValue();
            if (currentStatus == null || currentStatus.getState() == Status.State.UNKNOWN || newStatus.getTimestamp() < JobStatusManager.this.jobStatusListenerActivated || job == null || job.isDisabled()) {
                return;
            }
            if (newStatus.equals((Object)currentStatus) && !job.isBypass()) {
                return;
            }
            Set<Name> listeners = JobStatusManager.this.jobListenerManager.getListeners(triggerName);
            if (!listeners.isEmpty()) {
                if (newStatus.hasOutput() && JobStatusManager.this.statusService != null && JobStatusManager.this.statusService.isConnected()) {
                    newStatus = JobStatusManager.this.statusService.getStatus(triggerName, newStatus.getTimestamp(), true);
                }
                Trigger trigger = new Trigger(triggerName);
                for (Name listener : listeners) {
                    long timestamp = System.currentTimeMillis();
                    if (JobStatusManager.this.jobManager.executeJob(listener, trigger, newStatus, Job.Action.START, false, true) != JobManager.ExecuteResult.MISSED_QUEUE) continue;
                    JobStatusManager.this.queuedJobs.put((Object)listener, (Object)new QueuedJob(listener, trigger, newStatus, timestamp));
                }
            }
            if (newStatus.isInactive()) {
                Name name = newStatus.getName();
                Collection jobsQ = JobStatusManager.this.queuedJobs.get((Object)name);
                for (QueuedJob queueEntry : JobStatusManager.this.queuedJobs.get((Object)name)) {
                    JobStatusManager.this.queuedJobs.remove((Object)name, (Object)queueEntry);
                    Job queuedJob = JobStatusManager.this.jobManager.getJob(name);
                    if (queuedJob == null) continue;
                    if (queueEntry.getTimestamp() + queuedJob.getStartLimit().getMilliseconds() < System.currentTimeMillis()) {
                        JobStatusManager.this.jobStatuses.put((Object)name, (Object)new Status(name, Status.Result.MISSED).setStartTimestamp(queueEntry.getTimestamp()).setTrigger(queueEntry.getTrigger()).setMessage(Localise.format((String)"Timed out trying to start")));
                        break;
                    }
                    JobStatusManager.this.jobManager.executeJob(name, queueEntry.getTrigger(), queueEntry.getTriggerStatus(), Job.Action.START, false, false);
                    break;
                }
            }
        }
    }
}

