/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.property.PropertyValidator;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.message.PropertyList;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.PersistManager;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class PropertyManager
extends PropertyValidator
implements Persist.Listener {
    static final Logger logger = LogUtils.getLogger(PersistManager.class);
    private static Map<String, PropertyManager> managers = new HashMap<String, PropertyManager>();
    private DataManager data;

    public static synchronized PropertyManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        PropertyManager manager = managers.get(name);
        if (manager == null) {
            manager = new PropertyManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private PropertyManager(HazelcastInstance hazelcast) {
        super(hazelcast);
        this.data = DataManager.getInstance(hazelcast);
    }

    public boolean setProperty(Property property) {
        if (property.getType() == Property.Type.DEFAULT) {
            property.setType(Property.Type.VARIABLE);
        }
        return this.data.addProperty(property);
    }

    public boolean deleteProperty(Property property) {
        return this.data.removeProperty(property);
    }

    @Override
    public void messageLoaded(Name name, Message<?> message) {
        if (message instanceof Property) {
            this.setProperty((Property)message);
        } else if (message instanceof PropertyList) {
            for (Property property : ((PropertyList)message).getValues()) {
                this.setProperty(property);
            }
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message type %1$s", (Object[])new Object[]{message.getClass().getName()});
        }
    }
}

