/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.License;
import com.beyondcron.core.Limit;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ILock;

public class ServerLimit
extends Limit {
    private IAtomicLong calendars;
    private IAtomicLong jobs;
    private IAtomicLong executions;
    private IAtomicLong expired;
    private IAtomicLong loggedEpoch;
    private IAtomicLong loggedEpochExecutions;
    private ILock loggedEpochLock;
    private static long lastLoggedEpoch;

    public ServerLimit(HazelcastInstance hazelcast, License license) {
        super(license);
        this.init(hazelcast);
        this.setLicense(license);
    }

    private void init(HazelcastInstance hazelcast) {
        this.calendars = Hazelcast.getLicenseLimitsServerCalendars((HazelcastInstance)hazelcast);
        this.jobs = Hazelcast.getLicenseLimitsServerJobs((HazelcastInstance)hazelcast);
        this.executions = Hazelcast.getLicenseLimitsServerExecutions((HazelcastInstance)hazelcast);
        this.expired = Hazelcast.getLimitsExpired((HazelcastInstance)hazelcast);
        this.loggedEpoch = Hazelcast.getLimitsLogEpoch((HazelcastInstance)hazelcast);
        this.loggedEpochExecutions = Hazelcast.getLimitsLogEpochExecutions((HazelcastInstance)hazelcast);
        this.loggedEpochLock = Hazelcast.getLimitsLogEpochLock((HazelcastInstance)hazelcast);
    }

    public void setLicense(License license) {
        super.setLicense(license);
        if (this.expired != null) {
            this.setExpired(license.getType() == License.Type.EVALUATION && license.isExpired());
        }
    }

    public long getCalendars() {
        return this.calendars.get();
    }

    public void setCalendars(long calendars) {
        this.calendars.set(calendars);
    }

    public boolean addCalendar() {
        if (this.calendars.get() < this.maxCalendars) {
            this.calendars.incrementAndGet();
            return true;
        }
        return false;
    }

    public boolean removeCalendar() {
        if (this.calendars.get() > 0L) {
            this.calendars.decrementAndGet();
            return true;
        }
        return false;
    }

    public long getJobs() {
        return this.jobs.get();
    }

    public void setJobs(long jobs) {
        this.jobs.getAndSet(jobs);
    }

    public boolean addJob() {
        if (this.jobs.get() < this.maxJobs) {
            this.jobs.incrementAndGet();
            return true;
        }
        return false;
    }

    public boolean removeJob() {
        if (this.jobs.get() > 0L) {
            this.jobs.decrementAndGet();
            return true;
        }
        return false;
    }

    public long getExecutions() {
        return this.executions.get();
    }

    public long setExecutions(long executions) {
        this.executions.set(executions);
        return executions;
    }

    public long incrementExecutions() {
        return this.executions.incrementAndGet();
    }

    public boolean isExpired() {
        return this.expired.get() > 0L;
    }

    public void setExpired(boolean expired) {
        this.expired.set(expired ? 1L : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void logExecutions(String userName, long executions, long epochStart) {
        if (lastLoggedEpoch == epochStart) {
            return;
        }
        try {
            this.loggedEpochLock.lock();
            if (this.loggedEpoch.get() != epochStart) {
                this.loggedEpoch.set(epochStart);
                this.loggedEpochExecutions.set(executions);
            } else {
                executions = this.loggedEpochExecutions.get();
            }
        }
        finally {
            this.loggedEpochLock.unlock();
        }
        lastLoggedEpoch = epochStart;
        super.logExecutions(userName, executions, epochStart);
    }
}

