/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.agent.service;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.Output;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class Shell {
    static final Logger logger = LogUtils.getLogger(Shell.class);
    public static final String ENVIRONMENT_PATH = "PATH";
    @StringConfig.Annotation(defaultValue="/bin:/usr/bin")
    public static final String ENVIRONMENT_PATH_VALUE = "beyondcron.shell.environment.path";
    @StringConfig.Annotation(defaultValue="echo '%s'")
    public static final String COMMAND_CONNECTED = "beyondcron.shell.command.connected";
    @StringConfig.Annotation(defaultValue="<< CONNECTED >>")
    public static final String COMMAND_CONNECTED_VALUE = "beyondcron.shell.command.connected.value";
    @StringConfig.Annotation(defaultValue="bash")
    public static final String COMMAND_SHELL = "beyondcron.shell.command.shell";
    @StringConfig.Annotation(defaultValue="bash: line \\d+:\\s+(.+)\\s*$")
    public static final String COMMAND_SHELL_ERROR_REGEX = "beyondcron.shell.command.shell.error.regex";
    @StringConfig.Annotation(defaultValue="\\S+:\\s+(\\S+:\\s.+)\\s*$")
    public static final String COMMAND_ERROR_REGEX = "beyondcron.shell.command.error.regex";
    @StringConfig.Annotation(defaultValue="exit")
    public static final String COMMAND_EXIT = "beyondcron.shell.command.exit";
    @StringConfig.Annotation(defaultValue="echo '<< EXIT-VALUE='$?' >>'")
    public static final String COMMAND_EXIT_VALUE = "beyondcron.shell.command.exit.value";
    @StringConfig.Annotation(defaultValue="echo '<< EXIT-VALUE='${PIPESTATUS[0]}'/'$?' >>'")
    public static final String COMMAND_PIPE_EXIT_VALUE = "beyondcron.shell.command.pipe.exit.value";
    @StringConfig.Annotation(defaultValue="^<< EXIT-VALUE=(\\d+)(/(\\d+))? >>")
    public static final String COMMAND_EXIT_VALUE_REGEX = "beyondcron.shell.command.exit.value.regex";
    @StringConfig.Annotation(defaultValue="ssh -o BatchMode=yes %1$s env -i %2$s bash")
    public static final String COMMAND_SSH = "beyondcron.shell.command.ssh";
    @StringConfig.Annotation(defaultValue="ssh -o BatchMode=yes %1$s@%2$s env -i %3$s bash")
    public static final String COMMAND_SSH_USER = "beyondcron.shell.command.ssh.user";
    @StringConfig.Annotation(defaultValue="exec 2>&1")
    public static final String COMMAND_STDERR_REDIRECT = "beyondcron.shell.stderr.redirect";
    @StringConfig.Annotation(defaultValue="uname -s")
    public static final String COMMAND_UNAME = "beyondcron.shell.command.uname";
    @StringConfig.Annotation(defaultValue="/tmp", regex=".+")
    public static final String DIRECTORY_TEMP = "beyondcron.shell.directory.temp";
    public static String PATH;
    private static final Pattern SHELL_ERROR_REGEX;
    private static final Pattern ERROR_REGEX;
    private static final Pattern EXIT_VALUE_REGEX;
    private static String connectedCommand;
    private static String connectedValue;
    private static String shellCommand;
    private static String exitCommand;
    private static String exitValueCommand;
    private static String pipeExitValueCommand;
    private static String sshCommand;
    private static String sshCommandUser;
    private static String stderrRedirectCommand;
    private static String unameCommand;
    private Process process;
    private BufferedReader processOut;
    private PrintWriter processIn;
    private Program.OS os = Program.OS.UNKNOWN;
    private boolean closing = false;
    private boolean connected = false;
    private int exitValue = 0;
    private boolean success = true;
    private String errorMessage = "";
    private Output output;

    public Shell() throws IOException {
        this(null, null, new HashMap<String, String>());
    }

    public Shell(String hostName) throws IOException {
        this(hostName, null, new HashMap<String, String>());
    }

    public Shell(String hostName, String sshUserName, Map<String, String> baseEnvironment) throws IOException {
        this.process = StringUtils.isNullOrEmpty((String)hostName) ? this.getLocalProcess(baseEnvironment) : this.getSshProcess(hostName, sshUserName, baseEnvironment);
        this.processOut = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        this.processIn = new PrintWriter(this.process.getOutputStream(), true);
        this.processIn.println(String.format(connectedCommand, connectedValue));
        Output.Builder outputBuilder = new Output.Builder();
        while (true) {
            String line;
            if ((line = this.processOut.readLine()) == null) {
                this.exitValue = this.process.isAlive() ? -1 : this.process.exitValue();
                break;
            }
            if (line.equals(connectedValue)) {
                this.connected = true;
                break;
            }
            outputBuilder.addLine(line);
        }
        this.output = outputBuilder.build();
        if (!this.connected) {
            this.errorMessage = this.output.getFirstLine();
            return;
        }
        if (this.exitValue != 0) {
            return;
        }
        if (this.executeCommand(unameCommand) == 0) {
            switch (this.getOutput().getFirstLine().toUpperCase()) {
                case "LINUX": {
                    this.os = Program.OS.LINUX;
                    break;
                }
                case "DARWIN": {
                    this.os = Program.OS.MACOSX;
                }
            }
        } else {
            Localise.logError((Logger)logger, (String)"Could not determine os - %s", (Object[])new Object[]{this.getErrorMessage()});
        }
        if (this.executeCommand(stderrRedirectCommand) != 0) {
            Localise.logError((Logger)logger, (String)"Could not redirect stderr to stdout - %s", (Object[])new Object[]{this.getErrorMessage()});
        }
    }

    public void close() {
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"Closing shell - %s", (Object[])new Object[]{Boolean.toString(this.process.isAlive())});
        }
        if (this.process.isAlive()) {
            try {
                this.closing = true;
                this.executeCommand(exitCommand);
                this.processIn.close();
                this.processOut.close();
            }
            catch (IOException e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception closing shell - %s", (Object[])new Object[]{e.getMessage()});
            }
            finally {
                this.closing = false;
            }
            if (this.process.isAlive()) {
                this.process.destroyForcibly();
            }
        }
    }

    public boolean isConnected() {
        return this.connected && this.process.isAlive();
    }

    public Program.OS getOS() {
        return this.os;
    }

    private Process getLocalProcess(Map<String, String> baseEnvironment) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(shellCommand);
        builder.directory(new File((String)Configs.get((String)DIRECTORY_TEMP)));
        builder.redirectErrorStream(true);
        Map<String, String> environment = builder.environment();
        environment.clear();
        environment.putAll(baseEnvironment);
        environment.put(ENVIRONMENT_PATH, PATH);
        return builder.start();
    }

    private Process getSshProcess(String hostName, String userName, Map<String, String> baseEnvironment) throws IOException {
        ArrayList<String> environment = new ArrayList<String>();
        environment.add(String.format("'%s'='%s'", ENVIRONMENT_PATH, PATH));
        for (String name : baseEnvironment.keySet()) {
            if (name.equals(ENVIRONMENT_PATH)) continue;
            environment.add(String.format("'%s'='%s'", name, baseEnvironment.get(name)));
        }
        ProcessBuilder builder = StringUtils.isNullOrEmpty((String)userName) ? new ProcessBuilder(StringUtils.split((String)String.format(sshCommand, hostName, StringUtils.join((String)" ", environment)), (boolean)false)) : new ProcessBuilder(StringUtils.split((String)String.format(sshCommandUser, userName, hostName, StringUtils.join((String)" ", environment)), (boolean)false));
        builder.directory(new File((String)Configs.get((String)DIRECTORY_TEMP)));
        builder.redirectErrorStream(true);
        return builder.start();
    }

    public boolean wasSuccess() {
        return this.success;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Output getOutput() {
        return this.output;
    }

    public int executeCommand(String command) throws IOException {
        return this.executeCommand(new Output.Builder(), command, null, false, 0);
    }

    public int executeCommand(String command, int ... expectedExitValues) throws IOException {
        return this.executeCommand(new Output.Builder(), command, null, false, expectedExitValues);
    }

    public int executeCommand(String command, List<String> input, boolean includesPipe, int ... expectedExitValues) throws IOException {
        return this.executeCommand(new Output.Builder(), command, input, includesPipe, expectedExitValues);
    }

    public int executeCommand(Output.Builder outputBuilder, String command, List<String> input, boolean includesPipe, int ... expectedExitValues) throws IOException {
        int n;
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"Executing: %s", (Object[])new Object[]{command});
        }
        this.processIn.println(command);
        if (input != null) {
            for (String string : input) {
                this.processIn.println(string);
            }
        }
        if (this.closing) {
            try {
                this.process.waitFor(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.process.isAlive()) {
            this.processIn.println(includesPipe ? pipeExitValueCommand : exitValueCommand);
            this.exitValue = 255;
        } else {
            this.exitValue = this.process.exitValue();
        }
        Matcher matcher = null;
        while (true) {
            String string = this.processOut.readLine();
            if (logger.isTraceEnabled()) {
                Localise.logTrace((Logger)logger, (String)"Line: %s", (Object[])new Object[]{string});
            }
            if (string == null) break;
            matcher = EXIT_VALUE_REGEX.matcher(string);
            if (matcher.matches()) {
                this.exitValue = Integer.parseInt(matcher.group(1));
                break;
            }
            outputBuilder.addLine(string);
        }
        this.output = outputBuilder.build();
        this.errorMessage = "";
        this.success = false;
        if (expectedExitValues.length > 0) {
            for (int i2 : expectedExitValues) {
                if (i2 != this.exitValue) continue;
                this.success = true;
                break;
            }
        } else if (this.exitValue == 0) {
            this.success = true;
        }
        if (!this.success) {
            this.errorMessage = this.parseErrorMessage(this.output.getLastLine());
        } else if (includesPipe && matcher.matches() && (n = Integer.parseInt(matcher.group(3))) != 0) {
            this.exitValue = n;
            this.errorMessage = this.parseErrorMessage(this.output.getFirstLine());
        }
        if (logger.isDebugEnabled()) {
            Localise.logDebug((Logger)logger, (String)"Command: %s", (Object[])new Object[]{command});
            Localise.logDebug((Logger)logger, (String)"Exit value: %d", (Object[])new Object[]{this.exitValue});
            for (String line : this.output.getLines()) {
                Localise.logDebug((Logger)logger, (String)"Output: %s", (Object[])new Object[]{line});
            }
        }
        return this.exitValue;
    }

    private String parseErrorMessage(String line) {
        if (line == null) {
            return "";
        }
        Matcher matcher = SHELL_ERROR_REGEX.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        matcher = ERROR_REGEX.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return line;
    }

    static {
        Configs.addConfigs(Shell.class);
        PATH = (String)Configs.get((String)ENVIRONMENT_PATH_VALUE);
        SHELL_ERROR_REGEX = Configs.getPattern((String)COMMAND_SHELL_ERROR_REGEX);
        ERROR_REGEX = Configs.getPattern((String)COMMAND_ERROR_REGEX);
        EXIT_VALUE_REGEX = Configs.getPattern((String)COMMAND_EXIT_VALUE_REGEX);
        connectedCommand = (String)Configs.get((String)COMMAND_CONNECTED);
        connectedValue = (String)Configs.get((String)COMMAND_CONNECTED_VALUE);
        shellCommand = (String)Configs.get((String)COMMAND_SHELL);
        exitCommand = (String)Configs.get((String)COMMAND_EXIT);
        exitValueCommand = (String)Configs.get((String)COMMAND_EXIT_VALUE);
        pipeExitValueCommand = (String)Configs.get((String)COMMAND_PIPE_EXIT_VALUE);
        sshCommand = (String)Configs.get((String)COMMAND_SSH);
        sshCommandUser = (String)Configs.get((String)COMMAND_SSH_USER);
        stderrRedirectCommand = (String)Configs.get((String)COMMAND_STDERR_REDIRECT);
        unameCommand = (String)Configs.get((String)COMMAND_UNAME);
    }
}

