/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.jdbc;

import com.beyondcron.core.ConfigService;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.service.jdbc.JDBCClient;
import com.beyondcron.service.jdbc.JDBCException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class JDBCConfigService
extends ConfigService {
    static Logger logger = LogUtils.getLogger(JDBCConfigService.class);
    public static final String SERVICE_NAME = "JDBC";
    @StringConfig.Annotation(regex="[a-zA-Z_][a-zA-Z0-9_]{0,62}", startup=true)
    public static final String JDBC_TABLE_CONFIG = "JDBC_TABLE_CONFIG";
    public static final String JDBC_COLUMN_NAME = "bc_name";
    public static final String JDBC_COLUMN_VALUE = "bc_value";
    public static final String SQL_CREATE_TABLE_CONFIG = "createTableConfig";
    public static final String SQL_INSERT_CONFIG = "insertConfig";
    public static final String SQL_REPLACE_CONFIG = "replaceConfig";
    public static final String SQL_UPDATE_CONFIG = "updateConfig";
    public static final String SQL_SELECT_CONFIG = "selectConfig";
    public static final String SQL_SELECT_CONFIGS = "selectConfigs";
    private JDBCClient jdbcClient;
    private String configTable;
    private PreparedStatement insertConfig;
    private PreparedStatement replaceConfig;
    private PreparedStatement updateConfig;
    private PreparedStatement selectConfig;
    private PreparedStatement selectConfigs;
    private Map<String, String> properties = new HashMap<String, String>();
    private long propertiesUpdated = 0L;

    public JDBCConfigService() {
        super(SERVICE_NAME);
    }

    protected void init() throws ServiceException {
        this.jdbcClient = new JDBCClient(true, JDBC_TABLE_CONFIG);
        this.initConfigTable();
        this.initStatements();
        this.initProperties();
    }

    public String getServiceDescription() {
        return this.jdbcClient != null ? this.jdbcClient.getDescription() : "";
    }

    public boolean disconnect() {
        if (!super.disconnect()) {
            return false;
        }
        if (this.jdbcClient == null) {
            return true;
        }
        return this.jdbcClient.disconnect();
    }

    public boolean isConnected() {
        return this.jdbcClient != null && this.jdbcClient.isConnected() && super.isConnected();
    }

    private void initConfigTable() {
        this.configTable = (String)Configs.get((String)JDBC_TABLE_CONFIG);
        if (this.jdbcClient.validateTable(this.configTable, JDBC_COLUMN_NAME, JDBC_COLUMN_VALUE)) {
            return;
        }
        try {
            Statement statement = this.jdbcClient.createStatement();
            if (statement.execute(this.jdbcClient.getSQL(SQL_CREATE_TABLE_CONFIG, this.configTable))) {
                ResultSet result = statement.getResultSet();
                while (result.next()) {
                    Localise.logError((Logger)logger, (String)"Unexpected result set returned", (Object[])new Object[0]);
                }
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    private void initStatements() {
        try {
            this.insertConfig = this.jdbcClient.prepareStatement(SQL_INSERT_CONFIG, this.configTable);
            this.replaceConfig = this.jdbcClient.prepareStatement(SQL_REPLACE_CONFIG, this.configTable);
            this.updateConfig = this.jdbcClient.prepareStatement(SQL_UPDATE_CONFIG, this.configTable);
            this.selectConfig = this.jdbcClient.prepareStatement(SQL_SELECT_CONFIG, this.configTable);
            this.selectConfigs = this.jdbcClient.prepareStatement(SQL_SELECT_CONFIGS, this.configTable);
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    private void initProperties() throws ServiceException {
        if (this.propertiesUpdated == 0L) {
            this.properties.clear();
            try {
                ResultSet result = this.selectConfigs.executeQuery();
                while (result.next()) {
                    this.properties.put(result.getString(1), result.getString(2));
                }
            }
            catch (SQLException e) {
                throw new ServiceException(Localise.format((String)"Could not get properties in %1$s - %2$s", (Object[])new Object[]{this.configTable, e.getMessage()}));
            }
            this.propertiesUpdated = System.currentTimeMillis();
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String setProperty(String name, String value) throws ServiceException {
        block7: {
            if (!this.isConnected()) {
                return null;
            }
            if (value == null) {
                throw new ServiceException(Localise.format((String)"Value of %1$s cannot be null", (Object[])new Object[]{name}));
            }
            try {
                this.insertConfig.setString(1, name);
                this.insertConfig.setString(2, value);
                this.insertConfig.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getMessage().toLowerCase().contains("duplicate")) {
                    try {
                        this.replaceConfig.setString(1, value);
                        this.replaceConfig.setString(2, name);
                        this.replaceConfig.executeUpdate();
                        e = null;
                    }
                    catch (SQLException e1) {
                        e = e1;
                    }
                }
                if (e == null) break block7;
                throw new ServiceException(Localise.format((String)"Could not set %1$s to %2$s - %3$s", (Object[])new Object[]{name, value, e.getMessage()}));
            }
        }
        this.properties.put(name, value);
        return value;
    }

    public String setProperty(String name, String value, String currentValue) throws ServiceException {
        boolean updated;
        block11: {
            if (!this.isConnected()) {
                return null;
            }
            if (value == null) {
                throw new ServiceException(Localise.format((String)"Value of %1$s cannot be null", (Object[])new Object[]{name}));
            }
            updated = false;
            try {
                if (currentValue == null) {
                    this.insertConfig.setString(1, name);
                    this.insertConfig.setString(2, value);
                    this.insertConfig.executeUpdate();
                    updated = true;
                } else {
                    this.updateConfig.setString(1, value);
                    this.updateConfig.setString(2, name);
                    this.updateConfig.setString(3, currentValue);
                    updated = this.updateConfig.executeUpdate() == 1;
                }
            }
            catch (SQLException e) {
                if (e.getMessage().toLowerCase(Locale.ROOT).contains("duplicate")) break block11;
                throw new ServiceException(Localise.format((String)"Could not set %1$s to %2$s - %3$s", (Object[])new Object[]{name, value, e.getMessage()}));
            }
        }
        if (updated) {
            this.properties.put(name, value);
        } else {
            try {
                this.selectConfig.setString(1, name);
                ResultSet result = this.selectConfig.executeQuery();
                if (!result.next()) {
                    throw new ServiceException(Localise.format((String)"Could not get value of %1$s", (Object[])new Object[]{name}));
                }
                this.properties.put(name, result.getString(1));
            }
            catch (SQLException e) {
                throw new ServiceException(Localise.format((String)"Could not get value of %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()}));
            }
        }
        return this.properties.get(name);
    }

    static {
        Configs.addConfigs(JDBCClient.class);
        Configs.addConfigs(JDBCConfigService.class);
    }
}

