/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.jdbc;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.job.Output;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.StatusService;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.service.jdbc.JDBCClient;
import com.beyondcron.service.jdbc.JDBCException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class JDBCStatusService
extends StatusService {
    static final Logger logger = LogUtils.getLogger(JDBCStatusService.class);
    public static final String SERVICE_NAME = "JDBC";
    @StringConfig.Annotation(regex="[a-zA-Z_][a-zA-Z0-9_]{0,62}")
    public static final String JDBC_TABLE_STATUS = "jdbc.table.status";
    public static final String JDBC_COLUMN_NAME = "bc_name";
    public static final String JDBC_COLUMN_STATE = "bc_state";
    public static final String JDBC_COLUMN_RESULT = "bc_result";
    public static final String JDBC_COLUMN_VALUE = "bc_value";
    public static final String JDBC_COLUMN_TIMESTAMP = "bc_timestamp";
    public static final String JDBC_COLUMN_START_TIMESTAMP = "bc_start_timestamp";
    public static final String JDBC_COLUMN_MESSAGE = "bc_message";
    public static final String JDBC_COLUMN_TRIGGER = "bc_trigger";
    public static final String JDBC_COLUMN_OUTPUT = "bc_output";
    public static final String SQL_CREATE_TABLE_STATUS = "createTableStatus";
    public static final String SQL_INSERT_STATUS = "insertStatus";
    public static final String SQL_UPDATE_STATUS = "updateStatus";
    public static final String SQL_SELECT_STATUSES = "selectStatuses";
    public static final String SQL_SELECT_STATUSES_NAME_COUNT = "selectStatusesNameCount";
    public static final String SQL_SELECT_STATUSES_NAME_RANGE = "selectStatusesNameRange";
    public static final String SQL_SELECT_STATUSES_NAMES_RANGE = "selectStatusesNamesRange";
    public static final String SQL_SELECT_STATUS_EXCLUDE_OUTPUT = "selectStatusExcludeOutput";
    public static final String SQL_SELECT_STATUS_INCLUDE_OUTPUT = "selectStatusIncludeOutput";
    public static final String SQL_DELETE_STATUSES = "deleteStatuses";
    public static final String SQL_DELETE_STATUSES_NAME = "deleteStatusesName";
    private JDBCClient jdbcClient;
    private String statusTable;
    private PreparedStatement insertStatus;
    private PreparedStatement updateStatus;
    private PreparedStatement selectStatuses;
    private PreparedStatement selectStatusesNameCount;
    private PreparedStatement selectStatusesNameRange;
    private PreparedStatement selectStatusesNamesRange;
    private PreparedStatement selectStatusExcludeOutput;
    private PreparedStatement selectStatusIncludeOutput;
    private PreparedStatement deleteStatuses;
    private PreparedStatement deleteStatusesName;

    public JDBCStatusService() {
        super(SERVICE_NAME);
    }

    public void init() throws ServiceException {
        boolean startupConfig = false;
        if (JDBCClient.validateConfigs(false, new String[0]).size() == JDBCClient.getConfigNames(false).size()) {
            startupConfig = JDBCClient.validateConfigs(true, JDBC_TABLE_STATUS).isEmpty();
        }
        this.jdbcClient = new JDBCClient(startupConfig, JDBC_TABLE_STATUS);
        this.initStatusTable();
        this.initStatements();
    }

    public String getServiceDescription() {
        return this.jdbcClient != null ? this.jdbcClient.getDescription() : "";
    }

    public boolean disconnect() {
        if (!super.disconnect()) {
            return false;
        }
        if (this.jdbcClient == null) {
            return true;
        }
        return this.jdbcClient.disconnect();
    }

    public boolean isConnected() {
        return this.jdbcClient != null && this.jdbcClient.isConnected() && super.isConnected();
    }

    private void initStatusTable() {
        this.statusTable = (String)Configs.get((String)JDBC_TABLE_STATUS);
        if (this.jdbcClient.validateTable(this.statusTable, JDBC_COLUMN_NAME, JDBC_COLUMN_STATE, JDBC_COLUMN_RESULT, JDBC_COLUMN_VALUE, JDBC_COLUMN_TIMESTAMP, JDBC_COLUMN_START_TIMESTAMP, JDBC_COLUMN_MESSAGE, JDBC_COLUMN_TRIGGER, JDBC_COLUMN_OUTPUT)) {
            return;
        }
        try {
            Statement statement = this.jdbcClient.createStatement();
            if (statement.execute(this.jdbcClient.getSQL(SQL_CREATE_TABLE_STATUS, this.statusTable))) {
                ResultSet result = statement.getResultSet();
                while (result.next()) {
                    Localise.logError((Logger)logger, (String)"Unexpected result set returned", (Object[])new Object[0]);
                }
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    private void initStatements() {
        try {
            this.insertStatus = this.jdbcClient.prepareStatement(SQL_INSERT_STATUS, this.statusTable);
            this.updateStatus = this.jdbcClient.prepareStatement(SQL_UPDATE_STATUS, this.statusTable);
            this.selectStatuses = this.jdbcClient.prepareStatement(SQL_SELECT_STATUSES, this.statusTable);
            this.selectStatusesNameCount = this.jdbcClient.prepareStatement(SQL_SELECT_STATUSES_NAME_COUNT, this.statusTable);
            this.selectStatusesNameRange = this.jdbcClient.prepareStatement(SQL_SELECT_STATUSES_NAME_RANGE, this.statusTable);
            this.selectStatusesNamesRange = this.jdbcClient.prepareStatement(SQL_SELECT_STATUSES_NAMES_RANGE, this.statusTable);
            this.selectStatusExcludeOutput = this.jdbcClient.prepareStatement(SQL_SELECT_STATUS_EXCLUDE_OUTPUT, this.statusTable);
            this.selectStatusIncludeOutput = this.jdbcClient.prepareStatement(SQL_SELECT_STATUS_INCLUDE_OUTPUT, this.statusTable);
            this.deleteStatuses = this.jdbcClient.prepareStatement(SQL_DELETE_STATUSES, this.statusTable);
            this.deleteStatusesName = this.jdbcClient.prepareStatement(SQL_DELETE_STATUSES_NAME, this.statusTable);
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    private Status parseStatus(ResultSet result, boolean includesOutput) {
        JSONObject json = new JSONObject();
        try {
            json.put("name", (Object)result.getString(1));
            json.put("timestamp", result.getLong(2));
            json.put("startTimestamp", result.getLong(3));
            json.put("state", (Object)result.getString(4));
            json.put("result", (Object)result.getString(5));
            json.put("value", result.getInt(6));
            String s = result.getString(7);
            if (s != null) {
                json.put("message", (Object)s);
            }
            if ((s = result.getString(8)) != null) {
                json.put("trigger", (Object)s);
            }
            if (includesOutput) {
                s = result.getString(9);
                if (s != null) {
                    json.put("hasOutput", true);
                    json.put("output", (Object)new JSONObject(s));
                }
            } else {
                json.put("hasOutput", result.getBoolean(9));
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        return new Status().fromJSON(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus(Name name, long timestamp, boolean includeOutput) {
        if (!this.isConnected()) {
            return null;
        }
        PreparedStatement preparedStatement = this.selectStatusIncludeOutput;
        synchronized (preparedStatement) {
            Status status = null;
            try {
                PreparedStatement statement = includeOutput ? this.selectStatusIncludeOutput : this.selectStatusExcludeOutput;
                statement.setString(1, name.toString());
                statement.setLong(2, timestamp);
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    status = this.parseStatus(result, includeOutput);
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - getStatuses(%1$s, %2$d, %3$d) - %4$s", (Object[])new Object[]{name, timestamp, Boolean.toString(includeOutput), e.getMessage()});
            }
            return status;
        }
    }

    public List<Status> getStatusesRange(Name name, long startTimestamp, long endTimestamp) {
        return name.isWildcard() ? this.getStatusesNames(name, startTimestamp, endTimestamp) : this.getStatusesName(name, startTimestamp, endTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Status> getStatusesName(Name name, long startTimestamp, long endTimestamp) {
        if (!this.isConnected()) {
            return new ArrayList<Status>();
        }
        PreparedStatement preparedStatement = this.selectStatusesNameRange;
        synchronized (preparedStatement) {
            ArrayList<Status> statuses = new ArrayList<Status>();
            if (!this.isConnected()) {
                return statuses;
            }
            try {
                this.selectStatusesNameRange.setString(1, name.toString());
                this.selectStatusesNameRange.setLong(2, startTimestamp);
                this.selectStatusesNameRange.setLong(3, endTimestamp < startTimestamp ? System.currentTimeMillis() : endTimestamp);
                ResultSet result = this.selectStatusesNameRange.executeQuery();
                while (result.next()) {
                    statuses.add(this.parseStatus(result, false));
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - getStatusesRange(%1$s, %2$d, %3$d) - %4$s", (Object[])new Object[]{name, startTimestamp, endTimestamp, e.getMessage()});
            }
            return Status.sortByTimestamp(statuses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Status> getStatusesNames(Name name, long startTimestamp, long endTimestamp) {
        PreparedStatement preparedStatement = this.selectStatusesNamesRange;
        synchronized (preparedStatement) {
            ArrayList<Status> statuses = new ArrayList<Status>();
            if (!this.isConnected()) {
                return statuses;
            }
            try {
                this.selectStatusesNamesRange.setString(1, name.getGroupName() + "%");
                this.selectStatusesNamesRange.setLong(2, startTimestamp);
                this.selectStatusesNamesRange.setLong(3, endTimestamp < startTimestamp ? System.currentTimeMillis() : endTimestamp);
                ResultSet result = this.selectStatusesNamesRange.executeQuery();
                if (name.isWildcardRecursive()) {
                    while (result.next()) {
                        statuses.add(this.parseStatus(result, false));
                    }
                } else {
                    String group = name.getGroupName();
                    while (result.next()) {
                        Status status = this.parseStatus(result, false);
                        if (!status.getName().getGroupName().equals(group)) continue;
                        statuses.add(status);
                    }
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - getStatusesRange(%1$s, %2$d, %3$d) - %4$s", (Object[])new Object[]{name, startTimestamp, endTimestamp, e.getMessage()});
            }
            return Status.sortByTimestamp(statuses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Status> getStatusesCount(Name name, long count, long endTimestamp) {
        PreparedStatement preparedStatement = this.selectStatusesNameCount;
        synchronized (preparedStatement) {
            ArrayList<Status> statuses = new ArrayList<Status>();
            if (!this.isConnected() || count < 1L) {
                return statuses;
            }
            HashSet<Long> startTimestamps = new HashSet<Long>();
            try {
                this.selectStatusesNameCount.setString(1, name.toString());
                this.selectStatusesNameCount.setLong(2, endTimestamp);
                this.selectStatusesNameCount.setLong(3, count * 5L);
                ResultSet result = this.selectStatusesNameCount.executeQuery();
                while (result.next()) {
                    Status status = this.parseStatus(result, false);
                    long startTimestamp = status.getStartTimestamp();
                    if (!startTimestamps.contains(startTimestamp)) {
                        if ((long)startTimestamps.size() >= count) continue;
                        startTimestamps.add(startTimestamp);
                    }
                    statuses.add(status);
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - getStatusesCount(%1$s, %2$d, %3$d) - %4$s", (Object[])new Object[]{name, count, endTimestamp, e.getMessage()});
            }
            return Status.sortByTimestamp(statuses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Status> getStatuses() {
        ArrayList<Status> statuses = new ArrayList<Status>();
        if (!this.isConnected()) {
            return statuses;
        }
        PreparedStatement preparedStatement = this.selectStatuses;
        synchronized (preparedStatement) {
            try {
                ResultSet result = this.selectStatuses.executeQuery();
                while (result.next()) {
                    statuses.add(this.parseStatus(result, false));
                }
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - getStatusesCount() - %1$s", (Object[])new Object[]{e.getMessage()});
            }
            return statuses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStatus(Status status) {
        if (!this.isConnected()) {
            return;
        }
        PreparedStatement preparedStatement = this.insertStatus;
        synchronized (preparedStatement) {
            try {
                this.insertStatus.setString(1, status.getName().toString());
                this.insertStatus.setLong(2, status.getTimestamp());
                this.insertStatus.setLong(3, status.getStartTimestamp());
                this.insertStatus.setString(4, status.getState().toString());
                this.insertStatus.setString(5, status.getResult().toString());
                this.insertStatus.setInt(6, status.getExitValue());
                this.insertStatus.setString(7, status.getMessage());
                Trigger trigger = status.getTrigger();
                this.insertStatus.setString(8, trigger != null ? trigger.toString() : null);
                Output output = status.getOutput();
                this.insertStatus.setString(9, output != null ? output.toJSON().toString() : null);
                this.insertStatus.executeUpdate();
            }
            catch (SQLException e) {
                logger.debug(e.getMessage());
                if (this.getStatus(status.getName(), status.getTimestamp(), false) == null) {
                    Localise.logError((Logger)logger, (String)"Unexpected exception - saveStatus(Status) insert - %1$s", (Object[])new Object[]{e.getMessage()});
                    return;
                }
                PreparedStatement preparedStatement2 = this.updateStatus;
                synchronized (preparedStatement2) {
                    try {
                        this.updateStatus.setString(8, status.getName().toString());
                        this.updateStatus.setLong(9, status.getTimestamp());
                        this.updateStatus.setLong(1, status.getStartTimestamp());
                        this.updateStatus.setString(2, status.getState().toString());
                        this.updateStatus.setString(3, status.getResult().toString());
                        this.updateStatus.setInt(4, status.getExitValue());
                        this.updateStatus.setString(5, status.getMessage());
                        Trigger trigger = status.getTrigger();
                        this.updateStatus.setString(6, trigger != null ? trigger.toString() : null);
                        Output output = status.getOutput();
                        this.updateStatus.setString(7, output != null ? output.toJSON().toString() : null);
                        this.updateStatus.executeUpdate();
                    }
                    catch (SQLException e1) {
                        Localise.logError((Logger)logger, (String)"Unexpected exception - saveStatus(Status) update - %1$s", (Object[])new Object[]{e.getMessage()});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeStatuses(long timestamp) {
        if (!this.isConnected()) {
            return 0;
        }
        PreparedStatement preparedStatement = this.deleteStatuses;
        synchronized (preparedStatement) {
            try {
                this.deleteStatuses.setLong(1, timestamp);
                return this.deleteStatuses.executeUpdate();
            }
            catch (SQLException e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - removeStatuses(%1$d) - %2$s", (Object[])new Object[]{timestamp, e.getMessage()});
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeStatuses(Name name, long timestamp) {
        if (!this.isConnected()) {
            return 0;
        }
        PreparedStatement preparedStatement = this.deleteStatusesName;
        synchronized (preparedStatement) {
            try {
                this.deleteStatusesName.setString(1, name.toString());
                this.deleteStatusesName.setLong(2, timestamp);
                return this.deleteStatusesName.executeUpdate();
            }
            catch (SQLException e) {
                Localise.logError((Logger)logger, (String)"Unexpected exception - removeStatuses(%1$s, %2$d) - %3$s", (Object[])new Object[]{name, timestamp, e.getMessage()});
                return 0;
            }
        }
    }

    static {
        Configs.addConfigs(JDBCClient.class);
        Configs.addConfigs(JDBCStatusService.class);
    }
}

