/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.aws;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.StringConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AWSClient {
    @StringConfig.Annotation
    public static final String AWS_ACCESS_KEY_ID = "aws.access.key.id";
    @StringConfig.Annotation(secret=true)
    public static final String AWS_SECRET_ACCESS_KEY = "aws.secret.access.key";
    @StringConfig.Annotation
    public static final String AWS_REGION = "aws.region";
    @StringConfig.Annotation(startup=true)
    public static final String AWS_ACCESS_KEY_ID_STARTUP = "AWS_ACCESS_KEY_ID";
    @StringConfig.Annotation(startup=true, secret=true)
    public static final String AWS_SECRET_ACCESS_KEY_STARTUP = "AWS_SECRET_ACCESS_KEY";
    @StringConfig.Annotation(startup=true)
    public static final String AWS_REGION_STARTUP = "AWS_REGION";
    private String accessKeyId;
    private String accessKeySecret;
    private String region;
    private String profile = Configs.isDefault((String)"BEYONDCRON_CLUSTER_NAME") ? null : ((String)Configs.get((String)"BEYONDCRON_CLUSTER_NAME")).replaceAll("\\s+", "-");
    private AWSStaticCredentialsProvider credentialsProvider;
    private AmazonDynamoDBClient dbClient = null;
    private AmazonS3Client s3Client = null;

    public AWSClient(String ... configNames) throws ServiceException {
        this(false, configNames);
    }

    public AWSClient(boolean startup, String ... configNames) throws ServiceException {
        List<String> missing = AWSClient.validateConfigs(startup, configNames);
        if (!missing.isEmpty()) {
            if (startup) {
                throw new ServiceException(Localise.format((String)"Startup variable/s undefined - %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", missing)}));
            }
            throw new ServiceException(Localise.format((String)"Configuration variable/s undefined - %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", missing)}));
        }
        if (startup) {
            this.accessKeyId = (String)Configs.get((String)AWS_ACCESS_KEY_ID_STARTUP);
            try {
                this.accessKeySecret = Configs.getPassword((String)AWS_SECRET_ACCESS_KEY_STARTUP);
            }
            catch (IOException e) {
                throw new ServiceException(Localise.format((String)"Could not read password - %1$s", (Object[])new Object[]{e.getMessage()}));
            }
            this.region = (String)Configs.get((String)AWS_REGION_STARTUP);
        } else {
            this.accessKeyId = (String)Configs.get((String)AWS_ACCESS_KEY_ID);
            this.accessKeySecret = (String)Configs.get((String)AWS_SECRET_ACCESS_KEY);
            this.region = (String)Configs.get((String)AWS_REGION);
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKeyId, this.accessKeySecret);
        this.credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
    }

    public static List<String> getConfigNames(boolean startup) {
        ArrayList<String> names = new ArrayList<String>();
        if (startup) {
            Collections.addAll(names, AWS_ACCESS_KEY_ID_STARTUP, AWS_SECRET_ACCESS_KEY_STARTUP, AWS_REGION_STARTUP);
        } else {
            Collections.addAll(names, AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, AWS_REGION);
        }
        return names;
    }

    public static List<String> validateConfigs(boolean startup, String ... configNames) {
        List<String> names = AWSClient.getConfigNames(startup);
        Collections.addAll(names, configNames);
        ArrayList<String> missing = new ArrayList<String>();
        for (String name : names) {
            if (!StringUtils.isNullOrEmpty((String)((String)Configs.get((String)name)))) continue;
            missing.add(name);
        }
        return missing;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean hasProfile() {
        return !StringUtils.isNullOrEmpty((String)this.profile);
    }

    public AmazonDynamoDBClient getDBClient() throws ServiceException {
        if (this.dbClient == null) {
            try {
                AmazonDynamoDBClientBuilder builder = AmazonDynamoDBClientBuilder.standard();
                builder.withCredentials((AWSCredentialsProvider)this.credentialsProvider);
                builder.withRegion(this.region);
                this.dbClient = (AmazonDynamoDBClient)builder.build();
            }
            catch (SdkClientException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return this.dbClient;
    }

    public AmazonS3Client getS3Client() throws ServiceException {
        if (this.s3Client == null) {
            try {
                AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withPathStyleAccessEnabled(Boolean.valueOf(true));
                builder.withCredentials((AWSCredentialsProvider)this.credentialsProvider);
                builder.withRegion(this.region);
                this.s3Client = (AmazonS3Client)builder.build();
            }
            catch (SdkClientException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return this.s3Client;
    }

    static {
        Configs.addConfigs(AWSClient.class);
    }
}

