//

function fixTopBar() {
    var topBar = $('div.top-bar');
    if (topBar != undefined) {
        var height = +topBar.css('height').replace(/px/, '') + +topBar.css('margin-bottom').replace(/px/, '');
        $('body').css('padding-top', height + 'px');
    }
}

function positionFooter() {
    var footer = $('.site-footer');
    if (footer != undefined) {
        var height = +footer.css('height').replace(/px/, '') + +footer.css('margin-top').replace(/px/, '');
        $('div.wrapper').css('margin-bottom', ('-' + height + 'px'));
        $('div.push').css('height', (height + 'px'));
    }
}

function selector(groups) {
    const options = ['option-a', 'option-b', 'option-c', 'option-d', 'option-e'];

    groups.split(/\s+/).forEach(function (group) {
        options.forEach(function (option) {
            let value = group == 'true' ? option : `${group}.${option}`;


            $(`a.${value}`).click(function () {
                if ($(`a.${value}`).removeClass('hollow').length > 0) {
                    select(value);
                }
            });
        });
    });

    // ensure that option-a elements are visible. this is required in the case
    // of elements that belong to more than one option.
    $('div.option-a').show();
    $('p.option-a').show();
}

function select(value) {
    const options = ['option-a', 'option-b', 'option-c', 'option-d', 'option-e'];

    let tokens = value.split('.');
    let option = tokens.pop();
    let group = tokens.length > 0 ? (tokens.shift() + '.') : '';

    options.forEach(function (value) {
        if (value != option) {
            $(`a.${group}${value}`).addClass('hollow');
            $(`div.${group}${value}`).hide();
            $(`p.${group}${value}`).hide();
        }
    });

    $(`a.${value}`).removeClass('hollow');
    $(`div.${value}`).show();
    $(`p.${value}`).show();
}

$(document).ready(function () {
    fixTopBar();
    positionFooter();

    if ($.url().param('eap') != undefined) {
        $(".eap").removeClass("eap");
    }
    if ($.url().param('deprecated') != undefined) {
        $(".deprecated").removeClass("deprecated");
    }

    if ($.url().param('na') != undefined) {
        $('#noAccess').foundation('open');
    } else if ($.url().param('nf') != undefined) {
        $('#notFound').foundation('open');
    }

    if ($('div.collapse ul').addClass('collapsibleList').length > 0) {
        CollapsibleLists.apply();
    }

    $('body').addClass('host-' + $.url().attr('host').toLowerCase().replace(/\./g, '-'));

    $(window).resize(function () {
        positionFooter();
    });
});

$(window).load(function() {
    var anchor = $.url().attr('anchor');
    if (anchor && anchor.length > 0) {
        var y1 = $('#' + anchor).offset().top;
        var y2 = $('body').css('padding-top').replace(/px/, '');
        $(document).scrollTop(y1 - y2);
    }
});

// end