/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.security.HostACL;
import com.beyondcron.core.security.HostACLValidator;
import com.beyondcron.core.security.Protected;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class HostACLManager
extends HostACLValidator {
    private static Map<String, HostACLManager> managers = new HashMap<String, HostACLManager>();
    private MultiMap<String, HostACL> acls;
    private MultiMap<Protected.Type, String> protectedNames;

    public static synchronized HostACLManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        HostACLManager manager = managers.get(name);
        if (manager == null) {
            manager = new HostACLManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    protected HostACLManager(HazelcastInstance hazelcast) {
        super(hazelcast);
        this.acls = Hazelcast.getACLHostMap((HazelcastInstance)hazelcast);
        this.protectedNames = Hazelcast.getProtectedNames((HazelcastInstance)hazelcast);
    }

    public boolean initDefaults() {
        int changes = 0;
        if (this.protectedNames.get((Object)Protected.Type.HOST).isEmpty()) {
            for (String hostName : StringUtils.split((String)((String)Configs.get((String)"beyondcron.protected.hosts")))) {
                changes += this.protectedNames.put((Object)Protected.Type.HOST, (Object)hostName.toLowerCase()) ? 1 : 0;
            }
        }
        if (this.protectedNames.get((Object)Protected.Type.USER).isEmpty()) {
            for (String userName : StringUtils.split((String)((String)Configs.get((String)"beyondcron.protected.users")))) {
                changes += this.protectedNames.put((Object)Protected.Type.USER, (Object)userName.toLowerCase()) ? 1 : 0;
            }
        }
        changes += this.protectedNames.put((Object)Protected.Type.USER, (Object)Program.getUserName()) ? 1 : 0;
        HostACL acl = new HostACL((String)Configs.get((String)"beyondcron.everyone.role.name"), String.format("*@%1$s", "example.com"));
        changes += this.acls.put((Object)acl.getUserRole(), (Object)acl) ? 1 : 0;
        acl = new HostACL((String)Configs.get((String)"beyondcron.everyone.role.name"), String.format("*@*.%1$s", "example.com"));
        return (changes += this.acls.put((Object)acl.getUserRole(), (Object)acl) ? 1 : 0) > 0;
    }

    public boolean setACL(HostACL acl) {
        return this.acls.put((Object)acl.getUserRole(), (Object)acl);
    }

    public Collection<HostACL> getACLs() {
        return this.acls.values();
    }

    public boolean deleteACL(HostACL acl) {
        return this.acls.remove((Object)acl.getUserRole(), (Object)acl);
    }

    public boolean setProtected(Protected name) {
        return this.protectedNames.put((Object)name.getType(), (Object)name.getValue().toLowerCase());
    }

    public boolean deleteProtected(Protected name) {
        return this.protectedNames.remove((Object)name.getType(), (Object)name.getValue().toLowerCase());
    }

    public Collection<Protected> getProtected(Protected.Type type) {
        ArrayList<Protected> values = new ArrayList<Protected>();
        for (String value : this.protectedNames.get((Object)type)) {
            values.add(new Protected(type, value));
        }
        return values;
    }
}

