/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.calendar.CalendarInstance;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.IntegerConfig;
import com.beyondcron.core.job.Condition;
import com.beyondcron.core.job.Job;
import com.beyondcron.core.job.JobMode;
import com.beyondcron.core.job.Status;
import com.beyondcron.core.job.Trigger;
import com.beyondcron.core.schedule.Schedule;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.proto.ProtoJob;
import com.beyondcron.server.ACLManager;
import com.beyondcron.server.CalendarManager;
import com.beyondcron.server.DataManager;
import com.beyondcron.server.JobListenerManager;
import com.beyondcron.server.JobModeManager;
import com.beyondcron.server.JobStatusManager;
import com.beyondcron.server.LicenseManager;
import com.beyondcron.server.PropertyManager;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.Logger;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class JobManager
implements JobListener,
MigrationListener,
Persist.Listener {
    static final Logger logger = LogUtils.getLogger(JobManager.class);
    private static Map<String, JobManager> managers = new HashMap<String, JobManager>();
    private HazelcastInstance hazelcast;
    private DataManager data;
    private MultiMap<Integer, Name> partitionJobs;
    private ACLManager aclManager;
    private CalendarManager calendarManager;
    private JobListenerManager jobListenerManager;
    private JobStatusManager jobStatusManager;
    private JobModeManager jobModeManager;
    private LicenseManager licenseManager = null;
    private Scheduler scheduler;

    public static synchronized JobManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        JobManager manager = managers.get(name);
        if (manager == null) {
            manager = new JobManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private JobManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        Job.setHazelcast((HazelcastInstance)hazelcast);
        this.data = DataManager.getInstance(hazelcast);
        this.aclManager = ACLManager.getInstance(hazelcast);
        this.calendarManager = CalendarManager.getInstance(hazelcast);
        Hazelcast.getCalendarInstanceMap((HazelcastInstance)hazelcast).addEntryListener((EntryListener)new CalendarUpdateListener(logger), true);
        this.jobListenerManager = JobListenerManager.getInstance(hazelcast);
        this.jobStatusManager = JobStatusManager.getInstance(hazelcast, this);
        this.jobModeManager = JobModeManager.getInstance(hazelcast);
        this.partitionJobs = Hazelcast.getPartitionJobMap((HazelcastInstance)hazelcast);
        this.initScheduler();
        if (hazelcast.getCluster().getMembers().size() > 1) {
            this.scheduleJobs();
        }
        hazelcast.getPartitionService().addMigrationListener((MigrationListener)this);
    }

    private void initScheduler() {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        boolean defaultPool = Configs.isDefault((String)"org.quartz.threadPool.class");
        Properties properties = new Properties();
        for (Config config : Configs.getConfigs((String)"org.quartz.", (boolean)true)) {
            if (defaultPool && config.getName().equals("org.quartz.threadPool.threadCount")) {
                IntegerConfig c = (IntegerConfig)Configs.getConfig((String)"quartz.thread.jobs");
                int threadCount = this.data.getJobs().size() / (Integer)c.getValue();
                if (threadCount < c.getMinValue()) {
                    threadCount = c.getMinValue();
                }
                if (threadCount != (Integer)config.getValue()) {
                    config.setValue((Object)threadCount);
                }
            }
            properties.setProperty(config.getName(), config.getValue().toString());
        }
        try {
            factory.initialize(properties);
        }
        catch (SchedulerException e) {
            Localise.logFatal((Logger)logger, (Exception)((Object)e), (String)"Could not initialise factory", (Object[])new Object[0]);
            Program.exit((int)1);
        }
        try {
            this.scheduler = factory.getScheduler();
        }
        catch (SchedulerException e) {
            Localise.logWarn((Logger)logger, (String)"Using default scheduler configuration: %s", (Object[])new Object[]{e.getMessage()});
            try {
                factory = new StdSchedulerFactory();
                factory.initialize();
                this.scheduler = factory.getScheduler();
            }
            catch (SchedulerException e1) {
                Localise.logFatal((Logger)logger, (Exception)((Object)e1), (String)"Could not create scheduler", (Object[])new Object[0]);
                Program.exit((int)1);
            }
        }
        try {
            this.scheduler.getListenerManager().addJobListener((JobListener)this);
        }
        catch (SchedulerException e) {
            Localise.logFatal((Logger)logger, (Exception)((Object)e), (String)"Could not set job listener", (Object[])new Object[0]);
            Program.exit((int)1);
        }
    }

    public boolean startScheduler() {
        this.licenseManager = LicenseManager.getInstance(this.hazelcast);
        try {
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
            }
        }
        catch (SchedulerException e) {
            Localise.logError((Logger)logger, (String)"Could not start scheduler - %s", (Object[])new Object[]{e.getMessage()});
            return false;
        }
        Localise.logInfo((Logger)logger, (String)"Scheduler started", (Object[])new Object[0]);
        return true;
    }

    public boolean stopScheduler() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            Localise.logError((Logger)logger, (String)"Could not stop schedule - %s", (Object[])new Object[]{e.getMessage()});
            return false;
        }
        Localise.logInfo((Logger)logger, (String)"Scheduler stopped", (Object[])new Object[0]);
        return true;
    }

    public Job setJob(Job job) {
        return this.setJob(job, false);
    }

    public Job setJob(Job job, boolean dedupe) {
        Name name = job.getName();
        IExecutorService executor = this.hazelcast.getExecutorService("SetJob");
        try {
            return (Job)executor.submitToKeyOwner((Callable)new SetJob(job, dedupe), (Object)name).get();
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception setting job %s", (Object[])new Object[]{name});
            return null;
        }
    }

    public Job deleteJob(Name name) {
        IExecutorService executor = this.hazelcast.getExecutorService("DeleteJob");
        try {
            return (Job)executor.submitToKeyOwner((Callable)new DeleteJob(name), (Object)name).get();
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception deleting job %s", (Object[])new Object[]{name});
            return null;
        }
    }

    private Job delistJob(Name name) {
        Job job = this.data.getJob(name);
        if (job == null) {
            return null;
        }
        this.jobStatusManager.remove(name);
        if (job.hasSchedule()) {
            this.unscheduleJob(name, job.getKey());
        }
        this.jobListenerManager.remove(job);
        return job;
    }

    private void scheduleJobs() {
        IMap<Name, Job> jobs = this.data.getJobs();
        for (Name name : jobs.localKeySet()) {
            Job job = (Job)jobs.get((Object)name);
            if (!job.hasSchedule() || job.getMode() != Job.Mode.ENABLED) continue;
            try {
                this.scheduleJob(job);
            }
            catch (ScheduleException e) {
                Localise.logError((Logger)logger, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    private Status scheduleJob(Job job) throws ScheduleException {
        if (job.hasCalendar()) {
            CalendarInstance calendarInstance = this.calendarManager.getCalendarInstance(job);
            if (calendarInstance == null) {
                throw new ScheduleException(Localise.format((String)"Calendar %s does not exist", (Object[])new Object[]{job.getCalendar()}));
            }
            String calendarInstanceName = calendarInstance.getName();
            try {
                if (this.scheduler.getCalendar(calendarInstanceName) == null) {
                    this.scheduler.addCalendar(calendarInstanceName, (Calendar)calendarInstance, false, false);
                }
            }
            catch (SchedulerException e) {
                throw new ScheduleException(Localise.format((String)"Could not add calendar %s - %s", (Object[])new Object[]{calendarInstanceName, e.getMessage()}));
            }
        }
        Name name = job.getName();
        Status status = this.jobStatusManager.getStatus(job).setOutput(null);
        int i = 0;
        Date now = new Date();
        for (Schedule schedule : job.getSchedules()) {
            org.quartz.Trigger trigger = schedule.getTrigger();
            if (trigger.getFireTimeAfter(now) == null) continue;
            try {
                if (i++ < 1) {
                    this.scheduler.scheduleJob(job.getDetails(), trigger);
                } else {
                    this.scheduler.scheduleJob(trigger);
                }
                status.setState(Status.State.SCHEDULED);
            }
            catch (SchedulerException e) {
                try {
                    this.scheduler.deleteJob(job.getKey());
                }
                catch (SchedulerException e1) {
                    throw new ScheduleException(Localise.format((String)"Could not unschedule job %s - %s", (Object[])new Object[]{name, e.getMessage()}));
                }
                throw new ScheduleException(Localise.format((String)"Could not schedule job %s - %s", (Object[])new Object[]{name, e.getMessage()}));
            }
        }
        return status;
    }

    private boolean unscheduleJob(Name name, JobKey key) {
        try {
            if (!this.scheduler.checkExists(key)) {
                return true;
            }
            this.scheduler.deleteJob(key);
        }
        catch (SchedulerException e) {
            Localise.logError((Logger)logger, (Exception)((Object)e), (String)"Unexpected exception deleting job %s", (Object[])new Object[]{name});
            return false;
        }
        return true;
    }

    public boolean isJob(Name name) {
        return this.data.getJobs().containsKey((Object)name);
    }

    public Job getJob(Name name) {
        return (Job)this.data.getJobs().get((Object)name);
    }

    public Set<Job> getJobs(Name group) {
        TreeSet<Job> set = new TreeSet<Job>();
        for (Name name : this.data.getJobGroups().get((Object)group)) {
            set.add(this.data.getJob(name));
        }
        return set;
    }

    public Set<Job> getJobs(Filter filter) {
        TreeSet<Job> jobs = new TreeSet<Job>();
        if (filter != null) {
            for (Job job : this.data.getJobs().values()) {
                if (!filter.matches((Object)job.getName()) && !filter.matches(job.getDescription())) continue;
                jobs.add(job);
            }
        } else {
            jobs.addAll(this.data.getJobs().values());
        }
        return jobs;
    }

    public int getJobCount() {
        return this.data.getJobs().size();
    }

    public Collection<Name> getChildren(Name group) {
        return Collections.unmodifiableCollection(this.data.getJobGroups().get((Object)group));
    }

    public Job.Mode getJobMode(Name name) {
        Job job = this.data.getJob(name);
        return job != null ? job.getMode() : null;
    }

    public Job.Mode setJobMode(Name name, Job.Mode mode) {
        Job job = this.data.getJob(name);
        if (job == null) {
            return null;
        }
        Job.Mode previousMode = job.getMode();
        if (mode != previousMode) {
            this.setJob(job.setMode(mode));
        }
        return previousMode;
    }

    private Collection<Condition> getConditions(Job job) {
        ArrayList<Condition> expanded = new ArrayList<Condition>();
        Name name = job.getName();
        for (Condition condition : job.getConditions()) {
            if (condition.getJob().equals((Object)name)) continue;
            if (condition.getType() == Condition.Type.ANY || !condition.getJob().isWildcard()) {
                expanded.add(condition);
                continue;
            }
            Status.State state = condition.getState();
            Status.Result result = condition.getResult();
            Period maxAge = condition.getMaxAge();
            for (Name child : this.getChildren(condition.getJob().getGroup())) {
                if (child.equals((Object)name)) continue;
                expanded.add(new Condition(Condition.Type.ALL, child, state, result, maxAge));
            }
        }
        return expanded;
    }

    @Override
    public void messageLoaded(Name name, Message<?> message) {
        if (message instanceof Job) {
            this.setJob((Job)message, true);
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message type %s", (Object[])new Object[]{message.getClass().getName()});
        }
    }

    public Date getNextExecution(Name name) {
        IExecutorService executor = this.hazelcast.getExecutorService("NextExecution");
        try {
            return (Date)executor.submitToKeyOwner((Callable)new NextExecution(name), (Object)name).get();
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception getting next execution of job %s", (Object[])new Object[]{name});
            return null;
        }
    }

    public ExecuteResult executeJob(Name name, Trigger trigger, Status triggerStatus, Job.Action action, boolean force, boolean allowMissedQueue) {
        IExecutorService executor = this.hazelcast.getExecutorService("ExecuteJob");
        try {
            return (ExecuteResult)((Object)executor.submitToKeyOwner((Callable)new ExecuteJob(name, trigger, triggerStatus, action, force, allowMissedQueue), (Object)name).get());
        }
        catch (Exception e) {
            this.jobStatusManager.setStatus(new Status(name, e));
            Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception executing job %s", (Object[])new Object[]{name});
            return null;
        }
    }

    public String getName() {
        return this.hazelcast.getName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        Name name = new Name(context.getJobDetail().getKey());
        String action = context.getTrigger().getJobDataMap().getString("action");
        Localise.logDebug((Logger)logger, (String)"jobToBeExecuted %1$s - %2$s", (Object[])new Object[]{name, action});
        this.executeJob(name, new Trigger(), null, Job.Action.valueOf((String)action), false, true);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
    }

    public void migrationStarted(MigrationEvent event) {
        Localise.logDebug((Logger)logger, (String)"Partition migration started - %s", (Object[])new Object[]{event.getPartitionId()});
    }

    public void migrationCompleted(MigrationEvent event) {
        boolean schedule;
        Member localMember = this.hazelcast.getCluster().getLocalMember();
        if (localMember.equals(event.getOldOwner())) {
            schedule = false;
        } else if (localMember.equals(event.getNewOwner())) {
            schedule = true;
        } else {
            return;
        }
        for (Name name : this.partitionJobs.get((Object)event.getPartitionId())) {
            if (schedule) {
                Job job = this.data.getJob(name);
                if (job.hasSchedule() && job.getMode() == Job.Mode.ENABLED) {
                    try {
                        this.scheduleJob(job);
                    }
                    catch (ScheduleException e) {
                        Localise.logError((Logger)logger, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            } else {
                this.unscheduleJob(name, Job.getKey((Name)name));
            }
            Localise.logDebug((Logger)logger, (String)"Migrated %1$s %2$s server", (Object[])new Object[]{name, schedule ? "onto" : "off"});
        }
        Localise.logDebug((Logger)logger, (String)"Partition migration completed - %s", (Object[])new Object[]{event.getPartitionId()});
    }

    public void migrationFailed(MigrationEvent event) {
        Localise.logError((Logger)logger, (String)"Partition migration failed - %s", (Object[])new Object[]{event.getPartitionId()});
    }

    public static class ScheduleException
    extends Exception {
        public ScheduleException(String message) {
            super(message);
        }
    }

    private class CalendarUpdateListener
    extends Hazelcast.AbstractEntryListener<Name, CalendarInstance> {
        public CalendarUpdateListener(Logger logger) {
            super(logger);
        }

        public void entryRemoved(EntryEvent<Name, CalendarInstance> event) {
            String name = ((Name)event.getKey()).getName();
            Localise.logDebug((Logger)this.logger, (String)"Deleting calendar %s", (Object[])new Object[]{name});
            try {
                if (JobManager.this.scheduler.getCalendar(name) != null) {
                    JobManager.this.scheduler.deleteCalendar(name);
                }
            }
            catch (SchedulerException e) {
                Localise.logError((Logger)this.logger, (Exception)((Object)e), (String)"Could not delete calendar %s", (Object[])new Object[]{name});
            }
        }

        public void entryUpdated(EntryEvent<Name, CalendarInstance> event) {
            String name = ((Name)event.getKey()).getName();
            Localise.logDebug((Logger)this.logger, (String)"Updating calendar %s", (Object[])new Object[]{name});
            try {
                if (JobManager.this.scheduler.getCalendar(name) != null) {
                    JobManager.this.scheduler.addCalendar(name, (Calendar)event.getValue(), true, true);
                }
            }
            catch (SchedulerException e) {
                Localise.logError((Logger)this.logger, (Exception)((Object)e), (String)"Could not update calendar %s", (Object[])new Object[]{name});
            }
        }
    }

    private static class ExecuteJob
    implements Callable<ExecuteResult>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private Name name;
        private Trigger trigger;
        private Status triggerStatus;
        private Job.Action action;
        private boolean force;
        private boolean allowMissedQueue;

        private ExecuteJob() {
        }

        public ExecuteJob(Name name, Trigger trigger, Status triggerStatus, Job.Action action, boolean force, boolean allowMissedQueue) {
            this.name = name;
            this.trigger = trigger;
            this.triggerStatus = triggerStatus;
            this.action = action;
            this.force = force;
            this.allowMissedQueue = allowMissedQueue;
        }

        @Override
        public ExecuteResult call() {
            JobManager jobManager = JobManager.getInstance(this.hazelcast);
            JobStatusManager jobStatusManager = jobManager.jobStatusManager;
            JobModeManager jobModeManager = jobManager.jobModeManager;
            Trigger.Type triggerType = this.trigger.getType();
            Job job = jobManager.data.getJob(this.name);
            if (job == null) {
                Localise.logError((Logger)logger, (String)"Cannot execute non-existent job %s", (Object[])new Object[]{this.name});
                return ExecuteResult.MISSING_JOB;
            }
            JobMode mode = jobModeManager.getMode(job);
            Job.Mode jobMode = mode.getMode();
            if (mode.getGroup() != null && triggerType == Trigger.Type.SCHEDULE) {
                jobStatusManager.updateNextExecutionTime(this.name);
                if (jobMode == Job.Mode.BYPASS) {
                    return ExecuteResult.BYPASSED;
                }
                return ExecuteResult.DISABLED;
            }
            if (!(jobMode != Job.Mode.DISABLED || this.force && job.canEnable())) {
                return ExecuteResult.DISABLED;
            }
            Status status = jobStatusManager.getStatus(this.name);
            if (!job.isAction(this.action)) {
                status.set(Status.State.STOPPED, Status.Result.MISSED, -1, this.action.toString().toLowerCase() + " unsupported").setTrigger(this.trigger).updateTimestamp(true);
                jobStatusManager.persistStatus(status);
                return ExecuteResult.UNSUPPORTED_ACTION;
            }
            if (triggerType == Trigger.Type.JOB) {
                if (job.hasSchedule()) {
                    Localise.logWarn((Logger)logger, (String)"Jobs with schedules can only be triggered by their schedule/s, or a user. Job: %s", (Object[])new Object[]{this.name});
                    return ExecuteResult.WAITING;
                }
                if (job.hasCalendar() && !jobManager.calendarManager.getCalendarInstance(job).isTimeIncluded(System.currentTimeMillis())) {
                    return ExecuteResult.WAITING;
                }
            }
            if (this.action == Job.Action.START && !this.force) {
                Name triggerName;
                boolean triggered = triggerType != Trigger.Type.JOB;
                Name name = triggerName = this.triggerStatus != null ? this.triggerStatus.getName() : null;
                if (triggerName != null) {
                    if (this.name.equals((Object)triggerName)) {
                        return ExecuteResult.WAITING;
                    }
                    if (!jobManager.aclManager.canTrigger(triggerName, this.name)) {
                        Localise.logWarn((Logger)logger, (String)"Trigger %1$s cannot initiate %2$s", (Object[])new Object[]{triggerName, this.name});
                        return ExecuteResult.WAITING;
                    }
                }
                for (Condition condition : jobManager.getConditions(job)) {
                    Job j;
                    Name conditionName = condition.getJob();
                    Condition.Type conditionType = condition.getType();
                    if (conditionType == Condition.Type.ALL && !jobManager.aclManager.canTrigger(conditionName, this.name)) {
                        Localise.logWarn((Logger)logger, (String)"Condition %1$s cannot initiate %2$s", (Object[])new Object[]{conditionName, this.name});
                        return ExecuteResult.WAITING;
                    }
                    if (!conditionName.isWildcard()) {
                        j = jobManager.data.getJob(conditionName);
                        if (j == null) {
                            Localise.logWarn((Logger)logger, (String)"%1$s %2$s job %3$s does not exist", (Object[])new Object[]{this.name, conditionType == Condition.Type.ALL ? "condition" : "trigger", conditionName});
                            return ExecuteResult.MISSING_CONDITION;
                        }
                        Job.Mode jMode = j.getMode();
                        if (conditionType == Condition.Type.ALL) {
                            switch (jMode) {
                                case ENABLED: {
                                    Status jStatus = jobStatusManager.getStatus(j.getName());
                                    if (!condition.matches(jStatus, true)) {
                                        if (triggerType == Trigger.Type.SCHEDULE) {
                                            jobStatusManager.setStatus(new Status(this.name, Status.Result.MISSED));
                                        }
                                        return ExecuteResult.WAITING;
                                    }
                                    if (condition.getMaxAge() != null || status.getResult() == Status.Result.UNKNOWN || jStatus.getTimestamp() >= status.getTimestamp()) break;
                                    if (triggerType == Trigger.Type.SCHEDULE) {
                                        jobStatusManager.setStatus(new Status(this.name, Status.Result.MISSED));
                                    }
                                    return ExecuteResult.WAITING;
                                }
                                case BYPASS: {
                                    if (condition.getResult() == Status.Result.SUCCESS) break;
                                    if (triggerType == Trigger.Type.SCHEDULE) {
                                        jobStatusManager.setStatus(new Status(this.name, Status.Result.MISSED));
                                    }
                                    return ExecuteResult.WAITING;
                                }
                                case DISABLED: {
                                    if (!condition.matches(jobStatusManager.getStatus(j.getName()), true)) {
                                        if (triggerType == Trigger.Type.SCHEDULE) {
                                            jobStatusManager.setStatus(new Status(this.name, Status.Result.MISSED));
                                        }
                                        return ExecuteResult.WAITING;
                                    }
                                    return ExecuteResult.WAITING;
                                }
                            }
                        }
                        if (jMode == Job.Mode.DISABLED || !j.getName().equals((Object)triggerName) || !condition.matches(this.triggerStatus, jMode != Job.Mode.BYPASS)) continue;
                        triggered = true;
                        continue;
                    }
                    if (triggerName == null || !triggerName.matches(conditionName) || (j = jobManager.data.getJob(triggerName)) == null || !condition.matches(this.triggerStatus, j.getMode() != Job.Mode.BYPASS)) continue;
                    triggered = true;
                }
                if (!triggered) {
                    return ExecuteResult.WAITING;
                }
            }
            if (status.isActive()) {
                if (this.action == Job.Action.START) {
                    Localise.logDebug((Logger)logger, (String)"Job %1$s is already active (%2$s)", (Object[])new Object[]{this.name, status.getState().toString().toLowerCase()});
                    if (this.allowMissedQueue && job.canQueue()) {
                        return ExecuteResult.MISSED_QUEUE;
                    }
                    status.set(Status.State.STOPPED, Status.Result.MISSED, -1, "job already active").setTrigger(this.trigger).updateTimestamp(true);
                    jobStatusManager.persistStatus(status);
                    return ExecuteResult.MISSED;
                }
            } else if (this.action == Job.Action.STOP || this.action == Job.Action.KILL) {
                Localise.logInfo((Logger)logger, (String)"Job %1$s is already inactive (%2$s)", (Object[])new Object[]{this.name, status.getState().toString().toLowerCase()});
                status.set(Status.State.STOPPED, Status.Result.MISSED, -1, "job already inactive").setTrigger(this.trigger).updateTimestamp(true);
                jobStatusManager.persistStatus(status);
                return ExecuteResult.MISSED;
            }
            if (jobMode == Job.Mode.BYPASS && triggerType != Trigger.Type.USER && !this.force) {
                jobStatusManager.setStatus(new Status(this.name, Status.Result.SUCCESS).setMessage("bypassed"));
                return ExecuteResult.BYPASSED;
            }
            if (this.action == Job.Action.START && !job.getType().isInternal()) {
                try {
                    jobManager.licenseManager.execute(this.name);
                }
                catch (NullPointerException e) {
                    Localise.logInfo((Logger)logger, (String)"License manager not started", (Object[])new Object[0]);
                    jobStatusManager.setMissed(this.name, "License manager not started", this.trigger, false);
                    return ExecuteResult.UNEXPECTED_EXCEPTION;
                }
                catch (LicenseManager.LicenseException e) {
                    Localise.logInfo((Logger)logger, (String)e.getMessage(), (Object[])new Object[0]);
                    jobStatusManager.setMissed(this.name, String.format("%s license expired", e.getType().getLabel()), this.trigger, false);
                    return ExecuteResult.LICENSE_EXPIRED;
                }
                catch (LicenseManager.LimitException e) {
                    Localise.logInfo((Logger)logger, (String)e.getMessage(), (Object[])new Object[0]);
                    jobStatusManager.setMissed(this.name, String.format("%s %s limit exceeded", e.getType().getLabel(), e.getLimitType().getLabel()), this.trigger, true);
                    return ExecuteResult.LICENSE_LIMITS;
                }
            }
            Localise.logDebug((Logger)logger, (String)"Initiating execution of job %s)", (Object[])new Object[]{this.name});
            switch (this.action) {
                case START: {
                    jobStatusManager.setState(this.name, Status.State.STARTING, this.trigger);
                    break;
                }
                case STOP: {
                    jobStatusManager.setState(this.name, Status.State.STOPPING, this.trigger);
                    break;
                }
                case KILL: {
                    jobStatusManager.setState(this.name, Status.State.KILLING, this.trigger);
                    break;
                }
            }
            job.setDefaultProperties(PropertyManager.getInstance(this.hazelcast).getProperties(this.name, true));
            ThreadUtils.submit(() -> job.execute(this.action, jobStatusManager.getStatus(this.name).getStartTimestamp(), this.trigger, this.triggerStatus));
            return ExecuteResult.INITIATED;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.name.toProto().build().toByteArray());
            out.writeInt(this.action.toProto().getNumber());
            out.writeByteArray(this.trigger.toProto().build().toByteArray());
            if (this.trigger.getType() == Trigger.Type.JOB) {
                out.writeByteArray(this.triggerStatus.toProto().build().toByteArray());
            }
            out.writeBoolean(this.force);
            out.writeBoolean(this.allowMissedQueue);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = new Name().fromProto(in.readByteArray());
            this.action = Job.Action.fromProto((ProtoJob.Job.Action)ProtoJob.Job.Action.forNumber((int)in.readInt()));
            this.trigger = new Trigger().fromProto(in.readByteArray());
            if (this.trigger.getType() == Trigger.Type.JOB) {
                this.triggerStatus = new Status().fromProto(in.readByteArray());
            }
            this.force = in.readBoolean();
            this.allowMissedQueue = in.readBoolean();
        }
    }

    private static class NextExecution
    implements Callable<Date>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private Name name;

        private NextExecution() {
        }

        public NextExecution(Name name) {
            this.name = name;
        }

        @Override
        public Date call() throws Exception {
            Scheduler scheduler = JobManager.getInstance((HazelcastInstance)this.hazelcast).scheduler;
            Date nextExecution = null;
            for (org.quartz.Trigger trigger : scheduler.getTriggersOfJob(Job.getKey((Name)this.name))) {
                Date date = trigger.getNextFireTime();
                if (nextExecution != null && date.getTime() >= nextExecution.getTime()) continue;
                nextExecution = date;
            }
            return nextExecution;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.name.toProto().build().toByteArray());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = new Name().fromProto(in.readByteArray());
        }
    }

    private static class DeleteJob
    implements Callable<Job>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private Name name;

        private DeleteJob() {
        }

        public DeleteJob(Name name) {
            this.name = name;
        }

        @Override
        public Job call() {
            DistributedObject queuedJobsQueue;
            JobManager jobManager = JobManager.getInstance(this.hazelcast);
            Job job = jobManager.delistJob(this.name);
            if (job != null) {
                jobManager.data.removeJob(this.name);
                jobManager.partitionJobs.remove((Object)this.hazelcast.getPartitionService().getPartition((Object)this.name).getPartitionId(), (Object)this.name);
                if (job.hasCalendar()) {
                    jobManager.calendarManager.deleteCalendarJob(job);
                }
            }
            if ((queuedJobsQueue = Hazelcast.getObject((HazelcastInstance)this.hazelcast, (String)Hazelcast.getQueuedJobsQueueName((Name)this.name))) != null) {
                queuedJobsQueue.destroy();
            }
            return job;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.name.toProto().build().toByteArray());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.name = new Name().fromProto(in.readByteArray());
        }
    }

    private static class SetJob
    implements Callable<Job>,
    HazelcastInstanceAware,
    DataSerializable {
        private transient HazelcastInstance hazelcast;
        private Job job;
        private boolean dedupe;

        private SetJob() {
        }

        public SetJob(Job job, boolean dedupe) {
            this.job = job;
            this.dedupe = dedupe;
        }

        @Override
        public Job call() throws Exception {
            JobManager jobManager = JobManager.getInstance(this.hazelcast);
            JobStatusManager jobStatusManager = jobManager.jobStatusManager;
            Name name = this.job.getName();
            Job previousJob = jobManager.delistJob(name);
            jobManager.data.addJob(this.job);
            jobManager.partitionJobs.put((Object)this.hazelcast.getPartitionService().getPartition((Object)name).getPartitionId(), (Object)name);
            Status status = jobStatusManager.getStatus(this.job).setOutput(null);
            if (this.job.hasCalendar()) {
                jobManager.calendarManager.addCalendarJob(this.job);
            }
            if (previousJob != null && previousJob.hasCalendar() && !previousJob.getCalendar().equals((Object)this.job.getCalendar())) {
                jobManager.calendarManager.deleteCalendarJob(previousJob);
            }
            jobManager.jobListenerManager.add(this.job);
            if (this.job.getMode() == Job.Mode.ENABLED) {
                if (this.job.hasSchedule()) {
                    jobStatusManager.setStatus(jobManager.scheduleJob(this.job), this.dedupe);
                } else if (this.job.hasCondition()) {
                    jobStatusManager.setStatus(status.setState(Status.State.WAITING), this.dedupe);
                }
            }
            return previousJob;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByteArray(this.job.toProto().build().toByteArray());
            out.writeBoolean(this.dedupe);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.job = Job.parseFromProto((byte[])in.readByteArray());
            this.dedupe = in.readBoolean();
        }
    }

    public static enum ExecuteResult {
        UNSUPPORTED_ACTION,
        BYPASSED,
        DISABLED,
        MISSED,
        MISSED_QUEUE,
        MISSING_CONDITION,
        MISSING_JOB,
        WAITING,
        MIRRORED,
        INITIATED,
        LICENSE_EXPIRED,
        LICENSE_LIMITS,
        UNEXPECTED_EXCEPTION;

    }
}

