/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.BooleanUtils;
import com.beyondcron.core.ConfigService;
import com.beyondcron.core.Configs;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.License;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.Property;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.ThreadUtils;
import com.beyondcron.core.calendar.ICalendarData;
import com.beyondcron.core.config.ConfigProperty;
import com.beyondcron.core.job.CommandJob;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.Protected;
import com.beyondcron.core.user.User;
import com.beyondcron.core.user.UserService;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.MessageSerializer;
import com.beyondcron.messaging.NamedMessage;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.message.ACLList;
import com.beyondcron.messaging.message.Change;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.HostACLList;
import com.beyondcron.messaging.message.PersistCommand;
import com.beyondcron.messaging.message.PersistUpdate;
import com.beyondcron.messaging.message.PropertyList;
import com.beyondcron.messaging.message.ProtectedList;
import com.beyondcron.messaging.message.calendar.Calendar;
import com.beyondcron.server.ACLManager;
import com.beyondcron.server.CalendarManager;
import com.beyondcron.server.ConfigManager;
import com.beyondcron.server.HostACLManager;
import com.beyondcron.server.JobManager;
import com.beyondcron.server.JobModeManager;
import com.beyondcron.server.JobStatusManager;
import com.beyondcron.server.LicenseManager;
import com.beyondcron.server.PropertyManager;
import com.beyondcron.server.UserManager;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.logging.log4j.Logger;

public class PersistManager
implements EntryAddedListener<String, String>,
EntryUpdatedListener<String, String>,
EntryRemovedListener<String, String>,
MembershipListener {
    static final Logger logger = LogUtils.getLogger(PersistManager.class);
    public static final String PERSIST_ACTIVE_FILE = "active";
    public static final String GIT_ATTRIBUTES = ".gitattributes";
    public static final String GIT_IGNORE = ".gitignore";
    public static final long ACTIVE_WAIT_TIME = 10000L;
    private static Map<String, PersistManager> managers = new HashMap<String, PersistManager>();
    private HazelcastInstance hazelcast;
    private File activeFile;
    private File activeFileNew;
    private File activeFileOld;
    private Persist persist;
    private ConfigService configService = null;
    private UserService userService = null;
    private IMap<InetSocketAddress, String> memberName;
    private IMap<String, String> memberRepository;
    private ILock membersLock;
    private ITopic<PersistUpdate> updates;
    private UpdateListener updateListener;

    public static PersistManager getInstance(HazelcastInstance hazelcast) {
        try {
            return PersistManager.getInstance(hazelcast, false);
        }
        catch (LicenseManager.LicenseException e) {
            Localise.logFatal((Logger)logger, (Exception)e, (String)"Unexpected exception", (Object[])new Object[0]);
            Program.exit((int)1);
            return null;
        }
    }

    public static PersistManager getInstance(HazelcastInstance hazelcast, boolean forceLoad) throws LicenseManager.LicenseException {
        String name = hazelcast.getName();
        PersistManager manager = managers.get(name);
        return manager != null ? manager : new PersistManager(hazelcast, forceLoad);
    }

    private PersistManager(HazelcastInstance hazelcast, boolean forceLoad) throws LicenseManager.LicenseException {
        this.hazelcast = hazelcast;
        this.configService = Configs.getService();
        this.userService = UserManager.getInstance(hazelcast).getUserService();
        managers.put(hazelcast.getName(), this);
        this.init(forceLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean forceLoad) throws LicenseManager.LicenseException {
        File configDir = new File((String)Configs.get((String)"BEYONDCRON_DATA_DIR"));
        InetAddress address = this.hazelcast.getCluster().getLocalMember().getSocketAddress().getAddress();
        this.memberName = Hazelcast.getPersistMemberNameMap((HazelcastInstance)this.hazelcast);
        this.memberRepository = Hazelcast.getPersistMemberRepositoryMap((HazelcastInstance)this.hazelcast);
        this.membersLock = Hazelcast.getPersistMembersLock((HazelcastInstance)this.hazelcast);
        this.updates = Hazelcast.getPersistUpdatesTopic((HazelcastInstance)this.hazelcast);
        this.activeFile = new File(configDir, PERSIST_ACTIVE_FILE);
        this.activeFileNew = new File(this.activeFile.getPath() + ".new");
        this.activeFileOld = new File(this.activeFile.getPath() + ".old");
        this.membersLock.lock();
        try {
            Set<String> m;
            if (logger.isDebugEnabled()) {
                Localise.logDebug((Logger)logger, (String)"       memberName: %s", (Object[])new Object[]{this.getLocalMemberName()});
                if (this.configService != null) {
                    Localise.logDebug((Logger)logger, (String)" activeFileExists: %s", (Object[])new Object[]{BooleanUtils.toYesNo((boolean)this.activeFile.exists())});
                }
                Localise.logDebug((Logger)logger, (String)"    activeMembers: %s", (Object[])new Object[]{StringUtils.join((String)" ", this.getActiveMembers())});
                Localise.logDebug((Logger)logger, (String)"activeMembersSize: %s", (Object[])new Object[]{this.getActiveMembers().size()});
                Localise.logDebug((Logger)logger, (String)"        forceLoad: %s", (Object[])new Object[]{BooleanUtils.toYesNo((boolean)forceLoad)});
                Localise.logDebug((Logger)logger, (String)"lastPersistMember: %s", (Object[])new Object[]{BooleanUtils.toYesNo((boolean)this.isLastPersistMember())});
                m = this.getLastActiveMembers();
                m.remove(this.getLocalMemberName());
                Localise.logDebug((Logger)logger, (String)"lastActiveMembers: %s", (Object[])new Object[]{StringUtils.join((String)" ", m)});
                Localise.logDebug((Logger)logger, (String)"    persistActive: %s", (Object[])new Object[]{BooleanUtils.toYesNo((boolean)this.isPersistActive())});
            }
            if (this.isPersistActive()) {
                Localise.logDebug((Logger)logger, (String)"Syncing from: %s", (Object[])new Object[]{this.getMasterRepositoryName()});
                this.loadPersist(configDir, address, this.getMasterRepositoryName());
            } else if (this.isLastPersistMember() || !this.activeFile.exists() && !Configs.hasService() && ((String)Configs.get((String)"BEYONDCRON_SERVER_NAMES")).length() < 1 || forceLoad) {
                Localise.logDebug((Logger)logger, (String)"Loading persist", (Object[])new Object[0]);
                this.loadPersist(configDir, address, null);
            } else {
                if (this.getLastActiveMembers().size() < 1) {
                    if (this.configService == null) {
                        Localise.logFatal((Logger)logger, (String)"Active members file %s is empty, start with force argument", (Object[])new Object[]{this.activeFile});
                        throw new IllegalStateException(Localise.format((String)"Active members file %s is empty", (Object[])new Object[]{this.activeFile}));
                    }
                    Localise.logFatal((Logger)logger, (String)"Active members list %1$s:%2$s is empty, start with force argument", (Object[])new Object[]{this.configService.getServiceName(), "BEYONDCRON_SERVER_NAMES_ACTIVE"});
                    throw new IllegalStateException(Localise.format((String)"Active members list %1$s:%2$s is empty", (Object[])new Object[]{this.configService.getServiceName(), "BEYONDCRON_SERVER_NAMES_ACTIVE"}));
                }
                Localise.logDebug((Logger)logger, (String)"Waiting for last active member to start", (Object[])new Object[0]);
                this.membersLock.unlock();
                m = this.getLastActiveMembers();
                m.remove(this.getLocalMemberName());
                Localise.logWarn((Logger)logger, (String)"Waiting for %s to start", (Object[])new Object[]{StringUtils.join((String)", ", (String)" or ", m)});
                while (this.memberRepository.isEmpty()) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        Localise.logError((Logger)logger, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
                    }
                }
                this.loadPersist(configDir, address, this.getMasterRepositoryName());
            }
        }
        finally {
            if (this.membersLock.isLockedByCurrentThread()) {
                this.membersLock.unlock();
            }
        }
        this.hazelcast.getCluster().addMembershipListener((MembershipListener)this);
        this.memberRepository.addEntryListener((MapListener)this, false);
    }

    private void initGitIgnore(File configDir) {
        File gitIgnore = new File(configDir, GIT_IGNORE);
        if (!gitIgnore.exists()) {
            try {
                PrintWriter out = new PrintWriter(gitIgnore);
                out.println(this.activeFile.getName());
                out.println(this.activeFileNew.getName());
                out.println(this.activeFileOld.getName());
                out.close();
            }
            catch (IOException e) {
                Localise.logError((Logger)logger, (String)"Problem creating %1$s - %2$s", (Object[])new Object[]{gitIgnore, e.getMessage()});
            }
        }
    }

    private void initGitAttributes(File configDir) {
        File gitAttributes = new File(configDir, GIT_ATTRIBUTES);
        boolean createUpdate = true;
        ArrayList<String> lines = new ArrayList<String>();
        for (String tag : new TreeSet(MessageSerializer.getMessageTags())) {
            lines.add(String.format("*.%s -diff -merge -text", tag));
        }
        if (gitAttributes.exists()) {
            try {
                String s = IOUtils.read((InputStream)new FileInputStream(gitAttributes));
                s = s.replaceAll("[\n]", "");
                createUpdate = !s.equals(StringUtils.join(null, lines));
            }
            catch (IOException e) {
                Localise.logError((Logger)logger, (String)"Problem reading %1$s - %2$s", (Object[])new Object[]{gitAttributes, e.getMessage()});
            }
        }
        if (createUpdate) {
            try {
                PrintWriter out = new PrintWriter(gitAttributes);
                for (String line : lines) {
                    out.println(line);
                }
                out.close();
            }
            catch (IOException e) {
                Localise.logError((Logger)logger, (String)"Problem creating %1$s - %2$s", (Object[])new Object[]{gitAttributes, e.getMessage()});
            }
        }
    }

    public Date getCreationDate() {
        return this.persist.getCreationDate();
    }

    public String getLastCommitId() {
        return this.getLastCommitId((Integer)Configs.get((String)"beyondcron.git.abbrev.length"));
    }

    public String getLastCommitId(int length) {
        return this.persist.getLastCommitId(length);
    }

    public boolean isCommitId(String commitId) {
        return this.persist.isCommitId(commitId);
    }

    public Member getLocalMember() {
        return this.hazelcast.getCluster().getLocalMember();
    }

    public String getLocalMemberName() {
        return this.getMemberName(this.getLocalMember());
    }

    public String getMemberName(Member member) {
        return new com.beyondcron.core.InetSocketAddress(member.getSocketAddress()).toString();
    }

    public Set<String> getActiveMembers() {
        return new TreeSet<String>(this.memberRepository.keySet());
    }

    private String getMasterRepositoryName() {
        return this.memberRepository.values().toArray(new String[0])[0];
    }

    public boolean isPersistActive() {
        return this.getActiveMembers().size() > 0;
    }

    public boolean isLastPersistMember() {
        Set<String> members = this.getLastActiveMembers();
        if (members.size() == 1) {
            try {
                InetSocketAddress thisMember = this.getLocalMember().getAddress().getInetSocketAddress();
                com.beyondcron.core.InetSocketAddress lastMember = NetUtils.parseInetSocketAddress((String)members.iterator().next());
                return thisMember.equals(lastMember);
            }
            catch (Exception e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"Unexpected exception - %s", (Object[])new Object[]{e.getMessage()});
                return false;
            }
        }
        return false;
    }

    public int getPendingUpdates() {
        return this.updateListener.getPendingUpdates();
    }

    public boolean exists(Name name, com.beyondcron.messaging.Message message) {
        return this.persist.exists(name, message);
    }

    public void commit(PersistCommand command, Connection connection) {
        this.updates.publish((Object)new PersistUpdate(command.getChangeGroup(), this.hazelcast.getCluster().getClusterTime(), connection, PersistUpdate.Type.COMMIT, Name.ROOT, (com.beyondcron.messaging.Message)command));
    }

    public void save(NamedMessage message, Connection connection, int changeGroup) {
        this.save(message instanceof PersistMessage ? ((PersistMessage)message).getPersistName() : message.getName(), (com.beyondcron.messaging.Message)message, connection, changeGroup);
    }

    public void save(PersistMessage message, Connection connection, int changeGroup) {
        this.save(message.getPersistName(), (com.beyondcron.messaging.Message)message, connection, changeGroup);
    }

    public void save(Name name, com.beyondcron.messaging.Message message, Connection connection, int changeGroup) {
        if (this.userService != null) {
            if (message instanceof User) {
                throw new IllegalStateException(Localise.format((String)"Users cannot be saved a remote user service"));
            }
            if (message instanceof Role) {
                throw new IllegalStateException(Localise.format((String)"Roles cannot be saved a remote user service"));
            }
        }
        this.updates.publish((Object)new PersistUpdate(changeGroup, this.hazelcast.getCluster().getClusterTime(), connection, PersistUpdate.Type.SAVE, name, message));
    }

    public void remove(NamedMessage message, Connection connection, int changeGroup) {
        this.remove(message instanceof PersistMessage ? ((PersistMessage)message).getPersistName() : message.getName(), (com.beyondcron.messaging.Message)message, connection, changeGroup);
    }

    public void remove(PersistMessage message, Connection connection, int changeGroup) {
        this.remove(message.getPersistName(), (com.beyondcron.messaging.Message)message, connection, changeGroup);
    }

    public void remove(Name name, com.beyondcron.messaging.Message message, Connection connection, int changeGroup) {
        if (this.userService != null) {
            if (message instanceof User) {
                throw new IllegalStateException(Localise.format((String)"Users cannot be removed from a remote user service"));
            }
            if (message instanceof Role) {
                throw new IllegalStateException(Localise.format((String)"Roles cannot be removed from a remote user service"));
            }
        }
        this.updates.publish((Object)new PersistUpdate(changeGroup, this.hazelcast.getCluster().getClusterTime(), connection, PersistUpdate.Type.REMOVE, name, message));
    }

    public List<Change> getHistory(Name name, String messageTag) throws Persist.PersistException {
        try {
            return this.persist.getHistory(name, messageTag);
        }
        catch (Persist.PersistException e) {
            Localise.logError((Logger)logger, (Exception)e, (String)e.getMessage(), (Object[])new Object[0]);
            throw e;
        }
    }

    public List<Change> getCommit(String commitId) throws Persist.PersistException {
        return this.persist.getCommit(commitId);
    }

    public List<Change> getCommits(long startTimeStamp, long endTimeStart) throws Persist.PersistException {
        return this.persist.getCommits(startTimeStamp, endTimeStart);
    }

    public <T extends com.beyondcron.messaging.Message> T getMessage(Name name, String messageTag, String commitId) throws Persist.PersistException {
        try {
            List messages = this.persist.get(name, messageTag, commitId, false);
            return (T)(messages.isEmpty() ? null : (com.beyondcron.messaging.Message)messages.get(0));
        }
        catch (Persist.PersistUnknownCommitException e) {
            throw e;
        }
        catch (Persist.PersistException e) {
            Localise.logError((Logger)logger, (Exception)e, (String)e.getMessage(), (Object[])new Object[0]);
            throw e;
        }
    }

    public <T extends com.beyondcron.messaging.Message> List<T> getMessages(Name name, String messageTag, String commitId) throws Persist.PersistException {
        try {
            return this.persist.get(name, messageTag, commitId, true);
        }
        catch (Persist.PersistException e) {
            Localise.logError((Logger)logger, (Exception)e, (String)e.getMessage(), (Object[])new Object[0]);
            throw e;
        }
    }

    private void setActive(boolean active) {
        boolean updated;
        Member member = this.getLocalMember();
        InetSocketAddress address = member.getSocketAddress();
        String name = this.getMemberName(member);
        if (active) {
            String repositoryName = this.persist.getRepositoryName();
            boolean bl = updated = !repositoryName.equals(this.memberRepository.put((Object)name, (Object)repositoryName));
            if (updated) {
                this.memberName.put((Object)address, (Object)name);
            }
        } else {
            boolean bl = updated = this.memberRepository.remove((Object)name) != null;
            if (updated) {
                this.memberName.remove((Object)address);
            }
        }
        if (updated) {
            this.saveActiveMembers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPersist(File root, InetAddress address, String master) throws LicenseManager.LicenseException {
        try {
            this.persist = new Persist(root, address, master);
            this.initGitAttributes(root);
            this.initGitIgnore(root);
        }
        catch (Persist.PersistException e) {
            Localise.logFatal((Logger)logger, (Exception)e, (String)"Could not initialise data persistence", (Object[])new Object[0]);
            throw new IllegalStateException(Localise.format((String)"Could not initialise data persistence"));
        }
        boolean persistACLs = false;
        boolean migrateACLs = false;
        boolean migrateProperties = false;
        if (master == null) {
            try {
                Localise.logDebug((Logger)logger, (String)"Loading ACLs", (Object[])new Object[0]);
                File dir = new File(this.persist.getRoot(), "acls");
                ACLManager aclManager = ACLManager.getInstance(this.hazelcast);
                if (dir.exists()) {
                    persistACLs = this.persist.load(aclManager, MessageSerializer.getMessageTag(ACLList.class)) == 0;
                } else if (this.persist.load(aclManager, MessageSerializer.getMessageTag(ACL.class)) != 0) {
                    migrateACLs = true;
                } else {
                    persistACLs = true;
                }
                if (aclManager.initDefaults()) {
                    persistACLs = true;
                }
                Localise.logDebug((Logger)logger, (String)"Loading configuration properties", (Object[])new Object[0]);
                this.persist.load(new ConfigManager(), MessageSerializer.getMessageTag(ConfigProperty.class));
                LicenseManager licenseManager = LicenseManager.getInstance(this.hazelcast);
                License license = licenseManager.getServerLicense();
                if (license.isDefaultLicense()) {
                    license.setEvalEpoch(this.getCreationDate());
                    licenseManager.loadServerLicense(license);
                }
                if (this.userService == null) {
                    Localise.logDebug((Logger)logger, (String)"Loading roles", (Object[])new Object[0]);
                    this.persist.load(UserManager.getInstance(this.hazelcast), MessageSerializer.getMessageTag(Role.class));
                    Localise.logDebug((Logger)logger, (String)"Loading users", (Object[])new Object[0]);
                    UserManager userManager = UserManager.getInstance(this.hazelcast);
                    this.persist.load(userManager, MessageSerializer.getMessageTag(User.class));
                    userManager.refreshGuestUser();
                }
                Localise.logDebug((Logger)logger, (String)"Loading properties", (Object[])new Object[0]);
                dir = new File(this.persist.getRoot(), "properties");
                if (dir.exists()) {
                    this.persist.load(PropertyManager.getInstance(this.hazelcast), MessageSerializer.getMessageTag(PropertyList.class));
                } else {
                    this.persist.load(PropertyManager.getInstance(this.hazelcast), MessageSerializer.getMessageTag(Property.class));
                    migrateProperties = true;
                }
                CalendarManager calendarManager = CalendarManager.getInstance(this.hazelcast);
                Localise.logDebug((Logger)logger, (String)"Loading icalendars", (Object[])new Object[0]);
                this.persist.load(calendarManager, MessageSerializer.getMessageTag(ICalendarData.class));
                Localise.logDebug((Logger)logger, (String)"Loading calendars", (Object[])new Object[0]);
                this.persist.load(calendarManager, MessageSerializer.getMessageTag(Calendar.class));
                Localise.logDebug((Logger)logger, (String)"Loading jobs", (Object[])new Object[0]);
                JobModeManager jobModeManager = JobModeManager.getInstance(this.hazelcast).setActive(false);
                JobStatusManager jobStatusManager = JobStatusManager.getInstance(this.hazelcast).setActive(false);
                try {
                    jobStatusManager.reloadService();
                }
                catch (ServiceException e) {
                    Localise.logError((Logger)logger, (String)"Could not load status service", (Object[])new Object[0]);
                }
                try {
                    this.persist.load(JobManager.getInstance(this.hazelcast), MessageSerializer.getMessageTag(CommandJob.class));
                }
                finally {
                    jobModeManager.setActive(true);
                    jobStatusManager.setActive(true);
                }
                calendarManager.updateICalendars(true);
            }
            catch (Persist.PersistException e) {
                Localise.logFatal((Logger)logger, (Exception)e, (String)"Could not load persisted data", (Object[])new Object[0]);
                throw new IllegalStateException(Localise.format((String)"Could not load persisted data"));
            }
        }
        this.updateListener = new UpdateListener();
        this.updates.addMessageListener((MessageListener)this.updateListener);
        if (persistACLs || migrateACLs) {
            this.persistACLs(migrateACLs);
        }
        if (migrateProperties) {
            this.migrateProperties();
        }
        this.setActive(true);
    }

    private void persistACLs(boolean migration) {
        ACLManager aclManager = ACLManager.getInstance(this.hazelcast);
        Collection names = aclManager.getACLNames();
        if (names.isEmpty()) {
            return;
        }
        int changeGroup = Change.createGroup();
        for (Name name : names) {
            this.save((PersistMessage)new ACLList(name, aclManager.getACLs(name, false)), null, changeGroup);
        }
        HostACLManager hostACLManager = HostACLManager.getInstance(this.hazelcast);
        this.save((PersistMessage)new HostACLList(hostACLManager.getACLs()), null, changeGroup);
        Protected.Type type = Protected.Type.HOST;
        this.save((PersistMessage)new ProtectedList(type, hostACLManager.getProtected(type)), null, changeGroup);
        type = Protected.Type.USER;
        this.save((PersistMessage)new ProtectedList(type, hostACLManager.getProtected(type)), null, changeGroup);
        String message = migration ? Localise.format((String)"Migrated ACLs to the new persist structure") : Localise.format((String)"Default ACLs");
        PersistCommand command = new PersistCommand(changeGroup, message);
        command.setClientId("");
        this.commit(command, null);
        if (migration) {
            logger.warn(message);
        }
    }

    private void migrateProperties() {
        PropertyManager propertyManager = PropertyManager.getInstance(this.hazelcast);
        Collection names = propertyManager.getPropertyNames();
        if (names.isEmpty()) {
            return;
        }
        int changeGroup = Change.createGroup();
        for (Name name : names) {
            this.save((PersistMessage)new PropertyList(name, propertyManager.getProperties(name)), null, changeGroup);
        }
        String message = Localise.format((String)"Migrated properties to the new persist structure");
        PersistCommand command = new PersistCommand(changeGroup, message);
        command.setClientId("");
        this.commit(command, null);
        logger.warn(message);
    }

    private Set<String> getLastActiveMembers() {
        TreeSet<String> members = new TreeSet<String>();
        if (this.configService != null) {
            try {
                Collections.addAll(members, StringUtils.split((String)this.configService.getProperty("BEYONDCRON_SERVER_NAMES_ACTIVE")));
            }
            catch (ServiceException e) {
                Localise.logError((Logger)logger, (String)"Problem reading %1$s from configuration serivce %2$s - %3$s", (Object[])new Object[]{"BEYONDCRON_SERVER_NAMES_ACTIVE", this.configService.getServiceName(), e.getMessage()});
            }
        } else if (this.activeFile.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(this.activeFile));
                Collections.addAll(members, StringUtils.split((String)in.readLine()));
                in.close();
            }
            catch (IOException e) {
                Localise.logError((Logger)logger, (String)"Problem reading %1$s - %2$s", (Object[])new Object[]{this.activeFile, e.getMessage()});
            }
        }
        return members;
    }

    private void saveActiveMembers() {
        if (this.configService != null) {
            this.saveActiveMembersConfigService();
        } else {
            this.saveActiveMembersFile();
        }
    }

    private void saveActiveMembersConfigService() {
        try {
            this.configService.setProperty("BEYONDCRON_SERVER_NAMES_ACTIVE", StringUtils.join((String)" ", this.getActiveMembers()));
        }
        catch (ServiceException e) {
            Localise.logError((Logger)logger, (String)"Problem saving active members to %1$s:%2$s - %3$s", (Object[])new Object[]{this.configService.getServiceName(), "BEYONDCRON_SERVER_NAMES_ACTIVE", e.getMessage()});
        }
    }

    private void saveActiveMembersFile() {
        try {
            PrintWriter out = new PrintWriter(this.activeFileNew);
            out.println(StringUtils.join((String)" ", this.getActiveMembers()));
            out.close();
        }
        catch (IOException e) {
            Localise.logError((Logger)logger, (String)"Problem creating %1$s - %2$s", (Object[])new Object[]{this.activeFileNew, e.getMessage()});
            return;
        }
        if (this.activeFile.exists()) {
            if (this.activeFileOld.exists() && !this.activeFileOld.delete()) {
                Localise.logError((Logger)logger, (String)"Could not delete %1$s", (Object[])new Object[]{this.activeFileOld});
            }
            if (!this.activeFile.renameTo(this.activeFileOld)) {
                Localise.logError((Logger)logger, (String)"Could not rename %1$s to %2$s", (Object[])new Object[]{this.activeFile, this.activeFileOld});
            }
        }
        if (!this.activeFileNew.renameTo(this.activeFile)) {
            Localise.logError((Logger)logger, (String)"Could not rename %1$s to %2$s", (Object[])new Object[]{this.activeFileNew, this.activeFile});
        }
    }

    public void entryAdded(EntryEvent<String, String> event) {
        if (this.configService == null && !event.getMember().localMember()) {
            this.saveActiveMembersFile();
        }
    }

    public void entryUpdated(EntryEvent<String, String> event) {
        if (this.configService == null && !event.getMember().localMember()) {
            this.saveActiveMembersFile();
        }
    }

    public void entryRemoved(EntryEvent<String, String> event) {
        if (this.configService == null && !event.getMember().localMember()) {
            this.saveActiveMembersFile();
        }
    }

    public void memberAdded(MembershipEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberRemoved(MembershipEvent event) {
        this.membersLock.lock();
        try {
            InetSocketAddress address = event.getMember().getSocketAddress();
            String name = (String)this.memberName.remove((Object)address);
            if (name != null && this.memberRepository.remove((Object)name) != null) {
                this.saveActiveMembers();
            }
        }
        finally {
            this.membersLock.unlock();
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent event) {
    }

    private class UpdateListener
    implements MessageListener<PersistUpdate>,
    Runnable {
        private BlockingQueue<PersistUpdate> updates = new LinkedBlockingDeque<PersistUpdate>();

        public UpdateListener() {
            ThreadUtils.getThread((Runnable)this).start();
        }

        public int getPendingUpdates() {
            return this.updates.size();
        }

        public void onMessage(Message<PersistUpdate> msg) {
            if (logger.isDebugEnabled()) {
                PersistUpdate update = (PersistUpdate)msg.getMessageObject();
                Localise.logDebug((Logger)logger, (String)"Persist queued - %1$s - %2$s", (Object[])new Object[]{update.getType(), update.getName()});
            }
            try {
                this.updates.put((PersistUpdate)msg.getMessageObject());
            }
            catch (InterruptedException e) {
                Localise.logError((Logger)logger, (Exception)e, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
            }
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    while (true) {
                        PersistUpdate update = this.updates.take();
                        if (logger.isDebugEnabled()) {
                            Localise.logDebug((Logger)logger, (String)"Executing update 1 of %1$d - %2$s %3$s", (Object[])new Object[]{this.updates.size() + 1, update.getType(), update.getName()});
                        }
                        try {
                            PersistManager.this.persist.update(update);
                            continue block4;
                        }
                        catch (Persist.PersistException e) {
                            Localise.logError((Logger)logger, (String)"Could not persist %1$s - %2$s", (Object[])new Object[]{update.getName(), e.getMessage()});
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Localise.logError((Logger)logger, (Exception)e, (String)"Unexpectedly interrupted - %s", (Object[])new Object[]{e.getMessage()});
                    continue;
                }
                break;
            }
        }
    }
}

