/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.server;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.user.LocalUser;
import com.beyondcron.core.user.User;
import com.beyondcron.core.user.UserService;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.Persist;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.message.ACLList;
import com.beyondcron.server.ACLManager;
import com.beyondcron.server.ConnectionManager;
import com.beyondcron.server.PersistManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.logging.log4j.Logger;

public class UserManager
implements Persist.Listener {
    static final Logger logger = LogUtils.getLogger(UserManager.class);
    private static Map<String, UserManager> managers = new HashMap<String, UserManager>();
    private HazelcastInstance hazelcast;
    private IMap<String, User> users;
    private IMap<String, Role> roles;
    private ACLManager aclManager;
    private UserService userService = null;
    private boolean adminRoleRequiresLicense = (Boolean)Configs.get((String)"beyondcron.admin.role.license.required");

    public static synchronized UserManager getInstance(HazelcastInstance hazelcast) {
        String name = hazelcast.getName();
        UserManager manager = managers.get(name);
        if (manager == null) {
            manager = new UserManager(hazelcast);
            managers.put(name, manager);
        }
        return manager;
    }

    private UserManager(HazelcastInstance hazelcast) {
        this.hazelcast = hazelcast;
        this.users = Hazelcast.getUserMap((HazelcastInstance)hazelcast);
        this.roles = Hazelcast.getRoleMap((HazelcastInstance)hazelcast);
        this.init();
    }

    private void init() {
        this.aclManager = ACLManager.getInstance(this.hazelcast);
        String name = (String)Configs.get((String)"beyondcron.admin.user.name");
        LocalUser localUser = new LocalUser(name, (String)Configs.get((String)"beyondcron.admin.user.description"), this.createPassword(name, (String)Configs.get((String)"beyondcron.admin.user.salt")));
        localUser.addRole(Role.ADMIN);
        localUser.setHome(null);
        localUser.setReadOnly(true);
        this.initRoleUser(Role.ADMIN, new User((User)localUser));
        Role role = new Role((String)Configs.get((String)"beyondcron.agent.role.name"), (String)Configs.get((String)"beyondcron.agent.role.description"));
        role.setReadOnly(true);
        name = (String)Configs.get((String)"BEYONDCRON_AGENT_USER_NAME");
        User user = new User(name, (String)Configs.get((String)"BEYONDCRON_AGENT_USER_DESCRIPTION"), StringUtils.hashString((String)((String)Configs.get((String)"BEYONDCRON_AGENT_USER_PASSWORD"))));
        user.addRole(role);
        user.setHome(null);
        user.setReadOnly(true);
        this.initRoleUser(role, user);
        role = Role.EVERYONE;
        if (!this.roles.containsKey((Object)role.getName())) {
            this.roles.set((Object)role.getName(), (Object)role);
        }
        role = new Role((String)Configs.get((String)"beyondcron.server.role.name"), (String)Configs.get((String)"beyondcron.server.role.description"));
        role.setReadOnly(true);
        name = (String)Configs.get((String)"BEYONDCRON_SERVER_USER_NAME");
        localUser = new LocalUser(name, (String)Configs.get((String)"BEYONDCRON_SERVER_USER_DESCRIPTION"), this.createPassword(name));
        localUser.addRole(role);
        localUser.setHome(null);
        localUser.setReadOnly(true);
        this.initRoleUser(role, new User((User)localUser));
        role = new Role((String)Configs.get((String)"beyondcron.web.role.name"), (String)Configs.get((String)"beyondcron.web.role.description"));
        role.setReadOnly(true);
        name = (String)Configs.get((String)"BEYONDCRON_WEB_USER_NAME");
        user = new User(name, (String)Configs.get((String)"BEYONDCRON_WEB_USER_DESCRIPTION"), StringUtils.hashString((String)((String)Configs.get((String)"BEYONDCRON_WEB_USER_PASSWORD"))));
        user.addRole(role);
        user.setHome(null);
        user.setReadOnly(true);
        this.initRoleUser(role, user);
        this.refreshGuestUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRoleUser(Role role, User user) {
        String roleName = role.getName();
        String userName = user.getName();
        this.roles.lock((Object)roleName);
        this.users.lock((Object)userName);
        try {
            if (!this.roles.containsKey((Object)roleName)) {
                this.roles.set((Object)roleName, (Object)role);
            }
            if (!this.users.containsKey((Object)userName)) {
                this.users.put((Object)userName, (Object)user);
            }
        }
        finally {
            this.roles.unlock((Object)roleName);
            this.users.unlock((Object)userName);
        }
    }

    public void refreshGuestUser() {
        String guestUserName = (String)Configs.get((String)"beyondcron.guest.user.name");
        boolean guestAccess = (Boolean)Configs.get((String)"beyondcron.guest.user.access");
        if (guestAccess && !this.users.containsKey((Object)guestUserName)) {
            String password = (String)Configs.get((String)"beyondcron.guest.user.password");
            if (StringUtils.isNullOrEmpty((String)password)) {
                Localise.logError((Logger)logger, (String)"Guest user %1$s password is empty or undefined", (Object[])new Object[]{guestUserName});
                return;
            }
            User user = new User(guestUserName, (String)Configs.get((String)"beyondcron.guest.user.description"), password);
            user.setReadOnly(true);
            this.setUser(user);
        } else if (!guestAccess) {
            this.users.remove((Object)guestUserName);
        }
    }

    public boolean hasUserService() {
        return this.userService != null;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public String getUserServiceName() {
        return this.userService != null ? this.userService.getServiceName() : null;
    }

    public void refreshService() throws ServiceException {
        IExecutorService executor = this.hazelcast.getExecutorService("RefreshUserService");
        try {
            executor.executeOnAllMembers((Runnable)new ServiceRefresh());
        }
        catch (Exception e) {
            String message = Localise.format((String)"Unexpected exception refreshing user service");
            Localise.logError((Logger)logger, (Exception)e, (String)message, (Object[])new Object[0]);
            throw new ServiceException(message);
        }
    }

    public void reloadService() throws ServiceException {
        Cloneable failures;
        IExecutorService executor = this.hazelcast.getExecutorService("ReloadUserService");
        if (this.userService != null) {
            try {
                failures = new TreeSet();
                Map results = executor.submitToAllMembers((Callable)new ServiceStop());
                for (Member member : results.keySet()) {
                    if (((Boolean)((Future)results.get(member)).get()).booleanValue()) continue;
                    failures.add(member.getAddress().getHost());
                }
                if (!failures.isEmpty()) {
                    throw new ServiceException(Localise.format((String)"Could not stop service on %1$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", (Collection)((Object)failures))}));
                }
            }
            catch (Exception e) {
                String message = Localise.format((String)"Unexpected exception stopping service - %1$s", (Object[])new Object[]{e.getMessage()});
                Localise.logError((Logger)logger, (Exception)e, (String)message, (Object[])new Object[0]);
                throw new ServiceException(message);
            }
        }
        try {
            failures = new TreeMap();
            HashSet<String> failureMessages = new HashSet<String>();
            Map results = executor.submitToAllMembers((Callable)new ServiceStart());
            for (Member member : results.keySet()) {
                String message = (String)((Future)results.get(member)).get();
                if (StringUtils.isNullOrEmpty((String)message)) continue;
                failures.put(member.getAddress().getHost(), message);
                failureMessages.add(message);
            }
            if (!failures.isEmpty()) {
                String message = failureMessages.size() == 1 ? Localise.format((String)"Could not start service on %1$s - %2$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", failures.keySet()), failureMessages.iterator().next()}) : Localise.format((String)"Could not start service on %1$s - multiple reasons", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", failures.keySet())});
                throw new ServiceException(message);
            }
        }
        catch (ServiceException e) {
            Localise.logError((Logger)logger, (String)e.getMessage(), (Object[])new Object[0]);
            throw e;
        }
        catch (Exception e) {
            String message = Localise.format((String)"Unexpected exception starting service - %1$s", (Object[])new Object[]{e.getMessage()});
            Localise.logError((Logger)logger, (Exception)e, (String)message, (Object[])new Object[0]);
            throw new ServiceException(message);
        }
    }

    public boolean isUser(String name) {
        if (this.users.containsKey((Object)name)) {
            return true;
        }
        return this.userService != null && this.userService.isUser(name);
    }

    public User getUser(String name) {
        return this.getUser(name, false);
    }

    public User getUser(String name, boolean refresh) {
        User user = (User)this.users.get((Object)name);
        if (user == null && this.userService != null) {
            user = this.userService.getUser(name, refresh);
        }
        if (user != null && !this.adminRoleRequiresLicense && user.hasLicense() && user.hasRole(Role.ADMIN)) {
            user.setLicense(null);
        }
        return user;
    }

    public Collection<User> getUsers(Filter filter) {
        ArrayList<User> userList = new ArrayList<User>();
        if (filter != null && filter.getType() == Filter.Type.EXACT) {
            User user = this.getUser(filter.getPattern());
            if (user != null) {
                userList.add(user);
            }
        } else {
            if (this.userService != null) {
                String userType = this.userService.getServiceName();
                for (User user : this.userService.getUsers(filter)) {
                    user.setProperty("userType", (Object)userType);
                    userList.add(user);
                }
            }
            if (filter == null || filter.getType() == Filter.Type.ANY) {
                userList.addAll(this.users.values());
            } else {
                for (String name : this.users.keySet()) {
                    if (!filter.matches(name)) continue;
                    userList.add((User)this.users.get((Object)name));
                }
            }
        }
        if (!this.adminRoleRequiresLicense) {
            for (User user : userList) {
                if (!user.hasLicense() || !user.hasRole(Role.ADMIN)) continue;
                user.setLicense(null);
            }
        }
        return userList;
    }

    public User authenticateUser(String userName, String password) {
        if (StringUtils.isNullOrEmpty((String)userName) || StringUtils.isNullOrEmpty((String)password)) {
            return null;
        }
        User user = (User)this.users.get((Object)userName);
        if (user != null) {
            if (!user.validatePassword(password)) {
                user = null;
            }
        } else if (this.userService != null) {
            try {
                user = this.userService.authenticateUser(userName, password);
            }
            catch (ServiceException e) {
                logger.warn(e.getMessage());
            }
        }
        if (user == null) {
            return null;
        }
        Name home = user.getHome();
        if (home != null && !this.aclManager.hasACL(home, userName)) {
            ACL acl = new ACL(home, userName, new ACL.Permission[]{ACL.Permission.READ, ACL.Permission.EXECUTE, ACL.Permission.ENABLE, ACL.Permission.WRITE});
            this.aclManager.setACL(acl);
            ACLList values = new ACLList(home, this.aclManager.getACLs(home, false));
            PersistManager.getInstance(this.hazelcast).save((PersistMessage)values, ConnectionManager.getConnection(this.hazelcast), 0);
        }
        return user;
    }

    public User setUser(User user) {
        String name = user.getName();
        if (name.length() < 1) {
            throw new IllegalNameException(name);
        }
        User u = (User)this.users.get((Object)name);
        if (u != null) {
            if (u.isReadOnly()) {
                throw new ReadOnlyUserException(name);
            }
            if (!user.hasPassword()) {
                user.setPassword(u);
            }
        } else if (this.userService != null && !user.getName().equals(Configs.get((String)"beyondcron.guest.user.name"))) {
            throw new RemoteUserException(name);
        }
        for (String roleName : user.getRoles()) {
            Role role = (Role)this.roles.get((Object)roleName);
            if (role == null) {
                throw new NoSuchRoleException(roleName);
            }
            if (!role.isReadOnly()) continue;
            throw new ReadOnlyRoleException(roleName);
        }
        return (User)this.users.put((Object)user.getName(), (Object)user);
    }

    public User deleteUser(String name) {
        User user = (User)this.users.get((Object)name);
        if (user == null) {
            throw new NoSuchUserException(name);
        }
        if (user.isReadOnly()) {
            throw new ReadOnlyUserException(name);
        }
        return (User)this.users.remove((Object)name);
    }

    public boolean isRole(String name) {
        if (this.roles.containsKey((Object)name)) {
            return true;
        }
        return this.userService != null && this.userService.isRole(name);
    }

    public Role setRole(Role role) {
        String name = role.getName();
        Role r = (Role)this.roles.get((Object)name);
        if (r != null) {
            if (r.isReadOnly()) {
                throw new ReadOnlyRoleException(name);
            }
        } else if (this.userService != null) {
            throw new RemoteRoleException(name);
        }
        return (Role)this.roles.put((Object)name, (Object)role);
    }

    public Role deleteRole(String name) {
        Role role = (Role)this.roles.get((Object)name);
        if (role == null) {
            throw new NoSuchRoleException(name);
        }
        if (role.isReadOnly()) {
            throw new ReadOnlyRoleException(name);
        }
        IExecutorService executor = this.hazelcast.getExecutorService("roleInUse");
        try {
            for (Future inUse : executor.submitToAllMembers((Callable)new RoleInUse(name)).values()) {
                if (!((Boolean)inUse.get()).booleanValue()) continue;
                throw new RoleActiveException(name);
            }
        }
        catch (Exception e) {
            throw new SecurityManagerException(e.getMessage());
        }
        return (Role)this.roles.remove((Object)name);
    }

    public Role getRole(String name) {
        Role role = (Role)this.roles.get((Object)name);
        if (role == null && this.userService != null) {
            role = this.userService.getRole(name);
        }
        return role;
    }

    public Collection<Role> getRoles(Filter filter) {
        ArrayList<Role> l = new ArrayList<Role>();
        if (filter.getType() == Filter.Type.EXACT) {
            String name = filter.getPattern();
            Role role = (Role)this.roles.get((Object)name);
            if (role == null && this.userService != null) {
                role = this.userService.getRole(name);
            }
            if (role != null) {
                l.add(role);
            }
        } else {
            for (String name : this.roles.keySet()) {
                if (!filter.matches(name)) continue;
                l.add((Role)this.roles.get((Object)name));
            }
            if (this.userService != null) {
                for (Role role : this.userService.getRoles(filter)) {
                    if (l.contains(role)) continue;
                    l.add(role);
                }
            }
        }
        return l;
    }

    private String createPassword(String userName) {
        return this.createPassword(userName, null);
    }

    private String createPassword(String userName, String salt) {
        StringBuilder sb = new StringBuilder(userName);
        sb.append(System.getProperty("user.name"));
        sb.append((String)Configs.get((String)"BEYONDCRON_CLUSTER_NAME"));
        sb.append((String)Configs.get((String)"BEYONDCRON_CLUSTER_PASSWORD"));
        if (StringUtils.isNullOrEmpty((String)salt)) {
            sb.append(salt);
        }
        sb.append((String)Configs.get((String)"beyondcron.user.password.extra.salt"));
        return StringUtils.hashString((String)sb.toString());
    }

    @Override
    public void messageLoaded(Name name, Message<?> message) {
        if (message instanceof Role) {
            this.setRole((Role)message);
        } else if (message instanceof User) {
            this.setUser((User)message);
        } else {
            Localise.logWarn((Logger)logger, (String)"Unsupported message type $1$s", (Object[])new Object[]{message.getClass().getName()});
        }
    }

    public static class RemoteRoleException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public RemoteRoleException(String name) {
            super("Remote role " + name + " cannot be changed");
        }
    }

    public static class RemoteUserException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public RemoteUserException(String name) {
            super("Remote user " + name + " cannot be changed");
        }
    }

    public static class NoSuchUserException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public NoSuchUserException(String name) {
            super("User " + name + " does not exist");
        }
    }

    public static class NoSuchRoleException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public NoSuchRoleException(String name) {
            super("Role " + name + " does not exist");
        }
    }

    public static class RoleActiveException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public RoleActiveException(String name) {
            super("Role " + name + " is active");
        }
    }

    public static class ReadOnlyRoleException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public ReadOnlyRoleException(String role) {
            super("Role " + role + " is read only");
        }
    }

    public static class ReadOnlyUserException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public ReadOnlyUserException(String name) {
            super("User " + name + " is read only");
        }
    }

    public static class IllegalNameException
    extends SecurityManagerException {
        private static final long serialVersionUID = 1L;

        public IllegalNameException(String name) {
            super("Illegal user/role name: " + name);
        }
    }

    public static class SecurityManagerException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SecurityManagerException(String message) {
            super(message);
        }
    }

    static class RoleInUse
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    Serializable {
        private String roleName;
        private transient HazelcastInstance hazelcast;

        public RoleInUse(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public Boolean call() {
            IMap<String, User> users = UserManager.getInstance((HazelcastInstance)this.hazelcast).users;
            for (String userName : users.localKeySet()) {
                if (!((User)users.get((Object)userName)).hasRole(this.roleName)) continue;
                return true;
            }
            return false;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    static class ServiceRefresh
    implements Runnable,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        ServiceRefresh() {
        }

        @Override
        public void run() {
            UserService service = UserManager.getInstance(this.hazelcast).getUserService();
            if (service != null) {
                service.refresh();
            }
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    static class ServiceStart
    implements Callable<String>,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        ServiceStart() {
        }

        @Override
        public String call() {
            UserManager manager = UserManager.getInstance(this.hazelcast);
            if (manager.userService != null) {
                return Localise.format((String)"%1$s user service is already running", (Object[])new Object[]{manager.userService.getServiceName()});
            }
            try {
                manager.userService = UserService.getService((HazelcastInstance)this.hazelcast);
                return null;
            }
            catch (ServiceException e) {
                return e.getMessage();
            }
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }

    static class ServiceStop
    implements Callable<Boolean>,
    HazelcastInstanceAware,
    Serializable {
        private transient HazelcastInstance hazelcast;

        ServiceStop() {
        }

        @Override
        public Boolean call() {
            UserManager manager = UserManager.getInstance(this.hazelcast);
            if (manager.userService != null && manager.userService.disconnect()) {
                manager.userService = null;
            }
            return manager.userService == null;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcast) {
            this.hazelcast = hazelcast;
        }
    }
}

