/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.etcd;

import com.beyondcron.core.ConfigService;
import com.beyondcron.core.Configs;
import com.beyondcron.core.IOUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.IntegerConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class ETCDConfigService
extends ConfigService {
    static Logger logger = LogUtils.getLogger(ETCDConfigService.class);
    public static final String SERVICE_NAME = "etcd";
    @StringConfig.Annotation(startup=true)
    public static final String ETCD_DIR = "ETCD_DIR";
    @IntegerConfig.Annotation(defaultValue=2379, minValue=1, startup=true)
    public static final String ETCD_PORT = "ETCD_PORT";
    @StringConfig.Annotation(defaultValue="http", startup=true)
    public static final String ETCD_PROTOCOL = "ETCD_PROTOCOL";
    @StringConfig.Annotation(startup=true)
    public static final String ETCD_ENDPOINTS = "ETCD_ENDPOINTS";
    @StringConfig.Annotation(startup=true)
    public static final String ETCD_USER_NAME = "ETCD_USER_NAME";
    @StringConfig.Annotation(secret=true, startup=true)
    public static final String ETCD_USER_PASSWORD = "ETCD_USER_PASSWORD";
    @StringConfig.Annotation(defaultValue="%1$s://localhost:%2$d/", startup=true)
    public static final String ETCD_DEFAULT_ENDPOINT = "ETCD_DEFAULT_ENDPOINT";
    @PeriodConfig.Annotation(defaultValue="2 seconds", maxUnit=Period.Unit.MINUTE, startup=true)
    public static final String ETCD_CONNECT_TIMEOUT = "ETCD_CONNECT_TIMEOUT";
    public static final String ETCD_PARAM_DIR = "dir";
    public static final String ETCD_PARAM_PREV_EXIST = "prevExist";
    public static final String ETCD_PARAM_PREV_VALUE = "prevValue";
    public static final String ETCD_PARAM_PREV_INDEX = "prevIndex";
    public static final String ETCD_PARAM_VALUE = "value";
    public static final String JSON_DIR = "dir";
    public static final String JSON_KEY = "key";
    public static final String JSON_NODE = "node";
    public static final String JSON_NODES = "nodes";
    public static final String JSON_VALUE = "value";
    public static final String JSON_MODIFIED_INDEX = "modifiedIndex";
    private final Pattern ENDPOINT_REGEX = Pattern.compile("((https?)://)?([a-zA-Z0-9._-]+)(:(\\d+))?/?");
    private String rootDirName;
    private String dirName;
    private String credentials = null;
    private Deque<String> endpoints = new ArrayDeque<String>();
    private int connectTimeout = 0;
    private Map<String, String> properties = new HashMap<String, String>();
    private long propertiesUpdated = 0L;

    public ETCDConfigService() {
        super(SERVICE_NAME);
    }

    protected void init() throws ServiceException {
        int code;
        HttpURLConnection connection;
        String userName;
        this.connectTimeout = (int)((Period)Configs.get((String)ETCD_CONNECT_TIMEOUT)).getMilliseconds();
        String defaultProtocol = (String)Configs.get((String)ETCD_PROTOCOL);
        int defaultPort = (Integer)Configs.get((String)ETCD_PORT);
        LinkedHashSet<String> tmpEndpoints = new LinkedHashSet<String>();
        for (String endpoint : StringUtils.split((String)((String)Configs.get((String)ETCD_ENDPOINTS)))) {
            Matcher m = this.ENDPOINT_REGEX.matcher(endpoint);
            if (!m.matches()) {
                throw new ServiceException(Localise.format((String)"Unsupported endpoint name - %1$s", (Object[])new Object[]{endpoint}));
            }
            tmpEndpoints.add(String.format("%s://%s:%s", StringUtils.get((String)m.group(2), (String)defaultProtocol), m.group(3), StringUtils.get((String)m.group(5), (String)Integer.toString(defaultPort))));
        }
        this.endpoints = new ArrayDeque<String>(tmpEndpoints);
        if (this.endpoints.isEmpty()) {
            this.endpoints.add(String.format((String)Configs.get((String)ETCD_DEFAULT_ENDPOINT), defaultProtocol, defaultPort));
        }
        if (!StringUtils.isNullOrEmpty((String)(userName = (String)Configs.get((String)ETCD_USER_NAME)))) {
            try {
                this.credentials = String.format("Basic %s", StringUtils.toBase64((String)String.format("%s:%s", userName, Configs.getPassword((String)ETCD_USER_PASSWORD))));
            }
            catch (IOException e) {
                throw new ServiceException(Localise.format((String)"Could not read password - %1$s", (Object[])new Object[]{e.getMessage()}));
            }
        }
        this.dirName = (String)Configs.get((String)ETCD_DIR);
        if (StringUtils.isNullOrEmpty((String)this.dirName)) {
            throw new ServiceException(Localise.format((String)"Environment variable undefined - %1$s", (Object[])new Object[]{ETCD_DIR}));
        }
        if (this.dirName.startsWith("/")) {
            this.dirName = this.dirName.substring(1);
        }
        if (this.dirName.endsWith("/")) {
            this.dirName = this.dirName.substring(0, this.dirName.length() - 1);
        }
        this.rootDirName = String.format("/v2/keys/%s", this.dirName);
        try {
            connection = this.execute("", Method.GET, null);
            code = connection.getResponseCode();
            if (code != 200 && code != 404) {
                throw new ServiceException(Localise.format((String)"Could not connect to etcd - %1$s", (Object[])new Object[]{connection.getResponseMessage()}));
            }
        }
        catch (IOException e) {
            throw new ServiceException(Localise.format((String)"Could not connect to etcd server/s at %1$s - %2$s", (Object[])new Object[]{StringUtils.join((String)", ", (String)" & ", this.endpoints), e.getMessage()}));
        }
        if (code == 404) {
            try {
                connection = this.execute("", Method.PUT, StringUtils.asMap((String[])new String[]{"dir", "true"}));
                code = connection.getResponseCode();
                if (code != 201) {
                    throw new ServiceException(Localise.format((String)"Could not create %1$s%2$s - %3$s", (Object[])new Object[]{this.endpoints.element(), this.rootDirName, connection.getResponseMessage()}));
                }
            }
            catch (IOException e) {
                throw new ServiceException(Localise.format((String)"Could not connect to etcd - %1$s", (Object[])new Object[]{e.getMessage()}));
            }
        }
        this.initProperties();
    }

    private void initProperties() throws ServiceException {
        if (this.propertiesUpdated == 0L) {
            this.properties.clear();
            try {
                JSONObject directory;
                HttpURLConnection connection = this.execute("", Method.GET, null);
                int code = connection.getResponseCode();
                if (code == 200 && (directory = this.getResponse(connection).getJSONObject(JSON_NODE)).getBoolean("dir") && directory.has(JSON_NODES)) {
                    String prefix = "/" + this.dirName + "/";
                    for (Object property : directory.getJSONArray(JSON_NODES)) {
                        JSONObject json = (JSONObject)property;
                        String name = json.getString(JSON_KEY);
                        String value = json.optString("value", "");
                        this.properties.put(StringUtils.stripPrefix((String)name, (String)prefix), value);
                    }
                }
            }
            catch (IOException e) {
                throw new ServiceException(Localise.format((String)"Could not get properties in %1$s - %2$s", (Object[])new Object[]{this.rootDirName, e.getMessage()}));
            }
            this.propertiesUpdated = System.currentTimeMillis();
        }
    }

    public String getServiceDescription() {
        return String.format("etcd /%s on %s", this.dirName, StringUtils.join((String)" ", this.endpoints));
    }

    private String getPropertyPath(String name) {
        StringBuilder sb = new StringBuilder(this.endpoints.element());
        sb.append(this.rootDirName);
        if (!StringUtils.isNullOrEmpty((String)name)) {
            sb.append("/");
            sb.append(name);
        }
        return sb.toString();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String setProperty(String name, String value) throws ServiceException {
        if (!this.isConnected()) {
            return null;
        }
        if (value == null) {
            throw new ServiceException(Localise.format((String)"Value of %1$s cannot be null", (Object[])new Object[]{name}));
        }
        try {
            HttpURLConnection connection = this.execute(name, Method.PUT, StringUtils.asMap((String[])new String[]{"value", value}));
            int code = connection.getResponseCode();
            if (code != 200 && code != 201) {
                throw new ServiceException(Localise.format((String)"Could not set %1$s to %2$s - (%3$d) %4$s", (Object[])new Object[]{name, value, code, connection.getResponseMessage()}));
            }
        }
        catch (IOException e) {
            throw new ServiceException(Localise.format((String)"Could not set %1$s to %2$s - %3$s", (Object[])new Object[]{name, value, e.getMessage()}));
        }
        this.properties.put(name, value);
        return value;
    }

    public String setProperty(String name, String value, String currentValue) throws ServiceException {
        JSONObject response;
        int code;
        HttpURLConnection connection;
        String param;
        if (!this.isConnected()) {
            return null;
        }
        if (currentValue == null) {
            param = String.format("%s=false", ETCD_PARAM_PREV_EXIST);
        } else if (currentValue.length() > 0) {
            param = NetUtils.getParameterString((Map)StringUtils.asMap((String[])new String[]{ETCD_PARAM_PREV_VALUE, currentValue}));
        } else {
            param = null;
            try {
                connection = this.execute(name, Method.GET, null);
                code = connection.getResponseCode();
                if (code == 200) {
                    response = this.getResponse(connection).getJSONObject(JSON_NODE);
                    if (response.getString("value").length() == 0) {
                        param = String.format("%s=%d", ETCD_PARAM_PREV_INDEX, response.getInt(JSON_MODIFIED_INDEX));
                    }
                    System.out.println(response);
                } else {
                    param = String.format("%s=false", ETCD_PARAM_PREV_EXIST);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            connection = this.execute(String.format("%s?%s", name, param), Method.PUT, StringUtils.asMap((String[])new String[]{"value", value}));
            code = connection.getResponseCode();
            if (code != 200 && code != 201 && code != 412) {
                throw new ServiceException(Localise.format((String)"Could not set %1$s - (%2$d) %3$s", (Object[])new Object[]{name, code, connection.getResponseMessage()}));
            }
            if (code != 412) {
                this.properties.put(name, value);
            } else {
                connection = this.execute(name, Method.GET, null);
                code = connection.getResponseCode();
                if (code != 200) {
                    throw new ServiceException(Localise.format((String)"Could not get of %1$s - (%2$d) %3$s", (Object[])new Object[]{name, code, connection.getResponseMessage()}));
                }
                response = this.getResponse(connection);
                this.properties.put(name, response.getJSONObject(JSON_NODE).getString("value"));
            }
        }
        catch (IOException e) {
            throw new ServiceException(Localise.format((String)"Could not set %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()}));
        }
        return this.properties.get(name);
    }

    private HttpURLConnection execute(String path, Method method, Map<String, String> params) throws IOException, ServiceException {
        int i = 0;
        while (i++ < this.endpoints.size()) {
            try {
                URL url = new URL(this.getPropertyPath(path));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                if (method != Method.GET) {
                    connection.setRequestMethod(method.toString());
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
                }
                connection.setRequestProperty("Accept-Charset", "UTF-8");
                connection.setDoOutput(true);
                if (!StringUtils.isNullOrEmpty((String)this.credentials)) {
                    connection.setRequestProperty("Authorization", this.credentials);
                }
                if (logger.isDebugEnabled()) {
                    Localise.logDebug((Logger)logger, (String)"%1$s %2$s", (Object[])new Object[]{connection.getRequestMethod(), connection.getURL().toString()});
                }
                if (params != null && !params.isEmpty()) {
                    String data = NetUtils.getParameterString(params);
                    if (logger.isDebugEnabled()) {
                        Localise.logDebug((Logger)logger, (String)data, (Object[])new Object[0]);
                    }
                    connection.getOutputStream().write(data.getBytes("UTF-8"));
                }
                connection.setConnectTimeout(this.connectTimeout);
                connection.getResponseCode();
                return connection;
            }
            catch (SocketTimeoutException e) {
                if (i >= this.endpoints.size()) {
                    throw e;
                }
                this.endpoints.add(this.endpoints.remove());
            }
        }
        if (this.endpoints.size() > 0) {
            throw new IOException(Localise.format((String)"Could not connect to an endpoint - %1$s", (Object[])new Object[]{StringUtils.join((String)" ", this.endpoints)}));
        }
        throw new ServiceException(Localise.format((String)"No endpoints defined"));
    }

    private JSONObject getResponse(HttpURLConnection connection) throws IOException {
        return new JSONObject(IOUtils.read((InputStream)connection.getInputStream()));
    }

    static {
        Configs.addConfigs(ETCDConfigService.class);
    }

    private static enum Method {
        GET,
        PUT;

    }
}

