/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.aws;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.ScanFilter;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.beyondcron.core.ConfigService;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.service.aws.AWSClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class AWSConfigService
extends ConfigService {
    static final Logger logger = LogUtils.getLogger(AWSConfigService.class);
    public static final String SERVICE_NAME = "AWS";
    @StringConfig.Annotation(startup=true)
    public static final String AWS_TABLE_CONFIG = "AWS_TABLE_CONFIG";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    private AWSClient awsClient;
    private AmazonDynamoDBClient dbClient;
    private DynamoDB db;
    private Table configTable;
    private Map<String, String> properties = new HashMap<String, String>();
    private long propertiesUpdated = 0L;

    public AWSConfigService() {
        super(SERVICE_NAME);
    }

    protected void init() throws ServiceException {
        this.awsClient = new AWSClient(true, AWS_TABLE_CONFIG);
        this.initDb();
        this.initProperties();
    }

    private void initDb() throws ServiceException {
        this.dbClient = this.awsClient.getDBClient();
        this.db = new DynamoDB((AmazonDynamoDB)this.dbClient);
        this.configTable = this.getConfigTable((String)Configs.get((String)AWS_TABLE_CONFIG));
    }

    private void initProperties() throws ServiceException {
        if (this.propertiesUpdated == 0L) {
            this.properties.clear();
            try {
                for (Item item : this.configTable.scan(new ScanFilter[0])) {
                    this.properties.put(item.getString(ATTRIBUTE_NAME), item.getString(ATTRIBUTE_VALUE));
                }
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format((String)"Could not get properties in %1$s - %2$s", (Object[])new Object[]{this.configTable.getTableName(), e.getMessage()}));
            }
        }
    }

    public String getServiceDescription() {
        return Localise.format((String)"AWS %1$s:%2$s", (Object[])new Object[]{Configs.get((String)"AWS_REGION"), this.configTable.getTableName()});
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String setProperty(String name, String value) throws ServiceException {
        Item item = new Item().withString(ATTRIBUTE_NAME, name).withString(ATTRIBUTE_VALUE, value);
        try {
            this.configTable.putItem(item);
            this.properties.put(name, value);
            return value;
        }
        catch (Exception e) {
            throw new ServiceException(Localise.format((String)"Could not set %1$s to %2$s - %3$s", (Object[])new Object[]{name, value, e.getMessage()}));
        }
    }

    public String setProperty(String name, String value, String currentValue) throws ServiceException {
        Item item = new Item().withString(ATTRIBUTE_NAME, name).withString(ATTRIBUTE_VALUE, value);
        try {
            if (currentValue == null) {
                this.configTable.putItem(item, new Expected[]{new Expected(ATTRIBUTE_NAME).notExist()});
            } else {
                this.configTable.putItem(item, new Expected[]{new Expected(ATTRIBUTE_VALUE).eq((Object)currentValue)});
            }
            this.properties.put(name, value);
        }
        catch (ConditionalCheckFailedException e) {
            this.properties.put(name, this.configTable.getItem(new GetItemSpec().withPrimaryKey(new PrimaryKey(ATTRIBUTE_NAME, (Object)name)).withConsistentRead(true)).getString(ATTRIBUTE_VALUE));
        }
        catch (Exception e) {
            throw new ServiceException(Localise.format((String)"Unexpected exception saving %1$s=%2$s: %3$s", (Object[])new Object[]{name, value, e.getMessage()}));
        }
        return this.properties.get(name);
    }

    private Table getConfigTable(String name) throws ServiceException {
        Table table = this.db.getTable(name);
        boolean createTable = false;
        try {
            table.describe();
        }
        catch (ResourceNotFoundException e) {
            createTable = true;
        }
        if (createTable) {
            Localise.logInfo((Logger)logger, (String)"Creating table %1$s", (Object[])new Object[]{name});
            CreateTableRequest tableRequest = new CreateTableRequest().withTableName(name).withKeySchema(new KeySchemaElement[]{new KeySchemaElement(ATTRIBUTE_NAME, KeyType.HASH)}).withAttributeDefinitions(new AttributeDefinition[]{new AttributeDefinition(ATTRIBUTE_NAME, ScalarAttributeType.S)}).withBillingMode(BillingMode.PAY_PER_REQUEST);
            try {
                table = this.db.createTable(tableRequest);
                table.waitForActive();
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return table;
    }

    static {
        Configs.addConfigs(AWSConfigService.class);
    }
}

