/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.service.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClientBuilder;
import com.amazonaws.services.cognitoidp.model.AdminAddUserToGroupRequest;
import com.amazonaws.services.cognitoidp.model.AdminCreateUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminGetUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminGetUserResult;
import com.amazonaws.services.cognitoidp.model.AdminInitiateAuthRequest;
import com.amazonaws.services.cognitoidp.model.AdminInitiateAuthResult;
import com.amazonaws.services.cognitoidp.model.AdminRemoveUserFromGroupRequest;
import com.amazonaws.services.cognitoidp.model.AdminRespondToAuthChallengeRequest;
import com.amazonaws.services.cognitoidp.model.AdminUpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.AuthFlowType;
import com.amazonaws.services.cognitoidp.model.ChallengeNameType;
import com.amazonaws.services.cognitoidp.model.ChangePasswordRequest;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordRequest;
import com.amazonaws.services.cognitoidp.model.ExpiredCodeException;
import com.amazonaws.services.cognitoidp.model.ForgotPasswordRequest;
import com.amazonaws.services.cognitoidp.model.GroupType;
import com.amazonaws.services.cognitoidp.model.InvalidParameterException;
import com.amazonaws.services.cognitoidp.model.InvalidPasswordException;
import com.amazonaws.services.cognitoidp.model.LimitExceededException;
import com.amazonaws.services.cognitoidp.model.ListGroupsRequest;
import com.amazonaws.services.cognitoidp.model.ListUsersInGroupRequest;
import com.amazonaws.services.cognitoidp.model.ListUsersRequest;
import com.amazonaws.services.cognitoidp.model.MessageActionType;
import com.amazonaws.services.cognitoidp.model.NotAuthorizedException;
import com.amazonaws.services.cognitoidp.model.ResourceNotFoundException;
import com.amazonaws.services.cognitoidp.model.UserType;
import com.beyondcron.core.CollectionUtils;
import com.beyondcron.core.Configs;
import com.beyondcron.core.Filter;
import com.beyondcron.core.License;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.MailUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.Period;
import com.beyondcron.core.Role;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.IntegerConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.core.user.User;
import com.beyondcron.core.user.UserService;
import com.hazelcast.core.HazelcastInstance;
import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.YubicoClient;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class AWSUserService
extends UserService {
    static final Logger logger = LogUtils.getLogger(AWSUserService.class);
    public static final String SERVICE_NAME = "AWS";
    @StringConfig.Annotation
    public static final String AWS_ACCESS_KEY_ID = "aws.access.key.id";
    @StringConfig.Annotation(secret=true)
    public static final String AWS_SECRET_ACCESS_KEY = "aws.secret.access.key";
    @StringConfig.Annotation
    public static final String AWS_REGION = "aws.region";
    @StringConfig.Annotation
    public static final String AWS_COGNITO_POOL_ID = "aws.cognito.pool.id";
    @StringConfig.Annotation
    public static final String AWS_COGNITO_CLIENT_ADMIN_ID = "aws.cognito.client.admin.id";
    @StringConfig.Annotation
    public static final String AWS_COGNITO_CLIENT_RESET_ID = "aws.cognito.client.reset.id";
    @StringConfig.Annotation(secret=true)
    public static final String AWS_COGNITO_CLIENT_RESET_SECRET = "aws.cognito.client.reset.secret";
    @PeriodConfig.Annotation(defaultValue="15 minutes")
    public static final String AWS_COGNITO_CACHE_PERIOD = "aws.cognito.refresh.period";
    @IntegerConfig.Annotation(minValue=1, hidden=true)
    public static final String YUBICO_ID = "yubico.id";
    @StringConfig.Annotation(secret=true, hidden=true)
    public static final String YUBICO_SECRET = "yubico.secret";
    public static final String YUBICO_USER_ID = "yubiKeyId";
    public static final String ATTRIBUTE_FIRST_NAME = "given_name";
    public static final String ATTRIBUTE_LAST_NAME = "family_name";
    public static final String ATTRIBUTE_EMAIL = "email";
    public static final String ATTRIBUTE_EMAIL_VERIFIED = "email_verified";
    public static final String ATTRIBUTE_DATA = "custom:data";
    private HazelcastInstance hazelcast;
    private String poolId;
    private String clientAdminId;
    private String clientResetId;
    private String clientResetSecret;
    private AWSCognitoIdentityProviderClient cognitoClient;
    private YubicoClient yubicoClient = null;
    private long cachePeriod;
    private UserCache users;
    private RoleCache roles;

    public AWSUserService() {
        this(null);
    }

    public AWSUserService(HazelcastInstance hazelcast) {
        super(SERVICE_NAME);
        this.hazelcast = hazelcast;
        this.roles = new RoleCache(hazelcast);
        this.users = new UserCache(hazelcast);
    }

    protected void init() throws ServiceException {
        super.init();
        for (String name : new String[]{AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY}) {
            if (!StringUtils.isNullOrEmpty((String)((String)Configs.get((String)name)))) continue;
            throw new ServiceException(Localise.format((String)"Configuration variable undefined - %1$s", (Object[])new Object[]{name}));
        }
        this.poolId = (String)Configs.get((String)AWS_COGNITO_POOL_ID);
        this.clientAdminId = (String)Configs.get((String)AWS_COGNITO_CLIENT_ADMIN_ID);
        this.clientResetId = (String)Configs.get((String)AWS_COGNITO_CLIENT_RESET_ID);
        this.clientResetSecret = (String)Configs.get((String)AWS_COGNITO_CLIENT_RESET_SECRET);
        AWSCognitoIdentityProviderClientBuilder builder = AWSCognitoIdentityProviderClientBuilder.standard();
        BasicAWSCredentials credentials = new BasicAWSCredentials((String)Configs.get((String)AWS_ACCESS_KEY_ID), (String)Configs.get((String)AWS_SECRET_ACCESS_KEY));
        builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials));
        String region = (String)Configs.get((String)AWS_REGION);
        if (!StringUtils.isNullOrEmpty((String)region)) {
            builder.withRegion(region);
        }
        this.cognitoClient = (AWSCognitoIdentityProviderClient)builder.build();
        Integer yubicoId = (Integer)Configs.get((String)YUBICO_ID);
        String yubicoSecret = (String)Configs.get((String)YUBICO_SECRET);
        if (yubicoId != null && yubicoSecret != null) {
            try {
                this.yubicoClient = YubicoClient.getClient((Integer)yubicoId, (String)yubicoSecret);
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format((String)"Yubico exception: %s", (Object[])new Object[]{e.getMessage()}));
            }
        }
        this.cachePeriod = ((Period)Configs.get((String)AWS_COGNITO_CACHE_PERIOD)).getMilliseconds();
    }

    public User authenticateUser(String name, String password) {
        try {
            return this.authenticateUser(name, password, null);
        }
        catch (NotAuthorizedException notAuthorizedException) {
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (String)"Unexpected exception - %s", (Object[])new Object[]{e.getMessage()});
        }
        return null;
    }

    public void changePassword(String name, String password, String newPassword) throws ServiceException {
        if (!this.isConnected()) {
            ServiceException e = new ServiceException("Not connected");
            e.setReason(ServiceException.Reason.NOT_CONNECTED);
            throw e;
        }
        if (this.users.getUser(name, false) == null) {
            ServiceException e = new ServiceException("Unknown user");
            e.setReason(ServiceException.Reason.UNKNOWN_USER);
            throw e;
        }
        try {
            this.authenticateUser(name, password, newPassword);
        }
        catch (Exception cause) {
            ServiceException e;
            Object message = cause.getMessage();
            if (cause instanceof NotAuthorizedException) {
                e = new ServiceException("Incorrect current password", (Throwable)cause);
                e.setReason(ServiceException.Reason.INVALID_PASSWORD);
            } else if (cause instanceof InvalidParameterException) {
                int i = ((String)message).indexOf(": Member");
                if (i >= 0) {
                    message = "New password " + ((String)message).substring(i + 8);
                }
                if ((i = ((String)message).indexOf(" (Service")) > 0) {
                    message = ((String)message).substring(0, i);
                }
                e = new ServiceException((String)message, (Throwable)cause);
                e.setReason(ServiceException.Reason.INVALID_NEW_PASSWORD);
            } else if (cause instanceof InvalidPasswordException) {
                int i = ((String)message).indexOf(": P");
                if (i >= 0) {
                    message = "New p" + ((String)message).substring(i + 3);
                }
                if ((i = ((String)message).indexOf(" (Service")) > 0) {
                    message = ((String)message).substring(0, i);
                }
                e = new ServiceException((String)message, (Throwable)cause);
                e.setReason(ServiceException.Reason.INVALID_NEW_PASSWORD);
            } else {
                e = new ServiceException((Throwable)cause);
            }
            throw e;
        }
    }

    public void resetPassword(String name) throws ServiceException {
        if (!this.isConnected()) {
            ServiceException e = new ServiceException("Not connected");
            e.setReason(ServiceException.Reason.NOT_CONNECTED);
            throw e;
        }
        User user = this.users.getUser(name, true);
        if (user == null) {
            ServiceException e = new ServiceException("Unknown user");
            e.setReason(ServiceException.Reason.UNKNOWN_USER);
            throw e;
        }
        ForgotPasswordRequest request = new ForgotPasswordRequest().withClientId(this.clientResetId).withUsername(name).withSecretHash(this.calculataSecretHash(name));
        try {
            this.cognitoClient.forgotPassword(request);
        }
        catch (Exception cause) {
            ServiceException e;
            String message = cause.getMessage();
            if (cause instanceof InvalidParameterException) {
                int i = message.indexOf(": Cannot");
                if (i > 0) {
                    message = Localise.format((String)"User %s does not have a verified email address", (Object[])new Object[]{name});
                }
                e = new ServiceException(message, (Throwable)cause);
                e.setReason(ServiceException.Reason.UNVERIFIED_EMAIL);
            } else if (cause instanceof LimitExceededException) {
                int i = message.indexOf(": Attempt");
                if (i > 0) {
                    message = message.substring(i + 2);
                }
                if ((i = message.indexOf(". (Service")) > 0) {
                    message = message.substring(0, i);
                }
                e = new ServiceException(message, (Throwable)cause);
                e.setReason(ServiceException.Reason.UNVERIFIED_EMAIL);
            } else {
                e = new ServiceException((Throwable)cause);
            }
            throw e;
        }
    }

    public void resetPassword(String name, String token, String newPassword) throws ServiceException {
        if (!this.isConnected()) {
            ServiceException e = new ServiceException("Not connected");
            e.setReason(ServiceException.Reason.NOT_CONNECTED);
            throw e;
        }
        User user = this.users.getUser(name, true);
        if (user == null) {
            ServiceException e = new ServiceException("Unknown user");
            e.setReason(ServiceException.Reason.UNKNOWN_USER);
            throw e;
        }
        ConfirmForgotPasswordRequest request = new ConfirmForgotPasswordRequest().withClientId(this.clientResetId).withUsername(name).withConfirmationCode(token).withPassword(newPassword).withSecretHash(this.calculataSecretHash(name));
        try {
            this.cognitoClient.confirmForgotPassword(request);
        }
        catch (Exception cause) {
            ServiceException e;
            String message = cause.getMessage();
            if (cause instanceof ExpiredCodeException) {
                int i = message.indexOf(" Invalid");
                if (i > 0) {
                    message = message.substring(i + 2);
                }
                if ((i = message.indexOf(". (Service")) > 0) {
                    message = message.substring(0, i);
                }
                e = new ServiceException(message, (Throwable)cause);
                e.setReason(ServiceException.Reason.INVALID_PASSWORD);
            } else {
                e = new ServiceException((Throwable)cause);
            }
            throw e;
        }
    }

    private User authenticateUser(String name, String password, String newPassword) throws Exception {
        if (!this.isConnected()) {
            return null;
        }
        User user = this.users.getUser(name, true);
        if (user == null) {
            return null;
        }
        if (!this.isYubikeyOTP(user, password)) {
            AdminInitiateAuthRequest request = new AdminInitiateAuthRequest().withUserPoolId(this.poolId).withClientId(this.clientAdminId).withAuthFlow(AuthFlowType.ADMIN_NO_SRP_AUTH).addAuthParametersEntry("USERNAME", name).addAuthParametersEntry("PASSWORD", password);
            AdminInitiateAuthResult result = this.cognitoClient.adminInitiateAuth(request);
            String challenge = result.getChallengeName();
            if (challenge != null && challenge.length() > 0) {
                if (!ChallengeNameType.NEW_PASSWORD_REQUIRED.name().equals(challenge)) {
                    logger.error(Localise.format((String)"unexpected challenge: %s", (Object[])new Object[]{challenge}));
                    return null;
                }
                if (!StringUtils.isNullOrEmpty((String)newPassword)) {
                    AdminRespondToAuthChallengeRequest challengeRequest = new AdminRespondToAuthChallengeRequest().withChallengeName(ChallengeNameType.NEW_PASSWORD_REQUIRED).withUserPoolId(this.poolId).withClientId(this.clientAdminId).withSession(result.getSession()).addChallengeResponsesEntry("USERNAME", name).addChallengeResponsesEntry("NEW_PASSWORD", newPassword);
                    this.cognitoClient.adminRespondToAuthChallenge(challengeRequest).getAuthenticationResult().getAccessToken();
                } else {
                    user.setStatus(User.Status.UNVERIFIED);
                }
            } else if (!StringUtils.isNullOrEmpty((String)newPassword)) {
                String accessToken = result.getAuthenticationResult().getAccessToken();
                ChangePasswordRequest changeRequest = new ChangePasswordRequest().withAccessToken(accessToken).withPreviousPassword(password).withProposedPassword(newPassword);
                this.cognitoClient.changePassword(changeRequest);
            }
            if (!StringUtils.isNullOrEmpty((String)newPassword)) {
                AdminUpdateUserAttributesRequest attributesRequest = new AdminUpdateUserAttributesRequest().withUserPoolId(this.poolId).withUsername(name).withUserAttributes(new AttributeType[]{new AttributeType().withName(ATTRIBUTE_EMAIL_VERIFIED).withValue("true")});
                this.cognitoClient.adminUpdateUserAttributes(attributesRequest);
            }
        } else {
            if (!StringUtils.isNullOrEmpty((String)newPassword)) {
                Localise.logDebug((Logger)logger, (String)"Password - %1$s", (Object[])new Object[]{password});
                throw new ServiceException(Localise.format((String)"Cannot change yubikey password"));
            }
            try {
                VerificationResponse response = this.yubicoClient.verify(password);
                if (!response.isOk()) {
                    return null;
                }
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format((String)"Yubico exception: %s", (Object[])new Object[]{e.getMessage()}));
            }
            try {
                if (!YubicoClient.getPublicId((String)password).equals(user.getProperty(YUBICO_USER_ID))) {
                    return null;
                }
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format((String)"Unexpected exception: %s", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return user;
    }

    private boolean isYubikeyOTP(User user, String password) {
        if (this.yubicoClient == null) {
            return false;
        }
        String id = user.getProperty(YUBICO_USER_ID);
        if (StringUtils.isNullOrEmpty((String)id)) {
            return false;
        }
        if (!password.startsWith(id)) {
            return false;
        }
        return YubicoClient.isValidOTPFormat((String)password);
    }

    public User getUser(String name, boolean refresh) {
        return this.users.getUser(name, refresh);
    }

    public Set<User> getUsers(Filter filter) {
        TreeSet<User> userSet = new TreeSet<User>();
        for (User user : this.users.getUsers()) {
            if (filter != null && !filter.matches(user.getName())) continue;
            userSet.add(user);
        }
        return userSet;
    }

    public boolean isUser(String name) {
        return this.users.isUser(name);
    }

    public User createUser(User user, String password) throws ServiceException {
        if (!this.isConnected()) {
            ServiceException e = new ServiceException("Not connected");
            e.setReason(ServiceException.Reason.NOT_CONNECTED);
            throw e;
        }
        String name = user.getName();
        Set userRoles = user.getRoles();
        String tmpPassword = StringUtils.hashString((String)new Date().toString());
        if (this.isUser(name)) {
            throw new ServiceException(Localise.format((String)"User already exists"));
        }
        if (!MailUtils.isValidAddress((String)name)) {
            throw new ServiceException(Localise.format((String)"User name is not a valid email address"));
        }
        for (String role : userRoles) {
            ArrayList<String> missingRoles = new ArrayList<String>();
            if (!this.roles.isRole(role)) {
                missingRoles.add(role);
            }
            if (missingRoles.isEmpty()) continue;
            if (missingRoles.size() == 1) {
                throw new ServiceException(Localise.format((String)"Role %s does not exist", (Object[])new Object[]{StringUtils.join((String)" ", missingRoles)}));
            }
            throw new ServiceException(Localise.format((String)"Roles %s do not exist", (Object[])new Object[]{StringUtils.join((String)" ", missingRoles)}));
        }
        if (StringUtils.isNullOrEmpty((String)user.getProperty("firstName"))) {
            throw new ServiceException(Localise.format((String)"%s property is undefined", (Object[])new Object[]{"firstName"}));
        }
        if (StringUtils.isNullOrEmpty((String)user.getProperty("lastName"))) {
            throw new ServiceException(Localise.format((String)"%s property is undefined", (Object[])new Object[]{"lastName"}));
        }
        AdminCreateUserRequest request = new AdminCreateUserRequest().withUserPoolId(this.poolId).withUsername(name).withUserAttributes(this.getUserAttributes(user));
        if (!StringUtils.isNullOrEmpty((String)password)) {
            request.getUserAttributes().add(new AttributeType().withName(ATTRIBUTE_EMAIL_VERIFIED).withValue("true"));
            request.withTemporaryPassword(tmpPassword).withMessageAction(MessageActionType.SUPPRESS);
        }
        try {
            this.cognitoClient.adminCreateUser(request);
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (String)"Could not create user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            throw new ServiceException((Throwable)e);
        }
        if (!StringUtils.isNullOrEmpty((String)password)) {
            try {
                this.authenticateUser(name, tmpPassword, password);
            }
            catch (Exception e) {
                throw new ServiceException((Throwable)e);
            }
        }
        if (!userRoles.isEmpty()) {
            this.addUserRoles(name, userRoles);
        }
        return this.users.getUser(name, true);
    }

    public User updateUser(User user) throws ServiceException {
        if (!this.isConnected()) {
            ServiceException e = new ServiceException("Not connected");
            e.setReason(ServiceException.Reason.NOT_CONNECTED);
            throw e;
        }
        String name = user.getName();
        User cUser = this.getUser(name, true);
        if (cUser == null) {
            throw new ServiceException(Localise.format((String)"user does not exist"));
        }
        for (String role : user.getRoles()) {
            ArrayList<String> missingRoles = new ArrayList<String>();
            if (!this.roles.isRole(role) && cUser.hasRole(role)) {
                missingRoles.add(role);
            }
            if (missingRoles.isEmpty()) continue;
            throw new ServiceException(Localise.format((String)"role/s %s dot not exist", (Object[])new Object[]{StringUtils.join((String)" ", missingRoles)}));
        }
        AdminUpdateUserAttributesRequest request = new AdminUpdateUserAttributesRequest().withUserPoolId(this.poolId).withUsername(name).withUserAttributes(this.getUserAttributes(user));
        try {
            this.cognitoClient.adminUpdateUserAttributes(request);
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (String)"Could not update attribute of user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            throw new ServiceException((Throwable)e);
        }
        Set roleSet = CollectionUtils.not((Collection)user.getRoles(), (Collection)cUser.getRoles());
        if (!roleSet.isEmpty()) {
            this.addUserRoles(name, roleSet);
        }
        if (!(roleSet = CollectionUtils.not((Collection)cUser.getRoles(), (Collection)user.getRoles())).isEmpty()) {
            this.removeUserRoles(name, roleSet);
        }
        return this.users.getUser(name, true);
    }

    public boolean deleteUser(String name) throws ServiceException {
        if (!this.isConnected()) {
            ServiceException e = new ServiceException("Not connected");
            e.setReason(ServiceException.Reason.NOT_CONNECTED);
            throw e;
        }
        User user = this.getUser(name);
        if (user == null) {
            return false;
        }
        AdminDeleteUserRequest request = new AdminDeleteUserRequest().withUserPoolId(this.poolId).withUsername(name);
        try {
            this.cognitoClient.adminDeleteUser(request);
        }
        catch (Exception e) {
            Localise.logError((Logger)logger, (String)"Unexpected exception deleting user %1$s - %2$s", (Object[])new Object[]{name, e.getMessage()});
            throw new ServiceException((Throwable)e);
        }
        this.users.deleteUser(user);
        return true;
    }

    private Collection<AttributeType> getUserAttributes(User user) {
        Name home;
        Map properties;
        ArrayList<AttributeType> attributes = new ArrayList<AttributeType>();
        attributes.add(new AttributeType().withName(ATTRIBUTE_EMAIL).withValue(user.getName()));
        attributes.add(new AttributeType().withName(ATTRIBUTE_FIRST_NAME).withValue(user.getProperty("firstName")));
        attributes.add(new AttributeType().withName(ATTRIBUTE_LAST_NAME).withValue(user.getProperty("lastName")));
        JSONObject json = new JSONObject();
        String value = user.getDescription();
        if (!StringUtils.isNullOrEmpty((String)value)) {
            json.put("description", (Object)value);
        }
        if (!(properties = user.getProperties()).isEmpty()) {
            json.put("properties", properties);
        }
        if ((home = user.getHome()) != null) {
            json.put("home", (Object)home.toString());
        }
        if (user.hasLicense()) {
            json.put("license", (Object)user.getLicense().toJSON());
        }
        if (json.length() > 0) {
            attributes.add(new AttributeType().withName(ATTRIBUTE_DATA).withValue(json.toString()));
        }
        return attributes;
    }

    private void addUserRoles(String userName, Collection<String> userRoles) throws ServiceException {
        AdminAddUserToGroupRequest request = new AdminAddUserToGroupRequest().withUserPoolId(this.poolId).withUsername(userName);
        for (String role : userRoles) {
            request.setGroupName(role);
            try {
                this.cognitoClient.adminAddUserToGroup(request);
                this.roles.addMember(role, userName);
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format((String)"could not add %s to role %s - %s", (Object[])new Object[]{userName, role, e.getMessage()}));
            }
        }
    }

    private void removeUserRoles(String userName, Collection<String> userRoles) throws ServiceException {
        AdminRemoveUserFromGroupRequest request = new AdminRemoveUserFromGroupRequest().withUserPoolId(this.poolId).withUsername(userName);
        for (String role : userRoles) {
            request.setGroupName(role);
            try {
                this.cognitoClient.adminRemoveUserFromGroup(request);
                this.roles.removeMember(role, userName);
            }
            catch (Exception e) {
                throw new ServiceException(Localise.format((String)"could not remove %s from role %s - %s", (Object[])new Object[]{userName, role, e.getMessage()}));
            }
        }
    }

    public Role getRole(String name) {
        return this.roles.getRole(name);
    }

    public Set<Role> getRoles(Filter filter) {
        TreeSet<Role> roleSet = new TreeSet<Role>();
        for (Role role : this.roles.getRoles()) {
            if (filter != null && !filter.matches(role.getName())) continue;
            roleSet.add(role);
        }
        return roleSet;
    }

    public boolean isRole(String name) {
        return this.roles.isRole(name);
    }

    public void refresh() {
        Localise.logInfo((Logger)logger, (String)"Refreshing AWS cognito service", (Object[])new Object[0]);
        this.roles.updateCache(true);
        this.users.updateCache(true);
    }

    private String calculataSecretHash(String userName) {
        return AWSUserService.calculateSecretHash(this.clientResetId, this.clientResetSecret, userName);
    }

    private static String calculateSecretHash(String userPoolClientId, String userPoolClientSecret, String userName) {
        String HMAC_SHA256_ALGORITHM = "HmacSHA256";
        SecretKeySpec signingKey = new SecretKeySpec(userPoolClientSecret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            mac.update(userName.getBytes(StandardCharsets.UTF_8));
            byte[] rawHmac = mac.doFinal(userPoolClientId.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(rawHmac);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while calculating ");
        }
    }

    private class RoleCache {
        private Map<String, Role> roles;
        private Map<String, Set<String>> roleUsers;
        private long cacheExpiry = 0L;
        private Lock lock;

        public RoleCache(HazelcastInstance hazelcast) {
            if (hazelcast != null) {
                this.roles = hazelcast.getMap("service.cognito.roles");
                this.roleUsers = hazelcast.getMap("service.cognito.role.users");
                this.lock = hazelcast.getLock("service.cognito.roles.lock");
            } else {
                this.roles = new HashMap<String, Role>();
                this.roleUsers = new HashMap<String, Set<String>>();
                this.lock = new ReentrantLock();
            }
        }

        public boolean isRole(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                boolean bl = this.roles.containsKey(name);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Role getRole(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                Role role = this.roles.get(name);
                return role;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Collection<Role> getRoles() {
            this.lock.lock();
            try {
                this.updateCache(false);
                Collection<Role> collection = this.roles.values();
                return collection;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> getRoles(String userName) {
            this.lock.lock();
            try {
                this.updateCache(false);
                HashSet<String> groups = new HashSet<String>();
                for (String group : this.roleUsers.keySet()) {
                    if (!this.roleUsers.get(group).contains(userName)) continue;
                    groups.add(group);
                }
                HashSet<String> hashSet = groups;
                return hashSet;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void addMember(String roleName, String userName) {
            this.lock.lock();
            try {
                this.updateCache(false);
                this.roleUsers.get(roleName).add(userName);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void removeMember(String roleName, String userName) {
            this.lock.lock();
            try {
                this.updateCache(false);
                this.roleUsers.get(roleName).remove(userName);
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(boolean force) {
            block8: {
                if (!AWSUserService.this.isConnected()) {
                    return;
                }
                this.lock.lock();
                try {
                    if (!force && System.currentTimeMillis() <= this.cacheExpiry) break block8;
                    this.roles.clear();
                    this.roleUsers.clear();
                    ListGroupsRequest groupsRequest = new ListGroupsRequest().withUserPoolId(AWSUserService.this.poolId);
                    try {
                        for (GroupType cGroup : AWSUserService.this.cognitoClient.listGroups(groupsRequest).getGroups()) {
                            String groupName = cGroup.getGroupName();
                            this.roles.put(groupName, new Role(groupName, cGroup.getDescription()));
                            HashSet<String> userNames = new HashSet<String>();
                            ListUsersInGroupRequest membersRequest = new ListUsersInGroupRequest().withUserPoolId(AWSUserService.this.poolId).withGroupName(groupName);
                            for (UserType cUser : AWSUserService.this.cognitoClient.listUsersInGroup(membersRequest).getUsers()) {
                                userNames.add(cUser.getUsername());
                            }
                            this.roleUsers.put(groupName, userNames);
                        }
                    }
                    catch (Exception e) {
                        Localise.logError((Logger)logger, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    }
                    this.cacheExpiry = System.currentTimeMillis() + AWSUserService.this.cachePeriod;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
    }

    private class UserCache {
        private Map<String, User> users;
        private long cacheExpiry = 0L;
        private Lock lock;

        public UserCache(HazelcastInstance hazelcast) {
            if (hazelcast != null) {
                this.users = hazelcast.getMap("service.cognito.users");
                this.lock = hazelcast.getLock("service.cognito.users.lock");
            } else {
                this.users = new HashMap<String, User>();
                this.lock = new ReentrantLock();
            }
        }

        public boolean isUser(String name) {
            this.lock.lock();
            try {
                this.updateCache(false);
                boolean bl = this.users.containsKey(name);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public User getUser(String name, boolean ignoreCache) {
            this.lock.lock();
            try {
                User user = this.users.get(name);
                if ((user == null || ignoreCache || System.currentTimeMillis() > this.cacheExpiry) && AWSUserService.this.isConnected()) {
                    AdminGetUserRequest request = new AdminGetUserRequest().withUserPoolId(AWSUserService.this.poolId).withUsername(name);
                    try {
                        AdminGetUserResult cUser = AWSUserService.this.cognitoClient.adminGetUser(request);
                        user = this.createUser(cUser.getUsername(), cUser.isEnabled(), cUser.getUserStatus(), cUser.getUserAttributes());
                    }
                    catch (ResourceNotFoundException cUser) {
                    }
                    catch (Exception e) {
                        Localise.logError((Logger)logger, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    }
                }
                User user2 = user;
                return user2;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Collection<User> getUsers() {
            this.lock.lock();
            try {
                this.updateCache(false);
                Collection<User> collection = this.users.values();
                return collection;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCache(boolean force) {
            block7: {
                if (!AWSUserService.this.isConnected()) {
                    return;
                }
                this.lock.lock();
                try {
                    if (!force && System.currentTimeMillis() <= this.cacheExpiry) break block7;
                    this.users.clear();
                    ListUsersRequest request = new ListUsersRequest().withUserPoolId(AWSUserService.this.poolId);
                    try {
                        for (UserType cUser : AWSUserService.this.cognitoClient.listUsers(request).getUsers()) {
                            this.createUser(cUser.getUsername(), cUser.isEnabled(), cUser.getUserStatus(), cUser.getAttributes());
                        }
                    }
                    catch (Exception e) {
                        Localise.logError((Logger)logger, (String)"Unexpected exception - %1$s", (Object[])new Object[]{e.getMessage()});
                    }
                    this.cacheExpiry = System.currentTimeMillis() + AWSUserService.this.cachePeriod;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean deleteUser(User user) {
            this.lock.lock();
            try {
                String name = user.getName();
                for (String role : user.getRoles()) {
                    AWSUserService.this.roles.removeMember(role, name);
                }
                boolean bl = this.users.remove(name) != null;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        private User createUser(String userName, boolean enabled, String status, List<AttributeType> attributes) {
            String firstName = "";
            String lastName = "";
            User user = new User(userName);
            user.setOsUser(false);
            for (AttributeType attribute : attributes) {
                String name = attribute.getName();
                String value = attribute.getValue();
                switch (name) {
                    case "given_name": {
                        firstName = value;
                        break;
                    }
                    case "family_name": {
                        lastName = value;
                        break;
                    }
                    case "custom:data": {
                        JSONObject json = new JSONObject(value);
                        user.setDescription(json.optString("description"));
                        if (json.has("properties")) {
                            JSONObject p = json.getJSONObject("properties");
                            for (String key : JSONObject.getNames((JSONObject)p)) {
                                user.setProperty(key, (Object)p.getString(key));
                            }
                        }
                        if (json.has("home")) {
                            try {
                                user.setHome(new Name(json.getString("home")));
                            }
                            catch (URISyntaxException e) {
                                throw new JSONException(Localise.format((String)"invalid %1$s - %2$s - %3$s", (Object[])new Object[]{"home", json.get("home").toString(), e.getMessage()}));
                            }
                        }
                        if (!json.has("license")) break;
                        user.setLicense(new License().fromJSON(json.getJSONObject("license")));
                    }
                }
            }
            user.setProperty("firstName", (Object)firstName);
            user.setProperty("lastName", (Object)lastName);
            if (StringUtils.isNullOrEmpty((String)user.getDescription())) {
                user.setDescription(user.getFullName());
            }
            if (!enabled) {
                user.setStatus(User.Status.DISABLED);
            } else if ("FORCE_CHANGE_PASSWORD".equals(status)) {
                user.setStatus(User.Status.EXPIRED);
            } else if ("UNCONFIRMED".equals(status)) {
                user.setStatus(User.Status.UNVERIFIED);
            }
            user.addRoles(AWSUserService.this.roles.getRoles(userName));
            this.users.put(userName, user);
            return user;
        }
    }
}

