/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.util.regex.Pattern;

public class CardUtils {
    private static Pattern regexCvc = Pattern.compile("^[0-9]{3,4}$");

    public static boolean isNumber(String value) {
        return value.matches("^[0-9 -]+$");
    }

    public static boolean validateNumber(String value) {
        String number = value.replace("-", "").replace(" ", "");
        if (CardUtils._getCardType(number) == Type.UNKNOWN) {
            return false;
        }
        return CardUtils.validateLuhn(number);
    }

    public static Type getCardType(String value) {
        return CardUtils._getCardType(value.replace("-", "").replace(" ", ""));
    }

    private static Type _getCardType(String number) {
        int length = number.length();
        if ((length == 13 || length == 16) && number.startsWith("4")) {
            return Type.VISA;
        }
        if (length == 16 && Integer.parseInt(number.substring(0, 2)) >= 51 && Integer.parseInt(number.substring(0, 2)) <= 55) {
            return Type.MASTERCARD;
        }
        if (length == 15 && (number.startsWith("34") || number.startsWith("37"))) {
            return Type.AMEX;
        }
        if (length == 16 && number.startsWith("6011")) {
            return Type.DISCOVER;
        }
        if (length == 14 && (number.startsWith("36") || number.startsWith("38") || Integer.parseInt(number.substring(0, 3)) >= 300 && Integer.parseInt(number.substring(0, 3)) <= 305)) {
            return Type.DINERS;
        }
        if (length == 16 && Integer.parseInt(number.substring(0, 4)) >= 3528 && Integer.parseInt(number.substring(0, 4)) <= 3589) {
            return Type.JCB;
        }
        return Type.UNKNOWN;
    }

    public static boolean validateCVC(String value) {
        return regexCvc.matcher(value).matches();
    }

    private static boolean validateLuhn(String numberString) {
        int i;
        char[] charArray = numberString.toCharArray();
        int[] number = new int[charArray.length];
        int total = 0;
        for (i = 0; i < charArray.length; ++i) {
            number[i] = Character.getNumericValue(charArray[i]);
        }
        for (i = number.length - 2; i > -1; i -= 2) {
            int n = i;
            number[n] = number[n] * 2;
            if (number[i] <= 9) continue;
            int n2 = i;
            number[n2] = number[n2] - 9;
        }
        for (i = 0; i < number.length; ++i) {
            total += number[i];
        }
        return total % 10 == 0;
    }

    public static enum Type {
        AMEX("American Express"),
        DINERS("Diners Club"),
        DISCOVER("Discover"),
        JCB("JCB"),
        MASTERCARD("MasterCard"),
        VISA("VISA"),
        UNKNOWN("Unknown");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

