/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.neovisionaries.i18n.CountryCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.logging.log4j.Logger;

public class City {
    static final Logger logger = LogUtils.getLogger(City.class);
    public static int MINIMUM_POPULATION = 500000;
    private static Map<String, City> cityIds = new TreeMap<String, City>();
    private static Map<String, City> cityCodes = new TreeMap<String, City>();
    private static Map<String, City> cityNames = new TreeMap<String, City>();
    private static Map<String, City> timeZoneCity = new HashMap<String, City>();
    private String name;
    private String code;
    private CountryCode country;
    private double latitude;
    private double longitude;
    private TimeZone timeZone;
    private int population;

    private City(String name, String code, CountryCode country, double latitude, double longitude, TimeZone timeZone, int population) {
        this.name = name;
        this.code = code;
        this.country = country;
        this.latitude = latitude;
        this.longitude = longitude;
        this.timeZone = timeZone;
        this.population = population;
    }

    public String getId() {
        return this.name + ", " + this.country.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public CountryCode getCountry() {
        return this.country;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getPopulation() {
        return this.population;
    }

    public String toString() {
        return String.format("%s, %s", this.name, this.country.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadCities() {
        block24: {
            InputStream data;
            cityIds.clear();
            String dataName = (String)Configs.get("beyondcron.cities.data");
            if (StringUtils.isNullOrEmpty(dataName)) {
                Localise.logFatal(logger, "cityIds data file name not defined - %1$s", "beyondcron.cities.data");
                Program.exit(1);
            }
            if ((data = City.class.getClassLoader().getResourceAsStream(dataName)) == null) {
                Localise.logFatal(logger, "cityIds data file does not exist %1$s", dataName);
                Program.exit(1);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(data));
            String line = in.readLine();
            while (line != null) {
                int population;
                String[] values = line.split("\\t");
                String adminCode = values[7];
                try {
                    population = Integer.parseInt(values[14]);
                }
                catch (NumberFormatException e) {
                    population = 0;
                }
                if (population > MINIMUM_POPULATION || adminCode.equals("PPLC") || adminCode.equals("PPLA")) {
                    try {
                        String id;
                        City c;
                        String code = City.getIataCode(values[3]);
                        City city = new City(values[1], code, CountryCode.getByCode((String)values[8]), Double.parseDouble(values[4]), Double.parseDouble(values[5]), TimeZone.getTimeZone(values[17]), population);
                        City duplicateCity = cityIds.put(city.getId().toLowerCase(), city);
                        if (duplicateCity != null) {
                            Localise.logInfo(logger, "Duplicate cities found - %1$s: %2$s & %3$s:%4$s", duplicateCity.getId(), duplicateCity, city.getId(), city);
                            if (duplicateCity.getPopulation() > population) {
                                cityIds.put(duplicateCity.getId().toLowerCase(), duplicateCity);
                            }
                        }
                        if ((duplicateCity = cityNames.put(city.getName().toLowerCase(), city)) != null && duplicateCity.getPopulation() > population) {
                            cityNames.put(duplicateCity.getName().toLowerCase(), duplicateCity);
                        }
                        if (code != null && (duplicateCity = cityCodes.put(code, city)) != null) {
                            Localise.logInfo(logger, "Duplicate iata code cityIds found - %1$s: %2$s & %3$s", code, duplicateCity, city);
                            if (duplicateCity.getPopulation() > population) {
                                cityCodes.put(code, duplicateCity);
                            }
                        }
                        if ((c = timeZoneCity.get(id = city.getTimeZone().getID())) == null || c.getPopulation() < city.getPopulation()) {
                            timeZoneCity.put(id, city);
                        }
                    }
                    catch (NumberFormatException e) {
                        Localise.logError(logger, "Invalid latitude/longitude in %1$s", line);
                    }
                }
                line = in.readLine();
            }
            try {
                data.close();
            }
            catch (IOException e) {
                Localise.logError(logger, "Could not close data file %1$s - %2$s", dataName, e.getMessage());
            }
            break block24;
            catch (IOException e) {
                try {
                    Localise.logFatal(logger, "Problem reading cityIds file %1$s - %2$", dataName, e.getMessage());
                }
                catch (Throwable throwable) {
                    try {
                        data.close();
                    }
                    catch (IOException e2) {
                        Localise.logError(logger, "Could not close data file %1$s - %2$s", dataName, e2.getMessage());
                    }
                    throw throwable;
                }
                try {
                    data.close();
                }
                catch (IOException e3) {
                    Localise.logError(logger, "Could not close data file %1$s - %2$s", dataName, e3.getMessage());
                }
            }
        }
    }

    private static String getIataCode(String names) {
        for (String name : names.split(",")) {
            if (name.length() != 3 || !name.equals(name.toUpperCase())) continue;
            return name;
        }
        return null;
    }

    public static Set<String> getIDs() {
        return cityIds.keySet();
    }

    public static Set<String> getCodes() {
        return cityCodes.keySet();
    }

    public static Set<String> getNames() {
        return cityNames.keySet();
    }

    public static Collection<City> getValues() {
        return cityIds.values();
    }

    public static City getCity() {
        City city = City.getCityByTimeZone(TimeZone.getDefault().getID());
        if (city == null) {
            city = (City)cityIds.values().toArray()[new Random().nextInt(cityIds.size())];
        }
        return city;
    }

    public static City getCity(String name) {
        City city = City.getCityByID(name);
        if (city == null && (city = City.getCityByName(name)) == null) {
            city = City.getCityByCode(name);
        }
        return city;
    }

    public static City getCityByID(String id) {
        return cityIds.get(id.toLowerCase());
    }

    public static City getCityByCode(String code) {
        return cityCodes.get(code.toUpperCase());
    }

    public static City getCityByName(String name) {
        return cityNames.get(name.toLowerCase());
    }

    public static City getCityByTimeZone(String id) {
        return timeZoneCity.get(id);
    }

    static {
        City.loadCities();
    }
}

