/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.Period;
import com.beyondcron.core.Service;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import java.util.Map;

public abstract class ConfigService
extends Service {
    @StringConfig.Annotation(startup=true)
    public static final String CONFIG_CONFIG_SERVICE = "BEYONDCRON_CONFIG_SERVICE";
    @PeriodConfig.Annotation(defaultValue="2 minutes", minUnit=Period.Unit.MINUTE, startup=true)
    public static final String CONFIG_CONFIG_SERVICE_CONNECT_RETRY = "BEYONDCRON_CONFIG_SERVICE_CONNECT_RETRY";
    private static ConfigService service = null;

    public static ConfigService getService() throws ServiceException {
        String name;
        String className;
        if (service == null && !StringUtils.isNullOrEmpty(className = Service.getClassName(name = (String)Configs.get(CONFIG_CONFIG_SERVICE), Service.Type.CONFIG))) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                try {
                    clazz = Class.forName(Service.getClassName(StringUtils.capitalise(name), Service.Type.CONFIG));
                }
                catch (ClassNotFoundException | NoClassDefFoundError e1) {
                    try {
                        clazz = Class.forName(Service.getClassName(name.toUpperCase(), Service.Type.CONFIG));
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e2) {
                        throw new ServiceException(Localise.format("Config service class does not exist - %s", className));
                    }
                }
            }
            catch (ClassCastException e) {
                throw new ServiceException(Localise.format("class does not implement ConfigService - %s", className));
            }
            try {
                service = (ConfigService)clazz.newInstance();
                Configs.addConfigs(clazz);
                service.connect();
            }
            catch (Exception e) {
                if (e instanceof ServiceException) {
                    throw (ServiceException)e;
                }
                throw new ServiceException(Localise.format("could not load config service %s - %s", className, e.getMessage()), e);
            }
        }
        return service;
    }

    protected ConfigService(String name) {
        super(Service.Type.CONFIG, name, false);
    }

    public abstract Map<String, String> getProperties() throws ServiceException;

    public abstract String getProperty(String var1) throws ServiceException;

    public abstract String setProperty(String var1, String var2) throws ServiceException;

    public abstract String setProperty(String var1, String var2, String var3) throws ServiceException;
}

