/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.ConfigService;
import com.beyondcron.core.FileUtils;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.Program;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.config.BooleanConfig;
import com.beyondcron.core.config.Config;
import com.beyondcron.core.config.DoubleConfig;
import com.beyondcron.core.config.IntegerConfig;
import com.beyondcron.core.config.PeriodConfig;
import com.beyondcron.core.config.StringConfig;
import com.beyondcron.messaging.Hazelcast;
import com.beyondcron.messaging.MessageSerializer;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.EntryRemovedListener;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Configs {
    static final Logger logger = LogUtils.getLogger(Configs.class);
    private static ConfigService service = null;
    private static Map<String, Config> configsCache = new TreeMap<String, Config>();
    private static HazelcastInstance hazelcast = null;
    private static IMap<String, Config> configsCluster = null;
    private static Map<String, List<ConfigListener>> configListeners = new HashMap<String, List<ConfigListener>>();
    public static final String BEYONDCRON_NAME = "BeyondCron";
    public static final String BEYONDCRON_PREFIX = "beyondcron";
    public static final String BEYONDCRON_ABBREV = "bc";
    @IntegerConfig.Annotation(startup=true, minValue=0, hidden=true)
    public static final String BEYONDCRON_TEST = "BEYONDCRON_TEST";
    public static final String PASSWORD_FILE_PREFIX = "file:";
    @StringConfig.Annotation(regex="(?s).*", startup=true)
    public static final String HAZELCAST_SERVER_CONFIG = "HAZELCAST_CONFIG";
    @StringConfig.Annotation(regex="(?s).*", startup=true)
    public static final String HAZELCAST_CLIENT_CONFIG = "HAZELCAST_CLIENT_CONFIG";
    public static final String QUARTZ_PREFIX = "org.quartz.";
    @StringConfig.Annotation(defaultValue="org.quartz.simpl.SimpleThreadPool")
    public static final String QUARTZ_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    @IntegerConfig.Annotation(defaultValue=10, minValue=1)
    public static final String QUARTZ_THREAD_POOL_COUNT = "org.quartz.threadPool.threadCount";
    @IntegerConfig.Annotation(defaultValue=4000, minValue=10)
    public static final String QUARTZ_THREAD_JOBS = "quartz.thread.jobs";
    public static final String HAZELCAST_PHONE_HOME = "hazelcast.phone.home.enabled";
    @IntegerConfig.Annotation(startup=true)
    public static final String HAZELCAST_AGENT_CONNECTION_ATTEMPT_LIMIT = "HAZELCAST_AGENT_CONNECTION_ATTEMPT_LIMIT";
    @PeriodConfig.Annotation(defaultValue="10 seconds", startup=true)
    public static final String HAZELCAST_AGENT_CONNECTION_ATTEMPT_PERIOD = "HAZELCAST_AGENT_CONNECTION_ATTEMPT_PERIOD";
    @IntegerConfig.Annotation(defaultValue=10, minValue=0, startup=true)
    public static final String HAZELCAST_CLIENT_CONNECTION_ATTEMPT_LIMIT = "HAZELCAST_CLIENT_CONNECTION_ATTEMPT_LIMIT";
    @PeriodConfig.Annotation(defaultValue="1 second", startup=true)
    public static final String HAZELCAST_CLIENT_CONNECTION_ATTEMPT_PERIOD = "HAZELCAST_CLIENT_CONNECTION_ATTEMPT_PERIOD";
    @IntegerConfig.Annotation(startup=true)
    public static final String HAZELCAST_WEB_CONNECTION_ATTEMPT_LIMIT = "HAZELCAST_WEB_CONNECTION_ATTEMPT_LIMIT";
    @PeriodConfig.Annotation(defaultValue="10 seconds", startup=true)
    public static final String HAZELCAST_WEB_CONNECTION_ATTEMPT_PERIOD = "HAZELCAST_WEB_CONNECTION_ATTEMPT_PERIOD";
    @StringConfig.Annotation(defaultValue="{{ dir.tmp }}/beyondcron.{{ job.name encode }}.log")
    public static final String FILE_LOG = "beyondcron.file.log";
    @StringConfig.Annotation(defaultValue="{{ dir.tmp }}/beyondcron.{{ job.name encode }}.{{ job.user }}.log")
    public static final String FILE_LOG_USER = "beyondcron.file.log.user";
    @StringConfig.Annotation(defaultValue="{{ dir.tmp }}/beyondcron.{{ job.name encode }}.%1$s.log")
    public static final String FILE_LOG_TAGGED = "beyondcron.file.log.tagged";
    public static final String FILE_LOG_FAILSAFE = "beyondcron.%1$s.log";
    @StringConfig.Annotation(regex=".+", startup=true, hidden=true)
    public static final String CONFIG_DIR_CONFIG = "BEYONDCRON_CONFIG_DIR";
    @StringConfig.Annotation(regex=".+", startup=true)
    public static final String CONFIG_DIR_DATA = "BEYONDCRON_DATA_DIR";
    @StringConfig.Annotation(defaultValue="/tmp/beyondcron.running", regex=".+", startup=true)
    public static final String CONFIG_RUNNING_FILE = "BEYONDCRON_RUNNING_FILE";
    @BooleanConfig.Annotation(startup=true, hidden=true)
    public static final String CONFIG_EARLY_ACCESS = "BEYONDCRON_EARLY_ACCESS";
    public static final String EARLY_ACCESS = "eap";
    @StringConfig.Annotation(regex="(?s).*", system=true)
    public static final String CONFIG_LICENSE = "beyondcron.license";
    public static final String LICENSE_FILE = "license.yaml";
    public static final String TEMPORARY_LICENSE_FILE = "/tmp/license.yaml";
    public static final String LICENSE_EXPIRY_FILE = "~/.beyondcron_license_expiry";
    @IntegerConfig.Annotation(defaultValue=28, minValue=0)
    public static final String CONFIG_LICENSE_EXPIRY_WARNING = "beyondcron.license.expiry.warning";
    @StringConfig.Annotation(defaultValue="WINCH")
    public static final String CONFIG_SIGNAL_STOP = "beyondcron.signal.stop";
    @IntegerConfig.Annotation(defaultValue=10000, minValue=1)
    public static final String CONFIG_EXECUTE_ARG_MAX = "beyondcron.execute.arg.max";
    @StringConfig.Annotation(defaultValue="beyondcron", regex=".+", startup=true)
    public static final String CONFIG_CLUSTER_NAME = "BEYONDCRON_CLUSTER_NAME";
    @StringConfig.Annotation(defaultValue="RzMXwzmpu8V3gnRJtEer", regex=".+", secret=true, startup=true)
    public static final String CONFIG_CLUSTER_PASSWORD = "BEYONDCRON_CLUSTER_PASSWORD";
    @PeriodConfig.Annotation(defaultValue="100 milliseconds", minUnit=Period.Unit.MILLISECOND, maxUnit=Period.Unit.MINUTE)
    public static final String CONFIG_SERVICE_DISCONNECT_TIMEOUT = "beyondcron.service.disconnect.timeout";
    @StringConfig.Annotation
    public static final String CONFIG_AGENT_SERVICE = "beyondcron.agent.service";
    @PeriodConfig.Annotation(defaultValue="2 minutes", minUnit=Period.Unit.MINUTE)
    public static final String CONFIG_AGENT_SERVICE_CONNECT_RETRY = "beyondcron.agent.service.connect.retry";
    @PeriodConfig.Annotation(defaultValue="2 minutes", minUnit=Period.Unit.MINUTE)
    public static final String CONFIG_DEFAULT_SERVICE_CONNECT_RETRY = "beyondcron.default.service.connect.retry";
    @StringConfig.Annotation
    public static final String CONFIG_STATUS_SERVICE = "beyondcron.status.service";
    @BooleanConfig.Annotation
    public static final String CONFIG_STATUS_SERVICE_LOG_ALL = "beyondcron.status.service.log.all";
    @PeriodConfig.Annotation(defaultValue="2 minutes", minUnit=Period.Unit.MINUTE)
    public static final String CONFIG_STATUS_SERVICE_CONNECT_RETRY = "beyondcron.status.service.connect.retry";
    @IntegerConfig.Annotation(defaultValue=50, minValue=10)
    public static final String CONFIG_STATUS_SUBSCRIBE_DATE_ROWS = "beyondcron.status.subscribe.date.rows";
    @StringConfig.Annotation
    public static final String CONFIG_TIME_ZONE = "beyondcron.time.zone";
    @StringConfig.Annotation
    public static final String CONFIG_USER_SERVICE = "beyondcron.user.service";
    @BooleanConfig.Annotation
    public static final String CONFIG_USER_SERVICE_USER_CREATE = "beyondcron.user.service.user.create";
    @BooleanConfig.Annotation
    public static final String CONFIG_USER_SERVICE_USER_UPDATE = "beyondcron.user.service.user.update";
    @BooleanConfig.Annotation
    public static final String CONFIG_USER_SERVICE_USER_DELETE = "beyondcron.user.service.user.delete";
    @BooleanConfig.Annotation
    public static final String CONFIG_USER_SERVICE_USER_VALIDATE = "beyondcron.user.service.user.validate";
    @BooleanConfig.Annotation
    public static final String CONFIG_USER_SERVICE_PASSWORD_CHANGE = "beyondcron.user.service.password.change";
    @BooleanConfig.Annotation
    public static final String CONFIG_USER_SERVICE_PASSWORD_RESET = "beyondcron.user.service.password.reset";
    @PeriodConfig.Annotation(defaultValue="2 minutes", minUnit=Period.Unit.MINUTE)
    public static final String CONFIG_USER_SERVICE_CONNECT_RETRY = "beyondcron.user.service.connect.retry";
    @PeriodConfig.Annotation(defaultValue="1 day", minUnit=Period.Unit.MINUTE)
    public static final String CONFIG_VERSIONS_TTL = "beyondcron.versions.ttl";
    @BooleanConfig.Annotation(defaultValue=true, description="Include available unlicensed updates if true, otherwise only include available licensed updates.")
    public static final String CONFIG_UPDATES_LATEST = "beyondcron.updates.latest";
    @StringConfig.Annotation(defaultValue="admin", description="User/roles that should be notified in bc-web of available updates. If empty notifications are disabled.")
    public static final String CONFIG_UPDATES_NOTIFY = "beyondcron.updates.notify";
    @BooleanConfig.Annotation(startup=true)
    public static final String CONFIG_FORCE_START = "BEYONDCRON_FORCE_START";
    @StringConfig.Annotation(defaultValue="BeyondCron % ")
    public static final String COMMAND_PROMPT = "beyondcron.command.prompt";
    @StringConfig.Annotation(initValue="com.beyondcron.core.NetUtils.getUnqualifiedHostName()", startup=true)
    public static final String CONFIG_HOST_NAME = "BEYONDCRON_HOST_NAME";
    @StringConfig.Annotation(startup=true)
    public static final String CONFIG_SERVER_NAMES = "BEYONDCRON_SERVER_NAMES";
    @StringConfig.Annotation(system=true)
    public static final String CONFIG_SERVER_NAMES_ACTIVE = "BEYONDCRON_SERVER_NAMES_ACTIVE";
    @IntegerConfig.Annotation(defaultValue=22, minValue=1)
    public static final String CONFIG_HOST_REACHABLE_PORT = "beyondcron.host.reachable.port";
    @PeriodConfig.Annotation(defaultValue="100 milliseconds", minUnit=Period.Unit.MILLISECOND, maxUnit=Period.Unit.MINUTE)
    public static final String CONFIG_HOST_REACHABLE_TIMEOUT = "beyondcron.host.reachable.timeout";
    @PeriodConfig.Annotation(defaultValue="10 seconds", minUnit=Period.Unit.SECOND, maxUnit=Period.Unit.MINUTE)
    public static final String CONFIG_ICALENDAR_HOST_TIMEOUT = "beyondcron.icalendar.host.timeout";
    @IntegerConfig.Annotation(defaultValue=10, minValue=1, startup=true)
    public static final String CONFIG_SERVICE_UPDATE_ATTEMPTS = "BEYONDCRON_CONFIG_SERVICE_UPDATE\u2013ATTEMPTS";
    @IntegerConfig.Annotation(defaultValue=5701, minValue=1, startup=true)
    public static final String CONFIG_SERVER_PORT = "BEYONDCRON_SERVER_PORT";
    @BooleanConfig.Annotation(defaultValue=true, startup=true)
    public static final String CONFIG_SERVER_ADDRESS_PRIVATE = "BEYONDCRON_SERVER_ADDRESS_PRIVATE";
    @BooleanConfig.Annotation(startup=true)
    public static final String CONFIG_SERVER_ADDRESS_IP6 = "BEYONDCRON_SERVER_ADDRESS_IPV6";
    @StringConfig.Annotation(startup=true)
    public static final String CONFIG_SERVER_ADDRESS_IGNORE = "BEYONDCRON_SERVER_ADDRESS_IGNORE";
    @PeriodConfig.Annotation(defaultValue="5 minutes")
    public static final String CONFIG_CONNECTION_LOCK = "beyondcron.connection.lock";
    @IntegerConfig.Annotation(defaultValue=5)
    public static final String CONFIG_CONNECTION_UNLOCK_ATTEMPTS = "beyondcron.connection.unlock.attempts";
    @PeriodConfig.Annotation(defaultValue="500 milliseconds", minUnit=Period.Unit.MILLISECOND, maxUnit=Period.Unit.MINUTE)
    public static final String CONFIG_CONNECTION_UNLOCK_DELAY = "beyondcron.connection.unlock.delay";
    @IntegerConfig.Annotation(defaultValue=2)
    public static final String CONFIG_CONNECTION_UNLOCK_MULTIPLIER = "beyondcron.connection.unlock.multiplier";
    @PeriodConfig.Annotation(defaultValue="30 minutes", description="The idle time after which bc-cli & bc-web connections are closed. Changing this value affects new connections only.")
    public static final String CONFIG_CONNECTION_CLOSE = "beyondcron.connection.close";
    @IntegerConfig.Annotation(startup=true, minValue=1, maxValue=100, defaultValue=3)
    public static final String CONFIG_NULL_PASSWORD_ATTEMPTS = "BEYONDCRON_NULL_PASSWORD_ATTEMPTS";
    @StringConfig.Annotation(startup=true)
    public static final String CONFIG_USER_NAME = "BEYONDCRON_USER_NAME";
    @StringConfig.Annotation(secret=true, startup=true)
    public static final String CONFIG_USER_PASSWORD = "BEYONDCRON_USER_PASSWORD";
    @StringConfig.Annotation(defaultValue="~/.beyondcron")
    public static final String CONFIG_USER_PASSWORD_DIRECTORY = "beyondcron.user.password.directory";
    @StringConfig.Annotation(defaultValue="kSCABBYYXUCVUOhN7a6J", regex=".+", secret=true, hidden=true)
    public static final String CONFIG_USER_PASSWORD_EXTRA_SALT = "beyondcron.user.password.extra.salt";
    @StringConfig.Annotation(defaultValue="/user/%s")
    public static final String CONFIG_USER_HOME = "beyondcron.user.home";
    @IntegerConfig.Annotation(defaultValue=8080, startup=true)
    public static final String CONFIG_HTTP_PORT = "BEYONDCRON_HTTP_PORT";
    @StringConfig.Annotation(startup=true)
    public static final String CONFIG_WAR_FILE = "BEYONDCRON_WAR_FILE";
    @StringConfig.Annotation(defaultValue="admin", hidden=true)
    public static final String CONFIG_ADMIN_ROLE_NAME = "beyondcron.admin.role.name";
    @StringConfig.Annotation(defaultValue="BeyondCron administrator access", hidden=true)
    public static final String CONFIG_ADMIN_ROLE_DESCRIPTION = "beyondcron.admin.role.description";
    @BooleanConfig.Annotation(defaultValue=true, hidden=true)
    public static final String CONFIG_ADMIN_ROLE_LICENSE_REQUIRED = "beyondcron.admin.role.license.required";
    @StringConfig.Annotation(defaultValue="admin", hidden=true)
    public static final String CONFIG_ADMIN_USER_NAME = "beyondcron.admin.user.name";
    @StringConfig.Annotation(defaultValue="BeyondCron administrator", hidden=true)
    public static final String CONFIG_ADMIN_USER_DESCRIPTION = "beyondcron.admin.user.description";
    @StringConfig.Annotation(defaultValue="iT7ZKvoD7NQxUkiMkjhw", secret=true, hidden=true)
    public static final String CONFIG_ADMIN_USER_SALT = "beyondcron.admin.user.salt";
    @StringConfig.Annotation(defaultValue="agent", hidden=true)
    public static final String CONFIG_AGENT_ROLE_NAME = "beyondcron.agent.role.name";
    @StringConfig.Annotation(defaultValue="BeyondCron agent access", hidden=true)
    public static final String CONFIG_AGENT_ROLE_DESCRIPTION = "beyondcron.agent.role.description";
    @BooleanConfig.Annotation(startup=true)
    public static final String CONFIG_AGENT_LOCAL = "BEYONDCRON_AGENT_LOCAL";
    @StringConfig.Annotation(defaultValue="agent", startup=true, hidden=true)
    public static final String CONFIG_AGENT_USER_NAME = "BEYONDCRON_AGENT_USER_NAME";
    @StringConfig.Annotation(defaultValue="BeyondCron agent", startup=true, hidden=true)
    public static final String CONFIG_AGENT_USER_DESCRIPTION = "BEYONDCRON_AGENT_USER_DESCRIPTION";
    @StringConfig.Annotation(defaultValue="hnd4tYcvpTzyMcwiD0DZ", regex=".+", secret=true, startup=true, hidden=true)
    public static final String CONFIG_AGENT_USER_PASSWORD = "BEYONDCRON_AGENT_USER_PASSWORD";
    @StringConfig.Annotation(defaultValue="web", hidden=true)
    public static final String CONFIG_WEB_ROLE_NAME = "beyondcron.web.role.name";
    @StringConfig.Annotation(defaultValue="BeyondCron web access", hidden=true)
    public static final String CONFIG_WEB_ROLE_DESCRIPTION = "beyondcron.web.role.description";
    @StringConfig.Annotation(defaultValue="web", startup=true, hidden=true)
    public static final String CONFIG_WEB_USER_NAME = "BEYONDCRON_WEB_USER_NAME";
    @StringConfig.Annotation(defaultValue="BeyondCron web", startup=true, hidden=true)
    public static final String CONFIG_WEB_USER_DESCRIPTION = "BEYONDCRON_WEB_USER_DESCRIPTION";
    @StringConfig.Annotation(defaultValue="hnd4tYcupTzyNCwiD0DZ", regex=".+", secret=true, startup=true, hidden=true)
    public static final String CONFIG_WEB_USER_PASSWORD = "BEYONDCRON_WEB_USER_PASSWORD";
    @StringConfig.Annotation
    public static final String CONFIG_ENVIRONMENT_NAME = "beyondcron.environment.name";
    @StringConfig.Annotation(defaultValue="default", regex="(default|yellow|red|purple|blue|green|black|grey)")
    public static final String CONFIG_ENVIRONMENT_THEME = "beyondcron.environment.theme";
    @IntegerConfig.Annotation(defaultValue=25, minValue=10, maxValue=90)
    public static final String CONFIG_WEB_PANEL_SPLIT_1 = "beyondcron.web.panel.split.1";
    @IntegerConfig.Annotation(defaultValue=50, minValue=10, maxValue=90)
    public static final String CONFIG_WEB_PANEL_SPLIT_2 = "beyondcron.web.panel.split.2";
    @StringConfig.Annotation(initValue="com.beyondcron.core.NetUtils.getUnqualifiedHostName()", startup=true)
    public static final String CONFIG_AGENT_HOST_NAME = "BEYONDCRON_AGENT_HOST_NAME_URL";
    @IntegerConfig.Annotation(defaultValue=100, minValue=1, description="Number of ssh commands that each bc-agent will try to execute simultaneously. If set too high, jobs are likely to fail due bc-agent being unable to fork.")
    public static final String CONFIG_AGENT_SSH_THREADS = "beyondcron.agent.ssh.threads";
    @BooleanConfig.Annotation(hidden=true)
    public static final String CONFIG_BENCHMARK_START = "beyondcron.benchmark.start";
    @IntegerConfig.Annotation(defaultValue=512, minValue=0)
    public static final String CONFIG_OUTPUT_LINES_HEAD = "beyondcron.output.lines.head";
    @IntegerConfig.Annotation(defaultValue=512, minValue=0)
    public static final String CONFIG_OUTPUT_LINES_TAIL = "beyondcron.output.lines.tail";
    @IntegerConfig.Annotation(defaultValue=1024, minValue=10)
    public static final String CONFIG_OUTPUT_LINE_LENGTH = "beyondcron.output.line.length";
    @StringConfig.Annotation(defaultValue=" ...")
    public static final String CONFIG_OUTPUT_LINE_TRUNCATED_SUFFIX = "beyondcron.output.line.truncated.suffix";
    @StringConfig.Annotation(defaultValue="\n...\n")
    public static final String CONFIG_OUTPUT_SEPARATOR = "beyondcron.output.separator";
    @PeriodConfig.Annotation(defaultValue="55 minutes", minUnit=Period.Unit.MINUTE)
    public static final String CONFIG_CALENDAR_UPDATE_SCHEDULE = "beyondcron.calendar.update";
    @StringConfig.Annotation(defaultValue="everyone", hidden=true)
    public static final String CONFIG_EVERYONE_ROLE_NAME = "beyondcron.everyone.role.name";
    @StringConfig.Annotation(defaultValue="All users automatically belong to this role.", hidden=true)
    public static final String CONFIG_EVERYONE_ROLE_DESCRIPTION = "beyondcron.everyone.role.description";
    @BooleanConfig.Annotation
    public static final String CONFIG_GUEST_USER_ACCESS = "beyondcron.guest.user.access";
    @StringConfig.Annotation(defaultValue="guest")
    public static final String CONFIG_GUEST_USER_NAME = "beyondcron.guest.user.name";
    @StringConfig.Annotation(defaultValue="Guest user")
    public static final String CONFIG_GUEST_USER_DESCRIPTION = "beyondcron.guest.user.description";
    @StringConfig.Annotation(defaultValue="guest", regex=".+", secret=true)
    public static final String CONFIG_GUEST_USER_PASSWORD = "beyondcron.guest.user.password";
    @StringConfig.Annotation(defaultValue="localhost 127.0.0.1", description="This config is only used when no protected hosts are defined.")
    public static final String CONFIG_PROTECTED_HOSTS = "beyondcron.protected.hosts";
    @StringConfig.Annotation(defaultValue="root", description="This config is only used when no protected users are defined.")
    public static final String CONFIG_PROTECTED_USERS = "beyondcron.protected.users";
    @StringConfig.Annotation(defaultValue="server", hidden=true)
    public static final String CONFIG_SERVER_ROLE_NAME = "beyondcron.server.role.name";
    @StringConfig.Annotation(defaultValue="BeyondCron server access", hidden=true)
    public static final String CONFIG_SERVER_ROLE_DESCRIPTION = "beyondcron.server.role.description";
    @StringConfig.Annotation(defaultValue="server", startup=true, hidden=true)
    public static final String CONFIG_SERVER_USER_NAME = "BEYONDCRON_SERVER_USER_NAME";
    @StringConfig.Annotation(defaultValue="BeyondCron server", startup=true, hidden=true)
    public static final String CONFIG_SERVER_USER_DESCRIPTION = "BEYONDCRON_SERVER_USER_DESCRIPTION";
    @IntegerConfig.Annotation(defaultValue=10, minValue=1)
    public static final String CONFIG_THREAD_POOL_SIZE_CORE = "beyondcron.thread.pool.size.core";
    @IntegerConfig.Annotation(defaultValue=1000, minValue=1)
    public static final String CONFIG_THREAD_POOL_SIZE_MAX = "beyondcron.thread.pool.size.max";
    @PeriodConfig.Annotation(defaultValue="30 seconds")
    public static final String CONFIG_THREAD_POOL_THREAD_TIMEOUT = "beyondcron.thread.pool.thread.timeout";
    @StringConfig.Annotation(defaultValue="geonames/cities15000.txt")
    public static final String CONFIG_CITIES_DATA = "beyondcron.cities.data";
    @BooleanConfig.Annotation(defaultValue=true)
    public static final String CONFIG_CHECK_HOSTS_EXIST = "beyondcron.check.hosts.exist";
    @StringConfig.Annotation(defaultValue="^[a-z_]([a-z0-9_-]{0,31}|[a-z0-9_-]{0,30}\\$)@([a-zA-Z0-9]+(-[a-zA-Z0-9]+)*)+(\\.([a-zA-Z0-9]+(-[a-zA-Z0-9]+)*))*$")
    public static final String CONFIG_JOB_USER_HOST_REGEX = "beyondcron.job.user.host.regex";
    @IntegerConfig.Annotation(defaultValue=10)
    public static final String CONFIG_GIT_ABBREV_LENGTH = "beyondcron.git.abbrev.length";
    @StringConfig.Annotation(defaultValue="ssh://%1$s%2$s/")
    public static final String CONFIG_GIT_RESPOSITORY_URL = "beyondcron.git.repository.url";
    @StringConfig.Annotation(defaultValue="/usr/bin/mailx -s '%1$s' %2$s")
    public static final String COMMAND_MAIL = "beyondcron.command.mail";
    @StringConfig.Annotation(defaultValue="localhost")
    public static final String COMMAND_LOCALHOST = "beyondcron.command.localhost";
    @StringConfig.Annotation(defaultValue="/bin/bash")
    public static final String COMMAND_BASH = "beyondcron.command.bash";
    @StringConfig.Annotation(defaultValue="ping -c 1 %1$s", startup=true)
    public static final String COMMAND_PING = "BEYONDCRON_PING_COMMAND";
    @PeriodConfig.Annotation(defaultValue="100 milliseconds", minUnit=Period.Unit.MILLISECOND, maxUnit=Period.Unit.MINUTE, startup=true)
    public static final String COMMAND_PING_TIMEOUT = "BEYONDCRON_PING_TIMEOUT";
    @StringConfig.Annotation
    public static final String MAIL_SMTP_HOST = "mail.smtp.host";
    @StringConfig.Annotation
    public static final String MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String ENVIRONMENT_TIME_ZONE = "TZ";
    @PeriodConfig.Annotation(defaultValue="60 seconds")
    public static final String JOB_DEFAULT_LIMIT_START = "beyondcron.job.default.limit.start";
    @StringConfig.Annotation(defaultValue="dd/MM/yyyy HH:mm:ss z")
    public static final String VARIABLE_DATE_TIME_FORMAT_FULL = "beyondcron.datetime.format.full";
    @StringConfig.Annotation(defaultValue="dd/MM/yyyy HH:mm:ss")
    public static final String VARIABLE_DATE_TIME_FORMAT = "beyondcron.datetime.format";
    @StringConfig.Annotation(defaultValue="dd/MM/yyyy")
    public static final String VARIABLE_DATE_FORMAT = "beyondcron.date.format";
    @StringConfig.Annotation(defaultValue="^\\s*(\\d{1,2}):(\\d{1,2})(:(\\d{1,2}))?(\\s+(\\d{1,2})/(\\d{1,2})(/(\\d{4})))?\\s*$")
    public static final String VARIABLE_DATE_TIME_REGEX = "beyondcron.datetime.regex";
    public static final String VARIABLE_RANDOM = "random";
    public static final String VARIABLE_TIME = "time";
    @StringConfig.Annotation(defaultValue="HH:mm:ss")
    public static final String VARIABLE_TIME_FORMAT = "beyondcron.time.format";
    public static final String VARIABLE_TIME_FORMAT_DEFAULT = "HH:mm:ss";
    public static final String VARIABLE_DIRECTORY_TEMPORARY = "dir.tmp";
    public static final String VARIABLE_JOB_NAME = "job.name";
    public static final String VARIABLE_JOB_DESCRIPTION = "job.description";
    public static final String VARIABLE_JOB_HOST = "job.host";
    public static final String VARIABLE_JOB_USER = "job.user";
    public static final String VARIABLE_TRIGGER_NAME = "trigger.name";
    public static final String VARIABLE_TRIGGER_RESULT = "trigger.result";
    public static final String VARIABLE_TRIGGER_VALUE = "trigger.value";
    public static final String VARIABLE_TRIGGER_MESSAGE = "trigger.message";
    public static final String VARIABLE_TRIGGER_OUTPUT = "trigger.output";
    public static final String VARIABLE_OPTION_FIRST = "first";
    public static final String VARIABLE_OPTION_LAST = "last";
    public static final String VARIABLE_TRIGGER_TIME = "trigger.time";
    public static final String VARIABLE_TRIGGER_TIME_NEXT = "trigger.time.next";
    public static final String VARIABLE_USER_NAME = "user.name";
    public static final String VARIABLE_OPTION_SHORT = "short";
    public static final String VARIABLE_OPTION_ENCODE = "encode";
    public static final String PARAMETER_PASSWORD = "password";
    @BooleanConfig.Annotation(startup=true, hidden=true)
    public static final String BEYONDCRON_CLOUD = "BEYONDCRON_CLOUD";
    @BooleanConfig.Annotation(defaultValue=true)
    public static final String BEYONDCRON_ECHO = "beyondcron.echo";
    @StringConfig.Annotation(defaultValue="/opt/beyondcron/bin/echo", description="Command used by bc-agent when executing an echo command job.")
    public static final String BEYONDCRON_ECHO_COMMAND = "beyondcron.echo.command";
    @StringConfig.Annotation(defaultValue="http://localhost:8080/echo", description="URL used by bc-agent when executing an echo webhook job.")
    public static final String BEYONDCRON_ECHO_URL = "beyondcron.echo.url";
    public static final String VARIABLE_ECHO_URL = "echo_url";
    @IntegerConfig.Annotation(defaultValue=2, minValue=0, maxValue=3600)
    public static final String VARIABLE_ECHO_RUNTIME_MIN = "echo_run_min";
    @IntegerConfig.Annotation(defaultValue=5, minValue=0, maxValue=3600)
    public static final String VARIABLE_ECHO_RUNTIME_MAX = "echo_run_max";
    @IntegerConfig.Annotation(defaultValue=80, minValue=0, maxValue=100)
    public static final String VARIABLE_ECHO_SUCCESS = "echo_success";
    @StringConfig.Annotation(defaultValue="https://beyondcron.com")
    public static final String BEYONDCRON_URL_HOME = "beyondcron.url.home";
    @StringConfig.Annotation(defaultValue="https://beyondcron.com/downloads")
    public static final String BEYONDCRON_URL_DOWNLOADS = "beyondcron.url.downloads";
    @StringConfig.Annotation(defaultValue="https://beyondcron.com/downloads/releases.txt")
    public static final String BEYONDCRON_URL_RELEASES = "beyondcron.url.releases";
    @StringConfig.Annotation(defaultValue="https://beyondcron.com/store")
    public static final String BEYONDCRON_URL_STORE = "beyondcron.url.store";
    @StringConfig.Annotation(defaultValue="http")
    public static final String BEYONDCRON_DOCS_PROTOCOL = "beyondcron.docs.protocol";
    @StringConfig.Annotation(defaultValue="/docs/")
    public static final String BEYONDCRON_URL_DOCS = "beyondcron.url.docs";
    @StringConfig.Annotation(defaultValue="/docs/reference/cron-entry.html")
    public static final String BEYONDCRON_URL_CRON_ENTRY = "beyondcron.url.cron.entry";
    public static final String BEYONDCRON_URL_DOCS_WINDOW = "bcdocs";
    @StringConfig.Annotation
    public static final String BEYONDCRON_URL_TERMS = "beyondcron.url.terms";
    public static final String BEYONDCRON_URL_TERMS_WINDOW = "bcterms";
    @StringConfig.Annotation(defaultValue="support@beycondcron.com")
    public static final String CONFIG_SUPPORT_EMAIL = "beyondcron.support.email";
    @StringConfig.Annotation
    public static final String BEYONDCRON_SUPPORT_URL = "beyondcron.support.url";
    @StringConfig.Annotation(defaultValue="bcsupport")
    public static final String BEYONDCRON_SUPPORT_URL_WINDOW = "beyondcron.support.url.window";
    @StringConfig.Annotation(defaultValue="Your administrator")
    public static final String BEYONDCRON_SUPPORT_ADMIN = "beyondcron.support.admin";
    @StringConfig.Annotation
    public static final String BEYONDCRON_DESKTOP_LAYOUT = "beyondcron.desktop.layout";
    @BooleanConfig.Annotation(defaultValue=true, hidden=true, description="Select home folder, if defined, on first login.")
    public static final String BEYONDCRON_DESKTOP_HOME_SELECT = "beyondcron.desktop.home.select";

    public static void addConfigs(Class clazz) {
        block6: for (Field f : clazz.getFields()) {
            String name;
            if (f.getType() != String.class) continue;
            try {
                name = (String)f.get(null);
            }
            catch (IllegalAccessException e) {
                Localise.logError(logger, "Unexpected exception reading %1$s - %2$s", f.getName(), e.getMessage());
                continue;
            }
            for (Annotation a : f.getDeclaredAnnotations()) {
                Annotation ca;
                if (a instanceof StringConfig.Annotation) {
                    ca = (StringConfig.Annotation)a;
                    Pattern regexPattern = null;
                    try {
                        regexPattern = Pattern.compile(ca.regex());
                    }
                    catch (PatternSyntaxException e) {
                        Localise.logFatal(logger, "Illegal regex (%1$s) - %2$s", ca.regex(), e.getMessage());
                        Program.exit(1);
                    }
                    StringConfig config = new StringConfig(name, ca.description(), ca.defaultValue(), regexPattern, ca.regexDescription(), ca.initValue(), ca.secret(), ca.startup(), ca.hidden());
                    if (ca.system()) {
                        config.setType(Config.Type.SYSTEM);
                    }
                    Configs.addConfig(config);
                    continue block6;
                }
                if (a instanceof IntegerConfig.Annotation) {
                    ca = (IntegerConfig.Annotation)a;
                    Configs.addConfig(new IntegerConfig(name, ca.description(), ca.defaultValue(), ca.minValue(), ca.maxValue(), ca.secret(), ca.startup(), ca.hidden()));
                    continue block6;
                }
                if (a instanceof DoubleConfig.Annotation) {
                    ca = (DoubleConfig.Annotation)a;
                    Configs.addConfig(new DoubleConfig(name, ca.description(), ca.defaultValue(), ca.minValue(), ca.maxValue(), ca.secret(), ca.startup(), ca.hidden()));
                    continue block6;
                }
                if (a instanceof BooleanConfig.Annotation) {
                    ca = (BooleanConfig.Annotation)a;
                    Configs.addConfig(new BooleanConfig(name, ca.description(), ca.defaultValue(), ca.secret(), ca.startup(), ca.hidden()));
                    continue block6;
                }
                if (!(a instanceof PeriodConfig.Annotation)) continue;
                ca = (PeriodConfig.Annotation)a;
                Period period = null;
                try {
                    period = new Period(ca.defaultValue());
                }
                catch (IllegalArgumentException e) {
                    Localise.logFatal(logger, "Illegal period (%1$s) - %2$s", ca.defaultValue(), e.getMessage());
                    Program.exit(1);
                }
                Configs.addConfig(new PeriodConfig(name, ca.description(), period, ca.minValue(), ca.maxValue(), ca.minUnit(), ca.maxUnit(), ca.secret(), ca.startup(), ca.hidden()));
            }
        }
    }

    public static void addConfig(Config config) {
        Config currentConfig;
        if (config.isStartup()) {
            configsCache.putIfAbsent(config.getName(), Configs.initStartupConfig(config));
            return;
        }
        String name = config.getName();
        Config config2 = currentConfig = configsCluster != null ? (Config)configsCluster.get((Object)name) : configsCache.get(name);
        if (currentConfig != null) {
            if (currentConfig.getType() != Config.Type.USER || config.getType() == Config.Type.USER) {
                return;
            }
            try {
                config.set(currentConfig.getValue().toString(), config.getType());
            }
            catch (IllegalArgumentException e) {
                Localise.logError(logger, "Unexpected exception adding %1$s using default (%2$s) - %3$s", name, currentConfig.getValue(), e.getMessage());
            }
        }
        if (configsCluster != null) {
            configsCluster.putIfAbsent((Object)config.getName(), (Object)config);
        } else {
            configsCache.putIfAbsent(config.getName(), config);
        }
    }

    public static void setConfig(Config config) {
        if (config.isStartup()) {
            configsCache.put(config.getName(), Configs.initStartupConfig(config));
        } else if (configsCluster != null) {
            configsCluster.put((Object)config.getName(), (Object)config);
        } else {
            configsCache.put(config.getName(), config);
        }
    }

    public static void removeConfig(Config config) {
        if (config.getType() != Config.Type.USER) {
            Configs.setConfig(config.unset());
        } else if (configsCluster != null) {
            configsCluster.remove((Object)config.getName());
        } else {
            configsCache.remove(config.getName());
        }
    }

    public static boolean exists(String name) {
        return configsCache.containsKey(name);
    }

    public static Config getConfig(String name) {
        return configsCache.get(name);
    }

    public static List<Config> getConfigs(boolean includeStartup) {
        ArrayList<Config> values = new ArrayList<Config>();
        for (Config config : configsCache.values()) {
            if (config.getType() == Config.Type.SYSTEM || config.isStartup() && !includeStartup) continue;
            values.add(config);
        }
        return values;
    }

    public static List<Config> getConfigs(String prefix, boolean includeStartup) {
        if (StringUtils.isNullOrEmpty(prefix)) {
            return Configs.getConfigs(includeStartup);
        }
        ArrayList<Config> values = new ArrayList<Config>();
        for (Config config : configsCache.values()) {
            if (!config.getName().startsWith(prefix) || config.getType() == Config.Type.SYSTEM || config.isStartup() && !includeStartup) continue;
            values.add(config);
        }
        return values;
    }

    private static Config initStartupConfig(Config config) {
        String name = config.getName();
        String value = null;
        boolean serviceValue = true;
        if (service != null) {
            try {
                value = service.getProperty(name);
            }
            catch (ServiceException e) {
                Localise.logError(logger, "Unexpected exception reading configuration service property %1$s - %2$s", name, e.getMessage());
            }
        }
        if (value == null) {
            value = System.getProperty(name.toLowerCase().replace("_", "."));
            serviceValue = false;
        }
        if (value == null) {
            value = System.getenv(name.toUpperCase().replace(".", "_"));
            serviceValue = false;
        }
        if (value != null) {
            try {
                config.set(value, Config.Type.EXTERNAL);
            }
            catch (IllegalArgumentException e) {
                if (serviceValue) {
                    Localise.logError(logger, "Invalid value (%2$s) of configuration service property %1$s - %3$s", name, value, e.getMessage());
                }
                Localise.logError(logger, "Invalid value (%2$s) of configuration environment variable %1$s - %3$s", name, value, e.getMessage());
            }
        }
        return config;
    }

    public static boolean isClustered() {
        if (hazelcast != null && !hazelcast.getLifecycleService().isRunning()) {
            hazelcast = null;
            configsCluster = null;
        }
        return configsCluster != null;
    }

    public static void setHazelcast(HazelcastInstance hazelcast) {
        if (Configs.isClustered()) {
            return;
        }
        Configs.hazelcast = hazelcast;
        configsCluster = Hazelcast.getConfigMap(hazelcast);
        for (Config config : configsCache.values()) {
            if (config.isStartup()) continue;
            String name = config.getName();
            Config c = (Config)configsCluster.get((Object)name);
            if (c == null) {
                configsCluster.put((Object)name, (Object)config);
                continue;
            }
            if (c.getType() == Config.Type.USER && config.getType() != c.getType()) {
                Localise.logDebug(logger, "Updating user config - %1$s (%2$s): %3$s", new Object[]{name, config.getType(), c.getValue()});
                config.set(c.getValue().toString());
                configsCluster.put((Object)name, (Object)config);
                continue;
            }
            if (!c.isDefault() || config.isDefault()) continue;
            Localise.logDebug(logger, "Updating unset config - %1$s: %2$s", name, config.getValue());
            configsCluster.put((Object)name, (Object)config);
        }
        configsCache.putAll((Map<String, Config>)configsCluster);
        configsCluster.addEntryListener((MapListener)((EntryAddedListener)event -> {
            try {
                Config config = (Config)event.getValue();
                configsCache.put(config.getName(), config);
                Configs.notifyListeners(config);
            }
            catch (Exception e) {
                if (event != null) {
                    Localise.logError(Localise.logger, e, "Unexpected exception adding null config", new Object[0]);
                }
                Localise.logError(Localise.logger, e, "Unexpected exception adding config %1$s -> %2$s", event.getKey(), event.getValue());
            }
        }), true);
        configsCluster.addEntryListener((MapListener)((EntryUpdatedListener)event -> {
            try {
                Config config = (Config)event.getValue();
                configsCache.put(config.getName(), config);
                Configs.notifyListeners(config);
            }
            catch (Exception e) {
                if (event != null) {
                    Localise.logError(Localise.logger, e, "Unexpected exception updating null config", new Object[0]);
                }
                Localise.logError(Localise.logger, e, "Unexpected exception updating config %1$s -> %2$s", event.getKey(), event.getValue());
            }
        }), true);
        configsCluster.addEntryListener((MapListener)((EntryRemovedListener)event -> {
            try {
                configsCache.remove(event.getKey());
            }
            catch (Exception e) {
                if (event != null) {
                    Localise.logError(Localise.logger, e, "Unexpected exception removing null config", new Object[0]);
                }
                Localise.logError(Localise.logger, e, "Unexpected exception removing config %1$s", event.getKey(), event.getValue());
            }
        }), false);
    }

    public static <T> T get(String name) throws IllegalArgumentException {
        Config config = Configs.getConfig(name);
        if (config == null) {
            return null;
        }
        try {
            return config.getValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Localise.format("Incorrect data type for %1$s - %2$s", name, e.getMessage()));
        }
    }

    public static <T> T get(String name, Program.OS os) throws IllegalArgumentException {
        T value = Configs.get(Configs.getOSName(name, os));
        return value != null ? value : Configs.get(name);
    }

    public static <T> T getDefault(String name) throws IllegalArgumentException {
        Config config = Configs.getConfig(name);
        if (config == null) {
            return null;
        }
        try {
            return config.getDefault();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Localise.format("Incorrect data type for %1$s - %2$s", name, e.getMessage()));
        }
    }

    public static boolean isDefault(String name) {
        Config config = Configs.getConfig(name);
        return config != null ? config.isDefault() : true;
    }

    public static String readFile(String name) throws IllegalArgumentException {
        String value = (String)Configs.get(name);
        if (value != null && value.contains("\n")) {
            return value;
        }
        File file = Configs.getFile(name);
        if (file == null) {
            return null;
        }
        try {
            return FileUtils.read(file);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static File getFile(String name) {
        File file = new File(name);
        if (!file.isAbsolute()) {
            file = FileUtils.findFile(name, (String)Configs.get(CONFIG_DIR_CONFIG), System.getProperty("unix.dir"), System.getProperty("user.home") + File.separator + ".");
        }
        return file;
    }

    public static <T> T getDefault(String name, Program.OS os) throws IllegalArgumentException {
        T value = Configs.getDefault(Configs.getOSName(name, os));
        return value != null ? value : Configs.getDefault(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern getPattern(String name) throws IllegalArgumentException {
        Config config = Configs.getConfig(name);
        if (config == null) {
            Localise.logError(logger, "Pattern config %1$s not found", name);
            Configs.logConfigs(Level.ERROR);
            return null;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile((String)config.getValue());
        }
        catch (PatternSyntaxException e) {
            if (config.isDefault()) {
                Localise.logFatal(logger, "Invalid default regex (%2$s) for %1$s", name, config.getValue());
                Program.exit(1);
            }
            try {
                pattern = Pattern.compile((String)config.getDefault());
            }
            catch (PatternSyntaxException e1) {
                try {
                    Localise.logFatal(logger, "Invalid regex's (%2$s) & (%3$s) for %1$s", name, config.getValue(), config.getDefault());
                    Program.exit(1);
                }
                catch (Throwable throwable) {
                    Localise.logError(logger, "Invalid regex (%2$s) for %1$s using default (%3$s)", name, config.getValue(), config.getDefault());
                    throw throwable;
                }
                Localise.logError(logger, "Invalid regex (%2$s) for %1$s using default (%3$s)", name, config.getValue(), config.getDefault());
            }
            Localise.logError(logger, "Invalid regex (%2$s) for %1$s using default (%3$s)", name, config.getValue(), config.getDefault());
        }
        return pattern;
    }

    public static Pattern getPattern(String name, Program.OS os) {
        String osName = Configs.getOSName(name, os);
        return Configs.exists(osName) ? Configs.getPattern(osName) : Configs.getPattern(name);
    }

    public static String getPassword(String name) throws IOException {
        String password = (String)Configs.get(name);
        if (password == null) {
            password = "";
        }
        if (password.startsWith(PASSWORD_FILE_PREFIX)) {
            String fileName = password.substring(PASSWORD_FILE_PREFIX.length());
            if (StringUtils.isNullOrEmpty(fileName)) {
                throw new IOException(Localise.format("Undefined password file in password environment variable %s", name));
            }
            File file = new File(fileName);
            if (!file.exists()) {
                throw new IOException(Localise.format("Password file %s does not exist", fileName));
            }
            if (!file.canRead()) {
                throw new IOException(Localise.format("Cannot read password file %s", fileName));
            }
            password = FileUtils.readFirstLine(file);
            if (StringUtils.isNullOrEmpty(password)) {
                throw new IOException(Localise.format("Password file %s is empty", fileName));
            }
        }
        return password;
    }

    public static <T> void set(String name, T value) throws IllegalArgumentException {
        Config config = Configs.getConfig(name);
        if (config == null) {
            throw new IllegalArgumentException(Localise.format("Unknown config - %s", name));
        }
        try {
            Configs.setConfig(config.setValue(value));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(Localise.format("Incorrect data type for %1$s - %2$s", name, e.getMessage()));
        }
    }

    public static <T> void set(String name, Program.OS os, T value) throws IllegalArgumentException {
        Config config = Configs.getConfig(name);
        if (config == null) {
            throw new IllegalArgumentException(Localise.format("Unknown config - %s", name));
        }
        name = Configs.getOSName(name, os);
        Config osConfig = (Config)new MessageSerializer().duplicate(config);
        osConfig.setName(name);
        osConfig.setValue(value);
        Configs.setConfig(osConfig);
    }

    public static void unset(String name) throws IllegalArgumentException {
        Config config = Configs.getConfig(name);
        if (config == null) {
            throw new IllegalArgumentException(Localise.format("unknown config - %s", name));
        }
        Configs.removeConfig(config);
    }

    public static String getOSName(String name, Program.OS os) {
        return name + "." + os.getLabel();
    }

    private static boolean initService() {
        try {
            service = ConfigService.getService();
        }
        catch (ServiceException e) {
            if (logger.isDebugEnabled()) {
                Localise.logFatal(logger, e, "Could not connect to config service - %s", e.getMessage());
            } else {
                Localise.logFatal(logger, "Could not connect to config service - %s", e.getMessage());
            }
            Program.exit(1);
        }
        return service != null;
    }

    public static ConfigService getService() {
        return service;
    }

    public static boolean hasService() {
        return service != null;
    }

    public static void logConfigs(Level logLevel) {
        if (logger.isEnabled(logLevel)) {
            Localise.log(logger, logLevel, "Defined configs:", new Object[0]);
            for (Config config : Configs.getConfigs(true)) {
                Localise.log(logger, logLevel, "- %1$s: %2$s", config.getName(), config.getValue());
            }
        }
    }

    public static void addListener(String name, ConfigListener listener) {
        List<ConfigListener> listeners = configListeners.get(name);
        if (listeners == null) {
            listeners = new ArrayList<ConfigListener>();
            configListeners.put(name, listeners);
        }
        listeners.add(listener);
    }

    public static void notifyListeners(Config config) {
        List<ConfigListener> listeners = configListeners.get(config.getName());
        if (listeners != null) {
            for (ConfigListener listener : listeners) {
                listener.updated(config);
            }
        }
    }

    static {
        Configs.addConfigs(ConfigService.class);
        Configs.initService();
        Configs.addConfigs(Configs.class);
    }

    public static interface ConfigListener {
        public void updated(Config var1);
    }
}

