/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;

public class CurrencyUtils {
    private static Map<String, NumberFormat> formatters = new HashMap<String, NumberFormat>();

    public static String format(String currencyCode, double amount) {
        String code = currencyCode.toUpperCase();
        NumberFormat formatter = formatters.get(code);
        if (formatter == null) {
            Currency currency = Currency.getInstance(code);
            formatter = NumberFormat.getCurrencyInstance();
            formatter.setCurrency(currency);
            formatter.setMinimumFractionDigits(currency.getDefaultFractionDigits());
            formatter.setMaximumFractionDigits(currency.getDefaultFractionDigits());
            formatters.put(code, formatter);
        }
        return formatter.format(amount);
    }
}

