/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.messaging.proto.ProtoTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;

public enum Day {
    SUNDAY("Sunday", "Sun", "SUN"),
    MONDAY("Monday", "Mon", "MON"),
    TUESDAY("Tuesday", "Tue", "TUE"),
    WEDNESDAY("Wednesday", "Wed", "WED"),
    THURSDAY("Thursday", "Thu", "THU"),
    FRIDAY("Friday", "Fri", "FRI"),
    SATURDAY("Saturday", "Sat", "SAT"),
    DAILY("Daily", "Daily", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"),
    WEEKDAY("Weekday", "Wkday", "MON", "TUE", "WED", "THU", "FRI"),
    WEEKEND("Weekend", "Wkend", "SAT", "SUN");

    public static final String CRON_MONDAY = "MON";
    public static final String CRON_TUESDAY = "TUE";
    public static final String CRON_WEDNESDAY = "WED";
    public static final String CRON_THURSDAY = "THU";
    public static final String CRON_FRIDAY = "FRI";
    public static final String CRON_SATURDAY = "SAT";
    public static final String CRON_SUNDAY = "SUN";
    private final Set<Day> days = new TreeSet<Day>();
    private final Set<String> cronDays = new LinkedHashSet<String>();
    private final String name;
    private final String abbreviation;
    static final EnumMap<Day, ProtoTime.Day> dayMap;

    private Day(String name, String abreviation, String ... cronDays) {
        this.name = name;
        this.abbreviation = abreviation;
        Collections.addAll(this.cronDays, cronDays);
    }

    public Set<Day> getDays() {
        if (this.days.isEmpty()) {
            switch (this) {
                case SUNDAY: 
                case MONDAY: 
                case TUESDAY: 
                case WEDNESDAY: 
                case THURSDAY: 
                case FRIDAY: 
                case SATURDAY: {
                    this.days.add(this);
                    break;
                }
                case DAILY: {
                    this.days.add(SUNDAY);
                    this.days.add(MONDAY);
                    this.days.add(TUESDAY);
                    this.days.add(WEDNESDAY);
                    this.days.add(THURSDAY);
                    this.days.add(FRIDAY);
                    this.days.add(SATURDAY);
                    break;
                }
                case WEEKDAY: {
                    this.days.add(MONDAY);
                    this.days.add(TUESDAY);
                    this.days.add(WEDNESDAY);
                    this.days.add(THURSDAY);
                    this.days.add(FRIDAY);
                    break;
                }
                case WEEKEND: {
                    this.days.add(SATURDAY);
                    this.days.add(SUNDAY);
                }
            }
        }
        return this.days;
    }

    public Set<String> getCronDays() {
        return Collections.unmodifiableSet(this.cronDays);
    }

    public static Set<Day> consolidateDays(Set<Day> days) {
        TreeSet<Day> consolidated = new TreeSet<Day>();
        for (Day day : days) {
            consolidated.addAll(day.getDays());
        }
        int size = consolidated.size();
        if (size == 7) {
            consolidated.clear();
            consolidated.add(DAILY);
        } else if (size == 5 && !consolidated.contains((Object)SATURDAY) && !consolidated.contains((Object)SUNDAY)) {
            consolidated.clear();
            consolidated.add(WEEKDAY);
        } else if (size == 2 && consolidated.contains((Object)SATURDAY) && consolidated.contains((Object)SUNDAY)) {
            consolidated.clear();
            consolidated.add(WEEKEND);
        }
        return consolidated;
    }

    public static Set<Day> expandDays(Set<Day> days) {
        TreeSet<Day> expanded = new TreeSet<Day>();
        HashSet<String> cronDays = new HashSet<String>();
        for (Day day : days) {
            cronDays.addAll(day.getCronDays());
        }
        if (cronDays.contains(CRON_MONDAY)) {
            expanded.add(MONDAY);
        }
        if (cronDays.contains(CRON_TUESDAY)) {
            expanded.add(TUESDAY);
        }
        if (cronDays.contains(CRON_WEDNESDAY)) {
            expanded.add(WEDNESDAY);
        }
        if (cronDays.contains(CRON_THURSDAY)) {
            expanded.add(THURSDAY);
        }
        if (cronDays.contains(CRON_FRIDAY)) {
            expanded.add(FRIDAY);
        }
        if (cronDays.contains(CRON_SATURDAY)) {
            expanded.add(SATURDAY);
        }
        if (cronDays.contains(CRON_SUNDAY)) {
            expanded.add(SUNDAY);
        }
        return expanded;
    }

    public static Set<Day> range(Day start, Day end) {
        TreeSet<Day> days = new TreeSet<Day>();
        boolean started = false;
        for (Day day : Day.values()) {
            if (!started) {
                if (day != start) continue;
                started = true;
                days.add(day);
                continue;
            }
            days.add(day);
            if (day == end) break;
        }
        return days;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static Day forName(String value) throws IllegalArgumentException {
        switch (value.toLowerCase()) {
            case "mon": 
            case "monday": 
            case "mondays": {
                return MONDAY;
            }
            case "tue": 
            case "tuesday": 
            case "tuesdays": {
                return TUESDAY;
            }
            case "wed": 
            case "wednesday": 
            case "wednesdays": {
                return WEDNESDAY;
            }
            case "thu": 
            case "thursday": 
            case "thursdays": {
                return THURSDAY;
            }
            case "fri": 
            case "friday": 
            case "fridays": {
                return FRIDAY;
            }
            case "sat": 
            case "saturday": 
            case "saturdays": {
                return SATURDAY;
            }
            case "sun": 
            case "sunday": 
            case "sundays": {
                return SUNDAY;
            }
            case "daily": {
                return DAILY;
            }
            case "weekday": 
            case "weekdays": {
                return WEEKDAY;
            }
            case "weekend": 
            case "weekends": {
                return WEEKEND;
            }
        }
        throw new IllegalArgumentException(Localise.format("%s is not a valid day", value));
    }

    public static Day fromProto(ProtoTime.Day day) {
        return dayMap.getA(day);
    }

    public ProtoTime.Day toProto() {
        return dayMap.getB(this);
    }

    static {
        dayMap = new EnumMap<Day, ProtoTime.Day>(Day.class, ProtoTime.Day.class);
    }
}

