/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Name;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoCore;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.regex.Pattern;

public class Filter
implements Message<Filter> {
    private static final String MESSAGE_TAG = "filter";
    private static final String ANCHOR_START = "^";
    private static final String ANCHOR_END = "$";
    private Type type;
    private String pattern;
    private String patternLowerCase;
    private Pattern regex = null;

    public Filter() {
        this.type = Type.ANY;
        this.pattern = null;
    }

    public Filter(Name name) {
        this(name.getPath(), Type.EXACT);
    }

    public Filter(String pattern) {
        this(pattern, Type.EXACT);
    }

    public Filter(String pattern, Type type) {
        this.type = type;
        String string = this.pattern = pattern != null ? pattern : "";
        if (type == Type.REGEX) {
            this.setRegex();
        } else {
            this.patternLowerCase = this.pattern.toLowerCase();
        }
    }

    public static Filter getFilter(String pattern) {
        Filter filter = pattern.startsWith(ANCHOR_START) ? (pattern.endsWith(ANCHOR_END) ? new Filter(pattern.substring(1, pattern.length() - 1), Type.EXACT) : new Filter(pattern.substring(1), Type.STARTS_WITH)) : (pattern.endsWith(ANCHOR_END) ? new Filter(pattern.substring(0, pattern.length() - 1), Type.ENDS_WITH) : new Filter(pattern, Type.CONTAINS));
        return filter;
    }

    public Type getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    private void setRegex() {
        this.regex = Pattern.compile(this.pattern);
    }

    public boolean matches(Object value) {
        return this.matches(value.toString());
    }

    public boolean matches(String value) {
        switch (this.type) {
            case ANY: {
                return true;
            }
            case CONTAINS: {
                return value.toLowerCase().contains(this.patternLowerCase);
            }
            case STARTS_WITH: {
                return value.toLowerCase().startsWith(this.patternLowerCase);
            }
            case ENDS_WITH: {
                return value.toLowerCase().endsWith(this.patternLowerCase);
            }
            case REGEX: {
                return this.regex.matcher(value).matches();
            }
        }
        return value.equalsIgnoreCase(this.pattern);
    }

    public String toString() {
        return this.type == Type.ANY ? this.type.toString() : this.type + " " + this.pattern;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCore.Filter.Builder toProto() {
        ProtoCore.Filter.Builder builder = ProtoCore.Filter.newBuilder();
        builder.setType(this.type.toProto());
        if (this.pattern.length() > 0) {
            builder.setPattern(this.pattern);
        }
        return builder;
    }

    @Override
    public Filter fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCore.Filter proto = ProtoCore.Filter.parseFrom(data);
        this.type = Type.fromProto(proto.getType());
        String string = this.pattern = proto.hasPattern() ? proto.getPattern() : "";
        if (this.type == Type.REGEX) {
            this.setRegex();
        } else {
            this.patternLowerCase = this.pattern.toLowerCase();
        }
        return this;
    }

    public static enum Type {
        ANY,
        EXACT,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        REGEX;

        static EnumMap<Type, ProtoCore.Filter.Type> typeMap;

        public static Type fromProto(ProtoCore.Filter.Type type) {
            return typeMap.getA(type);
        }

        public ProtoCore.Filter.Type toProto() {
            return typeMap.getB(this);
        }

        static {
            typeMap = new EnumMap<Type, ProtoCore.Filter.Type>(Type.class, ProtoCore.Filter.Type.class);
        }
    }
}

