/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Localise {
    static final Logger logger = LogUtils.getLogger(Localise.class);
    private static Set<String> bundleNames = new LinkedHashSet<String>();
    private static Map<Locale, Bundles> localeBundles = new HashMap<Locale, Bundles>();
    private static ThreadLocale threadLocale = new ThreadLocale();
    private static String className = Localise.class.getName();

    public static void addBundle(String name) {
        if (bundleNames.add(name)) {
            for (Bundles bundles : localeBundles.values()) {
                bundles.addBundle(name);
            }
        }
    }

    public static String format(String value) {
        Locale locale = (Locale)threadLocale.get();
        Bundles bundles = localeBundles.get(locale);
        if (bundles == null) {
            bundles = new Bundles(locale);
            for (String name : bundleNames) {
                bundles.addBundle(name);
            }
            localeBundles.put(locale, bundles);
        }
        return bundles.format(value);
    }

    public static String format(String format, Object ... args) {
        try {
            return String.format(Localise.format(format), args);
        }
        catch (Exception e) {
            logger.error("unexpected error formatting \"{}\" - {}", (Object)format, (Object)e.getMessage());
            return format;
        }
    }

    public static void print(String format, Object ... args) {
        Localise.print(System.out, format, args);
    }

    public static void print(PrintStream out, String format, Object ... args) {
        out.print(Localise.format(format, args));
    }

    public static void println(String format, Object ... args) {
        Localise.println(System.out, format, args);
    }

    public static void println(PrintStream out, String format, Object ... args) {
        out.println(Localise.format(format, args));
    }

    public static void logFatal(Logger logger, String format, Object ... args) {
        Localise.log(logger, Level.FATAL, null, format, args);
    }

    public static void logFatal(Logger logger, Exception exception, String format, Object ... args) {
        Localise.log(logger, Level.FATAL, exception, format, args);
    }

    public static void logError(Logger logger, String format, Object ... args) {
        Localise.log(logger, Level.ERROR, null, format, args);
    }

    public static void logError(Logger logger, Exception exception, String format, Object ... args) {
        Localise.log(logger, Level.ERROR, exception, format, args);
    }

    public static void logWarn(Logger logger, String format, Object ... args) {
        Localise.log(logger, Level.WARN, null, format, args);
    }

    public static void logWarn(Logger logger, Exception exception, String format, Object ... args) {
        Localise.log(logger, Level.WARN, exception, format, args);
    }

    public static void logInfo(Logger logger, String format, Object ... args) {
        Localise.log(logger, Level.INFO, null, format, args);
    }

    public static void logInfo(Logger logger, Exception exception, String format, Object ... args) {
        Localise.log(logger, Level.INFO, exception, format, args);
    }

    public static void logDebug(Logger logger, String format, Object ... args) {
        Localise.log(logger, Level.DEBUG, null, format, args);
    }

    public static void logDebug(Logger logger, Exception exception, String format, Object ... args) {
        Localise.log(logger, Level.DEBUG, exception, format, args);
    }

    public static void logTrace(Logger logger, String format, Object ... args) {
        Localise.log(logger, Level.TRACE, null, format, args);
    }

    public static void logTrace(Logger logger, Exception exception, String format, Object ... args) {
        Localise.log(logger, Level.TRACE, exception, format, args);
    }

    public static void println(Logger logger, String format, Object ... args) {
        System.out.println(String.format(Localise.format(format), args));
    }

    public static void println(Logger logger, Exception exception, String format, Object ... args) {
        System.out.println(String.format(Localise.format(format), args));
        exception.printStackTrace(System.out);
    }

    public static void log(Logger logger, Level level, String format, Object ... args) {
        Localise.log(logger, level, null, format, args);
    }

    public static void log(Logger logger, Level level, Exception exception, String format, Object ... args) {
        if (logger.isEnabled(level)) {
            if (exception == null) {
                logger.log(level, Localise.format(format, args));
            } else {
                logger.log(level, Localise.format(format, args), (Throwable)exception);
            }
        }
    }

    public static void setThreadLocale(Locale locale) {
        if (locale != null) {
            threadLocale.set(locale);
        } else {
            Localise.resetThreadLocale();
        }
    }

    private static String getCallingClassName() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 2; i < elements.length; ++i) {
            String name = elements[i].getClassName();
            if (name.startsWith(className)) continue;
            return name;
        }
        return "unknown class";
    }

    public static void resetThreadLocale() {
        threadLocale.remove();
    }

    static {
        Localise.addBundle("Bliss-core");
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }

    private static class ThreadLocale
    extends ThreadLocal<Locale> {
        private ThreadLocale() {
        }

        @Override
        protected Locale initialValue() {
            return Locale.getDefault();
        }
    }

    private static class Bundles {
        private Locale locale;
        private Set<ResourceBundle> bundles = new LinkedHashSet<ResourceBundle>();
        private Map<String, String> formats = new HashMap<String, String>();

        public Bundles(Locale locale) {
            this.locale = locale;
        }

        public void addBundle(String name) {
            try {
                if (this.bundles.add(ResourceBundle.getBundle(name, this.locale, new UTF8Control()))) {
                    this.formats.clear();
                }
            }
            catch (MissingResourceException e) {
                logger.warn(e.getMessage());
            }
        }

        public String format(String value) {
            String format = this.formats.get(value);
            if (format == null) {
                for (ResourceBundle bundle : this.bundles) {
                    try {
                        format = bundle.getString(value);
                        if (format.length() <= 0) continue;
                        break;
                    }
                    catch (MissingResourceException missingResourceException) {
                    }
                }
                if (format == null) {
                    logger.info(String.format("%1$s.(%2$s) missing (%3$s)", Localise.getCallingClassName(), this.locale.toString(), value));
                    format = value;
                } else if (format.length() < 1) {
                    format = value;
                }
                this.formats.put(value, format);
            }
            return format;
        }
    }
}

