/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;
import org.apache.commons.validator.routines.EmailValidator;

public class MailUtils {
    private static boolean allowLocal = false;
    private static boolean allowDomain = false;
    private static EmailValidator validator = EmailValidator.getInstance((boolean)allowLocal, (boolean)allowDomain);

    public static boolean isValidAddress(String address) {
        return validator.isValid(address);
    }

    public static void setAllowLocal(boolean allowLocal) {
        MailUtils.allowLocal = allowLocal;
        validator = EmailValidator.getInstance((boolean)allowLocal, (boolean)allowDomain);
    }

    public static void setAllowDomain(boolean allowDomain) {
        MailUtils.allowDomain = allowDomain;
        validator = EmailValidator.getInstance((boolean)allowLocal, (boolean)allowDomain);
    }

    public static void send(File file, String subject, String ... recipients) throws MailException {
        if (!file.exists()) {
            throw new MailException(file + " does not exist");
        }
        if (!file.isFile()) {
            throw new MailException(file + " is not a file");
        }
        if (!file.canRead()) {
            throw new MailException(file + " is not readable");
        }
        String mailCommand = String.format((String)Configs.get("beyondcron.command.mail", Program.getOs()), subject, StringUtils.join(" ", recipients));
        ProcessBuilder mailBuilder = new ProcessBuilder(StringUtils.split(mailCommand, true));
        mailBuilder.redirectInput(file);
        try {
            mailBuilder.start().waitFor();
        }
        catch (Exception e) {
            throw new MailException(e.getMessage());
        }
    }

    public static void send(String message, String subject, String ... recipients) throws MailException {
        MailUtils.send(Arrays.asList((Object[])message.split("\n")), subject, recipients);
    }

    public static void send(List<String> message, String subject, String ... recipients) throws MailException {
        String mailCommand = String.format((String)Configs.get("beyondcron.command.mail", Program.getOs()), subject, StringUtils.join(" ", recipients));
        ProcessBuilder mailBuilder = new ProcessBuilder(StringUtils.split(mailCommand, true));
        try {
            Process process = mailBuilder.start();
            PrintWriter processIn = new PrintWriter(process.getOutputStream(), true);
            for (String line : message) {
                processIn.println(line);
            }
            processIn.close();
            process.waitFor();
        }
        catch (Exception e) {
            throw new MailException(e.getMessage());
        }
    }

    public static class MailException
    extends Exception {
        public MailException(String message) {
            super(message);
        }
    }

    public static enum Mode {
        STANDARD,
        LOCAL,
        DOMAIN,
        ALL;

    }
}

