/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.NetUtils;
import com.beyondcron.core.Program;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoCore;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hazelcast.core.PartitionAware;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.Logger;
import org.quartz.JobKey;

public class Name
implements Message<Name>,
Comparable<Name>,
PartitionAware<String> {
    private static final Logger logger = LogUtils.getLogger(Name.class);
    private static final String MESSAGE_TAG = "name";
    public static final String LEGACY_SCHEME = "bliss";
    public static final String SCHEME = "beyondcron";
    public static final String SEPARATOR = "/";
    private static final String DUPLICATE_SEPARATORS = "//+";
    public static final String WILDCARD = "*";
    public static final String RECURSIVE_WILDCARD = "**";
    public static final String THREAD_ROOT = "...";
    public static final Name ROOT;
    public static final Name DUMMY_NAME;
    private static URI baseURI;
    private static String defaultAuthority;
    private static ThreadLocal<String> threadRoot;
    private static ThreadLocal<Boolean> threadRootEnabled;
    private URI uri;
    private String name;
    private String group;
    private boolean rootGroup;
    private boolean wildcard;
    private boolean wildcardRecursive;

    public Name() {
    }

    public Name(ProtoCore.Name proto) {
        try {
            this.init(baseURI, proto.getName());
        }
        catch (URISyntaxException e) {
            Localise.logError(logger, "Could not parse %1$s - %2$s", proto.getName(), e.getMessage());
        }
    }

    public Name(String spec) throws URISyntaxException {
        this.init(baseURI, spec);
    }

    public Name(Name context, String spec) throws URISyntaxException {
        this.init(context.uri, spec);
    }

    public Name(JobKey key) {
        try {
            this.init(baseURI, key.getGroup() + key.getName());
        }
        catch (URISyntaxException e) {
            Localise.logError(logger, e, "Unexpected exception parsing job key %1$s", key);
        }
    }

    private void init(URI context, String spec) throws URISyntaxException {
        if (spec.startsWith(THREAD_ROOT)) {
            spec = spec.replaceFirst(THREAD_ROOT, threadRoot.get());
        }
        try {
            this.uri = context.resolve(spec).normalize();
            if (this.uri.getPath().length() > 1 && this.uri.getPath().endsWith(SEPARATOR)) {
                this.uri = context.resolve(spec.substring(0, spec.length() - 1)).normalize();
            }
        }
        catch (NullPointerException e) {
            throw new URISyntaxException("", "undefined path");
        }
        catch (Exception e) {
            throw new URISyntaxException(spec, e.getMessage());
        }
        this.validate();
        String path = this.uri.getPath();
        int i = path.lastIndexOf(SEPARATOR) + 1;
        this.name = path.substring(i);
        if (i > 1) {
            this.group = path.substring(0, i);
            this.rootGroup = false;
        } else {
            this.group = SEPARATOR;
            this.rootGroup = true;
        }
        this.wildcardRecursive = this.name.equals(RECURSIVE_WILDCARD);
        this.wildcard = this.name.equals(WILDCARD) || this.wildcardRecursive;
    }

    private void validate() throws URISyntaxException {
        if (!this.uri.getScheme().equals(baseURI.getScheme())) {
            throw new URISyntaxException(this.uri.toString(), "unsupported scheme: " + this.uri.getScheme());
        }
        if (!this.uri.getPath().startsWith(SEPARATOR)) {
            throw new URISyntaxException(this.uri.toString(), "path not absolute: " + this.uri.getPath());
        }
    }

    public static Name getDummyName(Name group) {
        return Name.parse(group, NetUtils.encode(" "));
    }

    public static void clearThreadRoot() {
        threadRoot.remove();
        threadRootEnabled.remove();
    }

    public static void setThreadRoot(Name root) {
        threadRoot.set(root.getPath());
        threadRootEnabled.set(true);
    }

    public static Name parse(String value) {
        return Name.parse(value, ROOT);
    }

    public static Name parse(String value, Name emptyValue) {
        if (StringUtils.isNullOrEmpty(value)) {
            return emptyValue;
        }
        try {
            return new Name(value);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Name parse(Name root, String ... values) {
        String path = root.uri.toString() + SEPARATOR + StringUtils.join(SEPARATOR, values);
        try {
            return new Name(root, path.replaceAll(DUPLICATE_SEPARATORS, SEPARATOR));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Name parse(File path) {
        try {
            return new Name(path.getPath().replace(File.separator, SEPARATOR));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public Name getGroup() {
        return this.rootGroup ? null : Name.parse(this.group);
    }

    public String getGroupName() {
        return this.group;
    }

    public Name getChild(Name parent) {
        String parentPath;
        String path = this.getPath();
        int i = path.indexOf(parentPath = parent.getPath());
        if (i == 0) {
            i = parentPath.length() + 1;
            if (i < path.length()) {
                if ((i = path.indexOf(SEPARATOR, i)) < 0) {
                    i = path.length();
                }
            } else {
                i = -1;
            }
        }
        return i >= 0 ? Name.parse(path.substring(0, i)) : null;
    }

    public boolean isRoot() {
        return this.rootGroup && this.name.length() < 1;
    }

    public boolean isRootGroup() {
        return this.rootGroup;
    }

    public boolean isLocal() {
        return this.uri.getAuthority() == null || this.uri.getAuthority().equals(defaultAuthority);
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public boolean isWildcardRecursive() {
        return this.wildcardRecursive;
    }

    public String getUser() {
        return this.uri.getUserInfo();
    }

    public String getRealm() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public boolean contains(Name that) {
        return this.name.length() <= 0 || that.getPath().startsWith(this.getPath() + SEPARATOR);
    }

    public boolean matches(Name that) {
        if (that.wildcard) {
            if (this.group.equals(that.group)) {
                return true;
            }
            if (that.wildcardRecursive) {
                return this.group.startsWith(that.group);
            }
            return false;
        }
        return this.uri.equals(that.uri);
    }

    public static int compareGroup(Name name1, Name name2) {
        Name group2;
        Name group1 = name1 != null ? name1.getGroup() : null;
        Name name = group2 = name2 != null ? name2.getGroup() : null;
        if (group1 != null) {
            return group2 != null ? group1.compareTo(group2) : 1;
        }
        return group2 != null ? -1 : 0;
    }

    public String toString() {
        Object path = this.uri.getPath();
        if (threadRootEnabled.get().booleanValue()) {
            String root = threadRoot.get();
            if (root.equals(SEPARATOR)) {
                path = THREAD_ROOT + (String)path;
            } else if (((String)path).startsWith(root)) {
                path = ((String)path).replaceFirst(root, THREAD_ROOT);
            }
        }
        if (this.uri.getAuthority() != null) {
            return "//" + this.uri.getAuthority() + (String)path;
        }
        return path;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String getPartitionKey() {
        return this.group;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Name)) {
            return false;
        }
        return this.uri.compareTo(((Name)obj).uri) == 0;
    }

    @Override
    public int compareTo(Name that) {
        String t;
        String s = this.getPath();
        int i = s.compareToIgnoreCase(t = that != null ? that.getPath() : "");
        if (i == 0) {
            i = s.compareTo(t);
        }
        return i;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCore.Name.Builder toProto() {
        ProtoCore.Name.Builder builder = ProtoCore.Name.newBuilder();
        builder.setName(this.toString());
        return builder;
    }

    @Override
    public Name fromProto(byte[] data) throws InvalidProtocolBufferException {
        return new Name(ProtoCore.Name.parseFrom(data));
    }

    static {
        threadRoot = ThreadLocal.withInitial(() -> "");
        threadRootEnabled = ThreadLocal.withInitial(() -> Boolean.FALSE);
        try {
            baseURI = new URI(String.format("%s:%s", SCHEME, SEPARATOR));
        }
        catch (URISyntaxException e) {
            Localise.logFatal(logger, e, "Could not create base URI", new Object[0]);
            Program.exit(1);
        }
        defaultAuthority = "";
        ROOT = Name.parse(SEPARATOR);
        DUMMY_NAME = Name.parse(SEPARATOR + NetUtils.encode(" "));
    }
}

