/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Duplicatable;
import com.beyondcron.core.EnumMap;
import com.beyondcron.core.Localise;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoTime;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OneArgumentOptionHandler;
import org.kohsuke.args4j.spi.Setter;

public class Period
implements Message<Period>,
Duplicatable<Period>,
Comparable<Period> {
    private static final String MESSAGE_TAG = "period";
    private static final Pattern REGEX_TIME = Pattern.compile("^(\\d+)\\s+(ms|millisecond|milliseconds|second|seconds|minute|minutes|hour|hours|day|days|week|weeks|month|months|year|years)$");
    private static final Pattern REGEX_TIME_SHORT = Pattern.compile("^(\\d+)([smhDWMY])$");
    private int value;
    private Unit unit;

    public Period() {
        this(1, Unit.SECOND);
    }

    public Period(int value, Unit unit) {
        this.value = value >= 0 ? value : -value;
        this.unit = unit;
    }

    public Period(String value) throws IllegalArgumentException {
        this(value, null);
    }

    public Period(String value, Unit maxUnit) {
        Matcher m = REGEX_TIME.matcher(value.toLowerCase());
        if (!m.matches() && !(m = REGEX_TIME_SHORT.matcher(value)).matches()) {
            throw new IllegalArgumentException(Localise.format("invalid period"));
        }
        this.value = Integer.parseInt(m.group(1));
        if (this.value < 0) {
            throw new IllegalArgumentException(Localise.format("period value must be greater than or equal to 0"));
        }
        switch (m.group(2)) {
            case "ms": 
            case "millisecond": 
            case "milliseconds": {
                this.unit = Unit.MILLISECOND;
                break;
            }
            case "s": 
            case "second": 
            case "seconds": {
                this.unit = Unit.SECOND;
                break;
            }
            case "m": 
            case "minute": 
            case "minutes": {
                this.unit = Unit.MINUTE;
                break;
            }
            case "h": 
            case "hour": 
            case "hours": {
                this.unit = Unit.HOUR;
                break;
            }
            case "D": 
            case "day": 
            case "days": {
                this.unit = Unit.DAY;
                break;
            }
            case "W": 
            case "week": 
            case "weeks": {
                this.unit = Unit.WEEK;
                break;
            }
            case "M": 
            case "month": 
            case "months": {
                this.unit = Unit.MONTH;
                break;
            }
            case "Y": 
            case "year": 
            case "years": {
                this.unit = Unit.YEAR;
            }
        }
        if (maxUnit != null && this.unit.ordinal() > maxUnit.ordinal()) {
            throw new IllegalArgumentException(Localise.format("period unit must be less than or equal to %s", maxUnit.getLabel().toLowerCase()));
        }
    }

    public int getValue() {
        return this.value;
    }

    public Period setValue(int value) {
        this.value = value >= 0 ? value : -value;
        return this;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Period setUnit(Unit unit) {
        this.unit = unit;
        return this;
    }

    public long getSeconds() {
        return this.unit.getSeconds(this.value);
    }

    public long getMilliseconds() {
        return this.unit.getMilliseconds(this.value);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean alwaysIncludeValue) {
        if (this.value == 1) {
            if (alwaysIncludeValue) {
                return String.format("%d %s", this.value, this.unit.toString().toLowerCase());
            }
            return this.unit.toString().toLowerCase();
        }
        return String.format("%d %ss", this.value, this.unit.toString().toLowerCase());
    }

    public String asString(boolean compact) {
        return compact ? String.format("%d%s", this.value, this.unit.getSuffix()) : this.toString(true);
    }

    public int hashCode() {
        return (int)(this.unit.getSeconds(this.value) % Integer.MAX_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((Period)o) == 0;
    }

    @Override
    public int compareTo(Period that) {
        if (that == null) {
            return 1;
        }
        long l = this.unit.getSeconds(this.value) - that.unit.getSeconds(that.value);
        return l == 0L ? 0 : (l < 0L ? -1 : 1);
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoTime.Period.Builder toProto() {
        ProtoTime.Period.Builder builder = ProtoTime.Period.newBuilder();
        builder.setValue(this.value);
        if (this.unit != Unit.SECOND) {
            builder.setUnit(this.unit.toProto());
        }
        return builder;
    }

    @Override
    public Period fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoTime.Period proto = ProtoTime.Period.parseFrom(data);
        this.value = proto.getValue();
        this.unit = Unit.fromProto(proto.getUnit());
        return this;
    }

    @Override
    public Period duplicate() {
        return new Period(this.value, this.unit);
    }

    public static class OptionHandler
    extends OneArgumentOptionHandler<Period> {
        public OptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Period> setter) {
            super(parser, option, setter);
        }

        protected Period parse(String argument) throws IllegalArgumentException {
            return new Period(argument);
        }
    }

    public static enum Unit {
        MILLISECOND(1L, "Millisecond", "ms"),
        SECOND(1000L, "Second", "s"),
        MINUTE(60000L, "Minute", "m"),
        HOUR(3600000L, "Hour", "h"),
        DAY(86400000L, "Day", "D"),
        WEEK(604800000L, "Week", "W"),
        MONTH(0L, "Month", "M"),
        YEAR(0L, "Year", "Y");

        static EnumMap<Unit, ProtoTime.Unit> unitMap;
        private long unitInMilliseconds;
        private String label;
        private String suffix;

        private Unit(long unitInMilliseconds, String label, String suffix) {
            this.unitInMilliseconds = unitInMilliseconds;
            this.label = label;
            this.suffix = suffix;
        }

        public long getUnitInSeconds() {
            return this.unitInMilliseconds / 1000L;
        }

        public long getMilliseconds(long value) {
            return value * this.unitInMilliseconds;
        }

        public long getSeconds(long value) {
            return value * this.unitInMilliseconds / 1000L;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public static Unit fromString(String value) {
            String s = value.toUpperCase();
            if (s.endsWith("S")) {
                s = s.substring(0, s.length() - 1);
            }
            try {
                return Unit.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String toString(long value) {
            return value == 1L ? this.toString().toLowerCase() : this.toString().toLowerCase() + "s";
        }

        public static Unit fromProto(ProtoTime.Unit unit) {
            return unitMap.getA(unit);
        }

        public ProtoTime.Unit toProto() {
            return unitMap.getB(this);
        }

        static {
            unitMap = new EnumMap<Unit, ProtoTime.Unit>(Unit.class, ProtoTime.Unit.class);
        }
    }
}

