/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.EnumMap;
import com.beyondcron.core.JSON;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Name;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.property.Schema;
import com.beyondcron.core.property.schemas.Default;
import com.beyondcron.core.property.schemas.JobConfirm;
import com.beyondcron.core.property.schemas.JobMode;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.PersistMessage;
import com.beyondcron.messaging.proto.ProtoProperty;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Property
implements Comparable<Property>,
Message<Property>,
PersistMessage<Property>,
JSON<Property> {
    static final Logger logger = LogUtils.getLogger(Property.class);
    private static Map<String, Schema> schemas = new HashMap<String, Schema>();
    public static Schema DEFAULT_SCHEMA;
    public static final String MESSAGE_TAG = "property";
    public static final int MESSAGE_TYPE;
    public static final String HIDDEN = "********";
    public static final String JSON_SECRET = "secret";
    public static final String JSON_TYPE = "type";
    public static final String JSON_NAME = "name";
    public static final String JSON_VALUE = "value";
    public static final String JSON_GROUP = "group";
    public static final String JSON_HIDDEN = "********";
    private boolean secret;
    private Type type;
    private String name;
    private String value;
    private Name group;
    private Schema schema = null;

    public Property() {
        this.name = "";
        this.value = "";
        this.secret = false;
        this.type = Type.DEFAULT;
        this.group = null;
    }

    public Property(Property that) {
        this.name = that.name;
        this.value = that.value;
        this.secret = that.secret;
        this.type = that.type;
        this.group = that.group;
        this.schema = schemas.get(this.name);
    }

    public Property(String name, String value) {
        this(name, value, Type.getDefaultType(name), false);
    }

    public Property(String name, String value, Type type, boolean secret) {
        this.setName(name);
        this.setValue(value);
        this.type = type;
        this.secret = secret;
    }

    @Override
    public Name getPersistName() {
        return Name.parse(this.group != null ? this.group : Name.ROOT, this.name);
    }

    public String getName() {
        return this.name;
    }

    public Property setName(String name) {
        this.name = name != null ? name : "";
        this.schema = schemas.get(name);
        return this;
    }

    public boolean isNameValid() {
        return this.type.isNameValid(this.name);
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(boolean showSecrets) {
        return !this.secret || showSecrets ? this.value : "********";
    }

    public Property setValue(String value) {
        this.value = value != null ? value : "";
        return this;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public Property setSecret(boolean secret) {
        this.secret = secret;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Type getType(Type defaultType) {
        return this.type != Type.DEFAULT ? this.type : defaultType;
    }

    public Property setType(Type type) {
        this.type = type;
        return this;
    }

    public Name getGroup() {
        return this.group;
    }

    public Property setGroup(Name group) {
        this.group = group;
        return this;
    }

    public boolean canUnset() {
        return this.getSchema().canUnset();
    }

    public Schema getSchema() {
        if (this.schema == null) {
            String key = Schema.getKey(this);
            this.schema = schemas.get(key);
            if (this.schema == null) {
                this.schema = schemas.get(Schema.getKey(this.name));
                if (this.schema == null) {
                    this.schema = DEFAULT_SCHEMA;
                }
                schemas.put(key, this.schema);
            }
        }
        return this.schema;
    }

    public String validate(Schema.Scope scope) {
        String message = null;
        if (!this.isNameValid()) {
            return Localise.format("Invalid %s property name", this.type.getLabel());
        }
        Schema schema = this.getSchema();
        if (this.type == Type.SYSTEM && schema.getType() != Type.SYSTEM) {
            return Localise.format("Unknown %s property", this.type.getLabel());
        }
        if (!schema.inScope(scope)) {
            if (scope == Schema.Scope.GROUP) {
                message = Localise.format("%s property is not supported in groups", this.name);
            } else if (scope == Schema.Scope.JOB) {
                message = Localise.format("%s property is not supported in jobs", this.name);
            }
        } else if (!schema.isValid(this.value)) {
            message = Localise.format(schema.getValueMessage());
        } else {
            this.value = schema.normalise(this.value);
        }
        return message;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean showSecrets) {
        if (this.secret) {
            if (this.type != Type.DEFAULT) {
                if (!showSecrets) {
                    return String.format("[secret %s] %s: %s", this.type.getLabel(), this.name, "********");
                }
                return String.format("[secret %s] %s: %s", this.type.getLabel(), this.name, this.value);
            }
            if (!showSecrets) {
                return String.format("[secret] %s: %s", this.name, "********");
            }
            return String.format("[secret] %s: %s", this.name, this.value);
        }
        if (this.type != Type.DEFAULT) {
            return String.format("[%s] %s: %s", this.type.getLabel(), this.name, this.value);
        }
        return String.format("%s: %s", this.name, this.value);
    }

    @Override
    public JSONObject toJSON() {
        return this.toJSON(false);
    }

    public JSONObject toJSON(boolean showSecretPropertyValues) {
        JSONObject json = new JSONObject();
        if (this.group != null) {
            json.put(JSON_GROUP, this.group.toString());
        }
        json.put(JSON_NAME, this.name);
        if (this.type != Type.UNSET) {
            if (!StringUtils.isNullOrEmpty(this.value)) {
                json.put(JSON_VALUE, showSecretPropertyValues ? this.value : "********");
            }
            if (this.secret) {
                json.put(JSON_SECRET, this.secret);
            }
        }
        if (this.type != Type.DEFAULT) {
            json.put(JSON_TYPE, this.type.toString());
        }
        return json;
    }

    @Override
    public Property fromJSON(JSONObject json) {
        return this.fromJSON(json, false);
    }

    public Property fromJSON(JSONObject json, boolean requiresGroup) {
        this.type = Type.getType(json.optString(JSON_TYPE, Type.DEFAULT.getLabel()));
        if (this.type == null) {
            throw new JSONException(Localise.format("invalid %1$s - %2$s", JSON_TYPE, json.get(JSON_TYPE).toString()));
        }
        this.name = json.getString(JSON_NAME);
        if (!this.type.isNameValid(this.name)) {
            throw new JSONException(Localise.format("invalid %1$s property name - %2$s", this.type.getLabel(), this.name));
        }
        if (this.type != Type.UNSET) {
            this.value = json.optString(JSON_VALUE);
            this.secret = json.optBoolean(JSON_SECRET, false);
        } else {
            this.value = "";
            this.secret = false;
        }
        if (json.has(JSON_GROUP)) {
            try {
                this.group = new Name(json.getString(JSON_GROUP));
            }
            catch (URISyntaxException e) {
                throw new JSONException(Localise.format("invalid %1$s - %2$s - %3$s", JSON_GROUP, json.get(JSON_GROUP).toString(), e.getMessage()));
            }
        } else {
            if (requiresGroup) {
                throw new JSONException(Localise.format("group undefined"));
            }
            this.group = null;
        }
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    @Override
    public int getMessageType() {
        return MESSAGE_TYPE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Property)) {
            return false;
        }
        return this.compareTo((Property)obj, null) == 0;
    }

    @Override
    public int compareTo(Property that) {
        return this.compareTo(that, null);
    }

    public int compareTo(Property that, Type defaultType) {
        int i = this.name.compareTo(that.name);
        if (i != 0) {
            return i;
        }
        i = this.value.compareTo(that.value);
        if (i != 0) {
            return i;
        }
        i = Boolean.compare(this.secret, that.secret);
        if (i != 0) {
            return i;
        }
        i = this.type.compareTo(that.type);
        if (i != 0 && defaultType != null) {
            if (this.type == Type.DEFAULT) {
                i = defaultType.compareTo(that.type);
            } else if (that.type == Type.DEFAULT) {
                i = this.type.compareTo(defaultType);
            }
        }
        return i;
    }

    public ProtoProperty.Property.Builder toProto() {
        ProtoProperty.Property.Builder builder = ProtoProperty.Property.newBuilder();
        builder.setName(this.name);
        if (this.type != Type.UNSET) {
            if (this.value.length() > 0) {
                builder.setValue(this.value);
            }
            if (this.secret) {
                builder.setSecret(this.secret);
            }
        }
        if (this.type != Type.DEFAULT) {
            builder.setType(this.type.toProto());
        }
        if (this.group != null) {
            builder.setGroup(this.group.toProto());
        }
        return builder;
    }

    @Override
    public Property fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoProperty.Property proto = ProtoProperty.Property.parseFrom(data);
        this.type = Type.fromProto(proto.getType());
        this.name = proto.getName();
        if (this.type != Type.UNSET) {
            this.value = proto.hasValue() ? proto.getValue() : "";
            this.secret = proto.getSecret();
        } else {
            this.value = "";
            this.secret = false;
        }
        this.group = proto.hasGroup() ? new Name(proto.getGroup()) : null;
        return this;
    }

    static {
        Schema schema = new JobConfirm();
        schemas.put(schema.getKey(), schema);
        schema = new JobMode();
        schemas.put(schema.getKey(), schema);
        DEFAULT_SCHEMA = new Default();
        MESSAGE_TYPE = "au.com.tonbo.bliss.core.Property".hashCode();
    }

    public static class FullComparator
    implements Comparator<Property> {
        @Override
        public int compare(Property property1, Property property2) {
            int i;
            Name group2;
            Name group1 = property1.group;
            if (group1 == null) {
                group1 = Name.ROOT;
            }
            if ((group2 = property2.group) == null) {
                group2 = Name.ROOT;
            }
            return (i = group1.compareTo(group2)) != 0 ? i : property1.compareTo(property2);
        }
    }

    public static enum Type {
        VARIABLE("V", "variable", Localise.format("Job variable"), Pattern.compile("[a-zA-Z_][a-zA-Z0-9_-]*")),
        ENVIRONMENT("E", "environment", Localise.format("Environment variable"), Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*")),
        PARAMETER("P", "parameter", Localise.format("Parameter"), Pattern.compile("[a-zA-Z_][a-zA-Z0-9_-]*")),
        HEADER("H", "header", Localise.format("Header property"), Pattern.compile("[a-zA-Z_][a-zA-Z0-9_-]*")),
        RESOURCE("R", "resource", Localise.format("Container resource"), Pattern.compile("[a-zA-Z_][a-zA-Z0-9_-]*")),
        SYSTEM("S", "system", Localise.format("System property"), Pattern.compile(":[a-zA-Z][a-zA-Z0-9-]*")),
        TEMPLATE("T", "template", Localise.format("Template value"), Pattern.compile("[a-zA-Z][a-zA-Z0-9-]*")),
        UNSET("U", "unset", Localise.format("Unset property"), Pattern.compile(".+")),
        DEFAULT("D", "default", Localise.format("Default property"), Pattern.compile("[a-zA-Z_][a-zA-Z0-9_-]*"));

        private String tag;
        private String label;
        private String description;
        private Pattern namePattern;
        private static final EnumMap<Type, ProtoProperty.Property.Type> typeMap;

        private Type(String tag, String label, String description, Pattern namePattern) {
            this.tag = tag;
            this.label = label;
            this.description = description;
            this.namePattern = namePattern;
        }

        public String getTag() {
            return this.tag;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public static Type getType(String type) {
            if (!StringUtils.isNullOrEmpty(type)) {
                switch (type.toLowerCase()) {
                    case "e": 
                    case "env": 
                    case "environment": {
                        return ENVIRONMENT;
                    }
                    case "h": 
                    case "head": 
                    case "header": {
                        return HEADER;
                    }
                    case "p": 
                    case "param": 
                    case "parameter": {
                        return PARAMETER;
                    }
                    case "r": 
                    case "resource": {
                        return RESOURCE;
                    }
                    case "t": 
                    case "template": {
                        return TEMPLATE;
                    }
                    case "v": 
                    case "var": 
                    case "variable": {
                        return VARIABLE;
                    }
                    case "u": 
                    case "unset": {
                        return UNSET;
                    }
                    case "default": {
                        return DEFAULT;
                    }
                    case "system": {
                        return SYSTEM;
                    }
                }
            }
            return null;
        }

        public static Type fromProto(ProtoProperty.Property.Type type) {
            return typeMap.getA(type);
        }

        public ProtoProperty.Property.Type toProto() {
            return typeMap.getB(this);
        }

        public boolean isNameValid(String name) {
            return this.namePattern.matcher(name).matches();
        }

        public static Type getDefaultType(String name) {
            return SYSTEM.isNameValid(name) ? SYSTEM : DEFAULT;
        }

        static {
            typeMap = new EnumMap<Type, ProtoProperty.Property.Type>(Type.class, ProtoProperty.Property.Type.class);
        }
    }
}

