/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.Name;
import com.beyondcron.core.Property;
import com.beyondcron.core.TableFormatter;
import com.beyondcron.core.security.ACL;
import com.beyondcron.core.security.UserACLValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PropertyList {
    private UserACLValidator aclValidator;
    private Name workingName;
    private Map<String, Property> properties = new TreeMap<String, Property>();
    private boolean containsInherited = false;
    private Property.Type defaultType = Property.Type.VARIABLE;
    private Set<Property.Type> supportedTypes = new HashSet<Property.Type>();

    public PropertyList(Name name, UserACLValidator aclValidator) {
        this.workingName = name;
        this.aclValidator = aclValidator;
        Collections.addAll(this.supportedTypes, Property.Type.values());
    }

    public PropertyList setDefaultType(Property.Type type) {
        this.defaultType = type;
        return this;
    }

    public PropertyList setSupportedTypes(Collection<Property.Type> types) {
        this.supportedTypes.clear();
        this.supportedTypes.addAll(types);
        return this;
    }

    public PropertyList addSupportedType(Property.Type type) {
        this.supportedTypes.add(type);
        return this;
    }

    public PropertyList addProperties(Collection<Property> properties) {
        for (Property property : properties) {
            this.addProperty(property);
        }
        return this;
    }

    public PropertyList addProperty(Property property) {
        Name g;
        Property p;
        boolean inherited;
        String name = property.getName();
        Name group = property.getGroup();
        boolean bl = inherited = group != null && !group.equals(this.workingName);
        if (inherited && (p = this.properties.get(name)) != null && ((g = p.getGroup()) == null || g.equals(group) || group.contains(g))) {
            return this;
        }
        this.properties.put(name, property);
        if (inherited) {
            this.containsInherited = true;
        }
        return this;
    }

    public Collection<Property> getProperties() {
        ArrayList<Property> l = new ArrayList<Property>();
        for (Property property : this.properties.values()) {
            Property.Type propertyType = property.getType(this.defaultType);
            if (this.supportedTypes.contains((Object)propertyType)) {
                if (propertyType == Property.Type.UNSET && property.getGroup() != null) continue;
                l.add(property);
                continue;
            }
            if (propertyType != Property.Type.SYSTEM || property.getGroup() != null) continue;
            l.add(property);
        }
        return l;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public TableFormatter asTable() {
        return this.asTable(true);
    }

    public TableFormatter asTable(boolean includeGroup) {
        TableFormatter table = new TableFormatter();
        table.addColumns(Localise.format("Type"), Localise.format("Name"), Localise.format("Value"));
        table.alignColumn(0, TableFormatter.Column.Align.RIGHT);
        if (this.containsInherited && includeGroup) {
            table.addColumn(Localise.format("Group"));
        }
        for (Property property : this.getProperties()) {
            table.startRow();
            Name group = property.getGroup();
            Property.Type type = property.getType(this.defaultType);
            boolean showSecrets = false;
            if (property.isSecret()) {
                table.addValue(Localise.format("secret %s", type.getLabel()));
                showSecrets = this.aclValidator.hasPermission(group != null ? group : this.workingName, ACL.Permission.WRITE);
            } else {
                table.addValue(type.getLabel());
            }
            String name = property.getName();
            table.addValue(name);
            table.addValue(property.getValue(showSecrets));
            if (!includeGroup || group == null || group.equals(this.workingName)) continue;
            table.addValue(group);
        }
        return table;
    }
}

