/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public class PropertyUtils {
    static final Logger logger = LogUtils.getLogger(PropertyUtils.class);

    public static Properties loadProperties(String name, String ... dirs) throws IOException {
        Localise.logDebug(logger, "Load properties - %1$s", name);
        Properties properties = new Properties();
        if (StringUtils.isNullOrEmpty(name)) {
            return properties;
        }
        if (name.contains("\n")) {
            try {
                properties.load(new StringReader(name));
            }
            catch (IOException e) {
                throw new IOException(String.format("could not parse properties - %s", e.getMessage()));
            }
        }
        File file = new File(name);
        if (!file.isAbsolute()) {
            for (String dir : dirs) {
                if (StringUtils.isNullOrEmpty(dir)) continue;
                Localise.logDebug(logger, "- %1$s", dir);
                file = dir.endsWith(File.separator) || dir.endsWith(File.separator + ".") ? new File(dir + name) : new File(dir + File.separator + name);
                if (file.exists()) break;
            }
        }
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new IOException(String.format("could not load properties file %s - %s", file.toString(), e.getMessage()));
            }
        }
        return properties;
    }
}

