/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.Logger;

public class ResizableSemaphore
extends Semaphore {
    static final Logger logger = LogUtils.getLogger(ResizableSemaphore.class);
    private int permits;

    public ResizableSemaphore(int permits) {
        super(permits);
        this.permits = permits;
    }

    public ResizableSemaphore(int permits, boolean fair) {
        super(permits, fair);
        this.permits = permits;
    }

    public void resize(int permits) {
        int i = permits - this.permits;
        if (i > 0) {
            this.release(i);
        } else if (i < 0) {
            this.reducePermits(-i);
        }
        if (i != 0) {
            Localise.logError(logger, "resized from %1$d %2$d", this.permits, permits);
            this.permits = permits;
        }
    }

    public int getTotalPermits() {
        return this.permits;
    }
}

