/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.JSON;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoRole;
import com.google.protobuf.InvalidProtocolBufferException;
import org.json.JSONObject;

public class Role
implements Cloneable,
Comparable<Role>,
Message<Role>,
JSON<Role> {
    private static final String MESSAGE_TAG = "role";
    public static final String JSON_NAME = "name";
    public static final String JSON_DESCRIPTION = "description";
    public static final String ADMIN_NAME = (String)Configs.get("beyondcron.admin.role.name");
    public static final Role ADMIN = new Role(ADMIN_NAME, (String)Configs.get("beyondcron.admin.role.description"));
    public static final String EVERYONE_NAME;
    public static final Role EVERYONE;
    private String name;
    private String description = "";
    private boolean readOnly = false;

    public Role() {
    }

    public Role(String name) {
        this(name, "");
    }

    public Role(String name, String description) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("empty/null user name");
        }
        this.name = name;
        this.setDescription(description);
    }

    public Role(Role role) {
        this.name = role.name;
        this.description = role.description;
        this.readOnly = role.readOnly;
    }

    public Role clone() {
        Role role = new Role(this.name);
        role.description = this.description;
        role.readOnly = this.readOnly;
        return role;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description != null ? StringUtils.stripDuplicateSpaces(description) : "";
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return this.name + " " + this.description;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put(JSON_NAME, this.name);
        if (!StringUtils.isNullOrEmpty(this.description)) {
            json.put(JSON_DESCRIPTION, this.description);
        }
        return json;
    }

    @Override
    public Role fromJSON(JSONObject json) {
        this.name = json.getString(JSON_NAME);
        this.description = json.optString(JSON_DESCRIPTION);
        return this;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoRole.Role.Builder toProto() {
        ProtoRole.Role.Builder builder = ProtoRole.Role.newBuilder();
        builder.setName(this.name);
        if (this.description != null && this.description.length() > 0) {
            builder.setDescription(this.description);
        }
        if (this.readOnly) {
            builder.setReadOnly(true);
        }
        return builder;
    }

    @Override
    public Role fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoRole.Role proto = ProtoRole.Role.parseFrom(data);
        this.name = proto.getName();
        this.description = proto.hasDescription() ? proto.getDescription() : "";
        this.readOnly = proto.getReadOnly();
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        return this.compareTo((Role)obj) == 0;
    }

    @Override
    public int compareTo(Role that) {
        return this.name.compareTo(that.name);
    }

    static {
        ADMIN.setReadOnly(false);
        EVERYONE_NAME = (String)Configs.get("beyondcron.everyone.role.name");
        EVERYONE = new Role(EVERYONE_NAME, (String)Configs.get("beyondcron.everyone.role.description"));
        EVERYONE.setReadOnly(true);
    }
}

