/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Period;
import com.beyondcron.core.ServiceException;
import com.beyondcron.core.ServiceStatus;
import com.beyondcron.core.StringUtils;
import com.beyondcron.messaging.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public abstract class Service {
    static final Logger logger = LogUtils.getLogger(Service.class);
    private static final String serviceClassFormat = "com.beyondcron.service.%s.%s%sService";
    private static Map<Type, Period> retryPeriods = new HashMap<Type, Period>();
    private static Map<Type, ServiceStatus> serviceStatuses = new HashMap<Type, ServiceStatus>();
    private Type type;
    private String name;
    private boolean canReconnect;
    private long connected = 0L;
    private Connect connecting = null;
    private ConnectListener connectListener = null;

    protected Service(Type type, String name, boolean canReconnect) {
        this.type = type;
        this.name = name;
        this.canReconnect = canReconnect;
    }

    public Type getType() {
        return this.type;
    }

    public String getServiceName() {
        return this.name;
    }

    public void setHazelcast(HazelcastInstance hazelcast) {
        HashMap<Type, ServiceStatus> tmpMap = new HashMap<Type, ServiceStatus>(serviceStatuses);
        serviceStatuses = Hazelcast.getServiceStatusMap(hazelcast);
        for (ServiceStatus status : tmpMap.values()) {
            serviceStatuses.put(status.type, status);
        }
    }

    public void setConnectListener(ConnectListener listener) {
        this.connectListener = listener;
    }

    protected abstract void init() throws ServiceException;

    public boolean isConnected() {
        return this.connected > 0L;
    }

    public long getConnected() {
        return this.connected;
    }

    public synchronized void connect() throws ServiceException {
        if (this.connected > 0L || this.connecting != null) {
            return;
        }
        this.connecting = new Connect();
        this.connecting.connect();
        if (this.connected == 0L && this.canReconnect) {
            this.connecting.start();
        }
    }

    public boolean disconnect() {
        if (this.connecting != null) {
            if (this.connecting.disconnect()) {
                this.connected = 0L;
            }
        } else {
            this.connected = 0L;
        }
        if (this.connected == 0L) {
            serviceStatuses.remove((Object)this.type);
            Localise.logInfo(logger, "%1$s service %2$s disconnected", this.type.suffix, this.name);
        }
        return this.connected == 0L;
    }

    public String getConnectionMessage() {
        return this.connecting != null ? this.connecting.message : "";
    }

    public String getServiceDescription() {
        return "";
    }

    public static String getClassName(String name, Type type) {
        String className = name;
        if (!StringUtils.isNullOrEmpty(className) && !className.contains(".")) {
            className = String.format(serviceClassFormat, className.toLowerCase(), className, type.suffix);
        }
        return className;
    }

    private static Period getRetryPeriod(Type type) {
        Period period = retryPeriods.get((Object)type);
        if (period == null) {
            switch (type) {
                case AGENT: {
                    period = (Period)Configs.get("beyondcron.agent.service.connect.retry");
                    break;
                }
                case CONFIG: {
                    period = (Period)Configs.get("BEYONDCRON_CONFIG_SERVICE_CONNECT_RETRY");
                    break;
                }
                case STATUS: {
                    period = (Period)Configs.get("beyondcron.status.service.connect.retry");
                    break;
                }
                case USER: {
                    period = (Period)Configs.get("beyondcron.user.service.connect.retry");
                    break;
                }
                default: {
                    period = (Period)Configs.get("beyondcron.default.service.connect.retry");
                }
            }
            retryPeriods.put(type, period);
        }
        return period;
    }

    private class Connect
    implements Runnable {
        private String message;
        private Period retryPeriod;
        private boolean failed;
        private Thread connectThread;

        private Connect() {
            this.retryPeriod = Service.getRetryPeriod(Service.this.type);
            this.failed = false;
            this.connectThread = null;
        }

        public void start() {
            this.connectThread = new Thread((Runnable)this, String.format("%1$S-%2$S-connector", Service.this.type.suffix, Service.this.name));
            this.connectThread.start();
        }

        public boolean connect() throws ServiceException {
            ServiceStatus status = new ServiceStatus(Service.this.type, Service.this.name, Service.this.getServiceDescription());
            serviceStatuses.put(Service.this.type, status);
            try {
                Service.this.init();
                Service.this.connected = System.currentTimeMillis();
                Service.this.connecting = null;
                this.message = "";
                status.connected = true;
                status.message = "";
                serviceStatuses.put(Service.this.type, status);
                String logMessage = Localise.format("%1$s service %2$s connected", Service.this.type.suffix, Service.this.name);
                if (!this.failed) {
                    logger.info(logMessage);
                } else {
                    logger.warn(logMessage);
                }
                if (Service.this.connectListener != null) {
                    Service.this.connectListener.connected();
                }
            }
            catch (ServiceException e) {
                if (Service.this.canReconnect) {
                    status.message = this.message = Localise.format("%1$s\nretrying every %2$s", e.getMessage(), this.retryPeriod.toString(true));
                    serviceStatuses.put(Service.this.type, status);
                    String logMessage = Localise.format("%1$s service %2$s connect failed, retrying every %3$s - %4$s", Service.this.type.suffix, Service.this.getServiceName(), this.retryPeriod.toString(true), e.getMessage());
                    if (!this.failed) {
                        logger.warn(logMessage);
                        this.failed = true;
                    } else {
                        logger.debug(logMessage);
                    }
                }
                status.message = this.message = e.getMessage();
                serviceStatuses.put(Service.this.type, status);
                throw e;
            }
            return Service.this.connected > 0L;
        }

        public boolean disconnect() {
            if (this.connectThread != null && this.connectThread.isAlive()) {
                this.connectThread.interrupt();
                try {
                    Period timeout = (Period)Configs.get("beyondcron.service.disconnect.timeout");
                    this.connectThread.join(timeout.getMilliseconds());
                    if (this.connectThread != null && this.connectThread.isAlive()) {
                        Localise.logError(logger, "Could not interrupt connect thread after %1$s", timeout.toString(true));
                        return false;
                    }
                }
                catch (InterruptedException e) {
                    Localise.logError(logger, "Unexpectedly interrupted", new Object[0]);
                }
            }
            return true;
        }

        @Override
        public void run() {
            while (Service.this.connected == 0L && !Thread.interrupted()) {
                try {
                    Thread.sleep(this.retryPeriod.getMilliseconds());
                }
                catch (InterruptedException e) {
                    break;
                }
                try {
                    this.connect();
                }
                catch (ServiceException e) {
                    Localise.logError(logger, "Unexpected exception - %s", e.getMessage());
                }
            }
            this.connectThread = null;
        }
    }

    public static interface ConnectListener {
        public void connected();
    }

    public static enum Type {
        AGENT("Agent"),
        CONFIG("Config"),
        STATUS("Status"),
        USER("User");

        private String suffix;

        private Type(String suffix) {
            this.suffix = suffix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

