/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SizeUtils {

    public static enum Unit {
        B(1L, "B"),
        K(1024L, "K"),
        M(0x100000L, "M"),
        G(0x40000000L, "G"),
        T(0x10000000000L, "T"),
        P(0x4000000000000L, "P");

        private static Pattern regex;
        private static Map<String, Unit> units;
        private String unit;
        private long bytes;

        private Unit(long bytes, String unit) {
            this.bytes = bytes;
            this.unit = unit;
        }

        public double getSize(String value, Unit defaultUnit) {
            Matcher matcher = regex.matcher(value.toUpperCase());
            if (!matcher.matches()) {
                throw new NumberFormatException();
            }
            Unit u = defaultUnit;
            String s = matcher.group(4);
            if (s != null) {
                u = Unit.getUnit(s);
            }
            return Double.parseDouble(matcher.group(1)) * (double)u.bytes / (double)this.bytes;
        }

        private static Unit getUnit(String unit) {
            if (units == null) {
                units = new HashMap<String, Unit>();
                for (Unit u : Unit.values()) {
                    units.put(u.unit, u);
                }
            }
            return units.get(unit);
        }

        static {
            regex = Pattern.compile("^([0-9]+(\\.[0-9]+)?)(([BKMGTP])B?)?$");
            units = null;
        }
    }
}

