/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.Period;
import com.beyondcron.core.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadUtils {
    private static ThreadPoolExecutor executor = new ThreadPoolExecutor((Integer)Configs.get("beyondcron.thread.pool.size.core"), (Integer)Configs.get("beyondcron.thread.pool.size.max"), ((Period)Configs.get("beyondcron.thread.pool.thread.timeout")).getSeconds(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static Map<String, Integer> threadNames = new HashMap<String, Integer>();

    protected static ThreadPoolExecutor getExecutor() {
        return executor;
    }

    public static int getActiveThreadCount() {
        return executor.getActiveCount();
    }

    public static int getAvailableThreadCount() {
        return executor.getMaximumPoolSize() - executor.getActiveCount();
    }

    public static void execute(Runnable command) {
        executor.execute(command);
    }

    public static Future submit(Runnable command) {
        return executor.submit(command);
    }

    public static Thread getThread(Runnable runnable) {
        return new Thread(runnable, ThreadUtils.getName(runnable, new String[0]));
    }

    public static String getName(Object obj, String ... suffixes) {
        return ThreadUtils.getName(obj.getClass(), suffixes);
    }

    public static String getName(Class clazz, String ... suffixes) {
        ArrayList<String> facets = new ArrayList<String>();
        facets.add("bc");
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass != null) {
            facets.add(enclosingClass.getSimpleName());
        }
        facets.add(clazz.getSimpleName());
        Collections.addAll(facets, suffixes);
        String name = StringUtils.join(".", facets);
        int count = 0;
        try {
            count = threadNames.get(name);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        threadNames.put(name, ++count);
        return String.format("%s-%d", name, count);
    }
}

