/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Duplicatable;
import com.beyondcron.core.Localise;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoTime;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.LocalTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time
implements Comparable<Time>,
Duplicatable<Time>,
Message<Time> {
    private static final String MESSAGE_TAG = "time";
    private static final Pattern REGEX_TIME = Pattern.compile("^(\\d{1,2}):(\\d{1,2}):(\\d{1,2})$");
    private int hour;
    private int minute;
    private int second;

    public Time() {
        this(0, 0, 0);
    }

    public Time(LocalTime time) {
        this(time.getHour(), time.getMinute(), time.getSecond());
    }

    public Time(int hour, int minute) {
        this(hour, minute, 0);
    }

    public Time(int hour, int minute, int second) {
        this.hour = hour % 24;
        this.minute = minute % 60;
        this.second = second % 60;
    }

    public Time(String value) throws IllegalArgumentException {
        Matcher m = REGEX_TIME.matcher(value);
        if (!m.matches()) {
            throw new IllegalArgumentException(Localise.format("invalid time value - %s", value));
        }
        this.hour = Integer.parseInt(m.group(1));
        this.minute = Integer.parseInt(m.group(2));
        this.second = Integer.parseInt(m.group(3));
    }

    public int getHour() {
        return this.hour;
    }

    public Time setHour(int hour) {
        this.hour = hour % 24;
        return this;
    }

    public int getMinute() {
        return this.minute;
    }

    public Time setMinute(int minute) {
        this.minute = minute % 60;
        return this;
    }

    public int getSecond() {
        return this.second;
    }

    public Time setSecond(int second) {
        this.second = second % 60;
        return this;
    }

    public LocalTime getTime() {
        return LocalTime.of(this.hour, this.minute, this.second);
    }

    public long toLong() {
        return (long)this.hour * 3600L + (long)this.minute * 60L + (long)this.second;
    }

    public String toString() {
        return String.format("%02d:%02d:%02d", this.hour, this.minute, this.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((Time)o) == 0;
    }

    @Override
    public int compareTo(Time that) {
        long l = this.toLong() - that.toLong();
        return l == 0L ? 0 : (l < 0L ? -1 : 1);
    }

    public int hashCode() {
        return (int)this.toLong();
    }

    private static int clamp(int value, int range) {
        while (value < 0) {
            value += range;
        }
        return value % range;
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoTime.Time.Builder toProto() {
        ProtoTime.Time.Builder builder = ProtoTime.Time.newBuilder();
        builder.setHour(this.hour);
        builder.setMinute(this.minute);
        if (this.second != 0) {
            builder.setSecond(this.second);
        }
        return builder;
    }

    @Override
    public Time fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoTime.Time proto = ProtoTime.Time.parseFrom(data);
        this.hour = proto.getHour();
        this.minute = proto.getMinute();
        this.second = proto.getSecond();
        return this;
    }

    @Override
    public Time duplicate() {
        return new Time(this.hour, this.minute, this.second);
    }
}

