/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Configs;
import com.beyondcron.core.License;
import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.Version;
import com.beyondcron.core.Versions;
import com.beyondcron.messaging.CommandConnection;
import com.beyondcron.messaging.message.Connection;
import com.beyondcron.messaging.message.ConnectionQuery;
import com.beyondcron.messaging.message.LicenseQuery;
import com.beyondcron.messaging.message.ResultMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 %2\u00020\u0001:\u0001%B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0010\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001cJ\"\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u001cJ\u0006\u0010$\u001a\u00020\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/beyondcron/core/Updates;", "", "connection", "Lcom/beyondcron/messaging/CommandConnection;", "(Lcom/beyondcron/messaging/CommandConnection;)V", "getConnection", "()Lcom/beyondcron/messaging/CommandConnection;", "connections", "", "Lcom/beyondcron/messaging/message/Connection;", "getConnections", "()Ljava/util/List;", "licenseExpiry", "", "getLicenseExpiry", "()Ljava/lang/String;", "versions", "Lcom/beyondcron/core/Versions;", "getVersions", "()Lcom/beyondcron/core/Versions;", "getError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getLatest", "Lcom/beyondcron/core/Version;", "getLatestLicensed", "getMessage", "html", "", "getNewLicenseText", "message", "includeLinkIcon", "getVersionText", "version", "hasError", "isLatest", "isLatestLicensed", "Companion", "Bliss-core"})
public final class Updates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final CommandConnection connection;
    @NotNull
    private final List<Connection> connections;
    @NotNull
    private final Versions versions;
    @NotNull
    private final String licenseExpiry;
    @NotNull
    private static final Logger logger;

    public Updates(@Nullable CommandConnection connection) {
        String string;
        this.connection = connection;
        this.connections = new ArrayList();
        if (this.connection != null) {
            ResultMessage resultMessage = this.connection.sendReceive(new ConnectionQuery());
            if (resultMessage == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.beyondcron.messaging.message.ConnectionQuery.Response");
            }
            ConnectionQuery.Response response = (ConnectionQuery.Response)resultMessage;
            if (response.getResult().wasSuccess()) {
                List<Connection> list = response.getConnections();
                Intrinsics.checkNotNullExpressionValue(list, (String)"response.connections");
                this.connections.addAll((Collection<Connection>)list);
            } else {
                Object[] objectArray = new Object[]{response.getResult().getMessage()};
                Localise.logError(logger, "could not get connection list - %1$s", objectArray);
            }
        }
        Object t = Configs.get("beyondcron.license");
        if (t == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String licenseText = (String)t;
        License license = !StringsKt.isBlank((CharSequence)licenseText) ? new License(licenseText) : new License();
        this.versions = new Versions(license);
        License.Type type = this.versions.getLicense().getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                string = "999999";
                break;
            }
            default: {
                String string2 = Version.getBuildString(this.versions.getLicense().getExpiry());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getBuildString(versions.license.expiry)");
            }
        }
        this.licenseExpiry = string;
    }

    public /* synthetic */ Updates(CommandConnection commandConnection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            commandConnection = null;
        }
        this(commandConnection);
    }

    @Nullable
    public final CommandConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public final List<Connection> getConnections() {
        return this.connections;
    }

    @NotNull
    public final Versions getVersions() {
        return this.versions;
    }

    @NotNull
    public final String getLicenseExpiry() {
        return this.licenseExpiry;
    }

    @NotNull
    public final Version getLatest() {
        return this.versions.getLatest();
    }

    public final boolean isLatest() {
        Iterable $this$forEach$iv = this.connections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Connection it = (Connection)element$iv;
            boolean bl = false;
            if (this.versions.isLatest(new Version(it.getClientVersion()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Version getLatestLicensed() {
        return this.versions.getLatestLicensed();
    }

    public final boolean isLatestLicensed() {
        Iterable $this$forEach$iv = this.connections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Connection it = (Connection)element$iv;
            boolean bl = false;
            if (this.versions.isLatestLicensed(new Version(it.getClientVersion()))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String getMessage(boolean html) {
        String string;
        if (this.isLatest()) {
            String string2 = Localise.format("BeyondCron is up to date");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            Localise.f\u2026is up to date\")\n        }");
        } else if (this.isLatestLicensed()) {
            Object[] objectArray = new Object[3];
            objectArray[0] = Updates.getVersionText$default(this, this.getLatest(), html, false, 4, null);
            String string3 = Localise.format("new license");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(\"new license\")");
            objectArray[1] = Updates.getNewLicenseText$default(this, string3, html, false, 4, null);
            objectArray[2] = html ? "" : "- ";
            String string4 = Localise.format("BeyondCron is running the latest licensed version:\n%3$s%1$s is available with a %2$s", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            Localise.f\u2026) \"\" else \"- \")\n        }");
            string = string4;
        } else if (Intrinsics.areEqual((Object)this.getLatest(), (Object)this.getLatestLicensed())) {
            Object[] objectArray = new Object[]{Updates.getVersionText$default(this, this.getLatest(), html, false, 4, null), html ? "" : "- "};
            String string5 = Localise.format("BeyondCron is running an old version:\n%2$s%1$s is available to install", objectArray);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n            Localise.f\u2026) \"\" else \"- \")\n        }");
        } else {
            Object[] objectArray = new Object[]{Updates.getVersionText$default(this, this.getLatestLicensed(), html, false, 4, null), Updates.getVersionText$default(this, this.getLatest(), html, false, 4, null), Updates.getNewLicenseText$default(this, "new license", html, false, 4, null), html ? "" : "- "};
            String string6 = Localise.format("BeyondCron is running an old version:\n%4$s%1$s is available to install\n%4$s%2$s is available with a %3$s", objectArray);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"{\n            Localise.f\u2026) \"\" else \"- \")\n        }");
        }
        return string;
    }

    public static /* synthetic */ String getMessage$default(Updates updates, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return updates.getMessage(bl);
    }

    @NotNull
    public final String getVersionText(@NotNull Version version, boolean html, boolean includeLinkIcon) {
        String string;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (html) {
            String href = (String)Configs.get("beyondcron.url.downloads");
            String string2 = "<a href=\"%2$s%3$s/#v%4$s?expiry=%5$s\" target=\"bc_downloads\">%1$s%6$s</a>";
            Object[] objectArray = new Object[6];
            objectArray[0] = version;
            objectArray[1] = href;
            objectArray[2] = version.getType() == Version.Type.TESTING ? "/testing" : "";
            String string3 = version.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"version.toString()");
            objectArray[3] = StringsKt.replace$default((String)string3, (String)".", (String)"_", (boolean)false, (int)4, null);
            objectArray[4] = this.licenseExpiry;
            objectArray[5] = includeLinkIcon ? " <i class=\"fas fa-external-link-alt\"></i>" : "";
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        } else {
            String string5 = version.toString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n            version.toString()\n        }");
        }
        return string;
    }

    public static /* synthetic */ String getVersionText$default(Updates updates, Version version, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return updates.getVersionText(version, bl, bl2);
    }

    @NotNull
    public final String getNewLicenseText(@NotNull String message, boolean html, boolean includeLinkIcon) {
        Object object;
        block7: {
            block4: {
                Object object2;
                String storeUrl;
                License license;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                        if (!html) break block4;
                        license = this.versions.getLicense();
                        Object t = Configs.get("beyondcron.url.store");
                        if (t == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        storeUrl = (String)t;
                        object2 = this.connection;
                        if (object2 == null || (object2 = ((CommandConnection)object2).sendReceive(new LicenseQuery(LicenseQuery.Type.INSTANCE))) == null) break block5;
                        Object it = object2;
                        boolean bl = false;
                        LicenseQuery.Response response = (LicenseQuery.Response)it;
                        Object object3 = response.getResult().wasSuccess() ? "&instance=" + response.getInstance() : "";
                        object2 = object3;
                        if (object3 != null) break block6;
                    }
                    Updates $this$getNewLicenseText_u24lambda_u2d3 = this;
                    boolean bl = false;
                    object2 = "";
                }
                Object instance = object2;
                String icon = includeLinkIcon ? " <i class=\"fas fa-external-link-alt\"></i>" : "";
                object = "<a href=\"" + storeUrl + "?jobs=" + license.getMaxJobs() + "&servers=" + license.getMaxServers() + (String)instance + "\" target=\"bc-store\">" + message + icon + "</a>";
                break block7;
            }
            object = message;
        }
        return object;
    }

    public static /* synthetic */ String getNewLicenseText$default(Updates updates, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return updates.getNewLicenseText(string, bl, bl2);
    }

    public final boolean hasError() {
        return Versions.Companion.hasError();
    }

    @Nullable
    public final Exception getError() {
        return Versions.Companion.getError();
    }

    public Updates() {
        this(null, 1, null);
    }

    static {
        Logger logger = LogUtils.getLogger(Updates.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(Updates::class.java)");
        Updates.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/beyondcron/core/Updates$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "Bliss-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[License.Type.values().length];
            nArray[License.Type.EVALUATION.ordinal()] = 1;
            nArray[License.Type.FREE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

