/*
 * Decompiled with CFR 0.152.
 */
package com.beyondcron.core;

import com.beyondcron.core.Localise;
import com.beyondcron.core.LogUtils;
import com.beyondcron.core.StringUtils;
import com.beyondcron.core.TimeUtils;
import com.beyondcron.messaging.Message;
import com.beyondcron.messaging.proto.ProtoCore;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class Version
implements Comparable<Version>,
Message<Version> {
    static final Logger logger = LogUtils.getLogger(Version.class);
    private static final String MESSAGE_TAG = "version";
    private static final Pattern REGEX_VERSION = Pattern.compile("^(\\d+)\\.(\\d\\d)(\\d\\d)(\\d\\d)(\\.(\\d+)(-(.+))?)?$");
    public static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyMMdd", Locale.US);
    private String value = "0.700101.0";
    private int major = 0;
    private Date buildDate = new Date(0L);
    private int patch = 0;
    private String suffix = "";
    private Type type = Type.TESTING;

    public Version() {
    }

    public Version(String value) {
        this.setValue(value.trim());
    }

    public String getValue() {
        return this.value;
    }

    public boolean isValid() {
        return this.toString().equals(this.value);
    }

    public int getMajor() {
        return this.major;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public String getBuildString() {
        return Version.getBuildString(this.buildDate);
    }

    public static String getBuildString(Date date) {
        return TimeUtils.getLocalDateTime(date).format(dateFormatter);
    }

    public int getPatch() {
        return this.patch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Type getType() {
        return this.type;
    }

    private void setValue(String value) {
        if (value == null || value.length() < 1) {
            return;
        }
        this.value = value;
        Matcher matcher = REGEX_VERSION.matcher(value);
        if (matcher.matches()) {
            this.major = Integer.parseInt(matcher.group(1));
            this.buildDate = new GregorianCalendar(Integer.parseInt(matcher.group(2)) + 2000, Integer.parseInt(matcher.group(3)) - 1, Integer.parseInt(matcher.group(4))).getTime();
            String s = matcher.group(6);
            this.patch = s != null ? Integer.parseInt(s) : 0;
            s = matcher.group(8);
            this.suffix = StringUtils.isNullOrEmpty(s) ? "" : s;
            this.type = StringUtils.isNullOrEmpty(matcher.group(7)) ? Type.STABLE : Type.TESTING;
        } else {
            Localise.logError(logger, "Unsupported version: %1$s", value);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(Version that) {
        int i = this.major - that.major;
        if (i != 0) {
            return i;
        }
        i = this.buildDate.compareTo(that.buildDate);
        if (i != 0) {
            return i;
        }
        i = this.patch - that.patch;
        if (i != 0) {
            return i;
        }
        i = this.suffix.compareTo(that.suffix);
        if (i != 0) {
            if (this.suffix.isEmpty()) {
                return 1;
            }
            if (that.suffix.isEmpty()) {
                return -1;
            }
        }
        return i;
    }

    public String toString() {
        if (this.type == Type.STABLE || StringUtils.isNullOrEmpty(this.suffix)) {
            return String.format("%d.%s.%d", this.major, this.getBuildString(), this.patch);
        }
        return String.format("%d.%s.%d-%s", this.major, this.getBuildString(), this.patch, this.suffix);
    }

    @Override
    public String getMessageTag() {
        return MESSAGE_TAG;
    }

    public ProtoCore.Version.Builder toProto() {
        ProtoCore.Version.Builder builder = ProtoCore.Version.newBuilder();
        builder.setValue(this.value);
        return builder;
    }

    @Override
    public Version fromProto(byte[] data) throws InvalidProtocolBufferException {
        ProtoCore.Version proto = ProtoCore.Version.parseFrom(data);
        this.setValue(proto.getValue());
        return this;
    }

    public static enum Type {
        STABLE,
        TESTING;

    }
}

